/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.validator.validatorService.PaymentSecurityToleranceValidatorService;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.vo.CoreBillInfo;
import org.apache.commons.lang.StringUtils;

public class FinPaymentSecuritySubmitCtrlService {
    private static final Log logger = LogFactory.getLog(FinPaymentSecuritySubmitCtrlService.class);
    private boolean isValidateQty;
    private boolean isValidateAmt;
    private Date minDate = null;

    public void execute(DynamicObject[] bills) {
        if (bills.length == 0) {
            logger.info("bills length is zero");
            return;
        }
        this.initValidataType();
        if (!this.isValidateQty && !this.isValidateAmt) {
            logger.info("execcontrol is disable");
            return;
        }
        Map<String, CoreBillInfo> coreBillInfoMap = this.loadCoreBillInfos(bills);
        if (coreBillInfoMap.size() == 0) {
            logger.info("coreBillInfoMap size is zero");
            return;
        }
        List<CoreBillInfo> cacheData = this.readFormCacheAndWriteCurBillToCache(bills);
        Map<String, CoreBillInfo> coreBillInfoGroupByOrg = this.loadNeedCtrlFinBillInfos(bills, coreBillInfoMap, cacheData);
        Map<String, List<String>> toleranceResult = PaymentSecurityToleranceValidatorService.getQtyTolearnceResult(coreBillInfoGroupByOrg, this.isValidateQty, this.isValidateAmt, "ap_finapbill");
        this.doValidate(bills, coreBillInfoGroupByOrg, toleranceResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CoreBillInfo> readFormCacheAndWriteCurBillToCache(DynamicObject[] bills) {
        final String cacheKey = "fincache";
        final String lockKey = cacheKey + RequestContext.get().getAccountId() + "_lock";
        final ArrayList<Long> billIds = new ArrayList<Long>(16);
        ArrayList<CoreBillInfo> existsCache = new ArrayList(16);
        ArrayList<CoreBillInfo> currentCacheList = new ArrayList<CoreBillInfo>(16);
        boolean isCurBillInDB = QueryServiceHelper.exists((String)"ap_finapbill", (Object)bills[0].getLong("id"));
        if (!isCurBillInDB) {
            for (DynamicObject bill : bills) {
                boolean isExpenseBill;
                String expenseBillIds = ((DynamicObject)bill.getDynamicObjectCollection("detailentry").get(0)).getString("e_expensebillids_tag");
                boolean bl = isExpenseBill = expenseBillIds != null && !"".equals(expenseBillIds);
                if (bill.getBoolean("ispremium") || bill.getBoolean("istanspay") || isExpenseBill) continue;
                Long billId = bill.getLong("id");
                Long asstactId = bill.getLong("asstact.id");
                Long orgId = bill.getLong("org.id");
                Long currencyId = bill.getLong("currency.id");
                billIds.add(billId);
                DynamicObjectCollection entry = bill.getDynamicObjectCollection("detailentry");
                for (DynamicObject row : entry) {
                    Long coreBillId = row.getLong("corebillid");
                    Long coreBillEntryId = row.getLong("corebillentryid");
                    if (coreBillId == 0L || coreBillEntryId == 0L) continue;
                    CoreBillInfo info = new CoreBillInfo();
                    info.setBillId(billId);
                    info.setSupplierId(asstactId);
                    info.setOrgId(orgId);
                    info.setCurrencyId(currencyId);
                    info.setCoreBillId(coreBillId);
                    info.setCoreBillEntryId(coreBillEntryId);
                    info.setCoreBillAmt(row.getBigDecimal("e_pricetaxtotal"));
                    info.setCoreBaseQtyUp(row.getBigDecimal("e_baseunitqty"));
                    currentCacheList.add(info);
                }
            }
        }
        final IAppCache iAppCache = AppCache.get((String)"paysecurity");
        try (DLock lock = DLock.create((String)lockKey);){
            lock.lock();
            try {
                String value = (String)iAppCache.get(cacheKey, String.class);
                if (value != null) {
                    existsCache = SerializationUtils.fromJsonStringToList((String)value, CoreBillInfo.class);
                    currentCacheList.addAll(existsCache);
                }
                if (!isCurBillInDB) {
                    iAppCache.put(cacheKey, (Object)SerializationUtils.toJsonString(currentCacheList));
                }
            }
            finally {
                lock.unlock();
            }
        }
        TX.addCommitListener((CommitListener)new CommitListener(){

            public void onEnded(boolean rollbacked) {
                FinPaymentSecuritySubmitCtrlService.this.removeCache(iAppCache, billIds, cacheKey, lockKey);
            }
        });
        return existsCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCache(IAppCache iAppCache, List<Long> billIds, String cacheKey, String lockKey) {
        try (DLock lock = DLock.create((String)lockKey);){
            lock.lock();
            try {
                String value = (String)iAppCache.get(cacheKey, String.class);
                if (value != null) {
                    List cache = SerializationUtils.fromJsonStringToList((String)value, CoreBillInfo.class);
                    Iterator iterator = cache.iterator();
                    while (iterator.hasNext()) {
                        CoreBillInfo next = (CoreBillInfo)iterator.next();
                        Long billId = next.getBillId();
                        if (!billIds.contains(billId)) continue;
                        iterator.remove();
                    }
                    iAppCache.put(cacheKey, (Object)SerializationUtils.toJsonString((Object)cache));
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    private void doValidate(DynamicObject[] bills, Map<String, CoreBillInfo> coreBillInfoGroupByOrg, Map<String, List<String>> toleranceResult) {
        ArrayList<String> messages = new ArrayList<String>(16);
        HashMap purOrderQtyTolFailBillInfo = new HashMap(16);
        HashMap conmQtyTolFailBillInfo = new HashMap(16);
        HashMap scpoQtyTolFailBillInfo = new HashMap(16);
        HashMap pmomQtyTolFailBillInfo = new HashMap(16);
        List<String> qtyToleranceRs = toleranceResult.get("qty");
        List<String> amtToleranceRs = toleranceResult.get("amt");
        for (DynamicObject bill : bills) {
            String billNo = bill.getString("billno");
            String bizTypeNum = bill.getString("biztype.number");
            String sourceBillType = bill.getString("sourcebilltype");
            if (bill.getBoolean("ispremium") || bill.getBoolean("istanspay") || "114-1".equals(bizTypeNum)) continue;
            Long orgId = bill.getLong("org.id");
            Long supplierId = bill.getLong("asstact.id");
            boolean isAmtBase = bill.getBoolean("payproperty.isbasedonamt");
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("detailentry");
            for (DynamicObject row : entry) {
                List<Integer> seqs;
                String key;
                CoreBillInfo info;
                Long coreBillId = row.getLong("corebillid");
                Long coreBillEntryId = row.getLong("corebillentryid");
                if (coreBillId == 0L || coreBillEntryId == 0L) continue;
                String coreBillType = row.getString("corebilltype");
                String coreBillName = null;
                if ("pm_purorderbill".equals(coreBillType)) {
                    coreBillName = ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355", (String)"FinPaymentSecuritySubmitCtrlService_0", (String)"fi-ap-opplugin", (Object[])new Object[0]);
                } else if ("conm_purcontract".equals(coreBillType)) {
                    coreBillName = ResManager.loadKDString((String)"\u91c7\u8d2d\u5408\u540c", (String)"FinPaymentSecuritySubmitCtrlService_1", (String)"fi-ap-opplugin", (Object[])new Object[0]);
                } else if ("sctm_scpo".equals(coreBillType)) {
                    coreBillName = ResManager.loadKDString((String)"\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355", (String)"FinPaymentSecuritySubmitCtrlService_2", (String)"fi-ap-opplugin", (Object[])new Object[0]);
                } else if ("pm_om_purorderbill".equals(coreBillType)) {
                    coreBillName = ResManager.loadKDString((String)"\u7b80\u5355\u59d4\u5916\u8ba2\u5355", (String)"FinPaymentSecuritySubmitCtrlService_3", (String)"fi-ap-opplugin", (Object[])new Object[0]);
                }
                if ((info = coreBillInfoGroupByOrg.get(key = coreBillId + "_" + coreBillEntryId + "_" + orgId + "_" + supplierId)) == null || info.isAllowOverPay()) continue;
                if (this.isValidateAmt && amtToleranceRs != null && amtToleranceRs.contains(key)) {
                    String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u7269\u6599\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u6309%3$s\u67e5\u8be2\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u7d2f\u8ba1\u5e94\u4ed8\u91d1\u989d\u4e0e%3$s\u4ef7\u7a0e\u5408\u8ba1\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u4fee\u6539\u5355\u636e\u6216\u4fee\u6539\u5bb9\u5dee\u65b9\u6848\u540e\u91cd\u8bd5\u3002", (String)"FinPaymentSecuritySubmitCtrlService_4", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, row.getInt("seq"), coreBillName);
                    messages.add(msg);
                }
                if (!this.isValidateQty || !sourceBillType.equals(coreBillType) || isAmtBase) continue;
                if ("pm_purorderbill".equals(coreBillType)) {
                    if (qtyToleranceRs == null || !qtyToleranceRs.contains(key)) continue;
                    seqs = (ArrayList<Integer>)purOrderQtyTolFailBillInfo.get(billNo);
                    if (seqs == null) {
                        seqs = new ArrayList<Integer>(16);
                        seqs.add(row.getInt("seq"));
                        purOrderQtyTolFailBillInfo.put(billNo, seqs);
                        continue;
                    }
                    seqs.add(row.getInt("seq"));
                    continue;
                }
                if ("conm_purcontract".equals(coreBillType)) {
                    if (qtyToleranceRs == null || !qtyToleranceRs.contains(key)) continue;
                    seqs = (List)conmQtyTolFailBillInfo.get(billNo);
                    if (seqs == null) {
                        seqs = new ArrayList(16);
                        seqs.add(row.getInt("seq"));
                        conmQtyTolFailBillInfo.put(billNo, seqs);
                        continue;
                    }
                    seqs.add(row.getInt("seq"));
                    continue;
                }
                if ("sctm_scpo".equals(coreBillType)) {
                    if (qtyToleranceRs == null || !qtyToleranceRs.contains(key)) continue;
                    seqs = (List)scpoQtyTolFailBillInfo.get(billNo);
                    if (seqs == null) {
                        seqs = new ArrayList(16);
                        seqs.add(row.getInt("seq"));
                        scpoQtyTolFailBillInfo.put(billNo, seqs);
                        continue;
                    }
                    seqs.add(row.getInt("seq"));
                    continue;
                }
                if (!"pm_om_purorderbill".equals(coreBillType) || qtyToleranceRs == null || !qtyToleranceRs.contains(key)) continue;
                seqs = (List)pmomQtyTolFailBillInfo.get(billNo);
                if (seqs == null) {
                    seqs = new ArrayList(16);
                    seqs.add(row.getInt("seq"));
                    pmomQtyTolFailBillInfo.put(billNo, seqs);
                    continue;
                }
                seqs.add(row.getInt("seq"));
            }
        }
        for (Map.Entry entry : purOrderQtyTolFailBillInfo.entrySet()) {
            String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u6309\u76f4\u63a5\u4e0a\u6e38\u662f\u91c7\u8d2d\u8ba2\u5355\u67e5\u8be2\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u57fa\u672c\u6570\u91cf\u4e4b\u548c\u4e0e\u91c7\u8d2d\u8ba2\u5355\u6536\u8d27\u4e0a\u9650\u57fa\u672c\u6570\u91cf\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u4fee\u6539\u5355\u636e\u6570\u91cf\u6216\u4fee\u6539\u5bb9\u5dee\u65b9\u6848\u540e\u91cd\u8bd5\u3002", (String)"FinPaymentSecuritySubmitCtrlService_9", (String)"fi-ap-opplugin", (Object[])new Object[0]), entry.getKey(), StringUtils.join((Collection)((Collection)entry.getValue()), (char)','));
            messages.add(msg);
        }
        for (Map.Entry entry : conmQtyTolFailBillInfo.entrySet()) {
            String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u6309\u76f4\u63a5\u4e0a\u6e38\u662f\u91c7\u8d2d\u5408\u540c\u67e5\u8be2\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u57fa\u672c\u6570\u91cf\u4e4b\u548c\u4e0e\u91c7\u8d2d\u5408\u540c\u57fa\u672c\u6570\u91cf\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u4fee\u6539\u5355\u636e\u6570\u91cf\u6216\u4fee\u6539\u5bb9\u5dee\u65b9\u6848\u540e\u91cd\u8bd5\u3002", (String)"FinPaymentSecuritySubmitCtrlService_10", (String)"fi-ap-opplugin", (Object[])new Object[0]), entry.getKey(), StringUtils.join((Collection)((Collection)entry.getValue()), (char)','));
            messages.add(msg);
        }
        for (Map.Entry entry : scpoQtyTolFailBillInfo.entrySet()) {
            String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u6309\u76f4\u63a5\u4e0a\u6e38\u662f\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u67e5\u8be2\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u57fa\u672c\u6570\u91cf\u4e4b\u548c\u4e0e\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u6536\u8d27\u4e0a\u9650\u57fa\u672c\u6570\u91cf\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u4fee\u6539\u5355\u636e\u6570\u91cf\u6216\u4fee\u6539\u5bb9\u5dee\u65b9\u6848\u540e\u91cd\u8bd5\u3002", (String)"FinPaymentSecuritySubmitCtrlService_11", (String)"fi-ap-opplugin", (Object[])new Object[0]), entry.getKey(), StringUtils.join((Collection)((Collection)entry.getValue()), (char)','));
            messages.add(msg);
        }
        for (Map.Entry entry : pmomQtyTolFailBillInfo.entrySet()) {
            String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u6309\u76f4\u63a5\u4e0a\u6e38\u662f\u7b80\u5355\u59d4\u5916\u8ba2\u5355\u67e5\u8be2\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u57fa\u672c\u6570\u91cf\u4e4b\u548c\u4e0e\u7b80\u5355\u59d4\u5916\u8ba2\u5355\u6536\u8d27\u4e0a\u9650\u57fa\u672c\u6570\u91cf\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u4fee\u6539\u5355\u636e\u6570\u91cf\u6216\u4fee\u6539\u5bb9\u5dee\u65b9\u6848\u540e\u91cd\u8bd5\u3002", (String)"FinPaymentSecuritySubmitCtrlService_12", (String)"fi-ap-opplugin", (Object[])new Object[0]), entry.getKey(), StringUtils.join((Collection)((Collection)entry.getValue()), (char)','));
            messages.add(msg);
        }
        if (messages.size() > 0) {
            throw new KDBizException(StringUtils.join(messages, (String)"\n"));
        }
    }

    private Map<String, CoreBillInfo> loadNeedCtrlFinBillInfos(DynamicObject[] bills, Map<String, CoreBillInfo> coreBillInfo, List<CoreBillInfo> cacheData) {
        HashMap<String, CoreBillInfo> coreBillInfoGroupByOrg = new HashMap<String, CoreBillInfo>(16);
        HashSet<Long> coreBillIds = new HashSet<Long>(16);
        HashSet<Long> cacheBillIds = new HashSet<Long>(16);
        HashSet<Long> orgIds = new HashSet<Long>(16);
        for (DynamicObject bill : bills) {
            boolean isExpenseBill;
            String expenseBillIds = ((DynamicObject)bill.getDynamicObjectCollection("detailentry").get(0)).getString("e_expensebillids_tag");
            boolean bl = isExpenseBill = expenseBillIds != null && !"".equals(expenseBillIds);
            if (bill.getBoolean("ispremium") || bill.getBoolean("istanspay") || isExpenseBill) continue;
            cacheBillIds.add(bill.getLong("id"));
            Long currencyId = bill.getLong("currency.id");
            int amtPrecision = bill.getInt("currency.amtprecision");
            Long orgId = bill.getLong("org.id");
            orgIds.add(orgId);
            Long supplierId = bill.getLong("asstact.id");
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("detailentry");
            for (DynamicObject row : entry) {
                String coreKey;
                CoreBillInfo info;
                Long coreBillId = row.getLong("corebillid");
                Long coreBillEntryId = row.getLong("corebillentryid");
                if (coreBillId == 0L || coreBillEntryId == 0L || (info = coreBillInfo.get(coreKey = coreBillId + "_" + coreBillEntryId)) == null) continue;
                Long materialId = row.getLong("material.id");
                Long coreCurrencyId = info.getCurrencyId();
                if (!coreCurrencyId.equals(currencyId)) continue;
                coreBillIds.add(coreBillId);
                int qtyPrecision = row.getInt("e_baseunit.precision");
                String ctrlCoreKey = coreBillId + "_" + coreBillEntryId + "_" + orgId + "_" + supplierId;
                CoreBillInfo ctrlInfo = (CoreBillInfo)coreBillInfoGroupByOrg.get(ctrlCoreKey);
                if (ctrlInfo == null) {
                    ctrlInfo = new CoreBillInfo();
                    ctrlInfo.setOrgId(orgId);
                    ctrlInfo.setSupplierId(supplierId);
                    ctrlInfo.setCoreBillId(coreBillId);
                    ctrlInfo.setMaterialId(materialId);
                    ctrlInfo.setCoreBillType(info.getCoreBillType());
                    ctrlInfo.setAllowOverPay(info.isAllowOverPay());
                    ctrlInfo.setCurrencyId(coreCurrencyId);
                    ctrlInfo.setCoreBillEntryId(coreBillEntryId);
                    ctrlInfo.setCoreBillAmt(info.getCoreBillAmt());
                    ctrlInfo.setCoreBaseQtyUp(info.getCoreBaseQtyUp());
                    ctrlInfo.setSumAmt(row.getBigDecimal("e_pricetaxtotal"));
                    ctrlInfo.setSumBaseQty(row.getBigDecimal("e_baseunitqty"));
                    ctrlInfo.setQtyPrecision(qtyPrecision);
                    ctrlInfo.setAmtPrecision(amtPrecision);
                    coreBillInfoGroupByOrg.put(ctrlCoreKey, ctrlInfo);
                    continue;
                }
                ctrlInfo.setSumBaseQty(ctrlInfo.getSumBaseQty().add(row.getBigDecimal("e_baseunitqty")));
                ctrlInfo.setSumAmt(ctrlInfo.getSumAmt().add(row.getBigDecimal("e_pricetaxtotal")));
            }
        }
        if (cacheData.size() > 0) {
            for (CoreBillInfo cacheInfo : cacheData) {
                Long ctrlCurrencyId;
                Long cacheCurrencyId;
                String key = cacheInfo.getCoreBillId() + "_" + cacheInfo.getCoreBillEntrySeq() + "_" + cacheInfo.getOrgId() + "_" + cacheInfo.getSupplierId();
                CoreBillInfo ctrlInfo = (CoreBillInfo)coreBillInfoGroupByOrg.get(key);
                if (ctrlInfo == null || !(cacheCurrencyId = cacheInfo.getCurrencyId()).equals(ctrlCurrencyId = ctrlInfo.getCurrencyId())) continue;
                cacheBillIds.add(cacheInfo.getBillId());
                ctrlInfo.setSumAmt(ctrlInfo.getSumAmt().add(cacheInfo.getCoreBillAmt()));
                ctrlInfo.setSumBaseQty(ctrlInfo.getSumBaseQty().add(cacheInfo.getCoreBaseQtyUp()));
            }
        }
        QFilter filter = new QFilter("org", "in", orgIds);
        filter.and(new QFilter("detailentry.corebillid", "in", coreBillIds));
        filter.and(new QFilter("billstatus", "in", (Object)new String[]{"B", "C"}));
        filter.and(new QFilter("ispremium", "=", (Object)Boolean.FALSE));
        filter.and(new QFilter("istanspay", "=", (Object)Boolean.FALSE));
        filter.and(new QFilter("biztype.number", "!=", (Object)"114-1"));
        if (this.minDate != null) {
            this.minDate = DateUtils.getDataFormat((Date)this.minDate, (boolean)true);
            filter.and(new QFilter("bizdate", ">=", (Object)this.minDate));
        }
        DynamicObjectCollection historyBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,org,asstact,currency,detailentry.corebillid corebillid,detailentry.corebillentryseq corebillseq,detailentry.e_baseunitqty baseqty,detailentry.e_pricetaxtotal amt,detailentry.corebillentryid corebillentryid,detailentry.e_expensebillids_tag", (QFilter[])new QFilter[]{filter});
        for (DynamicObject bill : historyBills) {
            Long historyCurrencyId;
            Long infoCurrencyId;
            boolean isExpenseBill;
            Long billId = bill.getLong("id");
            if (cacheBillIds.contains(billId)) continue;
            String expenseBillIds = bill.getString("detailentry.e_expensebillids_tag");
            boolean bl = isExpenseBill = expenseBillIds != null && !"".equals(expenseBillIds);
            if (isExpenseBill) continue;
            Long orgId = bill.getLong("org");
            Long asstactId = bill.getLong("asstact");
            Long corebillId = bill.getLong("corebillid");
            Long coreBillEntryId = bill.getLong("corebillentryid");
            String key = corebillId + "_" + coreBillEntryId + "_" + orgId + "_" + asstactId;
            CoreBillInfo info = (CoreBillInfo)coreBillInfoGroupByOrg.get(key);
            if (info == null || !(infoCurrencyId = info.getCurrencyId()).equals(historyCurrencyId = Long.valueOf(bill.getLong("currency")))) continue;
            info.setSumAmt(info.getSumAmt().add(bill.getBigDecimal("amt")));
            info.setSumBaseQty(info.getSumBaseQty().add(bill.getBigDecimal("baseqty")));
        }
        return coreBillInfoGroupByOrg;
    }

    private Map<String, CoreBillInfo> loadCoreBillInfos(DynamicObject[] bills) {
        HashMap<Long, HashSet<Long>> coreOrderBillInfo = new HashMap<Long, HashSet<Long>>(16);
        HashMap<Long, HashSet<Long>> coreConBillInfo = new HashMap<Long, HashSet<Long>>(16);
        HashMap<Long, HashSet<Long>> coreOmBillInfo = new HashMap<Long, HashSet<Long>>(16);
        HashMap<Long, HashSet<Long>> corePmOmBillInfo = new HashMap<Long, HashSet<Long>>(16);
        for (DynamicObject bill : bills) {
            boolean isExpenseBill;
            boolean isPremium = bill.getBoolean("ispremium");
            boolean isTanspay = bill.getBoolean("istanspay");
            String expenseBillIds = ((DynamicObject)bill.getDynamicObjectCollection("detailentry").get(0)).getString("e_expensebillids_tag");
            boolean bl = isExpenseBill = expenseBillIds != null && !"".equals(expenseBillIds);
            if (isPremium || isTanspay || isExpenseBill) continue;
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("detailentry");
            for (DynamicObject row : entry) {
                Long coreBillId = row.getLong("corebillid");
                Long coreBillEntryId = row.getLong("corebillentryid");
                if (coreBillId == 0L || coreBillEntryId == 0L) continue;
                String coreBillType = row.getString("corebilltype");
                if ("pm_purorderbill".equals(coreBillType)) {
                    HashSet<Long> coreOrderBillEntryIds = (HashSet<Long>)coreOrderBillInfo.get(coreBillId);
                    if (coreOrderBillEntryIds == null) {
                        coreOrderBillEntryIds = new HashSet<Long>(16);
                        coreOrderBillEntryIds.add(coreBillEntryId);
                        coreOrderBillInfo.put(coreBillId, coreOrderBillEntryIds);
                        continue;
                    }
                    coreOrderBillEntryIds.add(coreBillEntryId);
                    continue;
                }
                if ("conm_purcontract".equals(coreBillType)) {
                    HashSet<Long> coreConBillEntryIds = (HashSet<Long>)coreConBillInfo.get(coreBillId);
                    if (coreConBillEntryIds == null) {
                        coreConBillEntryIds = new HashSet<Long>(16);
                        coreConBillEntryIds.add(coreBillEntryId);
                        coreConBillInfo.put(coreBillId, coreConBillEntryIds);
                        continue;
                    }
                    coreConBillEntryIds.add(coreBillEntryId);
                    continue;
                }
                if ("sctm_scpo".equals(coreBillType)) {
                    HashSet<Long> coreOmBillEntryIds = (HashSet<Long>)coreOmBillInfo.get(coreBillId);
                    if (coreOmBillEntryIds == null) {
                        coreOmBillEntryIds = new HashSet<Long>(16);
                        coreOmBillEntryIds.add(coreBillEntryId);
                        coreOmBillInfo.put(coreBillId, coreOmBillEntryIds);
                        continue;
                    }
                    coreOmBillEntryIds.add(coreBillEntryId);
                    continue;
                }
                if (!"pm_om_purorderbill".equals(coreBillType)) continue;
                HashSet<Long> corePmOmBillEntryIds = (HashSet<Long>)corePmOmBillInfo.get(coreBillId);
                if (corePmOmBillEntryIds == null) {
                    corePmOmBillEntryIds = new HashSet<Long>(16);
                    corePmOmBillEntryIds.add(coreBillEntryId);
                    corePmOmBillInfo.put(coreBillId, corePmOmBillEntryIds);
                    continue;
                }
                corePmOmBillEntryIds.add(coreBillEntryId);
            }
        }
        HashMap<String, CoreBillInfo> coreBillInfoMap = new HashMap<String, CoreBillInfo>(16);
        if (coreOrderBillInfo.size() > 0) {
            List orderInfo = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"PurOrderService", (String)"queryOverPayParamAndAmount", (Object[])new Object[]{coreOrderBillInfo});
            this.setCoreBillInfoMap(coreBillInfoMap, orderInfo, "pm_purorderbill");
        }
        if (coreConBillInfo.size() > 0) {
            List orderInfo = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"conm", (String)"PurConmService", (String)"queryOverPayParamAndAmount", (Object[])new Object[]{coreConBillInfo});
            this.setCoreBillInfoMap(coreBillInfoMap, orderInfo, "conm_purcontract");
        }
        if (coreOmBillInfo.size() > 0) {
            List orderInfo = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sctm", (String)"ScPoService", (String)"queryOverPayParamAndAmount", (Object[])new Object[]{coreOmBillInfo});
            this.setCoreBillInfoMap(coreBillInfoMap, orderInfo, "sctm_scpo");
        }
        if (corePmOmBillInfo.size() > 0) {
            List orderInfo = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"OmPurOrderbillService", (String)"getOmPurOrderbillInfo", (Object[])new Object[]{corePmOmBillInfo});
            this.setCoreBillInfoMap(coreBillInfoMap, orderInfo, "pm_om_purorderbill");
            this.minDate = null;
        }
        return coreBillInfoMap;
    }

    private void setCoreBillInfoMap(Map<String, CoreBillInfo> coreBillInfoMap, List<Map<String, Object>> params, String coreBillType) {
        for (Map<String, Object> map : params) {
            boolean isAllowOverPay = (Boolean)map.get("isallowoverpay");
            Long id = (Long)map.get("billid");
            Long supplierId = (Long)map.get("invoicesupplier");
            Long currencyId = (Long)map.get("settlecurrency");
            List entrys = (List)map.get("entryinfo");
            Date coreCreateTime = (Date)map.get("createtime");
            if (coreCreateTime != null) {
                this.minDate = this.minDate == null ? coreCreateTime : (this.minDate.before(coreCreateTime) ? this.minDate : coreCreateTime);
            }
            for (Map entry : entrys) {
                CoreBillInfo info = new CoreBillInfo();
                Long entryId = (Long)entry.get("entryid");
                info.setCoreBillId(id);
                info.setCoreBillType(coreBillType);
                info.setAllowOverPay(isAllowOverPay);
                info.setOrgId((Long)entry.get("settleorg"));
                info.setSupplierId(supplierId);
                info.setCurrencyId(currencyId);
                info.setCoreBillEntryId(entryId);
                info.setCoreBillAmt((BigDecimal)entry.get("amountandtax"));
                Object baseQty = entry.get("receivebaseqtyup");
                if (baseQty == null) {
                    baseQty = entry.get("baseqty");
                }
                info.setCoreBaseQtyUp((BigDecimal)baseQty);
                String key = id + "_" + entryId;
                coreBillInfoMap.put(key, info);
            }
        }
    }

    private void initValidataType() {
        DynamicObjectCollection execcontrols = QueryServiceHelper.query((String)"arap_execcontrol", (String)"number,enable", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)new String[]{"SZJK-PRE-0087", "SZJK-PRE-0088"})});
        for (DynamicObject ctrl : execcontrols) {
            String number = ctrl.getString("number");
            if ("SZJK-PRE-0087".equals(number)) {
                if (!ctrl.getBoolean("enable")) continue;
                this.isValidateAmt = true;
                continue;
            }
            if (!"SZJK-PRE-0088".equals(number) || !ctrl.getBoolean("enable")) continue;
            this.isValidateQty = true;
        }
    }
}

