/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.fi.ap.piaozone.InvoiceHelper;

public class FinanceApBillAuditValidator
extends AbstractValidator {
    private Map<Long, Boolean> hasNumberMap = new HashMap<Long, Boolean>(2);

    public void validate() {
        ExtendedDataEntity[] datas = this.getDataEntities();
        Map invoiceMap = InvoiceHelper.getInvoiceMap((ExtendedDataEntity[])this.dataEntities);
        for (ExtendedDataEntity data : datas) {
            Map<Long, String> invoiceBillNoMap;
            String errorMessage;
            DynamicObjectCollection inventries;
            DynamicObject finBill = data.getDataEntity();
            BigDecimal premiumAmt = finBill.getBigDecimal("premiumamt");
            if (premiumAmt.compareTo(BigDecimal.ZERO) != 0) {
                if (!this.hashNumber(finBill.getLong("id"), finBill.getLong("org.id")).booleanValue()) {
                    this.addMessage(data, ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5355\u6ca1\u6709\u7f16\u7801\u89c4\u5219\uff0c\u4e0d\u5141\u8bb8\u5ba1\u6838\u201c\u8d28\u4fdd\u91d1\u6bd4\u4f8b\u201d\u4e0d\u4e3a0\u7684\u5e94\u4ed8\u5355\u3002", (String)"FinanceApBillAuditValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                }
                BigDecimal unsettleAmt = finBill.getBigDecimal("unsettleamount");
                if (premiumAmt.abs().compareTo(unsettleAmt.abs()) > 0) {
                    this.addMessage(data, ResManager.loadKDString((String)"\u8d28\u4fdd\u91d1\u91d1\u989d\u5927\u4e8e\u6574\u5355\u672a\u7ed3\u7b97\u91d1\u989d\uff0c\u4e0d\u5141\u8bb8\u5ba1\u6838\u3002", (String)"FinanceApBillAuditValidator_2", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                }
            }
            if ((inventries = finBill.getDynamicObjectCollection("inventry")).isEmpty() || ObjectUtils.isEmpty((Object)(errorMessage = InvoiceHelper.validatorInvoiceExist(invoiceBillNoMap = inventries.stream().collect(Collectors.toMap(e -> e.getLong("invid"), e -> e.getString("i_billno"))), (DynamicObject[])invoiceMap.values().toArray(new DynamicObject[0]))))) continue;
            this.addMessage(data, errorMessage);
        }
    }

    private Boolean hashNumber(long billId, long orgPk) {
        Boolean hasNumber = this.hasNumberMap.get(orgPk);
        if (hasNumber == null) {
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"ap_finapbill");
            hasNumber = CodeRuleServiceHelper.isExist((String)"ap_finapbill", (DynamicObject)bill, (String)String.valueOf(orgPk));
            this.hasNumberMap.put(orgPk, hasNumber);
        }
        return hasNumber;
    }
}

