/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.enums.InvoiceSrcTypeEnum;
import kd.fi.ap.piaozone.ReplaceInvoiceHelper;

public class InvoiceAntiAssignValidator
extends AbstractValidator {
    public void validate() {
        HashSet<Long> orgIds = new HashSet<Long>(8);
        HashSet<Long> invoiceIds = new HashSet<Long>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject invoice = dataEntity.getDataEntity();
            orgIds.add(invoice.getLong("org.id"));
            invoiceIds.add(invoice.getLong("id"));
        }
        if (!invoiceIds.isEmpty()) {
            QFilter filter = new QFilter("org", "in", orgIds);
            filter.and(new QFilter("inventry.invid", "in", invoiceIds));
            DataSet finApDataSet = QueryServiceHelper.queryDataSet((String)"query_finap", (String)"ap_finapbill", (String)"id,billno,inventry.invid invid,inventry.i_srctype i_srctype", (QFilter[])new QFilter[]{filter}, (String)"");
            HashMap<Long, Set> inv4FinApIdsMap = new HashMap<Long, Set>(16);
            HashMap<Long, String> finApBillNoMap = new HashMap<Long, String>(8);
            for (Row finApRow : finApDataSet) {
                Long billId = finApRow.getLong("id");
                Long invId = finApRow.getLong("invid");
                finApBillNoMap.put(billId, finApRow.getString("billno"));
                if (!InvoiceSrcTypeEnum.ASSIGNFINAPBILL.getValue().equals(finApRow.getString("i_srctype"))) continue;
                Set apBillIds = inv4FinApIdsMap.getOrDefault(invId, new HashSet(8));
                apBillIds.add(billId);
                inv4FinApIdsMap.put(invId, apBillIds);
            }
            Map onTheWayFinApIdsMap = ReplaceInvoiceHelper.returnOnTheWayBillIds((String)"ap_finapbill", orgIds, new ArrayList(finApBillNoMap.keySet()));
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                DynamicObject invoice = dataEntity.getDataEntity();
                long invoiceId = invoice.getLong("id");
                if (invoice.getBigDecimal("unrelatedamt").compareTo(invoice.getBigDecimal("pricetaxtotal")) == 0 && !inv4FinApIdsMap.containsKey(invoiceId)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6ca1\u6709\u6307\u5b9a\u5e94\u4ed8\uff0c\u65e0\u9700\u53d6\u6d88\u6307\u5b9a\u3002", (String)"InvoiceAntiAssignValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                    continue;
                }
                if (invoice.getBigDecimal("unrelatedamt").compareTo(invoice.getBigDecimal("pricetaxtotal")) != 0 && !inv4FinApIdsMap.containsKey(invoiceId)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6ca1\u6709\u6307\u5b9a\u5e94\u4ed8\uff0c\u65e0\u9700\u53d6\u6d88\u6307\u5b9a\u3002\u82e5\u9700\u91ca\u653e\u5e94\u4ed8\uff0c\u8bf7\u4e0b\u67e5\u5230\u8d22\u52a1\u5e94\u4ed8\u5355\u8fdb\u884c\u5904\u7406\u3002", (String)"InvoiceAntiAssignValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                    continue;
                }
                Set apBillIds = (Set)inv4FinApIdsMap.get(invoiceId);
                if (ObjectUtils.isEmpty((Object)apBillIds)) continue;
                ArrayList finApBillNos = new ArrayList(8);
                for (Long apBillId : apBillIds) {
                    if (!onTheWayFinApIdsMap.containsKey(apBillId)) continue;
                    finApBillNos.add(finApBillNoMap.get(apBillId));
                }
                if (finApBillNos.isEmpty()) continue;
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u8d22\u52a1\u5e94\u4ed8\u5355%1$s\u5b58\u5728\u672a\u5ba1\u6838\u7684\u6362\u7968\u8bb0\u5f55\uff0c\u8bf7\u901a\u8fc7\u8d22\u52a1\u5e94\u4ed8\u5355-\u8054\u67e5-\u67e5\u770b\u6362\u7968\u8bb0\u5f55\u5220\u9664\u6216\u5ba1\u6838\u6362\u7968\u8bb0\u5f55\u540e\u91cd\u8bd5\u3002", (String)"InvoiceAntiAssignValidator_2", (String)"fi-ap-opplugin", (Object[])new Object[0]), String.join((CharSequence)",", finApBillNos)));
            }
        }
    }
}

