/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.arapcommon.business.piaozone.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.arapcommon.helper.InvoiceTypeHelper;

public class InvoiceSubmitValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] datas = this.getDataEntities();
        HashSet<Long> orgIds = new HashSet<Long>(8);
        for (ExtendedDataEntity data : datas) {
            DynamicObject invoice = data.getDataEntity();
            orgIds.add(invoice.getLong("org.id"));
            if (invoice.getBigDecimal("pricetaxtotal").compareTo(BigDecimal.ZERO) == 0) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u6574\u5355\u201c\u4ef7\u7a0e\u5408\u8ba1\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvoiceSubmitValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]));
            }
            DynamicObject invoicetypef7 = invoice.getDynamicObject("invoicetypef7");
            String invoicetype = invoice.getString("invoicetype");
            if (!ObjectUtils.isEmpty((Object)invoicetype) || !ObjectUtils.isEmpty((Object)invoicetypef7)) continue;
            this.addErrorMessage(data, InvoiceTypeHelper.getValidateInfo());
        }
        Map configByOrg = KingdeeInvoiceCloudConfig.getErConfigByOrg(orgIds);
        for (ExtendedDataEntity data : datas) {
            DynamicObject invoice = data.getDataEntity();
            Long orgId = invoice.getLong("org.id");
            String invAssName = invoice.getString("asstactname");
            DynamicObject config = (DynamicObject)configByOrg.get(orgId);
            if (config == null || !"0".equals(config.getString("identicalpartyinvcom")) || invAssName.equals(invoice.getString("receivablessupp.name"))) continue;
            this.addMessage(data, ResManager.loadKDString((String)"\u5f80\u6765\u6237\u4e0e\u9500\u65b9\u540d\u79f0\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"InvoiceSubmitValidator_27", (String)"fi-ap-opplugin", (Object[])new Object[0]));
        }
    }
}

