/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.util.DateUtils;

public class PaidBillImportValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] datas;
        for (ExtendedDataEntity data : datas = this.dataEntities) {
            Date bizDate;
            DynamicObject bill = data.getDataEntity();
            String billSrctype = bill.getString("billsrctype");
            if (!BillSrcTypeEnum.IMPORT.getValue().equals(billSrctype)) continue;
            DynamicObject org = bill.getDynamicObject("org");
            Long orgPk = org.getLong("id");
            InitHelper init = new InitHelper(orgPk.longValue(), "ap_init");
            if (init.isFinishInit()) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u5df2\u7ecf\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"PaidBillImportValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), org.getLocaleString("name").getLocaleValue()));
            }
            if (DateUtils.compareTo((Date)(bizDate = bill.getDate("bizdate")), (Date)init.getStartDate()) >= 0) {
                SimpleDateFormat short_date = new SimpleDateFormat("yyyy-MM-dd");
                String message = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f\uff08%1$s\uff09\u5e94\u65e9\u4e8e\u542f\u7528\u65e5\u671f\uff08%2$s\uff09\u3002", (String)"PaidBillImportValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]), short_date.format(bizDate), short_date.format(init.getStartDate()));
                this.addErrorMessage(data, message);
            }
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("entry");
            for (int i = 0; i < entries.size(); ++i) {
                DynamicObject entry = (DynamicObject)entries.get(i);
                if (entry.get("e_material") == null || entry.get("e_expenseitem") == null) continue;
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\uff1a\u7269\u6599\u4e0e\u8d39\u7528\u9879\u76ee\u65e0\u6cd5\u540c\u65f6\u5f55\u5165\u3002", (String)"PaidBillImportValidator_2", (String)"fi-ap-opplugin", (Object[])new Object[0]), i + 1));
            }
        }
    }
}

