/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import com.alibaba.fastjson.JSONObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.business.invoice.InvoiceAssignService;
import kd.fi.arapcommon.business.piaozone.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.arapcommon.enums.ApInvoiceServiceEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;

public class PayApplyAssignValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity dataEntity = this.getDataEntities()[0];
        InvoiceAssignService assignService = (InvoiceAssignService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.ASSGININVOICE.getValue());
        String errorMessage = assignService.validateApply(dataEntity.getDataEntity());
        if (errorMessage != null) {
            this.addErrorMessage(dataEntity, errorMessage);
            return;
        }
        Map variableMap = this.getOption().getVariables();
        List invPks = (List)JSONObject.parseObject((String)((String)variableMap.get("invPks")), List.class);
        QFilter qFilter = assignService.constructQFilterByApply(dataEntity.getDataEntity());
        qFilter.and(new QFilter("id", "in", (Object)invPks));
        DynamicObjectCollection invoices = QueryServiceHelper.query((String)"ap_invoice", (String)"billno,id,asstactname", (QFilter[])new QFilter[]{qFilter});
        if (invoices.isEmpty() || invoices.size() != invPks.size()) {
            String message = ResManager.loadKDString((String)"\u6240\u9009\u6536\u7968\u5355\u4e0d\u6ee1\u8db3\u4ee5\u4e0b\u6761\u4ef6\uff0c\u4e0d\u5141\u8bb8\u6307\u5b9a\u3002", (String)"PayApplyAssignValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"1.\u6536\u7968\u5355\u672a\u5165\u8d26\u3002", (String)"PayApplyAssignValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"2.\u6536\u7968\u5355\u672a\u53c2\u4e0e\u53d1\u7968\u5339\u914d\u3002", (String)"PayApplyAssignValidator_2", (String)"fi-ap-opplugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"3.\u6536\u7968\u5355\u672a\u4e0e\u8d22\u52a1\u5e94\u4ed8\u5355\u5173\u8054\u3002", (String)"PayApplyAssignValidator_3", (String)"fi-ap-opplugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"4.\u6536\u7968\u5355\u672a\u5ba1\u6838\u3002", (String)"PayApplyAssignValidator_4", (String)"fi-ap-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, message);
        }
        DynamicObject applyBill = dataEntity.getDataEntity();
        HashSet<Long> orgIds = new HashSet<Long>(1);
        Long orgId = applyBill.getLong("applyorg.id");
        orgIds.add(orgId);
        Map configByOrg = KingdeeInvoiceCloudConfig.getErConfigByOrg(orgIds);
        DynamicObject config = (DynamicObject)configByOrg.get(orgId);
        if (config != null && "0".equals(config.getString("identicalpartyinvcom"))) {
            DynamicObjectCollection entrys = applyBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                String asstName = entry.getString("e_asstact.name");
                for (DynamicObject invoice : invoices) {
                    if (asstName.equals(invoice.getString("asstactname"))) continue;
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355\u7b2c%1$s\u884c\u5f80\u6765\u6237\u4e0e\u6536\u7968\u5355: %2$s\u9500\u65b9\u540d\u79f0\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u6307\u5b9a\u3002", (String)"PayApplyAssignValidator_5", (String)"fi-ap-opplugin", (Object[])new Object[]{entry.getInt("seq"), invoice.getString("billno")}));
                }
            }
        }
    }
}

