/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.helper.SystemParameterHelper;
import kd.fi.arapcommon.excecontrol.IExecCtrlService;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.vo.CoreBillInfo;

public class PayApplyBillPaymentSecuritySubmitCtrlService
implements IExecCtrlService<Object> {
    private Map<Long, Integer> settleModelMap = new HashMap<Long, Integer>(16);

    public <T> T execute(Object ... param) {
        if (param == null || param.length == 0) {
            return null;
        }
        DynamicObject[] bills = (DynamicObject[])param;
        Map<String, CoreBillInfo> coreBillInfo = this.queryCoreBill(bills);
        if (coreBillInfo.size() == 0) {
            return null;
        }
        List<CoreBillInfo> cacheData = this.getBillFromCache(bills);
        this.setCtrlBillInfo(coreBillInfo, cacheData);
        Map<Long, CoreBillInfo> mergeCoreBillInfo = this.mergeCoreBillInfo(coreBillInfo);
        this.doValidate(bills, mergeCoreBillInfo);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CoreBillInfo> getBillFromCache(DynamicObject[] bills) {
        List existsCache = new ArrayList(16);
        final String cacheKey = "applycache";
        final String lockKey = cacheKey + RequestContext.get().getAccountId() + "_lock";
        final IAppCache iAppCache = AppCache.get((String)"paysecurity");
        HashSet<Long> srcFinBillIds = new HashSet<Long>(16);
        final HashSet<Long> billIds = new HashSet<Long>(16);
        ArrayList<CoreBillInfo> currentBills = new ArrayList<CoreBillInfo>(16);
        ArrayList<DynamicObject> planSettlenBills = new ArrayList<DynamicObject>(16);
        for (DynamicObject applyBill : bills) {
            DynamicObjectCollection entry;
            Long billId = applyBill.getLong("id");
            billIds.add(billId);
            Long orgId = applyBill.getLong("settleorg.id");
            String sourceBillType = applyBill.getString("sourcebilltype");
            if ("pm_purorderbill".equals(sourceBillType) || "conm_purcontract".equals(sourceBillType) || "sctm_scpo".equals(sourceBillType)) {
                DynamicObjectCollection entry2 = applyBill.getDynamicObjectCollection("entry");
                for (DynamicObject row : entry2) {
                    this.setCoreBillInfo(currentBills, applyBill, row);
                }
            }
            if (!"ap_finapbill".equals(sourceBillType)) continue;
            Integer settleModel = this.settleModelMap.get(orgId);
            if (settleModel == null) {
                settleModel = SystemParameterHelper.getParameterInteger((long)orgId, (String)"ap_003");
                this.settleModelMap.put(orgId, settleModel);
            }
            if (1 == settleModel) {
                entry = applyBill.getDynamicObjectCollection("entry");
                for (DynamicObject row : entry) {
                    this.setCoreBillInfo(currentBills, applyBill, row);
                }
            }
            if (2 != settleModel) continue;
            planSettlenBills.add(applyBill);
            entry = applyBill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                DynamicObjectCollection entryLks = row.getDynamicObjectCollection("entry_lk");
                if (entryLks.size() <= 0) continue;
                Long sourceId = (Long)((DynamicObject)entryLks.get(0)).get("entry_lk_sbillid");
                srcFinBillIds.add(sourceId);
            }
        }
        Map<Object, Object> srcFinCoreBillCountMap = new HashMap(16);
        if (srcFinBillIds.size() > 0) {
            srcFinCoreBillCountMap = this.getSrcFinCoreBillIdCounts(srcFinBillIds);
            for (DynamicObject applyBill : planSettlenBills) {
                DynamicObjectCollection entry = applyBill.getDynamicObjectCollection("entry");
                for (DynamicObject row : entry) {
                    Long sourceId;
                    Integer count;
                    DynamicObjectCollection entryLks = row.getDynamicObjectCollection("entry_lk");
                    if (entryLks.size() <= 0 || (count = (Integer)srcFinCoreBillCountMap.get(sourceId = (Long)((DynamicObject)entryLks.get(0)).get("entry_lk_sbillid"))) == null || count != 1) continue;
                    this.setCoreBillInfo(currentBills, applyBill, row);
                }
            }
        }
        try (DLock lock = DLock.create((String)lockKey);){
            lock.lock();
            try {
                String value = (String)iAppCache.get(cacheKey, String.class);
                if (value != null) {
                    existsCache = SerializationUtils.fromJsonStringToList((String)value, CoreBillInfo.class);
                }
                if (existsCache != null) {
                    currentBills.addAll(existsCache);
                }
                iAppCache.put(cacheKey, (Object)SerializationUtils.toJsonString(currentBills));
            }
            finally {
                lock.unlock();
            }
        }
        TX.addCommitListener((CommitListener)new CommitListener(){

            public void onEnded(boolean rollbacked) {
                PayApplyBillPaymentSecuritySubmitCtrlService.this.removeCache(iAppCache, billIds, cacheKey, lockKey);
            }
        });
        return currentBills;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCache(IAppCache iAppCache, Set<Long> billIds, String cacheKey, String lockKey) {
        try (DLock lock = DLock.create((String)lockKey);){
            lock.lock();
            try {
                String value = (String)iAppCache.get(cacheKey, String.class);
                if (value != null) {
                    List cache = SerializationUtils.fromJsonStringToList((String)value, CoreBillInfo.class);
                    Iterator iterator = cache.iterator();
                    while (iterator.hasNext()) {
                        CoreBillInfo next = (CoreBillInfo)iterator.next();
                        Long billId = next.getBillId();
                        if (!billIds.contains(billId)) continue;
                        iterator.remove();
                    }
                    iAppCache.put(cacheKey, (Object)SerializationUtils.toJsonString((Object)cache));
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    private void setCoreBillInfo(List<CoreBillInfo> currentBills, DynamicObject applyBill, DynamicObject entry) {
        Long billId = applyBill.getLong("id");
        Long orgId = applyBill.getLong("settleorg.id");
        Long currencyId = applyBill.getLong("settlecurrency.id");
        Long coreBillId = entry.getLong("e_corebillid");
        if (coreBillId == 0L) {
            return;
        }
        String payType = entry.getString("e_paymenttype.biztype");
        String asstactType = entry.getString("e_asstacttype");
        if ("bd_supplier".equals(asstactType)) {
            Long asstactId = entry.getLong("e_asstact.id");
            CoreBillInfo info = new CoreBillInfo();
            info.setCoreBillId(coreBillId);
            info.setBillId(billId);
            info.setCurrencyId(currencyId);
            info.setOrgId(orgId);
            info.setSupplierId(asstactId);
            info.setCoreBillAmt(entry.getBigDecimal("e_approvedamt"));
            if ("202".equals(payType)) {
                info.setPreparePayAmt(entry.getBigDecimal("e_approvedamt"));
            }
            currentBills.add(info);
        }
    }

    private void doValidate(DynamicObject[] bills, Map<Long, CoreBillInfo> mergeCoreBillInfo) {
        ArrayList<String> messages = new ArrayList<String>(16);
        for (DynamicObject applyBill : bills) {
            String msg;
            String billNo = applyBill.getString("billno");
            Long orgId = applyBill.getLong("settleorg.id");
            Long currencyId = applyBill.getLong("settlecurrency.id");
            DynamicObjectCollection entry = applyBill.getDynamicObjectCollection("entry");
            HashSet<String> preOverPayCoreBillNo = new HashSet<String>(16);
            HashSet<String> overPayCoreBillNo = new HashSet<String>(16);
            for (DynamicObject row : entry) {
                CoreBillInfo coreBillInfo;
                Long coreBillId = row.getLong("e_corebillid");
                String coreBillNo = row.getString("e_corebillno");
                if (coreBillId == 0L || (coreBillInfo = mergeCoreBillInfo.get(coreBillId)) == null) continue;
                Long coreBillOrg = coreBillInfo.getOrgId();
                Long coreCurrencyId = coreBillInfo.getCurrencyId();
                if (!orgId.equals(coreBillOrg) || !currencyId.equals(coreCurrencyId)) continue;
                if (coreBillInfo.getSumPrePayAmt().compareTo(coreBillInfo.getPreparePayAmt()) > 0) {
                    preOverPayCoreBillNo.add(coreBillNo);
                }
                if (coreBillInfo.getSumAmt().compareTo(coreBillInfo.getCoreBillAmt()) <= 0) continue;
                overPayCoreBillNo.add(coreBillNo);
            }
            if (preOverPayCoreBillNo.size() > 0) {
                msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u6309\u91c7\u8d2d\u8ba2\u5355\u6216\u91c7\u8d2d\u5408\u540c\u67e5\u8be2\u7684\u9884\u4ed8\u6b3e\u7533\u8bf7\u5355\u7d2f\u8ba1\u672a\u5173\u95ed\u6001\u6838\u51c6\u91d1\u989d\u4e0e\u5173\u95ed\u6001\u5df2\u4ed8\u91d1\u989d\u4e4b\u548c\uff0c\u8d85\u8fc7\u91c7\u8d2d\u8ba2\u5355\u6216\u91c7\u8d2d\u5408\u540c\u9884\u4ed8\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u4e0b\u5217\u6838\u5fc3\u5355\u636e\u53f7\u5bf9\u5e94\u7684\u660e\u7ec6\u884c\uff1a%2$s", (String)"PayApplyBillPaymentSecuritySubmitCtrlService_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, org.apache.commons.lang.StringUtils.join(preOverPayCoreBillNo, (String)"\uff0c"));
                messages.add(msg);
            }
            if (overPayCoreBillNo.size() <= 0) continue;
            msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u6309\u91c7\u8d2d\u8ba2\u5355\u6216\u91c7\u8d2d\u5408\u540c\u67e5\u8be2\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u7d2f\u8ba1\u672a\u5173\u95ed\u6001\u6838\u51c6\u91d1\u989d\u4e0e\u5173\u95ed\u6001\u5df2\u4ed8\u91d1\u989d\u4e4b\u548c\uff0c\u8d85\u8fc7\u91c7\u8d2d\u8ba2\u5355\u6216\u91c7\u8d2d\u5408\u540c\u4ef7\u7a0e\u5408\u8ba1\uff0c\u8bf7\u68c0\u67e5\u4e0b\u5217\u6838\u5fc3\u5355\u636e\u53f7\u5bf9\u5e94\u7684\u660e\u7ec6\u884c\uff1a%2$s", (String)"PayApplyBillPaymentSecuritySubmitCtrlService_1", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, org.apache.commons.lang.StringUtils.join(overPayCoreBillNo, (String)"\uff0c"));
            messages.add(msg);
        }
        if (messages.size() > 0) {
            throw new KDBizException(org.apache.commons.lang.StringUtils.join(messages, (String)"\n"));
        }
    }

    private Map<Long, CoreBillInfo> mergeCoreBillInfo(Map<String, CoreBillInfo> coreBillInfo) {
        HashMap<Long, CoreBillInfo> mergeCoreBillInfo = new HashMap<Long, CoreBillInfo>(16);
        for (Map.Entry<String, CoreBillInfo> entrySet : coreBillInfo.entrySet()) {
            CoreBillInfo info = entrySet.getValue();
            Long coreBillId = info.getCoreBillId();
            if (coreBillId == null) continue;
            CoreBillInfo mergeInfo = (CoreBillInfo)mergeCoreBillInfo.get(coreBillId);
            if (mergeInfo == null) {
                mergeInfo = new CoreBillInfo();
                mergeInfo.setCoreBillId(coreBillId);
                mergeInfo.setSumPrePayAmt(info.getSumPrePayAmt());
                mergeInfo.setSumAmt(info.getSumAmt());
                mergeInfo.setOrgId(info.getOrgId());
                mergeInfo.setCurrencyId(info.getCurrencyId());
                mergeInfo.setCoreBillAmt(info.getCoreBillAmt());
                mergeInfo.setPreparePayAmt(info.getPreparePayAmt());
                mergeCoreBillInfo.put(coreBillId, mergeInfo);
                continue;
            }
            mergeInfo.setCoreBillAmt(mergeInfo.getCoreBillAmt().add(info.getCoreBillAmt()));
            mergeInfo.setSumAmt(mergeInfo.getSumAmt().add(info.getSumAmt()));
            mergeInfo.setSumPrePayAmt(mergeInfo.getSumPrePayAmt().add(info.getSumPrePayAmt()));
        }
        return mergeCoreBillInfo;
    }

    private void setCtrlBillInfo(Map<String, CoreBillInfo> coreBillInfoMap, List<CoreBillInfo> cacheData) {
        HashSet<Long> coreBillIds = new HashSet<Long>(16);
        for (Map.Entry<String, CoreBillInfo> entry : coreBillInfoMap.entrySet()) {
            CoreBillInfo info = entry.getValue();
            coreBillIds.add(info.getCoreBillId());
        }
        HashSet<Long> billIds = new HashSet<Long>(16);
        for (CoreBillInfo cacheInfo : cacheData) {
            billIds.add(cacheInfo.getBillId());
            Long coreBillId = cacheInfo.getCoreBillId();
            Long orgId = cacheInfo.getOrgId();
            Long asstactId = cacheInfo.getSupplierId();
            Long cacheCurrencyId = cacheInfo.getCurrencyId();
            String key = coreBillId + "_" + orgId + "_" + asstactId + "_" + cacheCurrencyId;
            CoreBillInfo coreBillInfo = coreBillInfoMap.get(key);
            if (coreBillInfo == null) continue;
            coreBillInfo.setSumPrePayAmt(coreBillInfo.getSumPrePayAmt().add(cacheInfo.getPreparePayAmt()));
            coreBillInfo.setSumAmt(coreBillInfo.getSumAmt().add(cacheInfo.getCoreBillAmt()));
        }
        HashSet<Long> hashSet = new HashSet<Long>(16);
        HashSet<Long> srcFinBillIds = new HashSet<Long>(16);
        DynamicObjectCollection payBills = QueryServiceHelper.query((String)"ap_payapply", (String)"id,sourcebilltype,billstatus,settlecurrency,settleorg,entry.e_paymenttype.biztype,entry.e_asstact,entry.e_corebillid,entry.e_approvedamt,entry.e_paidamt,entry.id", (QFilter[])new QFilter[]{new QFilter("entry.e_corebillid", "in", coreBillIds), new QFilter("billstatus", "!=", (Object)"A")});
        for (DynamicObject bill : payBills) {
            String sourceBillType = bill.getString("sourcebilltype");
            if (!"ap_finapbill".equals(sourceBillType)) continue;
            Long orgId = bill.getLong("settleorg");
            Integer settleModel = this.settleModelMap.get(orgId);
            if (settleModel == null) {
                settleModel = SystemParameterHelper.getParameterInteger((long)orgId, (String)"ap_003");
                this.settleModelMap.put(orgId, settleModel);
            }
            if (2 != settleModel) continue;
            hashSet.add(bill.getLong("entry.id"));
        }
        HashMap<Long, Long> entryIdToSrcBillIdMap = new HashMap<Long, Long>(16);
        if (hashSet.size() != 0) {
            String sql = "select fentryid,fsbillid from t_ap_applypaybillentry_lk where fentryid in" + StringUtils.longSetToString(hashSet);
            DataSet srcDatas = DB.queryDataSet((String)"applypaybillentry", (DBRoute)DBRoute.of((String)"ap"), (String)sql);
            for (Row row : srcDatas) {
                srcFinBillIds.add(row.getLong("fsbillid"));
                entryIdToSrcBillIdMap.put(row.getLong("fentryid"), row.getLong("fsbillid"));
            }
        }
        Map<Object, Object> srcFinCoreBillCountMap = new HashMap(16);
        HashMap applyEntryNeedCalculateMap = new HashMap(16);
        if (srcFinBillIds.size() > 0) {
            srcFinCoreBillCountMap = this.getSrcFinCoreBillIdCounts(srcFinBillIds);
            for (Map.Entry entrySet : entryIdToSrcBillIdMap.entrySet()) {
                Long finBillId = (Long)entrySet.getValue();
                Integer count = (Integer)srcFinCoreBillCountMap.get(finBillId);
                if (count == null) continue;
                if (count == 1) {
                    applyEntryNeedCalculateMap.put(entrySet.getKey(), Boolean.TRUE);
                    continue;
                }
                applyEntryNeedCalculateMap.put(entrySet.getKey(), Boolean.FALSE);
            }
        }
        for (DynamicObject bill : payBills) {
            Long billId = bill.getLong("id");
            if (billIds.contains(billId)) continue;
            Long coreBillId = bill.getLong("entry.e_corebillid");
            Long orgId = bill.getLong("settleorg");
            Long asstactId = bill.getLong("entry.e_asstact");
            Long currencyId = bill.getLong("settlecurrency");
            String key = coreBillId + "_" + orgId + "_" + asstactId + "_" + currencyId;
            CoreBillInfo coreBillInfo = coreBillInfoMap.get(key);
            if (coreBillInfo == null) continue;
            String billStatus = bill.getString("billstatus");
            BigDecimal approvedAmt = "D".equals(billStatus) ? bill.getBigDecimal("entry.e_paidamt") : bill.getBigDecimal("entry.e_approvedamt");
            String sourceBillType = bill.getString("sourcebilltype");
            String payType = bill.getString("entry.e_paymenttype.biztype");
            if ("pm_purorderbill".equals(sourceBillType) || "conm_purcontract".equals(sourceBillType) || "sctm_scpo".equals(sourceBillType)) {
                coreBillInfo.setSumAmt(coreBillInfo.getSumAmt().add(approvedAmt));
                if (!"202".equals(payType)) continue;
                coreBillInfo.setSumPrePayAmt(coreBillInfo.getSumPrePayAmt().add(approvedAmt));
                continue;
            }
            if (!"ap_finapbill".equals(sourceBillType)) continue;
            int settleModel = this.settleModelMap.get(orgId);
            if (1 == settleModel) {
                coreBillInfo.setSumAmt(coreBillInfo.getSumAmt().add(approvedAmt));
                if (!"202".equals(payType)) continue;
                coreBillInfo.setSumPrePayAmt(coreBillInfo.getSumPrePayAmt().add(approvedAmt));
                continue;
            }
            Long entryId = bill.getLong("entry.id");
            boolean needCalculate = (Boolean)applyEntryNeedCalculateMap.get(entryId);
            if (!needCalculate) continue;
            coreBillInfo.setSumAmt(coreBillInfo.getSumAmt().add(approvedAmt));
            if (!"202".equals(payType)) continue;
            coreBillInfo.setSumPrePayAmt(coreBillInfo.getSumPrePayAmt().add(approvedAmt));
        }
    }

    private Map<Long, Integer> getSrcFinCoreBillIdCounts(Set<Long> finIds) {
        HashMap<Long, Integer> srcFinCoreBillCountMap = new HashMap<Long, Integer>(16);
        DynamicObjectCollection finApBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,detailentry.corebillid", (QFilter[])new QFilter[]{new QFilter("id", "in", finIds)});
        Map<Long, List<DynamicObject>> finBillGroupById = finApBills.stream().collect(Collectors.groupingBy(v -> v.getLong("id")));
        for (Map.Entry<Long, List<DynamicObject>> entrySet : finBillGroupById.entrySet()) {
            List<DynamicObject> finBills = entrySet.getValue();
            HashSet<Long> coreBillIds = new HashSet<Long>(16);
            for (DynamicObject finBill : finBills) {
                Long coreBillId = finBill.getLong("detailentry.corebillid");
                if (coreBillId == 0L) continue;
                coreBillIds.add(coreBillId);
                if (coreBillIds.size() <= 1) continue;
                break;
            }
            if (coreBillIds.size() == 1) {
                srcFinCoreBillCountMap.put(entrySet.getKey(), 1);
                continue;
            }
            srcFinCoreBillCountMap.put(entrySet.getKey(), 2);
        }
        return srcFinCoreBillCountMap;
    }

    private Map<String, CoreBillInfo> queryCoreBill(DynamicObject[] bills) {
        List orderInfo;
        HashMap<String, CoreBillInfo> coreBillInfoMap = new HashMap<String, CoreBillInfo>(16);
        HashMap coreOrderBillInfo = new HashMap(16);
        HashMap coreConBillInfo = new HashMap(16);
        HashMap coreOmBillInfo = new HashMap(16);
        for (DynamicObject bill : bills) {
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                Long coreBillId = row.getLong("e_corebillid");
                if (coreBillId == 0L) continue;
                String coreBillType = row.getString("e_corebilltype");
                if ("pm_purorderbill".equals(coreBillType)) {
                    coreOrderBillInfo.put(coreBillId, new HashSet(2));
                    continue;
                }
                if ("conm_purcontract".equals(coreBillType)) {
                    coreConBillInfo.put(coreBillId, new HashSet(2));
                    continue;
                }
                if (!"sctm_scpo".equals(coreBillType)) continue;
                coreOmBillInfo.put(coreBillId, new HashSet(2));
            }
        }
        if (coreOrderBillInfo.size() > 0) {
            orderInfo = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"PurOrderService", (String)"queryOverPayParamAndAmount", (Object[])new Object[]{coreOrderBillInfo});
            this.setCoreBillInfoMap(coreBillInfoMap, orderInfo);
        }
        if (coreConBillInfo.size() > 0) {
            orderInfo = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"conm", (String)"PurConmService", (String)"queryOverPayParamAndAmount", (Object[])new Object[]{coreConBillInfo});
            this.setCoreBillInfoMap(coreBillInfoMap, orderInfo);
        }
        if (coreOmBillInfo.size() > 0) {
            orderInfo = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sctm", (String)"ScPoService", (String)"queryOverPayParamAndAmount", (Object[])new Object[]{coreOmBillInfo});
            this.setCoreBillInfoMap(coreBillInfoMap, orderInfo);
        }
        return coreBillInfoMap;
    }

    private void setCoreBillInfoMap(Map<String, CoreBillInfo> coreBillInfoMap, List<Map<String, Object>> params) {
        for (Map<String, Object> map : params) {
            boolean isAllowOverPay = (Boolean)map.get("isallowoverpay");
            if (isAllowOverPay) continue;
            Long id = (Long)map.get("billid");
            Long asstactId = (Long)map.get("supplier");
            Long currencyId = (Long)map.get("settlecurrency");
            BigDecimal preparePayAmt = (BigDecimal)map.get("sumprepayamount");
            List entrys = (List)map.get("entryinfo");
            for (Map entry : entrys) {
                Long orgId = (Long)entry.get("settleorg");
                String key = id + "_" + orgId + "_" + asstactId + "_" + currencyId;
                CoreBillInfo info = coreBillInfoMap.get(key);
                if (info == null) {
                    info = new CoreBillInfo();
                    info.setCoreBillId(id);
                    info.setOrgId(orgId);
                    info.setSupplierId(asstactId);
                    info.setCoreBillAmt((BigDecimal)entry.get("amountandtax"));
                    info.setCurrencyId(currencyId);
                    info.setPreparePayAmt(preparePayAmt);
                    coreBillInfoMap.put(key, info);
                    continue;
                }
                info.setCoreBillAmt(info.getCoreBillAmt().add((BigDecimal)entry.get("amountandtax")));
            }
        }
    }
}

