/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.enums.ApplyInvSrcTypeEnum;

public class PayApplyDeleteInvEntryValidator
extends AbstractValidator {
    public void validate() {
        Map<Long, DynamicObject> invoiceMap = this.getInvoiceMap();
        if (invoiceMap.isEmpty()) {
            return;
        }
        block0: for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObject applyBill = dataEntity.getDataEntity();
            DynamicObjectCollection invEntry = applyBill.getDynamicObjectCollection("inventry");
            for (DynamicObject invRow : invEntry) {
                DynamicObject invoice = invoiceMap.get(invRow.getLong("invid"));
                if (invoice == null) continue;
                String iSrcType = invRow.getString("i_srctype");
                if (ApplyInvSrcTypeEnum.INVOICECOLLECT.getValue().equals(iSrcType) ? invoice.getBoolean("isreffin") && "ap_payapply".equals(invoice.getString("businesssource")) && invoice.getBigDecimal("pricetaxtotal").compareTo(invoice.getBigDecimal("unrelatedamt")) == 0 && !invoice.getBoolean("ismatched") && !invoice.getBoolean("isvoucher") : ApplyInvSrcTypeEnum.ASSIGNINVOICE.getValue().equals(iSrcType) && !invoice.getBoolean("isreffin") && "ap_payapply".equals(invoice.getString("businesssource")) && invoice.getBigDecimal("pricetaxtotal").compareTo(invoice.getBigDecimal("unrelatedamt")) == 0 && !invoice.getBoolean("ismatched") && !invoice.getBoolean("isvoucher")) continue;
                String message = ResManager.loadKDString((String)"\u9884\u4ed8\u6b3e\u53d1\u7968\u5b58\u5728\u4ee5\u4e0b\u60c5\u51b5\uff0c\u64cd\u4f5c\u5931\u8d25\u3002\u82e5\u9700\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5148\u5c06\u9884\u4ed8\u6b3e\u53d1\u7968\u53d6\u6d88\u5165\u8d26\u3001\u53d6\u6d88\u53d1\u7968\u5339\u914d\u3001\u53d6\u6d88\u4e0e\u8d22\u52a1\u5e94\u4ed8\u5355\u5173\u8054\u3002", (String)"PayApplyDeleteInvEntryValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"1.\u9884\u4ed8\u6b3e\u53d1\u7968\u5df2\u5165\u8d26\u3002", (String)"PayApplyDeleteInvEntryValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"2.\u9884\u4ed8\u6b3e\u53d1\u7968\u5df2\u53c2\u4e0e\u53d1\u7968\u5339\u914d\u3002", (String)"PayApplyDeleteInvEntryValidator_2", (String)"fi-ap-opplugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"3.\u9884\u4ed8\u6b3e\u53d1\u7968\u5df2\u4e0e\u8d22\u52a1\u5e94\u4ed8\u5355\u5173\u8054\u3002", (String)"PayApplyDeleteInvEntryValidator_3", (String)"fi-ap-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, message);
                continue block0;
            }
        }
    }

    private Map<Long, DynamicObject> getInvoiceMap() {
        Set<Long> deleteInvoiceIds = new HashSet(16);
        Map optionMap = this.getOption().getVariables();
        String invPks = (String)optionMap.get("invPks");
        String selectRows = (String)optionMap.get("selectrows");
        if (ObjectUtils.isEmpty((Object)invPks)) {
            for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
                DynamicObject applyBill = dataEntity.getDataEntity();
                boolean isNoPerPay = ("save".equals(this.getOperateKey()) || "submit".equals(this.getOperateKey())) && !applyBill.getBoolean("isprepayinvoice");
                boolean isBillClose = this.isBillClose(selectRows, applyBill);
                boolean isAntiAssign = "antiassign".equals(this.getOperateKey());
                DynamicObjectCollection invEntry = applyBill.getDynamicObjectCollection("inventry");
                for (DynamicObject invRow : invEntry) {
                    if (!isNoPerPay && !"delete".equals(this.getOperateKey()) && !isBillClose && (!isAntiAssign || !ApplyInvSrcTypeEnum.ASSIGNINVOICE.getValue().equals(invRow.getString("i_srctype")))) continue;
                    deleteInvoiceIds.add(invRow.getLong("invid"));
                }
            }
        } else {
            deleteInvoiceIds = (Set)JSONObject.parseObject((String)invPks, Set.class);
        }
        if (deleteInvoiceIds.isEmpty()) {
            return new HashMap<Long, DynamicObject>(8);
        }
        HashMap<Long, DynamicObject> invoiceMap = new HashMap<Long, DynamicObject>(16);
        DynamicObjectCollection invoices = QueryServiceHelper.query((String)"ap_invoice", (String)"id,unrelatedamt,pricetaxtotal,ismatched,isvoucher,isreffin,businesssource", (QFilter[])new QFilter[]{new QFilter("id", "in", deleteInvoiceIds)});
        for (DynamicObject invoice : invoices) {
            invoiceMap.put(invoice.getLong("id"), invoice);
        }
        return invoiceMap;
    }

    private boolean isBillClose(String selectRows, DynamicObject applyBill) {
        if (!"closepay".equals(this.getOperateKey())) {
            return false;
        }
        if (ObjectUtils.isEmpty((Object)selectRows)) {
            return true;
        }
        List selectRowList = (List)SerializationUtils.fromJsonString((String)selectRows, List.class);
        ArrayList<Long> allUnCloseRowIds = new ArrayList<Long>(8);
        DynamicObjectCollection entry = applyBill.getDynamicObjectCollection("entry");
        for (DynamicObject row : entry) {
            if (!"A".equals(row.getString("e_closestatus"))) continue;
            allUnCloseRowIds.add(row.getLong("id"));
        }
        for (Long needCloseRowId : selectRowList) {
            allUnCloseRowIds.remove(needCloseRowId);
        }
        return allUnCloseRowIds.isEmpty();
    }
}

