/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.excecontrol.IOthersExecCtrlService;
import kd.fi.arapcommon.helper.BOTPHelper;

public class PayMentBillToPurBillValidatorByRelation
implements IOthersExecCtrlService {
    public Set<String> preparePropertys() {
        HashSet<String> selector = new HashSet<String>(16);
        selector.add("e_payableamt");
        selector.add("e_refundamt");
        return selector;
    }

    public Map<Long, String> validate(DynamicObject[] others) {
        Long supplierId;
        HashMap<Long, String> resultMap = new HashMap<Long, String>(16);
        HashSet<Long> payBillIds = new HashSet<Long>(16);
        for (DynamicObject payBill : others) {
            payBillIds.add(payBill.getLong("id"));
        }
        Map payBillIdToOrderIds = BOTPHelper.findSourceBills((String)"cas_paybill", (Long[])payBillIds.toArray(new Long[0]));
        Set orderBillIds = (Set)payBillIdToOrderIds.get("pm_purorderbill");
        if (orderBillIds == null || orderBillIds.size() == 0) {
            return new HashMap<Long, String>(8);
        }
        DynamicObjectCollection orderBills = QueryServiceHelper.query((String)"pm_purorderbill", (String)"totalallamount,invoicesupplier", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)orderBillIds)});
        HashMap<Long, BigDecimal> purSupplierAmt = new HashMap<Long, BigDecimal>(16);
        for (DynamicObject orderBill : orderBills) {
            Long supplierId2 = orderBill.getLong("invoicesupplier");
            BigDecimal supplierSumAmt = (BigDecimal)purSupplierAmt.get(supplierId2);
            if (supplierSumAmt == null) {
                purSupplierAmt.put(supplierId2, orderBill.getBigDecimal("totalallamount"));
                continue;
            }
            purSupplierAmt.put(supplierId2, supplierSumAmt.add(orderBill.getBigDecimal("totalallamount")));
        }
        Map allDownBillIdsMap = BOTPHelper.findTargetBills((String)"pm_purorderbill", (Long[])orderBillIds.toArray(new Long[0]));
        if (allDownBillIdsMap.size() == 0) {
            return resultMap;
        }
        Set downAllPayBillIds = (Set)allDownBillIdsMap.get("cas_paybill");
        if (downAllPayBillIds == null || downAllPayBillIds.size() == 0) {
            return resultMap;
        }
        DynamicObjectCollection payBills = QueryServiceHelper.query((String)"cas_paybill", (String)"payee,entry.e_payableamt,entry.e_refundamt", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)downAllPayBillIds)});
        HashMap<Long, BigDecimal> payAsstactAmt = new HashMap<Long, BigDecimal>(16);
        for (DynamicObject payBill : payBills) {
            supplierId = payBill.getLong("payee");
            BigDecimal asstactSumAmt = (BigDecimal)payAsstactAmt.get(supplierId);
            if (asstactSumAmt == null) {
                payAsstactAmt.put(supplierId, payBill.getBigDecimal("entry.e_payableamt").subtract(payBill.getBigDecimal("entry.e_refundamt")));
                continue;
            }
            payAsstactAmt.put(supplierId, asstactSumAmt.add(payBill.getBigDecimal("entry.e_payableamt").subtract(payBill.getBigDecimal("entry.e_refundamt"))));
        }
        for (Map.Entry entrySet : purSupplierAmt.entrySet()) {
            supplierId = (Long)entrySet.getKey();
            BigDecimal purAmt = (BigDecimal)entrySet.getValue();
            BigDecimal paySumAmt = (BigDecimal)payAsstactAmt.get(supplierId);
            if (paySumAmt == null || purAmt.compareTo(paySumAmt) >= 0) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u6309\u91c7\u8d2d\u8ba2\u5355\u67e5\u8be2\u7684\u4ed8\u6b3e\u5355\u7d2f\u8ba1\u5e94\u4ed8\u91d1\u989d\u51cf\u5df2\u9000\u6b3e\u91d1\u989d\u4e4b\u548c\u8d85\u8fc7\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\u884c\u76f8\u540c\u7ed3\u7b97\u7ec4\u7ec7\u4ef7\u7a0e\u5408\u8ba1\u6c47\u603b\u503c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PaymentBillOverPayValidator_0", (String)"fi-ar-mservice", (Object[])new Object[0]));
        }
        return resultMap;
    }
}

