/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.enums.SettleBillTypeEnum;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.util.StdConfig;

public class SettleRecordUnSettleValidator
extends AbstractValidator {
    public void validate() {
        if (this.dataEntities.length > 1) {
            for (ExtendedDataEntity entity : this.dataEntities) {
                DynamicObject settleRecord = entity.getDataEntity();
                if (!settleRecord.getBoolean("iswrittenoff")) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u7ea2\u51b2\u751f\u6210\u7684\u7ed3\u7b97\u8bb0\u5f55\u4e0d\u5141\u8bb8\u6279\u91cf\u53cd\u7ed3\u7b97\u3002", (String)"SettleRecordUnSettleValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]));
            }
        }
        HashMap<String, Set<Long>> billIdInfoMap = new HashMap<String, Set<Long>>(3);
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject settleRecord = entity.getDataEntity();
            this.setIdMapInfo(billIdInfoMap, settleRecord.getString("billentity"), settleRecord.getLong("mainbillid"));
            for (DynamicObject row : settleRecord.getDynamicObjectCollection("entry")) {
                this.setIdMapInfo(billIdInfoMap, row.getString("e_billentity"), row.getLong("billid"));
            }
        }
        Set<Long> existIds = this.getExistIds(billIdInfoMap);
        if (ObjectUtils.isEmpty(existIds)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u7ed3\u7b97\u8bb0\u5f55\u7684\u4e3b\u8f85\u65b9\u5355\u636e\u5747\u88ab\u5220\u9664\uff0c\u4e0d\u5141\u8bb8\u53cd\u7ed3\u7b97\u3002", (String)"SettleRecordUnSettleValidator_4", (String)"fi-ap-opplugin", (Object[])new Object[0]));
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject settleRecord = dataEntity.getDataEntity();
            if (!existIds.contains(settleRecord.getLong("mainbillid"))) {
                String billNo = settleRecord.getString("billno");
                String message = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e3a%s\u7684\u5355\u636e\u5df2\u5220\u9664\uff0c\u4e0d\u5141\u8bb8\u53cd\u7ed3\u7b97\u76f8\u5173\u7ed3\u7b97\u8bb0\u5f55\u3002", (String)"SettleRecordUnSettleValidator_6", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo);
                this.addErrorMessage(dataEntity, message);
            }
            DynamicObjectCollection entry = settleRecord.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                if (existIds.contains(row.getLong("billid"))) continue;
                String billNo = row.getString("billnum");
                String message = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e3a%s\u7684\u5355\u636e\u5df2\u5220\u9664\uff0c\u4e0d\u5141\u8bb8\u53cd\u7ed3\u7b97\u76f8\u5173\u7ed3\u7b97\u8bb0\u5f55\u3002", (String)"SettleRecordUnSettleValidator_6", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo);
                this.addErrorMessage(dataEntity, message);
            }
        }
        HashSet<Long> billIdSet = new HashSet<Long>(8);
        HashSet<Long> billEntryIdSet = new HashSet<Long>(8);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject entity = dataEntity.getDataEntity();
            if (!SettleRelationEnum.PAYRECSETTLE.getValue().equals(entity.getString("settlerelation")) || !"cas_paybill".equals(entity.getString("billentity"))) continue;
            billIdSet.add(entity.getLong("mainbillid"));
            billEntryIdSet.add(entity.getLong("mainbillentryid"));
        }
        Map<Long, List<Long>> payBillFinApMap = new HashMap<Long, List<Long>>(8);
        if (billIdSet.size() > 0) {
            payBillFinApMap = BOTPHelper.loadNearUpBillIds((String)"cas_paybill", (String)"entry", (Long[])billIdSet.toArray(new Long[0]), (Long[])billEntryIdSet.toArray(new Long[0]), (String)"ap_finapbill");
        }
        Map<Long, DynamicObject> refundRecordMap = this.getRefundRecordMap(payBillFinApMap);
        for (ExtendedDataEntity data : this.dataEntities) {
            Object row2;
            DynamicObject dataEntity = data.getDataEntity();
            if ("fromeas".equals(dataEntity.getString("settletype"))) {
                this.addMessage(data, ResManager.loadKDString((String)"\u7ed3\u7b97\u8bb0\u5f55\u4e3aEAS\u96c6\u6210\u7684\u6570\u636e\uff0c\u4e3a\u4fdd\u8bc1\u6570\u636e\u4e00\u81f4\u6027\uff0c\u4e0d\u5141\u8bb8\u53cd\u7ed3\u7b97\u3002", (String)"SettleRecordUnSettleValidator_21", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                continue;
            }
            DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("entry");
            String settlerelation = dataEntity.getString("settlerelation");
            String autoSettleType = dataEntity.getString("autosettletype");
            if (!"true".equals(StdConfig.get((String)"allowBotpUsettle")) && "1".equals(autoSettleType) && SettleRelationEnum.APPAYSETTLE.getValue().equals(settlerelation)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u7ed3\u7b97\u5173\u7cfb\u4e3a\u201c\u5e94\u4ed8\u4ed8\u6b3e\u201d\u5e76\u4e14\u4e3b\u8f85\u65b9\u5355\u636e\u5b58\u5728\u5173\u8054\u5173\u7cfb\u7684\u7ed3\u7b97\u8bb0\u5f55\uff0c\u53ea\u80fd\u901a\u8fc7\u5bf9\u4ed8\u6b3e\u5355\u53d6\u6d88\u4ed8\u6b3e\u8fdb\u884c\u53cd\u7ed3\u7b97\u3002", (String)"SettleRecordUnSettleValidator_15", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (SettleRelationEnum.PAYRECSETTLE.getValue().equals(settlerelation)) {
                Long mainBillId = dataEntity.getLong("mainbillid");
                List<Long> finApBillIds = payBillFinApMap.get(mainBillId);
                if (finApBillIds != null && finApBillIds.size() > 0) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u7ed3\u7b97\u5173\u7cfb\u4e3a\u201c\u4ed8\u6b3e\u51b2\u6536\u6b3e\u201d\u5e76\u4e14\u4ed8\u6b3e\u5355\u4e0a\u6e38\u5b58\u5728\u8d22\u52a1\u5e94\u4ed8\u5355\u7684\u9000\u6b3e\u9000\u7968\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u53cd\u7ed3\u7b97\u3002", (String)"SettleRecordUnSettleValidator_7", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                    continue;
                }
                ArrayList<DynamicObject> refundRecords = new ArrayList<DynamicObject>(8);
                for (DynamicObject asstEntry : entry) {
                    DynamicObject refundRecord = refundRecordMap.get(asstEntry.getLong("billid"));
                    if (refundRecord == null) continue;
                    refundRecords.add(refundRecord);
                }
                String settleType = dataEntity.getString("settletype");
                if (refundRecords.size() > 0 || "auto".equals(settleType)) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u7ed3\u7b97\u5173\u7cfb\u4e3a\u201c\u4ed8\u6b3e\u51b2\u6536\u6b3e\u201d\u5e76\u4e14\u7ed3\u7b97\u8bb0\u5f55\u4e3a\u9000\u6b3e\u9000\u7968\u4e1a\u52a1\u751f\u6210\u7684\uff0c\u4e0d\u5141\u8bb8\u53cd\u7ed3\u7b97\u3002", (String)"SettleRecordUnSettleValidator_19", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                    continue;
                }
            }
            if (SettleRelationEnum.PAYTRANS.getValue().equals(settlerelation)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u8f6c\u4ed8\u751f\u6210\u7684\u7ed3\u7b97\u8bb0\u5f55\u65e0\u6cd5\u53cd\u7ed3\u7b97\uff0c\u53ea\u80fd\u901a\u8fc7\u53cd\u5ba1\u6838\u8f85\u65b9\u5355\u636e\u53cd\u7ed3\u7b97\u3002", (String)"SettleRecordUnSettleValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (Objects.equals(dataEntity.getString("settlerelation"), SettleRelationEnum.APWRITEOFF.getValue())) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u7ed3\u7b97\u5173\u7cfb\u4e3a\u201c\u5e94\u4ed8\u7ea2\u84dd\u51b2\u9500\u201d\u7684\u7ed3\u7b97\u8bb0\u5f55\uff0c\u53ea\u80fd\u901a\u8fc7\u53cd\u5ba1\u6838\u8f85\u65b9\u5355\u636e\u5b8c\u6210\u53cd\u7ed3\u7b97\u3002", (String)"SettleRecordUnSettleValidator_2", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (Objects.equals(dataEntity.getString("settlerelation"), SettleRelationEnum.PREMSETTLE.getValue())) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u7ed3\u7b97\u5173\u7cfb\u4e3a\u201c\u8f6c\u51fa\u8d28\u4fdd\u91d1\u201d\u7684\u7ed3\u7b97\u8bb0\u5f55\uff0c\u53ea\u80fd\u901a\u8fc7\u53cd\u5ba1\u6838\u8f85\u65b9\u5355\u636e\u53cd\u7ed3\u7b97\u3002", (String)"SettleRecordUnSettleValidator_8", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                continue;
            }
            for (Object row2 : entry) {
                String billType = row2.getString("billtype");
                if (!SettleBillTypeEnum.LIQUIDATION.getValue().equals(billType)) continue;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u201c\u672a\u6e05\u9879\u6e05\u7406\u5355\u201d\u751f\u6210\u7684\u7ed3\u7b97\u8bb0\u5f55\u53ea\u80fd\u901a\u8fc7\u201c\u672a\u6e05\u9879\u6e05\u7406\u5355\u201d\u7684\u201c\u53cd\u5ba1\u6838\u201d\u64cd\u4f5c\u6765\u53cd\u7ed3\u7b97\u3002", (String)"SettleRecordUnSettleValidator_3", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                break;
            }
            if (dataEntity.getBoolean("iswrittenoff")) {
                BigDecimal mainTotalSettleaAmt;
                BigDecimal mainBillUnamount;
                Object row32;
                QFilter mainIdFilter;
                long mainBillId = dataEntity.getLong("mainbillid");
                String mainBillEntity = dataEntity.getString("billentity");
                DynamicObject mainBillStatus = QueryServiceHelper.queryOne((String)mainBillEntity, (String)"billstatus", (QFilter[])new QFilter[]{mainIdFilter = new QFilter("id", "=", (Object)mainBillId)});
                if (ObjectUtils.isEmpty((Object)mainBillStatus)) continue;
                if (!("C".equals(mainBillStatus.getString("billstatus")) || "cas_paybill".equals(mainBillEntity) || "cas_recbill".equals(mainBillEntity))) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e3b\u65b9\u5355\u636e\u72b6\u6001\u4e0d\u7b49\u4e8e\u5df2\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u53cd\u7ed3\u7b97\u3002", (String)"SettleRecordUnSettleValidator_9", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                }
                if (!"D".equals(mainBillStatus.getString("billstatus")) && "cas_recbill".equals(mainBillEntity)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e3b\u65b9\u5355\u636e\u72b6\u6001\u4e0d\u7b49\u4e8e\u5df2\u6536\u6b3e\uff0c\u4e0d\u5141\u8bb8\u53cd\u7ed3\u7b97\u3002", (String)"SettleRecordUnSettleValidator_10", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                }
                if (!"D".equals(mainBillStatus.getString("billstatus")) && "cas_paybill".equals(mainBillEntity)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e3b\u65b9\u5355\u636e\u72b6\u6001\u4e0d\u7b49\u4e8e\u5df2\u4ed8\u6b3e\uff0c\u4e0d\u5141\u8bb8\u53cd\u7ed3\u7b97\u3002", (String)"SettleRecordUnSettleValidator_11", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                }
                HashMap<String, Set<Long>> entryIdMap = new HashMap<String, Set<Long>>(entry.size());
                for (Object row32 : entry) {
                    String billEntity = row32.getString("e_billentity");
                    long billId = row32.getLong("billid");
                    this.setIdMapInfo(entryIdMap, billEntity, billId);
                }
                Set entryIdEntries = entryIdMap.entrySet();
                row32 = entryIdEntries.iterator();
                while (row32.hasNext()) {
                    Map.Entry entryIdEntry = (Map.Entry)row32.next();
                    String key = (String)entryIdEntry.getKey();
                    Set value = (Set)entryIdEntry.getValue();
                    QFilter idFilter = new QFilter("id", "in", (Object)value);
                    DynamicObjectCollection billStatusList = this.getBillFields(key, "billstatus", idFilter);
                    for (DynamicObject billStatus : billStatusList) {
                        if (!("C".equals(billStatus.getString("billstatus")) || "cas_paybill".equals(key) || "cas_recbill".equals(key))) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u8f85\u65b9\u5355\u636e\u72b6\u6001\u4e0d\u7b49\u4e8e\u5df2\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u53cd\u7ed3\u7b97\u3002", (String)"SettleRecordUnSettleValidator_12", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                        }
                        if (!"D".equals(billStatus.getString("billstatus")) && "cas_recbill".equals(key)) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u8f85\u65b9\u5355\u636e\u72b6\u6001\u4e0d\u7b49\u4e8e\u5df2\u6536\u6b3e\uff0c\u4e0d\u5141\u8bb8\u53cd\u7ed3\u7b97\u3002", (String)"SettleRecordUnSettleValidator_13", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                        }
                        if ("D".equals(billStatus.getString("billstatus")) || !"cas_paybill".equals(key)) continue;
                        throw new KDBizException(ResManager.loadKDString((String)"\u8f85\u65b9\u5355\u636e\u72b6\u6001\u4e0d\u7b49\u4e8e\u5df2\u4ed8\u6b3e\uff0c\u4e0d\u5141\u8bb8\u53cd\u7ed3\u7b97\u3002", (String)"SettleRecordUnSettleValidator_14", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                    }
                }
                String mainSettleEntry = dataEntity.getString("settleentry");
                long mainBillEntryId = dataEntity.getLong("mainbillentryid");
                String mainEntryEntityKey = this.getEntryEntityKey(mainBillEntity, mainSettleEntry);
                String mainEntryAmountField = this.getEntryAmountField(mainBillEntity, mainSettleEntry);
                QFilter mainEntryFilter = new QFilter(mainEntryEntityKey + ".id", "=", (Object)mainBillEntryId);
                DynamicObject mainBill = QueryServiceHelper.queryOne((String)mainBillEntity, (String)(mainEntryEntityKey + "." + mainEntryAmountField), (QFilter[])new QFilter[]{mainEntryFilter});
                if (ObjectUtils.isEmpty((Object)mainBill)) continue;
                BigDecimal mainAmount = dataEntity.getBigDecimal("mainpayableamt");
                if (this.isOverQuota(mainAmount, mainBillUnamount = mainBill.getBigDecimal(mainEntryEntityKey + "." + mainEntryAmountField), mainTotalSettleaAmt = dataEntity.getBigDecimal("totalsettleamt").negate())) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e3b\u65b9\u5355\u636e\u5df2\u7ed3\u7b97\u91d1\u989d\u9700\u5c0f\u4e8e\u7b49\u4e8e\u5355\u636e\u5e94\u4ed8\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u540e\u64cd\u4f5c\u3002", (String)"SettleRecordUnSettleValidator_17", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                }
                HashMap<String, Set<Long>> billEntryIdMap = new HashMap<String, Set<Long>>(entry.size());
                HashMap<String, String> settleMap = new HashMap<String, String>(2);
                for (DynamicObject row4 : entry) {
                    String billEntity = row4.getString("e_billentity");
                    long billId = row4.getLong("billentryid");
                    this.setIdMapInfo(billEntryIdMap, billEntity, billId);
                    settleMap.put(billEntity, row4.getString("e_settleentry"));
                }
                Set billEntryIdEntries = billEntryIdMap.entrySet();
                for (Map.Entry billEntryIdEntry : billEntryIdEntries) {
                    String key = (String)billEntryIdEntry.getKey();
                    Set value = (Set)billEntryIdEntry.getValue();
                    String sellteEntry = (String)settleMap.get(key);
                    String entryEntityKey = this.getEntryEntityKey(key, sellteEntry);
                    String entryAmountField = this.getEntryAmountField(key, sellteEntry);
                    QFilter entryFilter = new QFilter(entryEntityKey + ".id", "in", (Object)value);
                    DynamicObjectCollection bills = this.getBillFields(key, entryEntityKey + ".id," + entryEntityKey + "." + entryAmountField, entryFilter);
                    for (DynamicObject bill : bills) {
                        for (DynamicObject row5 : entry) {
                            BigDecimal amount = row5.getBigDecimal("payableamt");
                            BigDecimal billUnamount = bill.getBigDecimal(entryEntityKey + "." + entryAmountField);
                            BigDecimal totalSettleaAmt = row5.getBigDecimal("settleamt").negate();
                            if (bill.getLong(entryEntityKey + ".id") != row5.getLong("billentryid") || !this.isOverQuota(amount, billUnamount, totalSettleaAmt)) continue;
                            throw new KDBizException(ResManager.loadKDString((String)"\u8f85\u65b9\u5355\u636e\u5df2\u7ed3\u7b97\u91d1\u989d\u9700\u5c0f\u4e8e\u7b49\u4e8e\u5355\u636e\u5e94\u4ed8\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u540e\u64cd\u4f5c\u3002", (String)"SettleRecordUnSettleValidator_20", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                        }
                    }
                }
            }
            if (dataEntity.getBoolean("hadwrittenoff")) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5df2\u88ab\u7ea2\u51b2\u7684\u7ed3\u7b97\u8bb0\u5f55\u65e0\u6cd5\u53cd\u7ed3\u7b97\u3002", (String)"SettleRecordUnSettleValidator_5", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                continue;
            }
            boolean result = false;
            if (entry.size() <= 1) continue;
            row2 = entry.iterator();
            while (row2.hasNext()) {
                Iterator entry0 = (DynamicObject)row2.next();
                boolean hadWriteOff = entry0.getBoolean("e_hadwrittenoff");
                if (!hadWriteOff) continue;
                result = true;
                break;
            }
            if (!result) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u7ed3\u7b97\u8bb0\u5f55\u7684\u8f85\u65b9\u5b58\u5728\u88ab\u7ea2\u51b2\u548c\u9700\u8981\u53cd\u7ed3\u7b97\u7684\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u7ed3\u7b97\u8bb0\u5f55\u53cd\u7ed3\u7b97\uff0c\u8bf7\u53cd\u64cd\u4f5c\u9700\u8981\u53cd\u7ed3\u7b97\u7684\u8f85\u65b9\u5355\u636e\u3002", (String)"SettleRecordUnSettleValidator_16", (String)"fi-ap-opplugin", (Object[])new Object[0]));
        }
        String allowPrePaylUnsettle = StdConfig.get((String)"allowprepaylunsettle");
        if (!"true".equals(allowPrePaylUnsettle)) {
            HashSet<Long> coreBillSettlePayBillIds = new HashSet<Long>(16);
            for (ExtendedDataEntity entity : this.dataEntities) {
                DynamicObject settleRecord = entity.getDataEntity();
                String settleType = settleRecord.getString("settletype");
                String settleRelation = settleRecord.getString("settlerelation");
                String autoSettleType = settleRecord.getString("autosettletype");
                if (!"auto".equals(settleType) || !"appaysettle".equals(settleRelation) || !"2".equals(autoSettleType)) continue;
                for (DynamicObject row : settleRecord.getDynamicObjectCollection("entry")) {
                    coreBillSettlePayBillIds.add(row.getLong("billid"));
                }
            }
            Set<Long> prePayBillIds = this.getPrePayBillIds(coreBillSettlePayBillIds);
            block19: for (ExtendedDataEntity entity : this.dataEntities) {
                DynamicObject settleRecord = entity.getDataEntity();
                String settleType = settleRecord.getString("settletype");
                String settleRelation = settleRecord.getString("settlerelation");
                String autoSettleType = settleRecord.getString("autosettletype");
                if (!"auto".equals(settleType) || !"appaysettle".equals(settleRelation) || !"2".equals(autoSettleType)) continue;
                for (DynamicObject row : settleRecord.getDynamicObjectCollection("entry")) {
                    if (!prePayBillIds.contains(row.getLong("billid"))) continue;
                    String message = String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u5173\u7cfb\u4e3a\u201c\u5e94\u4ed8\u4ed8\u6b3e\u201d\u4e14\u4e3b\u8f85\u65b9\u5355\u636e\u6309\u6838\u5fc3\u5355\u636e\u53f7\u81ea\u52a8\u7ed3\u7b97\u7684\u7ed3\u7b97\u8bb0\u5f55\uff0c\u53ea\u80fd\u901a\u8fc7\u53cd\u5ba1\u6838\u8d22\u52a1\u5e94\u4ed8\u5355\u6216\u4ed8\u6b3e\u5355\u53d6\u6d88\u4ed8\u6b3e\u8fdb\u884c\u53cd\u7ed3\u7b97\u3002", (String)"SettleRecordUnSettleValidator_18", (String)"fi-ap-opplugin", (Object[])new Object[0]), new Object[0]);
                    this.addMessage(entity, message);
                    continue block19;
                }
            }
        }
    }

    private Map<Long, DynamicObject> getRefundRecordMap(Map<Long, List<Long>> payBillFinApMap) {
        HashSet<Long> recBillIds = new HashSet<Long>(8);
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject dataEntity = data.getDataEntity();
            Long mainBillId = dataEntity.getLong("mainbillid");
            String settlerelation = dataEntity.getString("settlerelation");
            if (!SettleRelationEnum.PAYRECSETTLE.getValue().equals(settlerelation) || !ObjectUtils.isEmpty(payBillFinApMap.get(mainBillId))) continue;
            DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("entry");
            for (DynamicObject asstEntry : entry) {
                recBillIds.add(asstEntry.getLong("billid"));
            }
        }
        HashMap<Long, DynamicObject> refundRecordMap = new HashMap<Long, DynamicObject>(8);
        if (!recBillIds.isEmpty()) {
            DynamicObject[] refundRecords;
            for (DynamicObject refundRecord : refundRecords = BusinessDataServiceHelper.load((String)"ap_refundrenote_record", (String)"id,recbillid", (QFilter[])new QFilter[]{new QFilter("recbillid", "in", recBillIds)})) {
                refundRecordMap.put(refundRecord.getLong("recbillid"), refundRecord);
            }
        }
        return refundRecordMap;
    }

    private boolean isOverQuota(BigDecimal priceandTaxTotal, BigDecimal billUnamount, BigDecimal totalSettleaAmt) {
        return priceandTaxTotal.multiply(billUnamount.subtract(totalSettleaAmt)).compareTo(BigDecimal.ZERO) < 0;
    }

    private Set<Long> getExistIds(Map<String, Set<Long>> map) {
        HashSet<Long> existIds = new HashSet<Long>(10);
        Set<Map.Entry<String, Set<Long>>> entries = map.entrySet();
        for (Map.Entry<String, Set<Long>> entry : entries) {
            String key = entry.getKey();
            Set<Long> value = entry.getValue();
            QFilter idFilter = new QFilter("id", "in", value);
            DynamicObjectCollection bills = QueryServiceHelper.query((String)key, (String)"id", (QFilter[])new QFilter[]{idFilter});
            if (bills.isEmpty()) continue;
            for (DynamicObject bill : bills) {
                existIds.add(bill.getLong("id"));
            }
        }
        return existIds;
    }

    private void setIdMapInfo(Map<String, Set<Long>> map, String entity, long id) {
        Set<Long> ids = map.get(entity);
        if (ids != null) {
            ids.add(id);
        } else {
            HashSet<Long> idSet = new HashSet<Long>(10);
            idSet.add(id);
            map.put(entity, idSet);
        }
    }

    private String getEntryEntityKey(String entity, String settleEntry) {
        if ("1".equals(settleEntry)) {
            if ("ar_finarbill".equals(entity)) {
                return "entry";
            }
            if ("ap_finapbill".equals(entity)) {
                return "detailentry";
            }
            if ("cas_recbill".equals(entity) || "cas_paybill".equals(entity) || "ar_receivedbill".equals(entity) || "ap_paidbill".equals(entity)) {
                return "entry";
            }
            if ("ap_liquidation".equals(entity)) {
                return "entryentity";
            }
        } else if ("ap_finapbill".equals(entity) || "ar_finarbill".equals(entity) || "ar_baddebtlossbill".equals(entity)) {
            return "planentity";
        }
        return "";
    }

    private String getEntryAmountField(String entity, String settleEntry) {
        if ("1".equals(settleEntry)) {
            if ("ar_finarbill".equals(entity)) {
                return "e_unlockamt";
            }
            if ("ap_finapbill".equals(entity)) {
                return "unlockamt";
            }
            if ("cas_recbill".equals(entity) || "cas_paybill".equals(entity) || "ar_receivedbill".equals(entity) || "ap_paidbill".equals(entity)) {
                return "e_unsettledamt";
            }
            if ("ap_liquidation".equals(entity)) {
                return "unsettleamt";
            }
        } else if ("ap_finapbill".equals(entity) || "ar_finarbill".equals(entity)) {
            return "unplanlockamt";
        }
        return "";
    }

    private DynamicObjectCollection getBillFields(String entity, String selectedFields, QFilter filter) {
        return QueryServiceHelper.query((String)entity, (String)selectedFields, (QFilter[])new QFilter[]{filter});
    }

    private Set<Long> getPrePayBillIds(Set<Long> coreBillSettlePayBillIds) {
        HashSet<Long> prePayBillIds = new HashSet<Long>(16);
        DynamicObjectCollection payBills = QueryServiceHelper.query((String)"cas_paybill", (String)"id,paymenttype.biztype", (QFilter[])new QFilter[]{new QFilter("id", "in", coreBillSettlePayBillIds)});
        for (DynamicObject bill : payBills) {
            String bizType = bill.getString("paymenttype.biztype");
            if (!"202".equals(bizType)) continue;
            prePayBillIds.add(bill.getLong("id"));
        }
        return prePayBillIds;
    }
}

