/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.vo.MatchBillChain;
import kd.fi.arapcommon.consts.DBRouteConst;

public class ToleranceMatchNumberValidator
extends AbstractValidator {
    public void validate() {
        MatchBillChain matchBillChain = (MatchBillChain)JSON.parseObject((String)this.getOption().getVariableValue("pagechaindata"), MatchBillChain.class);
        Map chainMap = matchBillChain.getChainMap();
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObjectCollection resultEntrys = dataEntity.getDynamicObjectCollection("resultentry");
            Map<String, Map<Long, List<DynamicObject>>> resultGroup = resultEntrys.stream().collect(Collectors.groupingBy(e -> e.getString("rs_entity"), Collectors.groupingBy(e -> e.getLong("rs_entryid"))));
            for (Map.Entry<String, Map<Long, List<DynamicObject>>> billEntityEntry : resultGroup.entrySet()) {
                String billEntity = billEntityEntry.getKey();
                MatchBillChain.MatchChain matchChain = (MatchBillChain.MatchChain)chainMap.get(billEntity);
                String entryIdentify = matchChain.getEntryEntity();
                String qtyKey = entryIdentify.concat("." + matchChain.getQtyKey());
                String amtKey = entryIdentify.concat("." + matchChain.getAmtKey());
                String entryIdKey = entryIdentify.concat(".id");
                String seqKey = entryIdentify.concat(".seq");
                String selectors = String.join((CharSequence)",", qtyKey, amtKey, entryIdKey, seqKey);
                Set<Long> billEntryIds = billEntityEntry.getValue().keySet();
                DynamicObjectCollection billEntrys = QueryServiceHelper.query((String)billEntity, (String)selectors, (QFilter[])new QFilter(entryIdKey, "in", billEntryIds).toArray());
                Map<Long, DynamicObject> billEntryMap = billEntrys.stream().collect(Collectors.toMap(e -> e.getLong(entryIdKey), e -> e));
                Map<Long, MatchRecord> matchRecordMap = this.queryMatchRecords(billEntryIds);
                for (Map.Entry<Long, List<DynamicObject>> entityIdEntry : billEntityEntry.getValue().entrySet()) {
                    Long billEntryId = entityIdEntry.getKey();
                    List<DynamicObject> value = entityIdEntry.getValue();
                    DynamicObject billEntry = billEntryMap.get(billEntryId);
                    if (billEntry == null) continue;
                    MatchRecord matchRecord = matchRecordMap.get(billEntryId);
                    BigDecimal recordAmt = matchRecord == null ? BigDecimal.ZERO : matchRecord.getAmt();
                    BigDecimal recordQty = matchRecord == null ? BigDecimal.ZERO : matchRecord.getQty();
                    BigDecimal totalAmt = billEntry.getBigDecimal(amtKey);
                    BigDecimal totalQty = billEntry.getBigDecimal(qtyKey);
                    BigDecimal resultAmt = value.stream().map(e -> e.getBigDecimal("rs_amt")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal resultQty = value.stream().map(e -> e.getBigDecimal("rs_qty")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    String chainEntityName = MetadataServiceHelper.getDataEntityType((String)matchChain.getBillEntity()).getDisplayName().getLocaleValue();
                    int rowNumber = billEntry.getInt(seqKey);
                    if (resultAmt.add(recordAmt).compareTo(totalAmt) > 0) {
                        this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"%1$s\u5206\u5f55\u7b2c%2$s\u884c\uff1a\u5339\u914d\u91d1\u989d\u5df2\u4e0d\u8db3\uff0c\u5df2\u5339\u914d\u91d1\u989d\u4e3a%3$s\uff0c\u672c\u6b21\u5339\u914d\u91d1\u989d\u4e3a%4$s\uff0c\u8d85\u51fa\u603b\u5339\u914d\u91d1\u989d%5$s\u3002", (String)"ToleranceMatchNumberValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), chainEntityName, rowNumber, recordAmt, resultAmt, totalAmt));
                    }
                    if (resultQty.add(recordQty).compareTo(totalQty) <= 0) continue;
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"%1$s\u5206\u5f55\u7b2c%2$s\u884c\uff1a\u5339\u914d\u6570\u91cf\u5df2\u4e0d\u8db3\uff0c\u5df2\u5339\u914d\u6570\u91cf\u4e3a%3$s\uff0c\u672c\u6b21\u5339\u914d\u6570\u91cf\u4e3a%4$s\uff0c\u8d85\u51fa\u603b\u5339\u914d\u6570\u91cf%5$s\u3002", (String)"ToleranceMatchNumberValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]), chainEntityName, rowNumber, recordQty, resultQty, totalQty));
                }
            }
        }
    }

    private Map<Long, MatchRecord> queryMatchRecords(Set<Long> billEntryIds) {
        String idStr = billEntryIds.stream().map(Object::toString).collect(Collectors.joining(","));
        List matchRecords = (List)DB.query((DBRoute)DBRouteConst.AP, (String)"select fbilltype billtype,sum(fmatchqty) qty,sum(fmatchamt) amt,fbillentryid entryid from t_ap_invoice_matchentry where fbillentryid in (?) group by fbilltype,fbillentryid", (Object[])new Object[]{idStr}, rs -> {
            ArrayList<MatchRecord> records = new ArrayList<MatchRecord>(64);
            while (rs.next()) {
                records.add(new MatchRecord(rs.getString("billtype"), rs.getBigDecimal("amt"), rs.getBigDecimal("qty"), rs.getLong("entryid")));
            }
            return records;
        });
        return matchRecords.stream().collect(Collectors.toMap(MatchRecord::getBillEntryId, e -> e));
    }

    static class MatchRecord {
        private String billType;
        private BigDecimal amt;
        private BigDecimal qty;
        private Long billEntryId;

        public MatchRecord(String billType, BigDecimal amt, BigDecimal qty, Long billEntryId) {
            this.billType = billType;
            this.amt = amt;
            this.qty = qty;
            this.billEntryId = billEntryId;
        }

        public String getBillType() {
            return this.billType;
        }

        public void setBillType(String billType) {
            this.billType = billType;
        }

        public BigDecimal getAmt() {
            return this.amt;
        }

        public void setAmt(BigDecimal amt) {
            this.amt = amt;
        }

        public BigDecimal getQty() {
            return this.qty;
        }

        public void setQty(BigDecimal qty) {
            this.qty = qty;
        }

        public Long getBillEntryId() {
            return this.billEntryId;
        }

        public void setBillEntryId(Long billEntryId) {
            this.billEntryId = billEntryId;
        }
    }
}

