/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.service.buswoff.BusWrittenOffWoffFromFinap;

public class WrittenOffBillUnAuditValidator
extends AbstractValidator {
    public void validate() {
        Set<String> verifyRelations;
        long billId;
        ExtendedDataEntity[] datas = this.getDataEntities();
        HashMap<Long, Object> srcBillIdMap = new HashMap<Long, Object>(8);
        HashMap<Long, Long> srcFinIdToWrittenOff = new HashMap<Long, Long>(2);
        HashSet<Long> orgIds = new HashSet<Long>(datas.length);
        for (ExtendedDataEntity data : datas) {
            DynamicObject dynamicObject = data.getDataEntity();
            if (!dynamicObject.getBoolean("iswrittenoff")) continue;
            orgIds.add(dynamicObject.getLong("org.id"));
            long srcBillId = dynamicObject.getLong("sourcebillid");
            srcBillIdMap.put(srcBillId, data);
            srcFinIdToWrittenOff.put(srcBillId, dynamicObject.getLong("id"));
        }
        if (ObjectUtils.isEmpty(srcBillIdMap)) {
            return;
        }
        Set srcBillIds = srcBillIdMap.keySet();
        BusWrittenOffWoffFromFinap writtenOffWoff = new BusWrittenOffWoffFromFinap();
        Map overfullSrcFinBillnoMap = writtenOffWoff.unAuditValidate(srcFinIdToWrittenOff);
        for (Map.Entry entry : overfullSrcFinBillnoMap.entrySet()) {
            this.addErrorMessage((ExtendedDataEntity)srcBillIdMap.get(entry.getKey()), String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u4f1a\u91cd\u65b0\u5360\u7528\u6682\u4f30\u5e94\u4ed8\u5355\u201c%1$s\u201d\u7684\u672a\u51b2\u56de\u6570\u91cf\u4e0e\u91d1\u989d\u3001\u672a\u786e\u8ba4\u5e94\u4ed8\u6570\u91cf\u4e0e\u91d1\u989d\uff0c\u989d\u5ea6\u4e0d\u8db3\uff0c\u53cd\u5ba1\u6838\u5931\u8d25\u3002", (String)"WrittenOffBillUnAuditValidator_3", (String)"fi-ar-opplugin", (Object[])new Object[0]), String.join((CharSequence)",", (Iterable)entry.getValue())));
        }
        QFilter filterByMain = new QFilter("org", "in", orgIds);
        filterByMain.and(new QFilter("billid", "in", srcBillIds));
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"ap_verifyrecord", (String)"verifyrelation,billid", (QFilter[])filterByMain.toArray());
        QFilter filterByAsst = new QFilter("org", "in", orgIds);
        filterByAsst.and(new QFilter("entry.e_billid", "in", srcBillIds));
        DynamicObjectCollection verifyRecordsByAsst = QueryServiceHelper.query((String)"ap_verifyrecord", (String)"verifyrelation,entry.e_billid", (QFilter[])filterByAsst.toArray());
        if (ObjectUtils.isEmpty((Object)dynamicObjectCollection) && ObjectUtils.isEmpty((Object)verifyRecordsByAsst)) {
            return;
        }
        HashMap<Long, HashSet<String>> verifyRelationMap = new HashMap<Long, HashSet<String>>();
        for (DynamicObject verifyRecord : dynamicObjectCollection) {
            billId = verifyRecord.getLong("billid");
            verifyRelations = (HashSet<String>)verifyRelationMap.get(billId);
            if (ObjectUtils.isEmpty((Object)verifyRelations)) {
                verifyRelations = new HashSet<String>();
            }
            verifyRelations.add(verifyRecord.getString("verifyrelation"));
            verifyRelationMap.put(billId, (HashSet<String>)verifyRelations);
        }
        for (DynamicObject verifyRecord : verifyRecordsByAsst) {
            billId = verifyRecord.getLong("entry.e_billid");
            verifyRelations = (Set)verifyRelationMap.get(billId);
            if (ObjectUtils.isEmpty(verifyRelations)) {
                verifyRelations = new HashSet();
            }
            verifyRelations.add(verifyRecord.getString("verifyrelation"));
            verifyRelationMap.put(billId, (HashSet<String>)verifyRelations);
        }
        for (ExtendedDataEntity writtenOffBill : srcBillIdMap.values()) {
            DynamicObject bill = writtenOffBill.getDataEntity();
            Set verifyRelation = (Set)verifyRelationMap.get(bill.getLong("sourcebillid"));
            if (ObjectUtils.isEmpty((Object)verifyRelation) || verifyRelation.size() <= 1) continue;
            this.addErrorMessage(writtenOffBill, ResManager.loadKDString((String)"\u53c2\u4e0e\u6838\u9500\u5355\u636e\u7684\u51b2\u9500\u5355\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"WrittenOffBillUnAuditValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[]{bill.getString("billno")}));
        }
    }
}

