/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.writeback;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.fi.ai.Voucher;
import kd.bos.ext.fi.ai.VoucherOperation;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ap.writeback.DapVoucherWriteBackFinAp;

public class DapVoucherWriteBackFinAp4Hw
extends DapVoucherWriteBackFinAp {
    Log logger = LogFactory.getLog(DapVoucherWriteBackFinAp4Hw.class);

    @Override
    public void writeBack(VoucherOperation operation, String billEntityNumber, Map<Long, Voucher> billToVch) {
        super.writeBack(operation, billEntityNumber, billToVch);
        this.sendVoucherMsg(operation.getValue(), billToVch);
        try {
            this.apPushDownPayBill(operation.getValue(), billToVch);
        }
        catch (Exception e) {
            this.logger.error("-----\u8c03\u7528\u4e0b\u63a8\u5f02\u5e38-------" + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendVoucherMsg(String voucherOpValue, Map<Long, Voucher> billToVch) {
        this.logger.info("-----sendVoucherMsg begin------- voucherOpValue = " + voucherOpValue);
        Map<Long, Long> billPkMap = billToVch.entrySet().stream().collect(Collectors.toMap(e -> (Long)e.getKey(), e -> ((Voucher)e.getValue()).getId()));
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher("fi", "hihn.fi.ap.fin_voucher_queue");){
            HashMap<String, Object> params = new HashMap<String, Object>(64);
            params.put("voucherOpValue", voucherOpValue);
            params.put("billPkMap", billPkMap);
            pub.publish(params);
        }
        this.logger.info("-----sendVoucherMsg end------- billPkMap = " + billPkMap);
    }

    private void apPushDownPayBill(String voucherOpValue, Map<Long, Voucher> billToVch) {
        this.logger.info("-----topaybill2020-10-24:voucherOpValue-------" + voucherOpValue);
        if ("1".equals(voucherOpValue)) {
            DynamicObject[] apbillObject;
            ArrayList<Long> pushBillIDs = new ArrayList<Long>(64);
            for (DynamicObject dy : apbillObject = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"id,billstatus,hihn_ishandpush,freezestate,org,payorg", (QFilter[])new QFilter[]{new QFilter("id", "in", billToVch.keySet())})) {
                String billstatus = dy.getString("billstatus");
                String hihn_ishandpush = dy.getString("hihn_ishandpush");
                String freezestate = dy.getString("freezestate");
                String org = dy.getString("org.id");
                String payorg = dy.getString("payorg.id");
                if (!"C".equals(billstatus) || !"false".equals(hihn_ishandpush) || !"unfreeze".equals(freezestate) || !org.equals(payorg)) continue;
                pushBillIDs.add(dy.getLong("id"));
                this.logger.info("-----topaybill2020-10-24:pushBillIDs-------" + pushBillIDs);
            }
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"pushandsave", (String)"ap_finapbill", (Object[])pushBillIDs.toArray(), (OperateOption)OperateOption.create());
            if (!operationResult.isSuccess()) {
                String showMessage = operationResult.getMessage();
                this.logger.info("-----topaybill2020-10-24:showMessage-------" + showMessage);
                operationResult.setSuccess(false);
                String message = String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u4e0b\u63a8\u4ed8\u6b3e\u5355\u5931\u8d25\uff1a%s", (String)"DapVoucherWriteBackFinAp4Hw_01", (String)"fi-ar-opplugin", (Object[])new Object[0]), showMessage);
                operationResult.setMessage(message);
                List reports = operationResult.getAllErrorInfo();
                StringBuilder str = new StringBuilder();
                for (OperateErrorInfo error : reports) {
                    str.append(error.getMessage());
                }
            }
        }
    }
}

