/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.fi.ap.mservice.ApAdjustSettleService;
import kd.fi.ap.mservice.SettleServiceFactory;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.service.AbsAutoSettleService;
import kd.fi.arapcommon.service.AbstractSettleTemplate;
import kd.fi.arapcommon.service.helper.FinApBillHandleHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class ApAdjustAutoSettleService
extends AbsAutoSettleService {
    public void autoSettle(DynamicObject obj, boolean isMain) throws KDBizException {
        if (isMain) {
            return;
        }
        BigDecimal adjustPayAmount = obj.getBigDecimal("pricetaxtotal");
        if (adjustPayAmount.compareTo(BigDecimal.ZERO) >= 0) {
            return;
        }
        DynamicObject[] sourceFinBills = this.getMainObjs(obj);
        if (EmptyUtils.isEmpty((Object)sourceFinBills)) {
            return;
        }
        DynamicObject sourceFinBill = sourceFinBills[0];
        DynamicObjectCollection planentitys = sourceFinBill.getDynamicObjectCollection("planentity");
        for (Object planentity : planentitys) {
            planentity.set("unplansettleamt", planentity.get("unplanlockamt"));
        }
        DynamicObjectCollection entrys = sourceFinBill.getDynamicObjectCollection("detailentry");
        for (DynamicObject entry : entrys) {
            entry.set("unsettleamt", entry.get("unlockamt"));
        }
        BigDecimal sourcePayAmount = sourceFinBill.getBigDecimal("unsettleamount");
        if (sourcePayAmount.abs().compareTo(adjustPayAmount.abs()) < 0) {
            return;
        }
        SettleSchemeVO settleScheme = new SettleSchemeVO();
        settleScheme.setOnlyByBotp(true);
        settleScheme.setAdjust(true);
        DynamicObject[] assts = new DynamicObject[]{obj};
        ApAdjustSettleService settleService = new ApAdjustSettleService();
        this.addSettleLock(sourceFinBills, assts);
        settleService.settle(sourceFinBills, assts, settleScheme, SettleTypeEnum.AUTO.getValue());
    }

    private DynamicObject[] getMainObjs(DynamicObject obj) {
        long sourceBillId = obj.getLong("sourcebillid");
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)sourceBillId)};
        return FinApBillHandleHelper.load((QFilter[])filters);
    }

    public AbstractSettleTemplate getSettleService(String settleRelation) {
        if (SettleRelationEnum.APSELF.getValue().equals(settleRelation)) {
            return new ApAdjustSettleService();
        }
        return SettleServiceFactory.getService(settleRelation);
    }
}

