/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.arapcommon.util.StringUtils;

public class ApExpenseCostService {
    public Map<Long, String> ExpenseIdsByBotp(DynamicObject[] apBills) {
        if (apBills != null && apBills.length > 0) {
            String entityName = apBills[0].getDataEntityType().getName();
            if ("ap_finapbill".equals(entityName)) {
                return this.setExpenseIdsByAp(apBills);
            }
            if ("ap_busbill".equals(entityName)) {
                return this.setExpenseIdsByBus(apBills);
            }
        }
        return null;
    }

    private Map<Long, String> setExpenseIdsByAp(DynamicObject[] dataEntities) {
        HashSet<DynamicObject> expenseBills = new HashSet<DynamicObject>(8);
        for (DynamicObject apBill : dataEntities) {
            String billTypeNum = apBill.getString("billtypeid.number");
            String srcBillType = apBill.getString("sourcebilltype");
            if (!"im_saloutbill".equals(srcBillType) && !"im_purinbill".equals(srcBillType) || !"ApFin_purfee_BT_S".equals(billTypeNum) && !"ApFin_salefee_BT_S".equals(billTypeNum)) continue;
            expenseBills.add(apBill);
        }
        HashMap<Long, String> expenseFiledMap = new HashMap<Long, String>(16);
        if (expenseBills.size() > 0) {
            this.setExpenseIdsBySrcBotp(expenseBills.toArray(new DynamicObject[0]), expenseFiledMap);
        }
        return expenseFiledMap;
    }

    private Map<Long, String> setExpenseIdsByBus(DynamicObject[] dataEntities) {
        HashSet<DynamicObject> expenseBills = new HashSet<DynamicObject>(8);
        for (DynamicObject apBill : dataEntities) {
            String billTypeNum = apBill.getString("billtype.number");
            String srcBillType = apBill.getString("sourcebilltype");
            if (!"im_saloutbill".equals(srcBillType) && !"im_purinbill".equals(srcBillType) || !"ap_busbill_purfee_BT_S".equals(billTypeNum) && !"ap_busbill_salefee_BT_S".equals(billTypeNum)) continue;
            expenseBills.add(apBill);
        }
        HashMap<Long, String> expenseFiledMap = new HashMap<Long, String>(16);
        if (expenseBills.size() > 0) {
            this.setExpenseIdsBySrcBotp(expenseBills.toArray(new DynamicObject[0]), expenseFiledMap);
        }
        return expenseFiledMap;
    }

    private Map<Long, String> setExpenseIdsBySrcBotp(DynamicObject[] entities, Map<Long, String> expenseFiledMap) {
        DynamicObject entry;
        Iterator iterator;
        Object entrys;
        String materialName;
        String entryName;
        String entityName = entities[0].getDataEntityType().getName();
        if ("ap_finapbill".equals(entityName)) {
            entryName = "detailentry";
            materialName = "material";
        } else {
            entryName = "entry";
            materialName = "e_material";
        }
        HashSet<Long> headIds = new HashSet<Long>(16);
        HashMap srcEntryMap = new HashMap(16);
        for (DynamicObject bill : entities) {
            entrys = bill.getDynamicObjectCollection(entryName);
            iterator = entrys.iterator();
            while (iterator.hasNext()) {
                entry = (DynamicObject)iterator.next();
                String expenseTag = entry.getString("e_expensebillids_tag");
                if (StringUtils.isNotEmpty((String)expenseTag)) continue;
                headIds.add(bill.getLong("id"));
            }
        }
        if (headIds.size() > 0) {
            Map dirtSourceBills = BFTrackerServiceHelper.findDirtSourceBills((String)entityName, (Long[])headIds.toArray(new Long[0]));
            for (Map.Entry entry2 : dirtSourceBills.entrySet()) {
                List bfRows = (List)entry2.getValue();
                for (BFRow bfRow : bfRows) {
                    BFRowId SrcRowId = bfRow.getSId();
                    BFRowId rowId = bfRow.getId();
                    Long apEntryId = rowId.getEntryId();
                    HashMap srcJsonMap = (HashMap)srcEntryMap.get(apEntryId);
                    Long srcBillId = SrcRowId.getBillId();
                    Long srcEntryId = SrcRowId.getEntryId();
                    if (srcJsonMap == null) {
                        srcJsonMap = new HashMap(8);
                        HashSet<Long> srcIdSet = new HashSet<Long>(1);
                        HashSet<Long> srcEntryIdSet = new HashSet<Long>(1);
                        srcIdSet.add(srcBillId);
                        srcEntryIdSet.add(srcEntryId);
                        srcJsonMap.put("id", srcIdSet);
                        srcJsonMap.put("entryid", srcEntryIdSet);
                    } else {
                        ((Set)srcJsonMap.get("id")).add(srcBillId);
                        ((Set)srcJsonMap.get("entryid")).add(srcEntryId);
                    }
                    srcEntryMap.put(apEntryId, srcJsonMap);
                }
            }
        }
        for (DynamicObject apBill : entities) {
            entrys = apBill.getDynamicObjectCollection(entryName);
            iterator = entrys.iterator();
            while (iterator.hasNext()) {
                entry = (DynamicObject)iterator.next();
                Map entryMap = (Map)srcEntryMap.get(entry.getLong("id"));
                if (entryMap == null) continue;
                DynamicObject material = entry.getDynamicObject(materialName);
                if (material == null) {
                    entryMap.remove("entryid");
                }
                entry.set("e_expensebillids_tag", (Object)JSON.toJSONString((Object)entryMap));
                expenseFiledMap.put(entry.getLong("id"), JSON.toJSONString((Object)entryMap));
            }
        }
        return expenseFiledMap;
    }
}

