/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.fi.ap.mservice.ApPaySettleService;
import kd.fi.ap.mservice.ApSelfSettleService;
import kd.fi.ap.mservice.PaySelfSettleService;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.service.IManualSettleService;
import kd.fi.arapcommon.service.helper.FinApBillHandleHelper;
import kd.fi.arapcommon.service.helper.PayBillHandleHelper;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.ManualSettleParam;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class ApPayManualSettleService
implements IManualSettleService {
    public static final String ASST_PAYBILL = "cas_paybill";
    public static final String ASST_PAIDBILL = "ap_paidbill";
    protected ApPaySettleService service;

    public ApPayManualSettleService() {
        this.service = new ApPaySettleService();
    }

    public ApPayManualSettleService(ApPaySettleService service) {
        this.service = service;
    }

    public void manualSettle(DynamicObject[] mainRows, DynamicObject[] asstRows, ManualSettleParam manualParam) throws KDBizException {
        HashSet<Long> mainBillIdSet = new HashSet<Long>(mainRows.length);
        HashSet<Long> mainEntryIdSet = new HashSet<Long>(mainRows.length);
        for (DynamicObject main : mainRows) {
            mainBillIdSet.add(main.getLong("id"));
            mainEntryIdSet.add(main.getLong("entryid"));
        }
        HashSet<Long> payBillIdSet = new HashSet<Long>();
        HashSet<Long> payEntryIdSet = new HashSet<Long>();
        HashSet<Long> paidBillIdSet = new HashSet<Long>();
        HashSet<Long> paidEntryIdSet = new HashSet<Long>();
        for (DynamicObject asst : asstRows) {
            String entityName = asst.getString("asst_billtype");
            if (ASST_PAYBILL.equals(entityName)) {
                payBillIdSet.add(asst.getLong("asst_id"));
                payEntryIdSet.add(asst.getLong("asst_entryid"));
                continue;
            }
            paidBillIdSet.add(asst.getLong("asst_id"));
            paidEntryIdSet.add(asst.getLong("asst_entryid"));
        }
        SettleSchemeVO scheme = new SettleSchemeVO();
        scheme.setSettle(true);
        scheme.setManual(true);
        scheme.setDiffCurrencySettle(manualParam.isDiffCurrencySettle());
        scheme.setSettleEntryParam(manualParam.getSettleEntryParam());
        scheme.setSettleDate(manualParam.getSettleDate());
        DynamicObject[] mainArr = this.reloadMainArr(mainBillIdSet);
        Object[] payArr = this.reloadPayArr(payBillIdSet);
        Object[] paidArr = this.reloadPaidArr(paidBillIdSet);
        DynamicObject[] payMergeArr = (DynamicObject[])ArrayUtils.addAll((Object[])payArr, (Object[])paidArr);
        Arrays.sort(payMergeArr, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                return o1.getDate("bizdate").compareTo(o2.getDate("bizdate"));
            }
        });
        List mainListVO = FinApBillHandleHelper.getMainListVO((DynamicObject[])mainArr, (SettleSchemeVO)scheme);
        List asstListVO = PayBillHandleHelper.getAsstListVO((DynamicObject[])payMergeArr);
        if (manualParam.isSingleSettle()) {
            scheme.setSettleSelf(true);
            this.settleSelfFirst(mainListVO, asstListVO, scheme);
            return;
        }
        if ((manualParam.isSettleSelfFirst() || manualParam.isTotal()) && !manualParam.isDiffCurrencySettle()) {
            scheme.setSettleSelf(true);
            this.settleSelfFirst(mainListVO, asstListVO, scheme);
            mainArr = this.reloadMainArr(mainBillIdSet);
            payArr = this.reloadPayArr(payBillIdSet);
            paidArr = this.reloadPaidArr(paidBillIdSet);
            payMergeArr = (DynamicObject[])ArrayUtils.addAll((Object[])payArr, (Object[])paidArr);
        }
        this.processMain(mainArr, mainRows, mainEntryIdSet, manualParam);
        this.processAsst((DynamicObject[])payArr, asstRows, payEntryIdSet, manualParam);
        this.processAsst((DynamicObject[])paidArr, asstRows, paidEntryIdSet, manualParam);
        Arrays.sort(payMergeArr, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                return o1.getDate("bizdate").compareTo(o2.getDate("bizdate"));
            }
        });
        mainListVO = FinApBillHandleHelper.getMainListVO((DynamicObject[])mainArr, (SettleSchemeVO)scheme);
        asstListVO = PayBillHandleHelper.getAsstListVO((DynamicObject[])payMergeArr);
        this.service.settleByVO(mainListVO, asstListVO, scheme, SettleTypeEnum.MANUAL.getValue());
    }

    private void settleSelfFirst(List<BillSettleVO> mainListVO, List<BillSettleVO> asstListVO, SettleSchemeVO scheme) {
        List mainPositiveList = this.getPositiveList(mainListVO);
        List mainNegativeList = this.getNegativeList(mainListVO);
        if (mainPositiveList.size() > 0 && mainNegativeList.size() > 0) {
            ApSelfSettleService apSelfService = new ApSelfSettleService();
            apSelfService.settleByVO(mainPositiveList, mainNegativeList, scheme, SettleTypeEnum.MANUAL.getValue());
        }
        List asstPositiveList = this.getPositiveList(asstListVO);
        List asstNegativeList = this.getNegativeList(asstListVO);
        if (asstPositiveList.size() > 0 && asstNegativeList.size() > 0) {
            PaySelfSettleService paySelfService = new PaySelfSettleService();
            paySelfService.settleByVO(asstPositiveList, asstNegativeList, scheme, SettleTypeEnum.MANUAL.getValue());
        }
        scheme.setSettleSelf(false);
    }

    protected DynamicObject[] reloadMainArr(Set<Long> billIdSet) {
        QFilter filter = new QFilter("id", "in", billIdSet);
        DynamicObject[] mainArr = FinApBillHandleHelper.load((QFilter[])new QFilter[]{filter});
        return mainArr;
    }

    protected void processMain(DynamicObject[] mainArr, DynamicObject[] mainRows, Set<Long> mainEntryIdSet, ManualSettleParam param) {
        int settleEntryParam = param.getSettleEntryParam();
        if (param.isTotal()) {
            for (DynamicObject main : mainRows) {
                BigDecimal curSettleAmt = main.getBigDecimal("curSettleAmt");
                long id = main.getLong("id");
                for (DynamicObject mainObj : mainArr) {
                    if (id != mainObj.getLong("id")) continue;
                    mainObj.set("exchangerate", (Object)main.getBigDecimal("exchangerate"));
                    DynamicObjectCollection entrys = mainObj.getDynamicObjectCollection(this.getApEntryKey(settleEntryParam));
                    for (DynamicObject entry : entrys) {
                        BigDecimal entryUnLockAmt = entry.getBigDecimal(this.getApEntryUnLockKey(settleEntryParam));
                        if (curSettleAmt.abs().compareTo(entryUnLockAmt.abs()) >= 0) {
                            entry.set(this.getApEntryAmtKey(settleEntryParam), (Object)entryUnLockAmt);
                            curSettleAmt = curSettleAmt.subtract(entryUnLockAmt);
                            continue;
                        }
                        entry.set(this.getApEntryAmtKey(settleEntryParam), (Object)curSettleAmt);
                        curSettleAmt = BigDecimal.ZERO;
                    }
                }
            }
        } else {
            for (DynamicObject mainObj : mainArr) {
                long id = mainObj.getLong("id");
                DynamicObjectCollection entrys = mainObj.getDynamicObjectCollection(this.getApEntryKey(settleEntryParam));
                for (int i = entrys.size() - 1; i >= 0; --i) {
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    long entryId = entry.getLong("id");
                    BigDecimal unSettleAmt = entry.getBigDecimal(this.getApEntryAmtKey(settleEntryParam));
                    if (mainEntryIdSet.contains(entryId)) {
                        for (DynamicObject main : mainRows) {
                            if (id != main.getLong("id") || entryId != main.getLong("entryid")) continue;
                            mainObj.set("exchangerate", (Object)main.getBigDecimal("exchangerate"));
                            BigDecimal curSettleAmt = main.getBigDecimal("curSettleAmt");
                            int comparevalue = unSettleAmt.abs().compareTo(curSettleAmt.abs());
                            curSettleAmt = comparevalue >= 0 ? curSettleAmt : unSettleAmt;
                            entry.set(this.getApEntryAmtKey(settleEntryParam), (Object)curSettleAmt);
                        }
                        continue;
                    }
                    entrys.remove(i);
                }
            }
        }
    }

    protected void processAsst(DynamicObject[] asstArr, DynamicObject[] asstRows, Set<Long> asstEntryIdSet, ManualSettleParam param) {
        if (param.isTotal()) {
            for (DynamicObject asst : asstRows) {
                BigDecimal curSettleAmt = asst.getBigDecimal("asst_cursettleamt");
                long id = asst.getLong("asst_id");
                for (DynamicObject asstObj : asstArr) {
                    if (id != asstObj.getLong("id")) continue;
                    asstObj.set("exchangerate", (Object)asst.getBigDecimal("asst_exchangerate"));
                    DynamicObjectCollection entrys = asstObj.getDynamicObjectCollection("entry");
                    for (DynamicObject entry : entrys) {
                        BigDecimal entryUnSettleAmt = entry.getBigDecimal("e_unsettledamt");
                        if (ASST_PAYBILL.equals(asstObj.getDataEntityType().getName()) && (!param.getOrgPk().equals(entry.get("settleorg.id")) || ObjectUtils.isEmpty((Object)entry.getDynamicObject("e_paymenttype")) || !entry.getDynamicObject("e_paymenttype").getBoolean("ispartpayment"))) {
                            entry.set("e_unsettledamt", (Object)BigDecimal.ZERO);
                            continue;
                        }
                        if (curSettleAmt.abs().compareTo(entryUnSettleAmt.abs()) >= 0) {
                            curSettleAmt = curSettleAmt.subtract(entryUnSettleAmt);
                            continue;
                        }
                        entry.set("e_unsettledamt", (Object)curSettleAmt);
                        curSettleAmt = BigDecimal.ZERO;
                    }
                }
            }
        } else {
            for (DynamicObject asstObj : asstArr) {
                long id = asstObj.getLong("id");
                DynamicObjectCollection entrys = asstObj.getDynamicObjectCollection("entry");
                for (int i = entrys.size() - 1; i >= 0; --i) {
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    long entryId = entry.getLong("id");
                    BigDecimal unSettleAmt = entry.getBigDecimal("e_unsettledamt");
                    if (asstEntryIdSet.contains(entryId)) {
                        for (DynamicObject asst : asstRows) {
                            if (id != asst.getLong("asst_id") || entryId != asst.getLong("asst_entryid")) continue;
                            asstObj.set("exchangerate", (Object)asst.getBigDecimal("asst_exchangerate"));
                            BigDecimal curSettleAmt = asst.getBigDecimal("asst_curSettleAmt");
                            int comparevalue = unSettleAmt.abs().compareTo(curSettleAmt.abs());
                            curSettleAmt = comparevalue >= 0 ? curSettleAmt : unSettleAmt;
                            entry.set("e_unsettledamt", (Object)curSettleAmt);
                        }
                        continue;
                    }
                    entrys.remove(i);
                }
            }
        }
    }
}

