/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.fi.ap.mservice.ApPayManualSettleService;
import kd.fi.ap.mservice.ApSelfSettleService;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.service.helper.FinApBillHandleHelper;
import kd.fi.arapcommon.vo.ManualSettleParam;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class ApSelfManualSettleService
extends ApPayManualSettleService {
    protected ApSelfSettleService selfService = new ApSelfSettleService();

    @Override
    public void manualSettle(DynamicObject[] mainRows, DynamicObject[] asstRows, ManualSettleParam manualParam) throws KDBizException {
        HashSet<Long> mainBillIdSet = new HashSet<Long>(mainRows.length);
        HashSet<Long> mainEntryIdSet = new HashSet<Long>(mainRows.length);
        for (DynamicObject main : mainRows) {
            mainBillIdSet.add(main.getLong("id"));
            mainEntryIdSet.add(main.getLong("entryid"));
        }
        HashSet<Long> asstBillIdSet = new HashSet<Long>(asstRows.length);
        HashSet<Long> asstEntryIdSet = new HashSet<Long>(asstRows.length);
        for (DynamicObject asst : asstRows) {
            asstBillIdSet.add(asst.getLong("asst_id"));
            asstEntryIdSet.add(asst.getLong("asst_entryid"));
        }
        SettleSchemeVO scheme = new SettleSchemeVO();
        scheme.setSettle(true);
        scheme.setManual(true);
        scheme.setDiffCurrencySettle(manualParam.isDiffCurrencySettle());
        scheme.setSettleEntryParam(manualParam.getSettleEntryParam());
        scheme.setSettleDate(manualParam.getSettleDate());
        DynamicObject[] mainArr = this.reloadMainArr(mainBillIdSet);
        DynamicObject[] asstArr = this.reloadMainArr(asstBillIdSet);
        this.processMain(mainArr, mainRows, mainEntryIdSet, manualParam);
        this.processAsst(asstArr, asstRows, asstEntryIdSet, manualParam);
        List mainListVO = FinApBillHandleHelper.getMainListVO((DynamicObject[])mainArr, (SettleSchemeVO)scheme);
        List asstListVO = FinApBillHandleHelper.getAsstListVO((DynamicObject[])asstArr, (SettleSchemeVO)scheme);
        this.selfService.settleByVO(mainListVO, asstListVO, scheme, SettleTypeEnum.MANUAL.getValue());
    }

    @Override
    protected void processMain(DynamicObject[] mainArr, DynamicObject[] mainRows, Set<Long> mainEntryIdSet, ManualSettleParam param) {
        int settleEntryParam = param.getSettleEntryParam();
        if (param.isTotal()) {
            for (DynamicObject main : mainRows) {
                BigDecimal curSettleAmt = main.getBigDecimal("curSettleAmt");
                long id = main.getLong("id");
                for (DynamicObject mainObj : mainArr) {
                    if (id != mainObj.getLong("id")) continue;
                    mainObj.set("exchangerate", (Object)main.getBigDecimal("exchangerate"));
                    DynamicObjectCollection entrys = mainObj.getDynamicObjectCollection(this.getApEntryKey(settleEntryParam));
                    for (DynamicObject entry : entrys) {
                        BigDecimal entryUnLockAmt = entry.getBigDecimal(this.getApEntryUnLockKey(settleEntryParam));
                        if (entryUnLockAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
                        if (curSettleAmt.abs().compareTo(entryUnLockAmt.abs()) >= 0) {
                            entry.set(this.getApEntryAmtKey(settleEntryParam), (Object)entryUnLockAmt);
                            curSettleAmt = curSettleAmt.subtract(entryUnLockAmt);
                            continue;
                        }
                        entry.set(this.getApEntryAmtKey(settleEntryParam), (Object)curSettleAmt);
                        curSettleAmt = BigDecimal.ZERO;
                    }
                }
            }
        } else {
            for (DynamicObject mainObj : mainArr) {
                long id = mainObj.getLong("id");
                DynamicObjectCollection entrys = mainObj.getDynamicObjectCollection(this.getApEntryKey(settleEntryParam));
                for (int i = entrys.size() - 1; i >= 0; --i) {
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    long entryId = entry.getLong("id");
                    BigDecimal unSettleAmt = entry.getBigDecimal(this.getApEntryAmtKey(settleEntryParam));
                    if (mainEntryIdSet.contains(entryId)) {
                        for (DynamicObject main : mainRows) {
                            if (id != main.getLong("id") || entryId != main.getLong("entryid")) continue;
                            mainObj.set("exchangerate", (Object)main.getBigDecimal("exchangerate"));
                            BigDecimal curSettleAmt = main.getBigDecimal("curSettleAmt");
                            int comparevalue = unSettleAmt.abs().compareTo(curSettleAmt.abs());
                            curSettleAmt = comparevalue >= 0 ? curSettleAmt : unSettleAmt;
                            entry.set(this.getApEntryAmtKey(settleEntryParam), (Object)curSettleAmt);
                        }
                        continue;
                    }
                    entrys.remove(i);
                }
            }
        }
    }

    @Override
    protected void processAsst(DynamicObject[] asstArr, DynamicObject[] asstRows, Set<Long> asstEntryIdSet, ManualSettleParam param) {
        int settleEntryParam = param.getSettleEntryParam();
        if (param.isTotal()) {
            for (DynamicObject asst : asstRows) {
                BigDecimal curSettleAmt = asst.getBigDecimal("asst_cursettleamt");
                long id = asst.getLong("asst_id");
                for (DynamicObject asstObj : asstArr) {
                    if (id != asstObj.getLong("id")) continue;
                    asstObj.set("exchangerate", (Object)asst.getBigDecimal("asst_exchangerate"));
                    DynamicObjectCollection entrys = asstObj.getDynamicObjectCollection(this.getApEntryKey(settleEntryParam));
                    for (DynamicObject entry : entrys) {
                        BigDecimal entryUnLockAmt = entry.getBigDecimal(this.getApEntryUnLockKey(settleEntryParam));
                        if (entryUnLockAmt.compareTo(BigDecimal.ZERO) >= 0) continue;
                        if (curSettleAmt.abs().compareTo(entryUnLockAmt.abs()) >= 0) {
                            entry.set(this.getApEntryAmtKey(settleEntryParam), (Object)entryUnLockAmt);
                            curSettleAmt = curSettleAmt.subtract(entryUnLockAmt);
                            continue;
                        }
                        entry.set(this.getApEntryAmtKey(settleEntryParam), (Object)curSettleAmt);
                        curSettleAmt = BigDecimal.ZERO;
                    }
                }
            }
        } else {
            for (DynamicObject asstObj : asstArr) {
                long id = asstObj.getLong("id");
                DynamicObjectCollection entrys = asstObj.getDynamicObjectCollection(this.getApEntryKey(settleEntryParam));
                for (int i = entrys.size() - 1; i >= 0; --i) {
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    long entryId = entry.getLong("id");
                    BigDecimal unSettleAmt = entry.getBigDecimal(this.getApEntryAmtKey(settleEntryParam));
                    if (asstEntryIdSet.contains(entryId)) {
                        for (DynamicObject asst : asstRows) {
                            if (id != asst.getLong("asst_id") || entryId != asst.getLong("asst_entryid")) continue;
                            asstObj.set("exchangerate", (Object)asst.getBigDecimal("asst_exchangerate"));
                            BigDecimal curSettleAmt = asst.getBigDecimal("asst_cursettleamt");
                            int comparevalue = unSettleAmt.abs().compareTo(curSettleAmt.abs());
                            curSettleAmt = comparevalue >= 0 ? curSettleAmt : unSettleAmt;
                            entry.set(this.getApEntryAmtKey(settleEntryParam), (Object)curSettleAmt);
                        }
                        continue;
                    }
                    entrys.remove(i);
                }
            }
        }
    }
}

