/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.mservice.CancelRefundAndRenoteValidateService;
import kd.fi.ap.mservice.PayRecSettleService;
import kd.fi.ap.mservice.PaySelfSettleService;
import kd.fi.ap.mservice.RefundAndRenoteConfirmHelper;
import kd.fi.ap.vo.CancelRefundAndRenoteParam;
import kd.fi.ap.vo.PayRefundEntryInfo;
import kd.fi.arapcommon.api.param.AssignSettleParam;
import kd.fi.arapcommon.api.param.SettleDetailParam;
import kd.fi.arapcommon.api.settle.ISettleService;
import kd.fi.arapcommon.enums.SettleDetailTypeEnum;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.BOTPNewHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.SettleRecordQueryHelper;
import kd.fi.arapcommon.service.concurrency.ConcurrencyCtrlUtil;
import kd.fi.arapcommon.service.freeze.CancelRefundAndRenoteUnFreezeService;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.vo.UnSettleParam;

public class CancelRefundAndRenoteNewExecutor {
    private static final Log logger = LogFactory.getLog(CancelRefundAndRenoteNewExecutor.class);

    public void cancel(CancelRefundAndRenoteParam cancelRefundAndRenoteParam) {
        logger.info("CancelRefundAndRenoteNewExecutor.cancel start");
        Set<Long> payIds = cancelRefundAndRenoteParam.getPayInfos().stream().map(PayRefundEntryInfo::getPayId).collect(Collectors.toSet());
        Long recId = cancelRefundAndRenoteParam.getRecId();
        ConcurrencyCtrlUtil.addCtrlInTX((String)"cas_paybill", (String)"cancelrefundandrenote", payIds, (boolean)false);
        HashSet<Long> botpToPayFinApBillIds = new HashSet<Long>(1);
        HashSet<Long> botpToPayFinArBillIds = new HashSet<Long>(1);
        Map srcBotpMap = BOTPHelper.findSourceBills((String)"cas_paybill", (Long[])payIds.toArray(new Long[0]));
        if (srcBotpMap.get("ap_finapbill") != null) {
            botpToPayFinApBillIds.addAll((Collection)srcBotpMap.get("ap_finapbill"));
        }
        if (srcBotpMap.get("ar_finarbill") != null) {
            botpToPayFinArBillIds.addAll((Collection)srcBotpMap.get("ar_finarbill"));
        }
        DynamicObject[] refundRecords = BusinessDataServiceHelper.load((String)"ap_refundrenote_record", (String)"org,settlerelation,finbillid", (QFilter[])new QFilter[]{new QFilter("recbillid", "=", (Object)recId)});
        CancelRefundAndRenoteValidateService validateService = new CancelRefundAndRenoteValidateService();
        validateService.validateFinBillIsWriteOff(botpToPayFinApBillIds, botpToPayFinArBillIds, refundRecords);
        validateService.validateUpApplyBillOrFinBillIsOver(cancelRefundAndRenoteParam);
        validateService.validateIsOverPeriod(payIds, recId);
        this.executePayRecUnSettle(payIds, recId);
        this.executePaySelfUnSettle(payIds);
        this.executeApPayUnSettle(cancelRefundAndRenoteParam);
        this.executeWriteBackFinOrApplyBill(cancelRefundAndRenoteParam);
        this.executeApPaySettle(recId, payIds);
        logger.info("CancelRefundAndRenoteNewExecutor.cancel end");
    }

    private void executePayRecUnSettle(Set<Long> payIds, Long recId) {
        logger.info("CancelRefundAndRenoteNewExecutor.executePayRecUnSettle start");
        PayRecSettleService settleService = new PayRecSettleService();
        QFilter filter = new QFilter("settlerelation", "=", (Object)SettleRelationEnum.PAYRECSETTLE.getValue());
        filter.and("mainbillid", "in", payIds);
        filter.and("entry.billid", "=", (Object)recId);
        filter.and("iswrittenoff", "=", (Object)Boolean.FALSE).and("hadwrittenoff", "=", (Object)Boolean.FALSE);
        DynamicObject[] settleRecords = BusinessDataServiceHelper.load((String)"ap_settlerecord", (String)CommonSettleServiceHelper.getSettleRecordSelector(), (QFilter[])filter.toArray());
        ArrayList<DynamicObject> deleteRecords = new ArrayList<DynamicObject>(settleRecords.length);
        ArrayList<DynamicObject> redRecords = new ArrayList<DynamicObject>(settleRecords.length);
        HashMap<Long, Date> currentDateMap = new HashMap<Long, Date>(1);
        boolean redAllSettleRecord = CommonSettleServiceHelper.isRedAllSettleRecord();
        if (redAllSettleRecord) {
            Collections.addAll(redRecords, settleRecords);
        } else {
            for (DynamicObject result2 : settleRecords) {
                Date currentDate;
                long orgId = result2.getLong("org.id");
                Date date = (Date)currentDateMap.get(orgId);
                if (date != null) {
                    currentDate = date;
                } else {
                    InitHelper init = new InitHelper(orgId, "ap_init");
                    currentDate = init.getCurrentDate() != null ? init.getCurrentDate() : init.getStartDate();
                    currentDateMap.put(orgId, currentDate);
                }
                if (result2.getBoolean("isvoucher") || DateUtils.getDiffDays((Date)result2.getDate("settledate"), (Date)currentDate) > 0) {
                    redRecords.add(result2);
                    continue;
                }
                deleteRecords.add(result2);
            }
        }
        if (deleteRecords.size() > 0) {
            UnSettleParam unSettleParam = new UnSettleParam();
            unSettleParam.setUnSettleByReturn(true);
            settleService.unSettle(deleteRecords.toArray(new DynamicObject[0]), unSettleParam);
        }
        if (redRecords.size() > 0) {
            List resultIds = redRecords.stream().map(result -> result.getLong("id")).collect(Collectors.toList());
            String apSettleRecordRedRuleId = "733772355079280640";
            List redSettleRecords = BOTPHelper.push((String)"ap_settlerecord", (String)"ap_settlerecord", (String)apSettleRecordRedRuleId, resultIds, (String)ResManager.loadKDString((String)"\u7ed3\u7b97\u8bb0\u5f55\u7ea2\u51b2\u5931\u8d25\u3002", (String)"CancelRefundAndRenoteNewExecutor_0", (String)"fi-ap-mservice", (Object[])new Object[0]));
            OperateOption option = OperateOption.create();
            option.setVariableValue("mutex_writeback", "false");
            OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"ap_settlerecord", (DynamicObject[])redSettleRecords.toArray(new DynamicObject[0]), (OperateOption)option);
            OperationHelper.assertResult((OperationResult)saveResult);
            OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"ap_settlerecord", (Object[])saveResult.getSuccessPkIds().toArray(), (OperateOption)option);
            OperationHelper.assertResult((OperationResult)submitResult);
            OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ap_settlerecord", (Object[])submitResult.getSuccessPkIds().toArray(), (OperateOption)option);
            OperationHelper.assertResult((OperationResult)auditResult);
            for (DynamicObject record : redRecords) {
                record.set("hadwrittenoff", (Object)1);
                DynamicObjectCollection entries = record.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entries) {
                    entry.set("e_hadwrittenoff", (Object)1);
                }
            }
            DynamicObject[] results = redRecords.toArray(new DynamicObject[0]);
            SaveServiceHelper.update((DynamicObject[])results);
            UnSettleParam unSettleParam = new UnSettleParam();
            unSettleParam.setRedSettleRecord(true);
            unSettleParam.setUnSettleByReturn(true);
            settleService.unSettle(redRecords.toArray(new DynamicObject[0]), unSettleParam);
        }
        CancelRefundAndRenoteUnFreezeService service = new CancelRefundAndRenoteUnFreezeService();
        service.freeze(payIds, false);
        logger.info("CancelRefundAndRenoteNewExecutor.executePayRecUnSettle end");
    }

    private void executePaySelfUnSettle(Set<Long> payIds) {
        logger.info("CancelRefundAndRenoteNewExecutor.executePaySelfUnSettle start");
        QFilter filter = new QFilter("settlerelation", "=", (Object)SettleRelationEnum.PAYSELF.getValue());
        filter.and("mainbillid", "in", payIds);
        filter.and("entry.billid", "in", payIds);
        filter.and("iswrittenoff", "=", (Object)Boolean.FALSE).and("hadwrittenoff", "=", (Object)Boolean.FALSE);
        DynamicObject[] settleRecords = BusinessDataServiceHelper.load((String)"ap_settlerecord", (String)CommonSettleServiceHelper.getSettleRecordSelector(), (QFilter[])filter.toArray());
        if (settleRecords.length == 0) {
            logger.info("CancelRefundAndRenoteNewExecutor.executePaySelfUnSettle end, payself settlerecord size is 0");
            return;
        }
        ArrayList<DynamicObject> deleteRecords = new ArrayList<DynamicObject>(settleRecords.length);
        ArrayList<DynamicObject> redRecords = new ArrayList<DynamicObject>(settleRecords.length);
        HashMap<Long, Date> currentDateMap = new HashMap<Long, Date>(1);
        boolean redAllSettleRecord = CommonSettleServiceHelper.isRedAllSettleRecord();
        if (redAllSettleRecord) {
            Collections.addAll(redRecords, settleRecords);
        } else {
            for (DynamicObject result2 : settleRecords) {
                Date currentDate;
                long orgId = result2.getLong("org.id");
                Date date = (Date)currentDateMap.get(orgId);
                if (date != null) {
                    currentDate = date;
                } else {
                    InitHelper init = new InitHelper(orgId, "ap_init");
                    currentDate = init.getCurrentDate() != null ? init.getCurrentDate() : init.getStartDate();
                    currentDateMap.put(orgId, currentDate);
                }
                if (result2.getBoolean("isvoucher") || DateUtils.getDiffDays((Date)result2.getDate("settledate"), (Date)currentDate) > 0) {
                    redRecords.add(result2);
                    continue;
                }
                deleteRecords.add(result2);
            }
        }
        PaySelfSettleService settleService = new PaySelfSettleService();
        if (deleteRecords.size() > 0) {
            UnSettleParam unSettleParam = new UnSettleParam();
            unSettleParam.setUnSettleByReturn(true);
            settleService.unSettle(deleteRecords.toArray(new DynamicObject[0]), unSettleParam);
        }
        if (redRecords.size() > 0) {
            List resultIds = redRecords.stream().map(result -> result.getLong("id")).collect(Collectors.toList());
            String apSettleRecordRedRuleId = "733772355079280640";
            List redSettleRecords = BOTPHelper.push((String)"ap_settlerecord", (String)"ap_settlerecord", (String)apSettleRecordRedRuleId, resultIds, (String)ResManager.loadKDString((String)"\u7ed3\u7b97\u8bb0\u5f55\u7ea2\u51b2\u5931\u8d25\u3002", (String)"CancelRefundAndRenoteNewExecutor_0", (String)"fi-ap-mservice", (Object[])new Object[0]));
            OperateOption option = OperateOption.create();
            option.setVariableValue("mutex_writeback", "false");
            OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"ap_settlerecord", (DynamicObject[])redSettleRecords.toArray(new DynamicObject[0]), (OperateOption)option);
            OperationHelper.assertResult((OperationResult)saveResult);
            OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"ap_settlerecord", (Object[])saveResult.getSuccessPkIds().toArray(), (OperateOption)option);
            OperationHelper.assertResult((OperationResult)submitResult);
            OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ap_settlerecord", (Object[])submitResult.getSuccessPkIds().toArray(), (OperateOption)option);
            OperationHelper.assertResult((OperationResult)auditResult);
            for (DynamicObject record : redRecords) {
                record.set("hadwrittenoff", (Object)1);
                DynamicObjectCollection entries = record.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entries) {
                    entry.set("e_hadwrittenoff", (Object)1);
                }
            }
            DynamicObject[] results = redRecords.toArray(new DynamicObject[0]);
            SaveServiceHelper.update((DynamicObject[])results);
            UnSettleParam unSettleParam = new UnSettleParam();
            unSettleParam.setRedSettleRecord(true);
            unSettleParam.setUnSettleByReturn(true);
            settleService.unSettle(redRecords.toArray(new DynamicObject[0]), unSettleParam);
        }
        logger.info("CancelRefundAndRenoteNewExecutor.executePaySelfUnSettle end");
    }

    private void executeApPayUnSettle(CancelRefundAndRenoteParam cancelRefundAndRenoteParam) {
        logger.info("CancelRefundAndRenoteNewExecutor.executeApPayUnSettle(ArPayUnSettle) start");
        Long recId = cancelRefundAndRenoteParam.getRecId();
        DynamicObject[] refundRecords = BusinessDataServiceHelper.load((String)"ap_refundrenote_record", (String)"org,settlerelation,finbillid,finbillentryid,paybillid,paybillentryid,oldsettleamt,newsettleamt,settletype,autosettletype", (QFilter[])new QFilter[]{new QFilter("recbillid", "=", (Object)recId)});
        if (refundRecords.length == 0) {
            return;
        }
        HashSet<Long> finBillIds = new HashSet<Long>(1);
        HashSet<Long> finBillEntryIds = new HashSet<Long>(1);
        HashSet<Long> payBillIds = new HashSet<Long>(1);
        HashSet<Long> payBillEntryIds = new HashSet<Long>(1);
        HashMap<String, String> fin2PayEntryIdMap = new HashMap<String, String>(1);
        for (DynamicObject refundRecord : refundRecords) {
            finBillIds.add(refundRecord.getLong("finbillid"));
            payBillIds.add(refundRecord.getLong("paybillid"));
            Long finBillEntryId = refundRecord.getLong("finbillentryid");
            Long payBillEntryId = refundRecord.getLong("paybillentryid");
            String key = finBillEntryId.toString() + payBillEntryId.toString();
            fin2PayEntryIdMap.put(key, key);
            finBillEntryIds.add(finBillEntryId);
            payBillEntryIds.add(payBillEntryId);
        }
        ArrayList<String> settleRelations = new ArrayList<String>(2);
        settleRelations.add(SettleRelationEnum.APPAYSETTLE.getValue());
        settleRelations.add(SettleRelationEnum.ARPAYSETTLE.getValue());
        QFilter filter = new QFilter("settlerelation", "in", settleRelations);
        filter.and("mainbillid", "in", finBillIds);
        filter.and("mainbillentryid", "in", finBillEntryIds);
        filter.and("entry.billid", "in", payBillIds);
        filter.and("entry.billentryid", "in", payBillEntryIds);
        filter.and("iswrittenoff", "=", (Object)Boolean.FALSE).and("hadwrittenoff", "=", (Object)Boolean.FALSE);
        DynamicObject[] settleRecordArray = SettleRecordQueryHelper.getSettleRecords((String)"ap_settlerecord", (String)"id,org,settletype,settledate,settlerelation,mainbillid,mainbilltype,maincurrency,mainbillentryid,totalsettleamt,localtotalsettleamt,exchangerate,swappl,autosettletype,corebillid,corebillentryid,settleentry,billentity,mainpayableamt,settlerelation,iswrittenoff,hadwrittenoff,entry.billtype,entry.currency,entry.settleamt,entry.e_billentity,entry.billid,entry.billentryid,entry.e_swappl,entry.e_exchangerate,entry.e_settleentry,entry.e_hadwrittenoff,isvoucher,entry.payableamt,entry.localsettleamt,settletype", (String)"cas_paybill", (Object[])finBillIds.toArray(), (QFilter)filter);
        List<DynamicObject> settleRecords = Arrays.stream(settleRecordArray).collect(Collectors.toList());
        if (settleRecords.size() == 0) {
            return;
        }
        this.settleRecordRemove(settleRecords, fin2PayEntryIdMap);
        if (settleRecords.size() == 0) {
            return;
        }
        HashSet<Long> payEntryIds = new HashSet<Long>(8);
        for (PayRefundEntryInfo payInfo : cancelRefundAndRenoteParam.getPayInfos()) {
            if (payInfo.getEntryRefundAmt().compareTo(BigDecimal.ZERO) == 0) continue;
            Long entryId = payInfo.getEntryId();
            payEntryIds.add(entryId);
        }
        RefundAndRenoteConfirmHelper.payUnSettle(settleRecords, payEntryIds);
        logger.info("CancelRefundAndRenoteNewExecutor.executeApPayUnSettle(ArPayUnSettle) end");
    }

    private void settleRecordRemove(List<DynamicObject> settleRecords, Map<String, String> fin2PayEntryIdMap) {
        Iterator<DynamicObject> iterator = settleRecords.iterator();
        while (iterator.hasNext()) {
            DynamicObject settleRecord = iterator.next();
            String mainBillEntryId = Long.toString(settleRecord.getLong("mainbillentryid"));
            DynamicObjectCollection entries = settleRecord.getDynamicObjectCollection("entry");
            boolean isExist = false;
            for (DynamicObject entry : entries) {
                String key = mainBillEntryId + entry.getLong("billentryid");
                if (fin2PayEntryIdMap.get(key) == null) continue;
                isExist = true;
                break;
            }
            if (isExist) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void executeApPaySettle(Long recId, Set<Long> payIds) {
        void var13_30;
        DynamicObject[] dynamicObjectArray;
        BigDecimal unSettleAmt;
        DynamicObject planEntry;
        Iterator planEntries;
        Object detailEntry;
        Object detailEntries;
        long finBillId;
        int n;
        logger.info("CancelRefundAndRenoteNewExecutor.executeApPaySettle(ArPaySettle) start");
        DynamicObject[] refundRecords = BusinessDataServiceHelper.load((String)"ap_refundrenote_record", (String)"org,settlerelation,finbillid,finbillentryid,paybillid,paybillentryid,oldsettleamt,newsettleamt,settletype,autosettletype,settledate", (QFilter[])new QFilter[]{new QFilter("recbillid", "=", (Object)recId)});
        if (refundRecords.length == 0) {
            return;
        }
        this.handleOtherRefundRecordAndRepairCurrentRecords(refundRecords);
        HashSet<Long> apBillIds = new HashSet<Long>(1);
        HashSet<Long> arBillIds = new HashSet<Long>(1);
        HashSet<Long> payBillIds = new HashSet<Long>(1);
        for (DynamicObject dynamicObject : refundRecords) {
            String settleRelation = dynamicObject.getString("settlerelation");
            if ("appaysettle".equals(settleRelation)) {
                apBillIds.add(dynamicObject.getLong("finbillid"));
            } else {
                arBillIds.add(dynamicObject.getLong("finbillid"));
            }
            payBillIds.add(dynamicObject.getLong("paybillid"));
        }
        HashMap<Long, Long> finBillIdMap = new HashMap<Long, Long>(refundRecords.length);
        HashMap<Long, BigDecimal> finBillEntryIdToUnSettleAmt = new HashMap<Long, BigDecimal>(8);
        if (apBillIds.size() > 0) {
            DynamicObject[] apBills;
            DynamicObject[] dynamicObjectArray2 = apBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"id,org,unsettleamt,unplansettleamt", (QFilter[])new QFilter[]{new QFilter("id", "in", apBillIds)});
            int settleRelation = dynamicObjectArray2.length;
            for (n = 0; n < settleRelation; ++n) {
                DynamicObject dynamicObject = dynamicObjectArray2[n];
                finBillId = dynamicObject.getLong("id");
                finBillIdMap.put(finBillId, finBillId);
                detailEntries = dynamicObject.getDynamicObjectCollection("detailentry");
                Iterator iterator = detailEntries.iterator();
                while (iterator.hasNext()) {
                    detailEntry = (DynamicObject)iterator.next();
                    BigDecimal unSettleAmt2 = detailEntry.getBigDecimal("unsettleamt");
                    if (unSettleAmt2.compareTo(BigDecimal.ZERO) == 0) continue;
                    finBillEntryIdToUnSettleAmt.put(detailEntry.getLong("id"), unSettleAmt2);
                }
                planEntries = dynamicObject.getDynamicObjectCollection("planentity");
                detailEntry = planEntries.iterator();
                while (detailEntry.hasNext()) {
                    planEntry = (DynamicObject)detailEntry.next();
                    unSettleAmt = planEntry.getBigDecimal("unplansettleamt");
                    if (unSettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                    finBillEntryIdToUnSettleAmt.put(planEntry.getLong("id"), unSettleAmt);
                }
            }
        }
        if (arBillIds.size() > 0) {
            DynamicObject[] arBills;
            for (DynamicObject dynamicObject : arBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"id,org,e_unsettleamt,unplansettleamt", (QFilter[])new QFilter[]{new QFilter("id", "in", arBillIds)})) {
                finBillId = dynamicObject.getLong("id");
                finBillIdMap.put(finBillId, finBillId);
                detailEntries = dynamicObject.getDynamicObjectCollection("entry");
                planEntries = detailEntries.iterator();
                while (planEntries.hasNext()) {
                    detailEntry = (DynamicObject)planEntries.next();
                    BigDecimal unSettleAmt2 = detailEntry.getBigDecimal("e_unsettleamt");
                    if (unSettleAmt2.compareTo(BigDecimal.ZERO) == 0) continue;
                    finBillEntryIdToUnSettleAmt.put(detailEntry.getLong("id"), unSettleAmt2);
                }
                planEntries = dynamicObject.getDynamicObjectCollection("planentity");
                detailEntry = planEntries.iterator();
                while (detailEntry.hasNext()) {
                    planEntry = (DynamicObject)detailEntry.next();
                    unSettleAmt = planEntry.getBigDecimal("unplansettleamt");
                    if (unSettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                    finBillEntryIdToUnSettleAmt.put(planEntry.getLong("id"), unSettleAmt);
                }
            }
        }
        HashMap<Long, BigDecimal> payBillEntryIdToUnSettleAmt = new HashMap<Long, BigDecimal>(8);
        DynamicObject[] settleRelation = dynamicObjectArray = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,e_unsettledamt", (QFilter[])new QFilter[]{new QFilter("id", "in", payBillIds)});
        n = settleRelation.length;
        boolean bl = false;
        while (var13_30 < n) {
            DynamicObject payBill = settleRelation[var13_30];
            DynamicObjectCollection entries = payBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                BigDecimal unSettleAmt3 = entry.getBigDecimal("e_unsettledamt");
                if (unSettleAmt3.compareTo(BigDecimal.ZERO) == 0) continue;
                payBillEntryIdToUnSettleAmt.put(entry.getLong("id"), unSettleAmt3);
            }
            ++var13_30;
        }
        HashMap<Long, ArrayList<DynamicObject>> refundRecordGroupOrgMap = new HashMap<Long, ArrayList<DynamicObject>>(8);
        for (DynamicObject refundRecord3 : refundRecords) {
            ArrayList<DynamicObject> result = (ArrayList<DynamicObject>)refundRecordGroupOrgMap.get(refundRecord3.getLong("org.id"));
            if (result == null) {
                result = new ArrayList<DynamicObject>(1);
                result.add(refundRecord3);
                refundRecordGroupOrgMap.put(refundRecord3.getLong("org.id"), result);
                continue;
            }
            result.add(refundRecord3);
        }
        for (Map.Entry entry : refundRecordGroupOrgMap.entrySet()) {
            ISettleService service;
            AssignSettleParam param;
            Long orgId = (Long)entry.getKey();
            logger.info("CancelRefundAndRenoteNewExecutor executeApPaySettle(ArPaySettle) orgid : " + orgId);
            Date orgCurrentDate = this.getOrgCurrentDate(orgId);
            List records = (List)entry.getValue();
            ArrayList<SettleDetailParam> mainApDetailParam = new ArrayList<SettleDetailParam>(1);
            ArrayList<SettleDetailParam> mainArDetailParam = new ArrayList<SettleDetailParam>(1);
            ArrayList<SettleDetailParam> asstApToPayDetailParam = new ArrayList<SettleDetailParam>(1);
            ArrayList<SettleDetailParam> asstArToPayDetailParam = new ArrayList<SettleDetailParam>(1);
            ArrayList<SettleDetailParam> botpMainApDetailParam = new ArrayList<SettleDetailParam>(1);
            ArrayList<SettleDetailParam> botpMainArDetailParam = new ArrayList<SettleDetailParam>(1);
            ArrayList<SettleDetailParam> botpAsstApToPayDetailParam = new ArrayList<SettleDetailParam>(1);
            ArrayList<SettleDetailParam> botpAsstArToPayDetailParam = new ArrayList<SettleDetailParam>(1);
            for (DynamicObject refundRecord4 : records) {
                long recordId = refundRecord4.getLong("id");
                String settleRelation2 = refundRecord4.getString("settlerelation");
                long finBillId2 = refundRecord4.getLong("finbillid");
                if (finBillIdMap.get(finBillId2) == null) continue;
                long finBillEntryId = refundRecord4.getLong("finbillentryid");
                long payBillId = refundRecord4.getLong("paybillid");
                long payBillEntryId = refundRecord4.getLong("paybillentryid");
                BigDecimal oldSettleAmt = refundRecord4.getBigDecimal("oldsettleamt");
                if (oldSettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                BigDecimal finUnSettleAmt = (BigDecimal)finBillEntryIdToUnSettleAmt.get(finBillEntryId);
                BigDecimal payUnSettleAmt = (BigDecimal)payBillEntryIdToUnSettleAmt.get(payBillEntryId);
                if (finUnSettleAmt == null || finUnSettleAmt.compareTo(BigDecimal.ZERO) == 0 || payUnSettleAmt == null || payUnSettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                BigDecimal needSettleAmt = finUnSettleAmt.abs().compareTo(payUnSettleAmt.abs()) > 0 ? payUnSettleAmt.abs() : finUnSettleAmt.abs();
                if (needSettleAmt.compareTo(oldSettleAmt.abs()) > 0) {
                    needSettleAmt = oldSettleAmt.abs();
                }
                needSettleAmt = needSettleAmt.multiply(new BigDecimal(oldSettleAmt.signum()));
                finBillEntryIdToUnSettleAmt.put(finBillEntryId, finUnSettleAmt.subtract(needSettleAmt));
                payBillEntryIdToUnSettleAmt.put(payBillEntryId, payUnSettleAmt.subtract(needSettleAmt));
                SettleDetailParam mainParam = new SettleDetailParam(finBillId2, finBillEntryId, needSettleAmt, true);
                mainParam.setMatchFieldValue("matchId", (Object)recordId);
                mainParam.setMatchFieldValue("settletype", (Object)refundRecord4.getString("settletype"));
                String autoSettleType = refundRecord4.getString("autosettletype");
                mainParam.setMatchFieldValue("autosettletype", (Object)autoSettleType);
                Date refundSettleDate = refundRecord4.getDate("settledate");
                if (!this.isOverPeriod(refundSettleDate, orgCurrentDate)) {
                    mainParam.setMatchFieldValue("settledate", (Object)refundSettleDate);
                }
                SettleDetailParam asstParam = new SettleDetailParam(payBillId, payBillEntryId, needSettleAmt, true);
                asstParam.setMatchFieldValue("matchId", (Object)recordId);
                if ("appaysettle".equals(settleRelation2)) {
                    if ("1".equals(autoSettleType)) {
                        botpMainApDetailParam.add(mainParam);
                        botpAsstApToPayDetailParam.add(asstParam);
                        continue;
                    }
                    mainApDetailParam.add(mainParam);
                    asstApToPayDetailParam.add(asstParam);
                    continue;
                }
                mainParam.setSettleAmt(needSettleAmt.negate());
                if ("1".equals(autoSettleType)) {
                    botpMainArDetailParam.add(mainParam);
                    botpAsstArToPayDetailParam.add(asstParam);
                    continue;
                }
                mainArDetailParam.add(mainParam);
                asstArToPayDetailParam.add(asstParam);
            }
            if (botpMainApDetailParam.size() > 0 && botpAsstApToPayDetailParam.size() > 0) {
                logger.info("CancelRefundAndRenoteNewExecutor executeApPaySettle(botp)");
                param = this.buildAssignSettleParam(orgId, true, botpMainApDetailParam, botpAsstApToPayDetailParam);
                service = ArApServiceAPIFactory.getSettleService((String)"appaysettle");
                service.assignSettle(param);
            }
            if (mainApDetailParam.size() > 0 && asstApToPayDetailParam.size() > 0) {
                logger.info("CancelRefundAndRenoteNewExecutor executeApPaySettle(not botp)");
                param = this.buildAssignSettleParam(orgId, false, mainApDetailParam, asstApToPayDetailParam);
                service = ArApServiceAPIFactory.getSettleService((String)"appaysettle");
                service.assignSettle(param);
            }
            if (botpMainArDetailParam.size() > 0 && botpAsstArToPayDetailParam.size() > 0) {
                logger.info("CancelRefundAndRenoteNewExecutor executeArPaySettle(botp)");
                param = this.buildAssignSettleParam(orgId, true, botpMainArDetailParam, botpAsstArToPayDetailParam);
                service = ArApServiceAPIFactory.getSettleService((String)"arpaysettle");
                service.assignSettle(param);
            }
            if (mainArDetailParam.size() <= 0 || asstArToPayDetailParam.size() <= 0) continue;
            logger.info("CancelRefundAndRenoteNewExecutor executeArPaySettle(not botp)");
            param = this.buildAssignSettleParam(orgId, false, mainArDetailParam, asstArToPayDetailParam);
            service = ArApServiceAPIFactory.getSettleService((String)"arpaysettle");
            service.assignSettle(param);
        }
        List refundRecordIds = Arrays.stream(refundRecords).map(refundRecord -> refundRecord.getLong("id")).collect(Collectors.toList());
        DeleteServiceHelper.delete((String)"ap_refundrenote_record", (QFilter[])new QFilter[]{new QFilter("id", "in", refundRecordIds)});
        logger.info("CancelRefundAndRenoteNewExecutor.executeApPaySettle(ArPaySettle) end");
    }

    private void handleOtherRefundRecordAndRepairCurrentRecords(DynamicObject[] refundRecords) {
        String key;
        Long payBillEntryId;
        Long finBillEntryId;
        logger.info("CancelRefundAndRenoteNewExecutor.handleOtherRefundRecord start");
        HashSet<Long> finBillEntryIds = new HashSet<Long>(8);
        HashSet<Long> payBillEntryIds = new HashSet<Long>(8);
        HashMap<String, Tuple> finPayRefundAmtMap = new HashMap<String, Tuple>(8);
        HashSet<Long> refundRecordIds = new HashSet<Long>(8);
        for (DynamicObject refundRecord : refundRecords) {
            refundRecordIds.add(refundRecord.getLong("id"));
            Long finBillEntryId2 = refundRecord.getLong("finbillentryid");
            finBillEntryIds.add(finBillEntryId2);
            Long payBillEntryId2 = refundRecord.getLong("paybillentryid");
            payBillEntryIds.add(payBillEntryId2);
            String key2 = finBillEntryId2.toString() + payBillEntryId2.toString();
            Tuple tuple = finPayRefundAmtMap.computeIfAbsent(key2, v -> new Tuple((Object)BigDecimal.ZERO, (Object)Boolean.FALSE));
            BigDecimal curRefundAmt = refundRecord.getBigDecimal("oldsettleamt").subtract(refundRecord.getBigDecimal("newsettleamt"));
            BigDecimal refundAmt = ((BigDecimal)tuple.item1).add(curRefundAmt);
            finPayRefundAmtMap.put(key2, new Tuple((Object)refundAmt, (Object)Boolean.FALSE));
        }
        DynamicObject[] recordArr = BusinessDataServiceHelper.load((String)"ap_refundrenote_record", (String)"id,finbillid,finbillentryid,paybillid,paybillentryid,oldsettleamt,newsettleamt,createtime", (QFilter[])new QFilter[]{new QFilter("finbillentryid", "in", finBillEntryIds), new QFilter("paybillentryid", "in", payBillEntryIds)}, (String)"createtime");
        logger.info("CancelRefundAndRenoteNewExecutor.handleOtherRefundRecord: " + refundRecords.length + "," + recordArr.length);
        HashSet<DynamicObject> saveRecords = new HashSet<DynamicObject>(1);
        HashMap<String, BigDecimal> behindRecordRefundAmtMap = new HashMap<String, BigDecimal>(8);
        for (DynamicObject refundRecord : recordArr) {
            finBillEntryId = refundRecord.getLong("finbillentryid");
            finBillEntryIds.add(finBillEntryId);
            payBillEntryId = refundRecord.getLong("paybillentryid");
            payBillEntryIds.add(payBillEntryId);
            key = finBillEntryId.toString() + payBillEntryId.toString();
            Tuple tuple = (Tuple)finPayRefundAmtMap.get(key);
            if (tuple == null) continue;
            long recordId = refundRecord.getLong("id");
            BigDecimal refundAmt = (BigDecimal)tuple.item1;
            if (refundRecordIds.contains(recordId)) {
                finPayRefundAmtMap.put(key, new Tuple((Object)refundAmt, (Object)Boolean.TRUE));
                continue;
            }
            if (!((Boolean)tuple.item2).booleanValue()) continue;
            BigDecimal behindRecordRefundAmt = behindRecordRefundAmtMap.computeIfAbsent(key, v -> BigDecimal.ZERO);
            BigDecimal curRefundAmt = refundRecord.getBigDecimal("oldsettleamt").subtract(refundRecord.getBigDecimal("newsettleamt"));
            behindRecordRefundAmtMap.put(key, behindRecordRefundAmt.add(curRefundAmt));
            refundRecord.set("oldsettleamt", (Object)refundAmt.add(refundRecord.getBigDecimal("oldsettleamt")));
            refundRecord.set("newsettleamt", (Object)refundAmt.add(refundRecord.getBigDecimal("newsettleamt")));
            saveRecords.add(refundRecord);
        }
        if (!saveRecords.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])saveRecords.toArray(new DynamicObject[0]));
        }
        if (behindRecordRefundAmtMap.size() > 0) {
            logger.info("CancelRefundAndRenoteNewExecutor.handleOtherRefundRecord.behindRecordRefundAmtMap " + behindRecordRefundAmtMap.size());
            for (DynamicObject refundRecord : refundRecords) {
                finBillEntryId = refundRecord.getLong("finbillentryid");
                payBillEntryId = refundRecord.getLong("paybillentryid");
                key = finBillEntryId.toString() + payBillEntryId.toString();
                BigDecimal behindRecordRefundAmt = behindRecordRefundAmtMap.computeIfAbsent(key, v -> BigDecimal.ZERO);
                BigDecimal oldSettleAmt = refundRecord.getBigDecimal("oldsettleamt");
                if (oldSettleAmt.abs().compareTo(behindRecordRefundAmt.abs()) >= 0) {
                    refundRecord.set("oldsettleamt", (Object)oldSettleAmt.subtract(behindRecordRefundAmt));
                    behindRecordRefundAmtMap.put(key, BigDecimal.ZERO);
                    continue;
                }
                refundRecord.set("oldsettleamt", (Object)BigDecimal.ZERO);
                behindRecordRefundAmtMap.put(key, behindRecordRefundAmt.subtract(oldSettleAmt));
            }
        }
        logger.info("CancelRefundAndRenoteNewExecutor.handleOtherRefundRecord end");
    }

    private AssignSettleParam buildAssignSettleParam(Long orgId, boolean isRefundByBotp, List<SettleDetailParam> mainParam, List<SettleDetailParam> asstParam) {
        AssignSettleParam param = new AssignSettleParam(orgId.longValue(), SettleTypeEnum.AUTO.getValue(), SettleDetailTypeEnum.BYENTRY.getValue());
        param.setRefundAndRenote(true);
        param.setMatchServiceClass("kd.fi.arapcommon.service.match.RefundAndRenoteSettleMatchService");
        param.setRefundByBotp(isRefundByBotp);
        param.setMainDetailParamList(mainParam);
        param.setAsstDetailParamList(asstParam);
        return param;
    }

    private void executeWriteBackFinOrApplyBill(CancelRefundAndRenoteParam cancelRefundAndRenoteParam) {
        logger.info("CancelRefundAndRenoteNewExecutor.executeWriteBackFinOrApplyBill start");
        Set<Long> payIds = cancelRefundAndRenoteParam.getPayInfos().stream().map(PayRefundEntryInfo::getPayId).collect(Collectors.toSet());
        DynamicObject[] payBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"entry.id,entry.e_sourcebillid,entry.e_sourcebillentryid,sourcebilltype,billstatus,e_payableamt,e_refundamt", (QFilter[])new QFilter[]{new QFilter("id", "in", payIds)});
        HashMap<String, ArrayList<DynamicObject>> sourceBillTypeToPayBills = new HashMap<String, ArrayList<DynamicObject>>(1);
        for (DynamicObject payBill : payBills) {
            String sourcebilltype = payBill.getString("sourcebilltype");
            if (StringUtils.isEmpty((String)sourcebilltype)) continue;
            ArrayList<DynamicObject> groupPayBills = (ArrayList<DynamicObject>)sourceBillTypeToPayBills.get(sourcebilltype);
            if (groupPayBills == null) {
                groupPayBills = new ArrayList<DynamicObject>(payBills.length);
                groupPayBills.add(payBill);
                sourceBillTypeToPayBills.put(sourcebilltype, groupPayBills);
                continue;
            }
            groupPayBills.add(payBill);
        }
        logger.info("CancelRefundAndRenoteNewExecutor.executeWriteBackFinOrApplyBill sourceBillTypeToPayBills.size = " + sourceBillTypeToPayBills.size());
        for (Map.Entry entry : sourceBillTypeToPayBills.entrySet()) {
            String sourceBillType = (String)entry.getKey();
            List value = (List)entry.getValue();
            if ("ap_payapply".equals(sourceBillType)) {
                Object payInfo22;
                logger.info("CancelRefundAndRenoteNewExecutor.writeBackApplyBill start");
                List payInfos = cancelRefundAndRenoteParam.getPayInfos();
                HashMap needSettleEntryMap = new HashMap(payInfos.size());
                for (Object payInfo22 : payInfos) {
                    needSettleEntryMap.put(payInfo22.getEntryId(), payInfo22.getEntryRefundAmt());
                }
                ArrayList params = new ArrayList(8);
                payInfo22 = value.iterator();
                while (payInfo22.hasNext()) {
                    DynamicObject payBill = (DynamicObject)payInfo22.next();
                    DynamicObjectCollection entrys = payBill.getDynamicObjectCollection("entry");
                    for (DynamicObject entry2 : entrys) {
                        HashMap<String, Object> param = new HashMap<String, Object>(6);
                        param.put("sourcepk", entry2.getLong("e_sourcebillid"));
                        param.put("sourceentrypk", entry2.getLong("e_sourcebillentryid"));
                        param.put("operate", cancelRefundAndRenoteParam.getOperateKey());
                        param.put("issuccess", true);
                        param.put("payableamt", entry2.getBigDecimal("e_payableamt"));
                        param.put("refundamt", needSettleEntryMap.get(entry2.getLong("id")) == null ? BigDecimal.ZERO : ((BigDecimal)needSettleEntryMap.get(entry2.getLong("id"))).negate());
                        params.add(param);
                    }
                }
                DispatchServiceHelper.invokeBizService((String)"fi", (String)"ap", (String)"payO2OService", (String)"syncBill", (Object[])new Object[]{params});
                logger.info("CancelRefundAndRenoteNewExecutor.writeBackApplyBill end");
                continue;
            }
            if (!"ap_finapbill".equals(sourceBillType) && !"ar_finarbill".equals(sourceBillType)) continue;
            logger.info("CancelRefundAndRenoteNewExecutor.writeBackFinBill start");
            HashSet<Long> upFinPayBillIds = new HashSet<Long>(value.size());
            for (DynamicObject payBill : value) {
                upFinPayBillIds.add(payBill.getLong("id"));
            }
            List payInfos = cancelRefundAndRenoteParam.getPayInfos();
            Set<Long> payEntryIds = payInfos.stream().map(PayRefundEntryInfo::getEntryId).collect(Collectors.toSet());
            Map payEntryIdToFinEntryId = BOTPNewHelper.loadNearSourceRowIds((String)"cas_paybill", (String)"entry", (Long[])payIds.toArray(new Long[0]), (Long[])payEntryIds.toArray(new Long[0]), (String)sourceBillType);
            HashMap<Long, BigDecimal> needSettleEntryMap = new HashMap<Long, BigDecimal>(payInfos.size());
            for (PayRefundEntryInfo payInfo : payInfos) {
                if (!upFinPayBillIds.contains(payInfo.getPayId()) || payEntryIdToFinEntryId.get(payInfo.getEntryId()) == null) continue;
                needSettleEntryMap.put(payInfo.getEntryId(), payInfo.getEntryRefundAmt());
            }
            RefundAndRenoteConfirmHelper.writeBackFinBill(upFinPayBillIds, needSettleEntryMap, false);
            logger.info("CancelRefundAndRenoteNewExecutor.writeBackFinBill end");
        }
        logger.info("CancelRefundAndRenoteNewExecutor.executeWriteBackFinOrApplyBill end");
    }

    private Date getOrgCurrentDate(long orgId) {
        Date currentDate;
        InitHelper init = new InitHelper(orgId, "ap_init");
        Date date = currentDate = init.getCurrentDate() != null ? init.getCurrentDate() : init.getStartDate();
        if (currentDate == null) {
            currentDate = new Date();
        }
        return currentDate;
    }

    private boolean isOverPeriod(Date settleRecordDate, Date orgCurrentDate) {
        boolean isOverPeriod = false;
        if (DateUtils.getDiffDays((Date)settleRecordDate, (Date)orgCurrentDate) > 0) {
            isOverPeriod = true;
        }
        return isOverPeriod;
    }
}

