/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.mservice.PayRecSettleService;
import kd.fi.ap.mservice.PayReturnProcessSettleService;
import kd.fi.ap.mservice.helper.SettleServiceHelper;
import kd.fi.arapcommon.api.param.NoAssignSettleParam;
import kd.fi.arapcommon.api.param.ServiceNameEnum;
import kd.fi.arapcommon.api.settle.ISettleService;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.CasCancelUnSettleServiceHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.journal.JournalService;
import kd.fi.arapcommon.service.ext.SettleExtDataLoader;
import kd.fi.arapcommon.service.freeze.CancelPayFreezeService;
import kd.fi.arapcommon.service.freeze.CancelRefundAndRenoteUnFreezeService;
import kd.fi.arapcommon.service.freeze.ConfirmPayFreezeService;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.service.log.LogUtil;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.StdConfig;
import kd.fi.arapcommon.vo.UnSettleParam;

public class PayBillListener {
    public static final Log logger = LogFactory.getLog(PayBillListener.class);

    public void execute(List<Map<String, Object>> param) {
        Object operate = param.get(0).get("operate");
        logger.info("PayBillListener-execute operate:" + operate);
        Object isFullRefund = param.get(0).get("isfullrefund");
        logger.info("PayBillListener-execute isfullrefund:" + isFullRefund);
        boolean isSuccess = (Boolean)param.get(0).get("issuccess");
        if (isSuccess && "pay".equals(operate)) {
            this.paySuccess(param);
        } else if ("cancelPay".equals(operate)) {
            this.cancelPay(param);
        } else if ("renote".equals(operate) || "refund".equals(operate) && isFullRefund != null && ((Boolean)isFullRefund).booleanValue()) {
            new PayReturnProcessSettleService().execute(param);
        } else if ("cancelRenote".equals(operate) || "cancelRefund".equals(operate)) {
            this.cancelRenote(param);
        }
    }

    public void paySuccess(List<Map<String, Object>> payParam) {
        logger.info("paySuccess-begin");
        try (TXHandle tx = TX.required();){
            Set<Long> paymentBillPks;
            List<Map<String, Object>> logPayParam;
            block22: {
                logPayParam = this.getLogPaParam(payParam);
                paymentBillPks = new HashSet<Long>(payParam.size());
                for (Map<String, Object> map : payParam) {
                    paymentBillPks.add(Long.parseLong(map.get("targetpk").toString()));
                }
                if (!ObjectUtils.isEmpty(paymentBillPks = this.getPartSettlePKs(paymentBillPks))) break block22;
                logger.info("paySuccess:paymentBillPks isEmpty");
                return;
            }
            try {
                logger.info("paySuccess-PartSettlePKs:" + paymentBillPks);
                if (this.isBatchExecute()) {
                    logger.info("paySuccess-isBatchExecute:true");
                    this.paySuccessBatchExecute(paymentBillPks);
                } else {
                    logger.info("paySuccess-isBatchExecute:false");
                    for (Long paymentBillPk : paymentBillPks) {
                        this.paySuccessExecute(paymentBillPk);
                    }
                }
                ConfirmPayFreezeService service = new ConfirmPayFreezeService();
                service.freeze(paymentBillPks, false);
                LogUtil.addInvokeLog((String)"paySuccess", (Object[])new Object[]{logPayParam}, null, (boolean)true);
            }
            catch (Throwable e) {
                logger.info("paySuccess-exception:" + e);
                LogUtil.addInvokeErrorLog((String)"paySuccess", (Object[])new Object[]{logPayParam}, (Throwable)e, (boolean)true);
                tx.markRollback();
                throw e;
            }
            logger.info("paySuccess-end");
        }
    }

    private void paySuccessExecute(Long paymentBillPk) {
        HashSet<Long> remainPayBillIds = new HashSet<Long>(1);
        remainPayBillIds.add(paymentBillPk);
        this.paySuccessBatchExecute(remainPayBillIds);
    }

    private void paySuccessBatchExecute(Set<Long> paymentBillPks) {
        List linkUpNodeList = BFTrackerServiceHelper.loadLinkUpNodes((String)"cas_paybill", (Long[])paymentBillPks.toArray(new Long[0]), (OperateOption)OperateOption.create());
        HashSet<Long> srcArBillIdSet = new HashSet<Long>(paymentBillPks.size());
        HashSet<Long> arBillIdSet = new HashSet<Long>(paymentBillPks.size());
        HashSet<Long> srcApBillIdSet = new HashSet<Long>(paymentBillPks.size());
        HashSet<Long> apBillIdSet = new HashSet<Long>(paymentBillPks.size());
        HashSet<Long> coreBillSettleIdSet = new HashSet(paymentBillPks.size());
        if (linkUpNodeList.isEmpty()) {
            coreBillSettleIdSet = paymentBillPks;
            this.doApPaySettleByCoreBill(coreBillSettleIdSet);
        } else {
            TableDefine arTableDefine = EntityMetadataCache.loadTableDefine((String)"ar_finarbill", (String)"ar_finarbill");
            Long arTableId = arTableDefine.getTableId();
            TableDefine apTableDefine = EntityMetadataCache.loadTableDefine((String)"ap_finapbill", (String)"ap_finapbill");
            Long apTableId = apTableDefine.getTableId();
            for (Long payId : paymentBillPks) {
                List nodes = linkUpNodeList.stream().filter(bfRowLinkUpNode -> bfRowLinkUpNode.getRowId().getBillId().compareTo(payId) == 0).collect(Collectors.toList());
                ArrayList<BFRowLinkUpNode> arOrApsrcNodes = new ArrayList<BFRowLinkUpNode>(10);
                for (BFRowLinkUpNode node : nodes) {
                    List<BFRowLinkUpNode> sourceNodes = PayBillListener.findSourceNodes(node, arTableId, apTableId, payId);
                    arOrApsrcNodes.addAll(sourceNodes);
                }
                if (arOrApsrcNodes.isEmpty()) continue;
                List srcIdList = arOrApsrcNodes.stream().map(srcNode -> srcNode.getRowId().getBillId()).collect(Collectors.toList());
                Long tableId = ((BFRowLinkUpNode)arOrApsrcNodes.get(0)).getRowId().getMainTableId();
                if (arTableId.compareTo(tableId) == 0) {
                    srcArBillIdSet.add(payId);
                    arBillIdSet.addAll(srcIdList);
                    continue;
                }
                if (apTableId.compareTo(tableId) != 0) continue;
                srcApBillIdSet.add(payId);
                apBillIdSet.addAll(srcIdList);
            }
            if (!srcApBillIdSet.isEmpty()) {
                this.doApPaySettleByBotp(srcApBillIdSet, apBillIdSet);
            }
            if (!srcArBillIdSet.isEmpty()) {
                this.doArPaySettleByBotp(srcArBillIdSet, arBillIdSet);
            }
            ArrayList<Long> payBillPKList = new ArrayList<Long>(paymentBillPks);
            for (Long payId : payBillPKList) {
                if (srcApBillIdSet.contains(payId) || srcArBillIdSet.contains(payId)) continue;
                coreBillSettleIdSet.add(payId);
            }
            if (!coreBillSettleIdSet.isEmpty()) {
                this.doApPaySettleByCoreBill(coreBillSettleIdSet);
            }
        }
        this.doGenJournals(paymentBillPks);
    }

    public void payFail(List<Map<String, Object>> param) {
    }

    @Deprecated
    public void pay(List<Map<String, Object>> param) {
        this.paySuccess(param);
    }

    public void cancelPay(List<Map<String, Object>> payParam) {
        logger.info("cancelPay-begin");
        try (TXHandle tx = TX.required();){
            List<Map<String, Object>> logPayParam = this.getLogPaParam(payParam);
            try {
                ArrayList<Long> paymentBillPks = new ArrayList<Long>(payParam.size());
                for (Map<String, Object> map : payParam) {
                    paymentBillPks.add((Long)map.get("targetpk"));
                }
                if (this.isBatchExecute()) {
                    logger.info("cancelPay-isBatchExecute:true");
                    CasCancelUnSettleServiceHelper.cancelPay(paymentBillPks);
                    JournalService journalService = new JournalService();
                    journalService.deleteJournals("cas_paybill", paymentBillPks.toArray(new Long[0]));
                } else {
                    logger.info("cancelPay-isBatchExecute:false");
                    for (Long paymentBillPk : paymentBillPks) {
                        ArrayList<Long> payBillIds = new ArrayList<Long>(1);
                        payBillIds.add(paymentBillPk);
                        CasCancelUnSettleServiceHelper.cancelPay(payBillIds);
                        JournalService journalService = new JournalService();
                        journalService.deleteJournals("cas_paybill", payBillIds.toArray(new Long[0]));
                    }
                }
                this.invalidLiquidation(paymentBillPks);
                CancelPayFreezeService service = new CancelPayFreezeService();
                service.freeze(new HashSet<Long>(paymentBillPks), true);
                LogUtil.addInvokeLog((String)"cancelPay", (Object[])new Object[]{logPayParam}, null, (boolean)true);
            }
            catch (Throwable e) {
                logger.info("cancelPay-exception:" + e);
                LogUtil.addInvokeErrorLog((String)"cancelPay", (Object[])new Object[]{logPayParam}, (Throwable)e, (boolean)true);
                tx.markRollback();
                throw e;
            }
        }
        logger.info("cancelPay-end");
    }

    @Deprecated
    private void cancelRenote(List<Map<String, Object>> param) {
        try (TXHandle tx = TX.required();){
            try {
                HashSet<Long> payBillPks = new HashSet<Long>(param.size());
                for (Map<String, Object> map : param) {
                    payBillPks.add((Long)map.get("targetpk"));
                }
                PayRecSettleService settleService = new PayRecSettleService();
                QFilter filter = new QFilter("settlerelation", "=", (Object)SettleRelationEnum.PAYRECSETTLE.getValue());
                filter.and("mainbillid", "in", payBillPks);
                filter.and("iswrittenoff", "=", (Object)Boolean.FALSE).and("hadwrittenoff", "=", (Object)Boolean.FALSE);
                DynamicObject[] settleRecords = BusinessDataServiceHelper.load((String)"ap_settlerecord", (String)CommonSettleServiceHelper.getSettleRecordSelector(), (QFilter[])filter.toArray());
                ArrayList<DynamicObject> deleteRecords = new ArrayList<DynamicObject>(settleRecords.length);
                ArrayList<DynamicObject> redRecords = new ArrayList<DynamicObject>(settleRecords.length);
                HashMap<Long, Date> currentDateMap = new HashMap<Long, Date>();
                boolean redAllSettleRecord = CommonSettleServiceHelper.isRedAllSettleRecord();
                if (redAllSettleRecord) {
                    Collections.addAll(redRecords, settleRecords);
                } else {
                    for (DynamicObject result2 : settleRecords) {
                        Object currentDate;
                        DynamicObjectCollection entrys = result2.getDynamicObjectCollection("entry");
                        long orgId = result2.getLong("org.id");
                        Date date = (Date)currentDateMap.get(orgId);
                        if (date != null) {
                            currentDate = date;
                        } else {
                            InitHelper init = new InitHelper(orgId, "ap_init");
                            currentDate = init.getCurrentDate() != null ? init.getCurrentDate() : init.getStartDate();
                            currentDateMap.put(orgId, (Date)currentDate);
                        }
                        if (result2.getBoolean("isvoucher") || DateUtils.getDiffDays((Date)result2.getDate("settledate"), (Date)currentDate) > 0) {
                            redRecords.add(result2);
                            continue;
                        }
                        deleteRecords.add(result2);
                    }
                }
                if (deleteRecords.size() > 0) {
                    UnSettleParam unSettleParam = new UnSettleParam();
                    unSettleParam.setUnSettleByReturn(true);
                    settleService.unSettle(deleteRecords.toArray(new DynamicObject[0]), unSettleParam);
                }
                if (redRecords.size() > 0) {
                    List resultIds = redRecords.stream().map(result -> result.getLong("id")).collect(Collectors.toList());
                    String apSettleRecordRedRuleId = "733772355079280640";
                    List redSettleRecords = BOTPHelper.push((String)"ap_settlerecord", (String)"ap_settlerecord", (String)apSettleRecordRedRuleId, resultIds, (String)ResManager.loadKDString((String)"\u7ed3\u7b97\u8bb0\u5f55\u7ea2\u51b2\u5931\u8d25\u3002", (String)"PayBillListener_0", (String)"fi-ap-mservice", (Object[])new Object[0]));
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("mutex_writeback", "false");
                    OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"ap_settlerecord", (DynamicObject[])redSettleRecords.toArray(new DynamicObject[0]), (OperateOption)option);
                    OperationHelper.assertResult((OperationResult)saveResult);
                    OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"ap_settlerecord", (Object[])saveResult.getSuccessPkIds().toArray(), (OperateOption)option);
                    OperationHelper.assertResult((OperationResult)submitResult);
                    OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ap_settlerecord", (Object[])submitResult.getSuccessPkIds().toArray(), (OperateOption)option);
                    OperationHelper.assertResult((OperationResult)auditResult);
                    for (DynamicObject record : redRecords) {
                        record.set("hadwrittenoff", (Object)1);
                        DynamicObjectCollection entries = record.getDynamicObjectCollection("entry");
                        for (DynamicObject entry : entries) {
                            entry.set("e_hadwrittenoff", (Object)1);
                        }
                    }
                    DynamicObject[] results = redRecords.toArray(new DynamicObject[0]);
                    SaveServiceHelper.update((DynamicObject[])results);
                    UnSettleParam unSettleParam = new UnSettleParam();
                    unSettleParam.setRedSettleRecord(true);
                    unSettleParam.setUnSettleByReturn(true);
                    settleService.unSettle(redRecords.toArray(new DynamicObject[0]), unSettleParam);
                }
                CancelRefundAndRenoteUnFreezeService service = new CancelRefundAndRenoteUnFreezeService();
                service.freeze(payBillPks, false);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    public List<String> getSelector() {
        ArrayList<String> lst = new ArrayList<String>(50);
        lst.add("billno");
        lst.add("billstatus");
        lst.add("bizdate");
        lst.add("billtype");
        lst.add("paymenttype");
        lst.add("payeetype");
        lst.add("description");
        lst.add("issingle");
        lst.add("org");
        lst.add("payeracctcash");
        lst.add("payeracctbank");
        lst.add("payerbank");
        lst.add("payee");
        lst.add("payeeformid");
        lst.add("payeename");
        lst.add("payeeaccformid");
        lst.add("payeeacctbank");
        lst.add("payeebanknum");
        lst.add("payeebank");
        lst.add("payeebankname");
        lst.add("iscommitbe");
        lst.add("bankpaystatus");
        lst.add("actpayamt");
        lst.add("currency");
        lst.add("payquotation");
        lst.add("exchangerate");
        lst.add("localamt");
        lst.add("settletype");
        lst.add("settletnumber");
        lst.add("fundflowitem");
        lst.add("usage");
        lst.add("expectdealtime");
        lst.add("reccountry");
        lst.add("recprovince");
        lst.add("reccity");
        lst.add("recaccbankname");
        lst.add("recbanknumber");
        lst.add("sourcetype");
        lst.add("sourcebilltype");
        lst.add("sourcebillid");
        lst.add("cashier");
        lst.add("paydate");
        lst.add("bankcheckflag");
        lst.add("entrance");
        lst.add("e_actamt");
        lst.add("e_localamt");
        lst.add("e_fundflowitem");
        lst.add("e_remark");
        lst.add("e_payableAmt");
        lst.add("e_sourcebillentryid");
        lst.add("e_unsettledamt");
        lst.add("e_settledamt");
        lst.add("e_material");
        lst.add("e_expenseitem");
        lst.add("e_corebillno");
        lst.add("e_corebillentryseq");
        lst.add("e_sourcebillid");
        lst.add("settleorg");
        lst.add("e_paymenttype");
        lst.add("basecurrency");
        List keys = SettleExtDataLoader.loadSettleRecordExtListKeys((String)"cas_paybill");
        keys.forEach(v -> lst.add(v.getBillKey()));
        return lst;
    }

    private Set<Long> getPartSettlePKs(Set<Long> paymentBillPks) {
        HashSet<Long> idSet = new HashSet<Long>(paymentBillPks.size());
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getPartSettlePKs", (String)"cas_paybill", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", paymentBillPks), new QFilter("entry.e_paymenttype.ispartpayment", "=", (Object)Boolean.TRUE)}, (String)"");
        for (Row row : dataSet) {
            idSet.add(row.getLong("id"));
        }
        return idSet;
    }

    private void doApPaySettleByCoreBill(Set<Long> coreBillSettleIdSet) {
        Map<Long, Set<Long>> map;
        logger.info("paySuccess-doApPaySettleByCoreBill:" + coreBillSettleIdSet);
        HashSet<Long> settleOrgIds = new HashSet<Long>(2);
        HashSet<String> coreBillNos = new HashSet<String>(2);
        HashSet<String> conBillNos = new HashSet<String>(2);
        DataSet payDataSet = QueryServiceHelper.queryDataSet((String)"getFinApBillIdsByCoreBill-query-paybill", (String)"cas_paybill", (String)"id,entry.settleorg,entry.e_corebillno,entry.conbillnumber,entry.e_corebilltype", (QFilter[])new QFilter[]{new QFilter("id", "in", coreBillSettleIdSet)}, (String)"");
        for (Row row : payDataSet) {
            settleOrgIds.add(row.getLong("entry.settleorg"));
            String eCoreBillNo = row.getString("entry.e_corebillno");
            if (!ObjectUtils.isEmpty((Object)eCoreBillNo)) {
                coreBillNos.add(eCoreBillNo);
            }
            String string = row.getString("entry.e_corebilltype");
            String eConBillNo = row.getString("entry.conbillnumber");
            if (ObjectUtils.isEmpty((Object)eConBillNo)) continue;
            if ("pm_purorderbill".equals(string)) {
                if (!ObjectUtils.isEmpty((Object)eCoreBillNo)) continue;
                conBillNos.add(eConBillNo);
                continue;
            }
            conBillNos.add(eConBillNo);
        }
        if (ObjectUtils.isEmpty(settleOrgIds)) {
            return;
        }
        HashSet<Long> needSettleOrgIds = new HashSet<Long>(2);
        Map ap019Map = SystemParameterHelper.batchGetAppParameter((Boolean)Boolean.FALSE, new ArrayList(settleOrgIds), (String)"ap_019");
        for (Map.Entry entry : ap019Map.entrySet()) {
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            needSettleOrgIds.add((Long)entry.getKey());
        }
        if (ObjectUtils.isEmpty(needSettleOrgIds)) {
            return;
        }
        Map<Long, Set<Long>> apBillIdByCoreSettleMap = SettleServiceHelper.getFinApBillIdsByCoreBill(needSettleOrgIds, coreBillNos);
        if (!apBillIdByCoreSettleMap.isEmpty()) {
            ISettleService iSettleService = ArApServiceAPIFactory.getSettleService((String)ServiceNameEnum.APPAYSETTLE.getValue());
            for (Map.Entry entry : apBillIdByCoreSettleMap.entrySet()) {
                Long orgId = (Long)entry.getKey();
                Set apBillIds = (Set)entry.getValue();
                NoAssignSettleParam settleParam = new NoAssignSettleParam(orgId.longValue(), SettleTypeEnum.AUTO.getValue());
                settleParam.setMainBillIds(apBillIds);
                settleParam.setAsstBillIds(coreBillSettleIdSet);
                settleParam.setOnlyByCoreBill(true);
                settleParam.setLockWait(true);
                iSettleService.settle(settleParam);
            }
        }
        if (!(map = SettleServiceHelper.getFinApBillIdsByConBill(needSettleOrgIds, conBillNos)).isEmpty()) {
            ISettleService settleService = ArApServiceAPIFactory.getSettleService((String)ServiceNameEnum.APPAYSETTLE.getValue());
            for (Map.Entry<Long, Set<Long>> mapEntry : map.entrySet()) {
                Long orgId = mapEntry.getKey();
                Set<Long> apBillIds = mapEntry.getValue();
                NoAssignSettleParam settleParam = new NoAssignSettleParam(orgId.longValue(), SettleTypeEnum.AUTO.getValue());
                settleParam.setMainBillIds(apBillIds);
                settleParam.setAsstBillIds(coreBillSettleIdSet);
                settleParam.setOnlyByConBill(true);
                settleParam.setLockWait(true);
                settleService.settle(settleParam);
            }
        }
    }

    private void doApPaySettleByBotp(Set<Long> srcApBillIdSet, Set<Long> apBillIdSet) {
        if (ObjectUtils.isEmpty(srcApBillIdSet) || ObjectUtils.isEmpty(apBillIdSet)) {
            return;
        }
        Map<Long, Set<Long>> idMap = this.groupByOrg(apBillIdSet, "ap_finapbill");
        ISettleService settleService = ArApServiceAPIFactory.getSettleService((String)ServiceNameEnum.APPAYSETTLE.getValue());
        for (Map.Entry<Long, Set<Long>> mapEntry : idMap.entrySet()) {
            Long orgId = mapEntry.getKey();
            Set<Long> apBillIds = mapEntry.getValue();
            NoAssignSettleParam settleParam = new NoAssignSettleParam(orgId.longValue(), SettleTypeEnum.AUTO.getValue());
            settleParam.setMainBillIds(apBillIds);
            settleParam.setAsstBillIds(srcApBillIdSet);
            settleParam.setOnlyByBotp(true);
            settleParam.setLockWait(true);
            settleService.settle(settleParam);
        }
    }

    private void doArPaySettleByBotp(Set<Long> srcArBillIdSet, Set<Long> arBillIdSet) {
        if (ObjectUtils.isEmpty(srcArBillIdSet) || ObjectUtils.isEmpty(arBillIdSet)) {
            return;
        }
        Map<Long, Set<Long>> idMap = this.groupByOrg(arBillIdSet, "ar_finarbill");
        ISettleService settleService = ArApServiceAPIFactory.getSettleService((String)ServiceNameEnum.ARPAYSETTLE.getValue());
        for (Map.Entry<Long, Set<Long>> mapEntry : idMap.entrySet()) {
            Long orgId = mapEntry.getKey();
            Set<Long> arBillIds = mapEntry.getValue();
            NoAssignSettleParam settleParam = new NoAssignSettleParam(orgId.longValue(), SettleTypeEnum.AUTO.getValue());
            settleParam.setMainBillIds(arBillIds);
            settleParam.setAsstBillIds(srcArBillIdSet);
            settleParam.setOnlyByBotp(true);
            settleParam.setMainOp(false);
            settleParam.setLockWait(true);
            settleService.settle(settleParam);
        }
    }

    private void doGenJournals(Set<Long> paymentBillPks) {
        JournalService journalService = new JournalService();
        String selectors = String.join((CharSequence)",", this.getSelector());
        DynamicObject[] paymentBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)selectors, (QFilter[])new QFilter[]{new QFilter("id", "in", paymentBillPks)});
        journalService.pushAndSaveJournals(paymentBills);
    }

    private Map<Long, Set<Long>> groupByOrg(Set<Long> billIdSet, String billEntity) {
        HashMap<Long, Set<Long>> idMap = new HashMap<Long, Set<Long>>(2);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"groupByOrg", (String)billEntity, (String)"id,org", (QFilter[])new QFilter[]{new QFilter("id", "in", billIdSet)}, (String)"");
        for (Row row : dataSet) {
            Long orgId = row.getLong("org");
            Long id = row.getLong("id");
            HashSet<Long> ids = (HashSet<Long>)idMap.get(orgId);
            if (ids == null) {
                ids = new HashSet<Long>(billIdSet.size());
            }
            ids.add(id);
            idMap.put(orgId, ids);
        }
        return idMap;
    }

    private static List<BFRowLinkUpNode> findSourceNodes(BFRowLinkUpNode node, Long arTableId, Long apTableId, Long id) {
        ArrayList<BFRowLinkUpNode> nodes = new ArrayList<BFRowLinkUpNode>(10);
        Long mainTableId = node.getRowId().getMainTableId();
        if ((mainTableId.compareTo(arTableId) == 0 || mainTableId.compareTo(apTableId) == 0) && node.getRowId().getBillId().compareTo(id) != 0) {
            nodes.add(node);
        } else {
            for (BFRowLinkUpNode sNode : node.getSNodes().values()) {
                nodes.addAll(PayBillListener.findSourceNodes(sNode, arTableId, apTableId, id));
            }
        }
        return nodes;
    }

    private List<Map<String, Object>> getLogPaParam(List<Map<String, Object>> payParam) {
        if (ObjectUtils.isEmpty(payParam)) {
            return new ArrayList<Map<String, Object>>(1);
        }
        ArrayList<Map<String, Object>> logPayParam = new ArrayList<Map<String, Object>>(payParam.size());
        for (Map<String, Object> payParamMap : payParam) {
            HashMap<String, Object> logPayParamMap = new HashMap<String, Object>(8);
            logPayParamMap.put("sourcepk", payParamMap.get("sourcepk"));
            logPayParamMap.put("targetentrypk", payParamMap.get("targetentrypk"));
            logPayParamMap.put("issuccess", payParamMap.get("issuccess"));
            logPayParamMap.put("operate", payParamMap.get("operate"));
            logPayParamMap.put("isfullrefund", payParamMap.get("isfullrefund"));
            logPayParam.add(logPayParamMap);
        }
        return logPayParam;
    }

    private boolean isBatchExecute() {
        String isBatchExecutePayOrRec = StdConfig.get((String)"isBatchExecutePayOrRec");
        return isBatchExecutePayOrRec == null || "true".equals(isBatchExecutePayOrRec);
    }

    private void invalidLiquidation(List<Long> paymentBillPks) {
        OperationResult result;
        QFilter filter = new QFilter("entryentity.sourcebillid", "in", paymentBillPks);
        filter.and(new QFilter("billstatus", "!=", (Object)"D"));
        DynamicObjectCollection liquidationbills = QueryServiceHelper.query((String)"ap_liquidation", (String)"id,billstatus", (QFilter[])new QFilter[]{filter});
        if (liquidationbills.size() == 0) {
            return;
        }
        HashSet<Long> liquidationIds4Audit = new HashSet<Long>(liquidationbills.size());
        HashSet<Long> liquidationIds4submit = new HashSet<Long>(liquidationbills.size());
        for (DynamicObject liquidationbill : liquidationbills) {
            String billstatus = liquidationbill.getString("billstatus");
            long billId = liquidationbill.getLong("id");
            if ("C".equals(billstatus)) {
                liquidationIds4Audit.add(billId);
            }
            if (!"B".equals(billstatus)) continue;
            liquidationIds4submit.add(billId);
        }
        if (liquidationIds4Audit.size() > 0) {
            result = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_liquidation", (Object[])liquidationIds4Audit.toArray(), (OperateOption)OperateOption.create());
            OperationHelper.assertResult((OperationResult)result);
            liquidationIds4submit.addAll(result.getSuccessPkIds());
        }
        if (liquidationIds4submit.size() > 0) {
            result = OperationServiceHelper.executeOperate((String)"invalid", (String)"ap_liquidation", (Object[])liquidationIds4submit.toArray(), (OperateOption)OperateOption.create());
            OperationHelper.assertResult((OperationResult)result);
        }
    }
}

