/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.service.writeback.bill.DisposerInfo;
import kd.fi.arapcommon.service.writeback.bill.FinApLockWBServiceHelper;
import kd.fi.arapcommon.service.writeback.bill.FinArLockWBServiceHelper;

public class PayBillWriteBackLockAmtService {
    private static final Log logger = LogFactory.getLog(PayBillWriteBackLockAmtService.class);

    public void disposeLockAmt(List<Map<String, Object>> params) {
        logger.info("PayBillWriteBackLockAmtService disposeLockAmt start ");
        if (ObjectUtils.isEmpty(params)) {
            return;
        }
        logger.info("PayBillWriteBackLockAmtService params is : " + params);
        try (TXHandle tx = TX.required((String)"CasPayBillWriteBackPlugin");){
            try {
                Map writeBackFinArMap;
                boolean isChargeBack = this.isChargeBill(params.get(0));
                HashMap<Long, List> srcWriteBackFinApMap = new HashMap<Long, List>(64);
                HashMap<Long, List> srcWriteBackFinArMap = new HashMap<Long, List>(64);
                for (Map<String, Object> param : params) {
                    List disposerInfos;
                    DisposerInfo info;
                    Object entityName = param.get("entityName");
                    long sourceId = Long.parseLong(String.valueOf(param.get("sourceId")));
                    long sourceEntryId = Long.parseLong(String.valueOf(param.get("sourceEntryId")));
                    long tarRowId = Long.parseLong(String.valueOf(param.get("tarRowId")));
                    BigDecimal disposeAmt = this.getNeedWriteBackAmount(param);
                    if ("ap_finapbill".equals(entityName)) {
                        info = new DisposerInfo(Long.valueOf(sourceId), Long.valueOf(sourceEntryId), disposeAmt);
                        disposerInfos = srcWriteBackFinApMap.getOrDefault(tarRowId, new ArrayList(8));
                        disposerInfos.add(info);
                        srcWriteBackFinApMap.put(tarRowId, disposerInfos);
                        continue;
                    }
                    if (!"ar_finarbill".equals(entityName)) continue;
                    info = new DisposerInfo(Long.valueOf(sourceId), Long.valueOf(sourceEntryId), disposeAmt.negate());
                    disposerInfos = srcWriteBackFinArMap.getOrDefault(tarRowId, new ArrayList(8));
                    disposerInfos.add(info);
                    srcWriteBackFinArMap.put(tarRowId, disposerInfos);
                }
                String opType = (String)params.get(0).get("opType");
                boolean isRelease = this.isRelease(opType) || isChargeBack;
                Map writeBackFinApMap = ArApHelper.processWriteBackMap(srcWriteBackFinApMap);
                if (!writeBackFinApMap.isEmpty()) {
                    Set finApBillIds = writeBackFinApMap.values().stream().map(DisposerInfo::getSourceId).collect(Collectors.toSet());
                    CommonSettleServiceHelper.settleAddMutexCtrlInTX(finApBillIds, (String)"ap_finapbill", (boolean)false);
                    if (isRelease) {
                        FinApLockWBServiceHelper.inverseWriteBack(finApBillIds, (Map)writeBackFinApMap);
                    } else {
                        FinApLockWBServiceHelper.directWriteBack(finApBillIds, (Map)writeBackFinApMap);
                    }
                }
                if (!(writeBackFinArMap = ArApHelper.processWriteBackMap(srcWriteBackFinArMap)).isEmpty()) {
                    Set finArBillIds = writeBackFinArMap.values().stream().map(DisposerInfo::getSourceId).collect(Collectors.toSet());
                    CommonSettleServiceHelper.settleAddMutexCtrlInTX(finArBillIds, (String)"ar_finarbill", (boolean)false);
                    if (isRelease) {
                        FinArLockWBServiceHelper.inverseWriteBack(finArBillIds, (Map)writeBackFinArMap);
                    } else {
                        FinArLockWBServiceHelper.directWriteBack(finArBillIds, (Map)writeBackFinArMap);
                    }
                }
            }
            catch (Exception e1) {
                tx.markRollback();
                throw e1;
            }
        }
        logger.info("PayBillWriteBackLockAmtService disposeLockAmt end ");
    }

    private BigDecimal getNeedWriteBackAmount(Map<String, Object> param) {
        String billsStatus;
        BigDecimal disposeAmt = (BigDecimal)param.get("disposeAmt");
        String opType = (String)param.get("opType");
        if (this.isRelease(opType)) {
            disposeAmt = disposeAmt.negate();
        } else if ("save".equalsIgnoreCase(opType) && "G".equals(billsStatus = String.valueOf(param.get("billStatus")))) {
            disposeAmt = disposeAmt.negate();
        }
        return disposeAmt;
    }

    private boolean isChargeBill(Map<String, Object> param) {
        return "save".equalsIgnoreCase(String.valueOf(param.get("opType"))) && "G".equals(String.valueOf(param.get("billStatus")));
    }

    private boolean isRelease(String opType) {
        return "delete".equalsIgnoreCase(opType) || "invalid".equalsIgnoreCase(opType);
    }
}

