/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.fi.ap.mservice.PayRecManualSettleService;
import kd.fi.ap.mservice.PaySelfSettleService;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.service.helper.PayBillHandleHelper;
import kd.fi.arapcommon.vo.ManualSettleParam;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class PaySelfManualSettleService
extends PayRecManualSettleService {
    protected PaySelfSettleService selfService = new PaySelfSettleService();

    @Override
    public void manualSettle(DynamicObject[] mainRows, DynamicObject[] asstRows, ManualSettleParam manualParam) throws KDBizException {
        HashSet<Long> mainBillIdSet = new HashSet<Long>(mainRows.length);
        HashSet<Long> mainEntryIdSet = new HashSet<Long>(mainRows.length);
        HashSet<Long> mainPaidIdSet = new HashSet<Long>(mainRows.length);
        for (DynamicObject dynamicObject : mainRows) {
            String entityName = dynamicObject.getString("billtype");
            if ("cas_paybill".equals(entityName)) {
                mainBillIdSet.add(dynamicObject.getLong("id"));
            } else {
                mainPaidIdSet.add(dynamicObject.getLong("id"));
            }
            mainEntryIdSet.add(dynamicObject.getLong("entryid"));
        }
        HashSet<Long> asstBillIdSet = new HashSet<Long>(asstRows.length);
        HashSet<Long> asstEntryIdSet = new HashSet<Long>(asstRows.length);
        HashSet<Long> asstPaidIdSet = new HashSet<Long>(asstRows.length);
        for (DynamicObject asst : asstRows) {
            String entityName = asst.getString("asst_billtype");
            if ("cas_paybill".equals(entityName)) {
                asstBillIdSet.add(asst.getLong("asst_id"));
            } else {
                asstPaidIdSet.add(asst.getLong("asst_id"));
            }
            asstEntryIdSet.add(asst.getLong("asst_entryid"));
        }
        SettleSchemeVO settleSchemeVO = new SettleSchemeVO();
        settleSchemeVO.setSettle(true);
        settleSchemeVO.setManual(true);
        settleSchemeVO.setDiffCurrencySettle(manualParam.isDiffCurrencySettle());
        settleSchemeVO.setSettleEntryParam(manualParam.getSettleEntryParam());
        settleSchemeVO.setSettleDate(manualParam.getSettleDate());
        Object[] mainArr = this.reloadPayArr(mainBillIdSet);
        Object[] mainPaidArr = this.reloadPaidArr(mainPaidIdSet);
        Object[] asstArr = this.reloadPayArr(asstBillIdSet);
        Object[] asstPaidArr = this.reloadPaidArr(asstPaidIdSet);
        DynamicObject[] mainMergeArr = (DynamicObject[])ArrayUtils.addAll((Object[])mainArr, (Object[])mainPaidArr);
        DynamicObject[] asstMergeArr = (DynamicObject[])ArrayUtils.addAll((Object[])asstArr, (Object[])asstPaidArr);
        this.processMain(mainMergeArr, mainRows, mainEntryIdSet, manualParam);
        this.processAsst(asstMergeArr, asstRows, asstEntryIdSet, manualParam);
        List mainListVO = PayBillHandleHelper.getMainListVO((DynamicObject[])mainMergeArr);
        List asstListVO = PayBillHandleHelper.getAsstListVO((DynamicObject[])asstMergeArr);
        mainListVO = mainListVO.stream().filter(mainVo -> mainVo.getEntryUnSettleAmt().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        asstListVO = asstListVO.stream().filter(asstVo -> asstVo.getEntryUnSettleAmt().compareTo(BigDecimal.ZERO) < 0).collect(Collectors.toList());
        this.selfService.settleByVO(mainListVO, asstListVO, settleSchemeVO, SettleTypeEnum.MANUAL.getValue());
    }

    protected void processAsst(DynamicObject[] asstArr, DynamicObject[] asstRows, Set<Long> asstEntryIdSet, ManualSettleParam param) {
        if (param.isTotal()) {
            for (DynamicObject asst : asstRows) {
                BigDecimal curSettleAmt = asst.getBigDecimal("asst_cursettleamt");
                long id = asst.getLong("asst_id");
                for (DynamicObject asstObj : asstArr) {
                    if (id != asstObj.getLong("id")) continue;
                    asstObj.set("exchangerate", (Object)asst.getBigDecimal("asst_exchangerate"));
                    DynamicObjectCollection entrys = asstObj.getDynamicObjectCollection("entry");
                    for (DynamicObject entry : entrys) {
                        BigDecimal entryUnSettleAmt = entry.getBigDecimal("e_unsettledamt");
                        if (entryUnSettleAmt.compareTo(BigDecimal.ZERO) > 0) continue;
                        if ("cas_paybill".equals(asstObj.getDataEntityType().getName()) && (!param.getOrgPk().equals(entry.get("settleorg.id")) || ObjectUtils.isEmpty((Object)entry.getDynamicObject("e_paymenttype")) || !entry.getDynamicObject("e_paymenttype").getBoolean("ispartpayment"))) {
                            entry.set("e_unsettledamt", (Object)BigDecimal.ZERO);
                            continue;
                        }
                        if (curSettleAmt.abs().compareTo(entryUnSettleAmt.abs()) >= 0) {
                            curSettleAmt = curSettleAmt.subtract(entryUnSettleAmt);
                            continue;
                        }
                        entry.set("e_unsettledamt", (Object)curSettleAmt);
                        curSettleAmt = BigDecimal.ZERO;
                    }
                }
            }
        } else {
            for (DynamicObject asstObj : asstArr) {
                long id = asstObj.getLong("id");
                DynamicObjectCollection entrys = asstObj.getDynamicObjectCollection("entry");
                for (int i = entrys.size() - 1; i >= 0; --i) {
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    long entryId = entry.getLong("id");
                    BigDecimal unSettleAmt = entry.getBigDecimal("e_unsettledamt");
                    if (asstEntryIdSet.contains(entryId)) {
                        for (DynamicObject asst : asstRows) {
                            if (id != asst.getLong("asst_id") || entryId != asst.getLong("asst_entryid")) continue;
                            asstObj.set("exchangerate", (Object)asst.getBigDecimal("asst_exchangerate"));
                            BigDecimal curSettleAmt = asst.getBigDecimal("asst_curSettleAmt");
                            int comparevalue = unSettleAmt.abs().compareTo(curSettleAmt.abs());
                            curSettleAmt = comparevalue >= 0 ? curSettleAmt : unSettleAmt;
                            entry.set("e_unsettledamt", (Object)curSettleAmt);
                        }
                        continue;
                    }
                    entrys.remove(i);
                }
            }
        }
    }
}

