/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.fi.ap.mservice.AbstractPaySettleService;
import kd.fi.ap.mservice.helper.SettleServiceHelper;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.service.helper.PayBillHandleHelper;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.SettleRecordEntryVO;
import kd.fi.arapcommon.vo.SettleRecordVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class PaySelfSettleService
extends AbstractPaySettleService {
    public void autoSettle(DynamicObject[] mains, DynamicObject[] assts) {
        if (ObjectUtils.isEmpty((Object[])mains) || ObjectUtils.isEmpty((Object[])assts)) {
            return;
        }
        SettleSchemeVO scheme = new SettleSchemeVO();
        scheme.setSettle(true);
        this.settle(mains, assts, scheme, SettleTypeEnum.AUTO.getValue());
    }

    @Override
    protected List<BillSettleVO> getMainListVO(DynamicObject[] mains) {
        List<BillSettleVO> mainList = super.getMainListVO(mains);
        for (int i = mainList.size() - 1; i >= 0; --i) {
            BillSettleVO mainVO = mainList.get(i);
            if (mainVO.getEntryUnSettleAmt().compareTo(BigDecimal.ZERO) > 0) continue;
            mainList.remove(mainVO);
        }
        return mainList;
    }

    protected List<BillSettleVO> getAsstListVO(DynamicObject[] assts) {
        List asstList = PayBillHandleHelper.getAsstListVO((DynamicObject[])assts);
        for (int i = asstList.size() - 1; i >= 0; --i) {
            BillSettleVO asstVO = (BillSettleVO)asstList.get(i);
            if (asstVO.getEntryUnSettleAmt().compareTo(BigDecimal.ZERO) < 0) continue;
            asstList.remove(asstVO);
        }
        return asstList;
    }

    @Override
    protected List<SettleRecordVO> doSettle(List<BillSettleVO> mainList, List<BillSettleVO> asstList, SettleSchemeVO scheme, String settleType) {
        scheme.setSettleSelf(true);
        if (scheme.isDiffCurrencySettle()) {
            return SettleServiceHelper.diffCurrencySettle(mainList, asstList, scheme, settleType);
        }
        return SettleServiceHelper.settleSelf(mainList, asstList, scheme, settleType);
    }

    public void disposeAsstBill(List<SettleRecordEntryVO> entryList, SettleSchemeVO scheme) {
        PayBillHandleHelper.disposeByAsstBill(entryList, (SettleSchemeVO)scheme);
    }

    protected String getSettleRelation() {
        return SettleRelationEnum.PAYSELF.getValue();
    }
}

