/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ap.mservice.AbstractApSettleService;
import kd.fi.arapcommon.dev.BeanFactory;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.service.helper.FinApBillHandleHelper;
import kd.fi.arapcommon.service.settle.SettleVersionServiceHelper;
import kd.fi.arapcommon.service.settle.writeback.FinApSettleWriteBacker;
import kd.fi.arapcommon.service.settle.writeback.SettleWriteBackerParam;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.SettleRecordEntryVO;
import kd.fi.arapcommon.vo.SettleRecordVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;
import kd.fi.arapcommon.writeback.settle.PreSettleWBService;

public class PremSettleService
extends AbstractApSettleService {
    @Override
    protected List<BillSettleVO> getMainListVO(DynamicObject[] mains) {
        List<BillSettleVO> mainListVO = super.getMainListVO(mains);
        if (2 == this.scheme.getSettleEntryParam()) {
            for (BillSettleVO vo : mainListVO) {
                block1: for (DynamicObject main : mains) {
                    DynamicObjectCollection planEntrys = main.getDynamicObjectCollection("planentity");
                    for (DynamicObject planEntry : planEntrys) {
                        if (planEntry.getLong("id") != vo.getEntryId()) continue;
                        vo.setEntryUnSettleAmt(planEntry.getBigDecimal("planlockedamt"));
                        continue block1;
                    }
                }
            }
        } else {
            for (BillSettleVO vo : mainListVO) {
                block4: for (DynamicObject main : mains) {
                    DynamicObjectCollection planEntrys = main.getDynamicObjectCollection("detailentry");
                    for (DynamicObject planEntry : planEntrys) {
                        if (planEntry.getLong("id") != vo.getEntryId()) continue;
                        vo.setEntryUnSettleAmt(planEntry.getBigDecimal("lockedamt"));
                        continue block4;
                    }
                }
            }
        }
        return mainListVO;
    }

    protected List<BillSettleVO> getAsstListVO(DynamicObject[] assts) {
        return FinApBillHandleHelper.getAsstListVOForPremAndTransfor((DynamicObject[])assts, (SettleSchemeVO)this.scheme);
    }

    protected String getSettleRelation() {
        return SettleRelationEnum.PREMSETTLE.getValue();
    }

    @Override
    protected void batchDisposeMainBill(List<SettleRecordVO> voList, SettleSchemeVO scheme) {
        Set billIdSet = voList.stream().map(SettleRecordVO::getMainBillId).collect(Collectors.toSet());
        DynamicObject[] apBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"id,org,settleversion", (QFilter[])new QFilter[]{new QFilter("id", "in", billIdSet)});
        HashMap<Long, String> billVersion = new HashMap<Long, String>(8);
        for (DynamicObject apBill : apBills) {
            billVersion.put(apBill.getLong("id"), apBill.getString("settleversion"));
        }
        ArrayList<SettleRecordVO> oldList = new ArrayList<SettleRecordVO>(8);
        ArrayList<SettleRecordVO> newList = new ArrayList<SettleRecordVO>(8);
        boolean allowNewSettleByOrg = SettleVersionServiceHelper.isAllowNewSettleByOrg((long)apBills[0].getLong("org.id"));
        boolean newCustomerUseNewSettle = SettleVersionServiceHelper.isNewCustomerUseNewSettle();
        for (SettleRecordVO vo : voList) {
            long mainBillId = vo.getMainBillId();
            String version = (String)billVersion.get(mainBillId);
            if (newCustomerUseNewSettle) {
                newList.add(vo);
                continue;
            }
            if ("0".equals(version) || "".equals(version)) {
                oldList.add(vo);
                continue;
            }
            if (allowNewSettleByOrg) {
                newList.add(vo);
                continue;
            }
            oldList.add(vo);
        }
        if (oldList.size() > 0) {
            PreSettleWBService preWBService = (PreSettleWBService)BeanFactory.getBean(PreSettleWBService.class, (Object[])new Object[0]);
            preWBService.writeBack(oldList, scheme);
        }
        if (newList.size() > 0) {
            FinApSettleWriteBacker finApSettleWriteBacker = (FinApSettleWriteBacker)BeanFactory.getBean(FinApSettleWriteBacker.class, (Object[])new Object[0]);
            finApSettleWriteBacker.initParam(new SettleWriteBackerParam(scheme, "ap_finapbill"));
            finApSettleWriteBacker.writeBackAsMain(newList);
        }
    }

    public void disposeAsstBill(List<SettleRecordEntryVO> entryList, SettleSchemeVO scheme) {
    }
}

