/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.fi.ap.mservice.helper.RefundAndRenoteServiceHelper;
import kd.fi.ap.vo.PayRefundEntryInfo;
import kd.fi.ap.vo.RefundAndRenoteParam;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.helper.SettleRecordQueryHelper;
import kd.fi.arapcommon.service.helper.PayBillHandleHelper;
import kd.fi.arapcommon.vo.Result;

public class RefundAndRenoteValidateService {
    private static final Log logger = LogFactory.getLog(RefundAndRenoteValidateService.class);

    public Result validate(String paramJson) {
        logger.info("RefundAndRenoteValidateService.validate param:" + paramJson);
        RefundAndRenoteParam param = RefundAndRenoteServiceHelper.confirmConvertParam(paramJson);
        logger.info("RefundAndRenoteValidateService.validate param convert result:" + JSON.toJSONString((Object)param));
        Throwable throwable = null;
        try (TXHandle tx = TX.required((String)"RefundAndRenoteValidate");){
            Set<Long> payIds = param.getPayInfos().stream().map(PayRefundEntryInfo::getPayId).collect(Collectors.toSet());
            Long recId = param.getRecId();
            boolean isExecuteNewLogic = RefundAndRenoteServiceHelper.isExecuteNewLogic();
            if (isExecuteNewLogic) {
                this.validateRecBillIsExistSettleRecord(recId);
                this.validatePayBillRefundAmtIsOverUnSettleAmt(param);
            } else {
                this.validateRecBillIsExistSettleRecord(recId);
                this.validatePayBillIsExistSettleRecord(payIds);
            }
            Result result = Result.success();
            return result;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            tx.markRollback();
            Result result = Result.ex((Throwable)e);
            return result;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    private void validatePayBillRefundAmtIsOverUnSettleAmt(RefundAndRenoteParam param) {
        Set<Long> payIds = param.getPayInfos().stream().map(PayRefundEntryInfo::getPayId).collect(Collectors.toSet());
        List<DynamicObject> settleRecords = this.getSettleRecords(payIds);
        for (DynamicObject settleRecord : settleRecords) {
            long mainCurrency = settleRecord.getLong("maincurrency.id");
            DynamicObjectCollection entries = settleRecord.getDynamicObjectCollection("entry");
            for (DynamicObject dynamicObject : entries) {
                long asstCurrency = dynamicObject.getLong("currency.id");
                if (mainCurrency == asstCurrency) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u5b58\u5728\u5f02\u5e01\u522b\u7684\u5e94\u4ed8\u4ed8\u6b3e/\u5e94\u6536\u9000\u6b3e\u7ed3\u7b97\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u9000\u6b3e/\u9000\u7968\u5904\u7406\u3002", (String)"RefundAndRenoteValidateService_3", (String)"fi-ap-mservice", (Object[])new Object[0]));
            }
        }
        HashMap<Long, BigDecimal> payEntryIdToRefundAmt = new HashMap<Long, BigDecimal>(8);
        List payInfos = param.getPayInfos();
        for (PayRefundEntryInfo payInfo : payInfos) {
            payEntryIdToRefundAmt.put(payInfo.getEntryId(), payInfo.getEntryRefundAmt());
        }
        HashMap<Long, BigDecimal> payEntryIdToUnSettleAmt = new HashMap<Long, BigDecimal>(8);
        QFilter[] payFilter = new QFilter[]{new QFilter("id", "in", payIds)};
        DynamicObject[] payBills = PayBillHandleHelper.loadPay((QFilter[])payFilter);
        for (DynamicObject payBill : payBills) {
            DynamicObjectCollection entries = payBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                payEntryIdToUnSettleAmt.put(entry.getLong("id"), entry.getBigDecimal("e_unsettledamt"));
            }
        }
        for (DynamicObject dynamicObject : settleRecords) {
            DynamicObjectCollection entries = dynamicObject.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                long payEntryId = entry.getLong("billentryid");
                BigDecimal unSettleAmt = (BigDecimal)payEntryIdToUnSettleAmt.get(payEntryId);
                if (unSettleAmt == null) continue;
                BigDecimal recordSettleAmt = entry.getBigDecimal("settleamt");
                payEntryIdToUnSettleAmt.put(payEntryId, unSettleAmt.add(recordSettleAmt));
            }
        }
        for (Map.Entry entry : payEntryIdToRefundAmt.entrySet()) {
            Long payEntryId = (Long)entry.getKey();
            BigDecimal entryRefundAmt = (BigDecimal)entry.getValue();
            BigDecimal entryUnSettleAmt = (BigDecimal)payEntryIdToUnSettleAmt.get(payEntryId);
            if (entryUnSettleAmt == null || entryRefundAmt.abs().compareTo(entryUnSettleAmt.abs()) <= 0) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u53ef\u7ed3\u7b97\u91d1\u989d\u989d\u5ea6\u4e0d\u8db3\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u9000\u6b3e/\u9000\u7968\u5904\u7406\u3002", (String)"RefundAndRenoteValidateService_2", (String)"fi-ap-mservice", (Object[])new Object[0]));
        }
    }

    private void validatePayBillIsExistSettleRecord(Set<Long> payIds) {
        QFilter mainFilter = new QFilter("settlerelation", "in", (Object)new String[]{"payrecsettle", "payself"});
        mainFilter.and("iswrittenoff", "=", (Object)Boolean.FALSE).and("hadwrittenoff", "=", (Object)Boolean.FALSE);
        boolean mainExist = SettleRecordQueryHelper.isExistsSettlesByMain((String)"ap_settlerecord", (String)"cas_paybill", (Object[])payIds.toArray(), (QFilter)mainFilter);
        QFilter asstFilter = new QFilter("settlerelation", "in", (Object)new String[]{"recpaysettle", "payself"});
        asstFilter.and("iswrittenoff", "=", (Object)Boolean.FALSE).and("hadwrittenoff", "=", (Object)Boolean.FALSE);
        boolean asstExist = SettleRecordQueryHelper.isExistsSettlesByAsst((String)"ap_settlerecord", (String)"cas_paybill", (Object[])payIds.toArray(), (QFilter)asstFilter);
        if (mainExist || asstExist) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8fdb\u884c\u8fc7\u4ed8\u6b3e\u51b2\u6536\u6b3e\u3001\u6536\u6b3e\u51b2\u4ed8\u6b3e\u3001\u4ed8\u6b3e\u7ea2\u84dd\u5bf9\u51b2\u7ed3\u7b97\u7684\u4ed8\u6b3e\u5355\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u9000\u6b3e/\u9000\u7968\u5904\u7406\u3002", (String)"RefundAndRenoteValidateService_0", (String)"fi-ap-mservice", (Object[])new Object[0]));
        }
    }

    private void validateRecBillIsExistSettleRecord(Long recId) {
        QFilter mainFilter = new QFilter("iswrittenoff", "=", (Object)Boolean.FALSE);
        mainFilter.and("hadwrittenoff", "=", (Object)Boolean.FALSE);
        boolean mainExist = SettleRecordQueryHelper.isExistsSettlesByMain((String)"ap_settlerecord", (String)"cas_recbill", (Object[])new Object[]{recId}, (QFilter)mainFilter);
        QFilter asstFilter = new QFilter("iswrittenoff", "=", (Object)Boolean.FALSE);
        asstFilter.and("hadwrittenoff", "=", (Object)Boolean.FALSE);
        boolean asstExist = SettleRecordQueryHelper.isExistsSettlesByAsst((String)"ap_settlerecord", (String)"cas_recbill", (Object[])new Object[]{recId}, (QFilter)asstFilter);
        if (mainExist || asstExist) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8fdb\u884c\u8fc7\u7ed3\u7b97\u7684\u6536\u6b3e\u5355\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u9000\u6b3e/\u9000\u7968\u5904\u7406\u3002", (String)"RefundAndRenoteValidateService_1", (String)"fi-ap-mservice", (Object[])new Object[0]));
        }
    }

    private List<DynamicObject> getSettleRecords(Set<Long> payIds) {
        ArrayList<String> settleRelations = new ArrayList<String>(2);
        settleRelations.add(SettleRelationEnum.APPAYSETTLE.getValue());
        settleRelations.add(SettleRelationEnum.ARPAYSETTLE.getValue());
        QFilter filter = new QFilter("settlerelation", "in", settleRelations);
        filter.and("entry.billid", "in", payIds);
        filter.and("iswrittenoff", "=", (Object)Boolean.FALSE).and("hadwrittenoff", "=", (Object)Boolean.FALSE);
        DynamicObject[] settleRecords = SettleRecordQueryHelper.getSettleRecords((String)"ap_settlerecord", (String)"id,org,settletype,settledate,settlerelation,mainbillid,mainbilltype,maincurrency,mainbillentryid,totalsettleamt,localtotalsettleamt,exchangerate,swappl,autosettletype,corebillid,corebillentryid,settleentry,billentity,mainpayableamt,settlerelation,iswrittenoff,hadwrittenoff,entry.billtype,entry.currency,entry.settleamt,entry.e_billentity,entry.billid,entry.billentryid,entry.e_swappl,entry.e_exchangerate,entry.e_settleentry,entry.e_hadwrittenoff,isvoucher,entry.payableamt,entry.localsettleamt,settletype", (String)"cas_paybill", (Object[])payIds.toArray(), (QFilter)filter);
        return Arrays.stream(settleRecords).collect(Collectors.toList());
    }
}

