/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.api.push;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ap.business.fin.PayTransfer;
import kd.fi.ap.consts.Constants;
import kd.fi.ap.mservice.api.push.PushFinApBillServiceImpl;
import kd.fi.arapcommon.api.param.AssignBillPushParam;
import kd.fi.arapcommon.api.param.ServiceNameEnum;
import kd.fi.arapcommon.dev.BeanFactory;
import kd.fi.arapcommon.excecontrol.ExecCtrlHelper;
import kd.fi.arapcommon.helper.ArApTransferHelper;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.PushApSetSupplierFiledHelper;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.service.helper.FinApBillHandleHelper;
import kd.fi.arapcommon.service.writeback.helper.ApTransferWBFinBillServiceHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StdConfig;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.validator.DecimalScopeValidator;

@KSObject
public class FinApTransferServiceImpl
extends PushFinApBillServiceImpl {
    public List<Object> assignBillPush(String sourEntity, List<AssignBillPushParam> paramList) {
        throw new KDBizException("not support");
    }

    public List<Object> assignBillPush(String sourEntity, List<AssignBillPushParam> paramList, String ruleId) {
        throw new KDBizException("not support");
    }

    public List<Object> assignBillEntryPush(String sourEntity, String sourEntryEntity, List<AssignBillPushParam> paramList) {
        return this.assignBillEntryPush(sourEntity, sourEntryEntity, paramList, null);
    }

    public List<Object> assignBillEntryPush(String sourEntity, String sourEntryEntity, List<AssignBillPushParam> paramList, String ruleId) {
        this.checkParam(sourEntity, sourEntryEntity, paramList, true);
        return this.transferLogic(sourEntity, sourEntryEntity, paramList, ruleId);
    }

    private List<Object> transferLogic(String sourEntity, String sourEntryEntity, List<AssignBillPushParam> paramList, String ruleId) {
        Throwable throwable = null;
        try (TXHandle txHandle = TX.required();){
            List<DynamicObject> transferBills;
            DynamicObject transferInfo = this.paramCovertDynamicObject(paramList);
            PayTransfer payTransfer = (PayTransfer)BeanFactory.getBean(PayTransfer.class, (Object[])new Object[0]);
            if (StringUtils.isNotEmpty((String)ruleId)) {
                payTransfer.setRuleId(ruleId);
            }
            if ("summary".equals(transferInfo.getString("methodtype"))) {
                DynamicObject transferBill = payTransfer.transferSummly(transferInfo);
                transferBills = Collections.singletonList(transferBill);
            } else {
                transferBills = payTransfer.transferDispersedly(transferInfo);
            }
            this.setHeadFieldByParam(transferBills, paramList);
            PushApSetSupplierFiledHelper.setInvoiceType((DynamicObject[])transferBills.toArray(new DynamicObject[0]), (boolean)true);
            this.setEntryFieldByParam(transferBills, paramList);
            for (DynamicObject dynamicObject : transferBills) {
                this.setHeadDueDate(dynamicObject);
            }
            DecimalScopeValidator decimalScopeValidator = new DecimalScopeValidator();
            for (DynamicObject bill : transferBills) {
                decimalScopeValidator.validate(bill);
            }
            List<Object> list = this.saveTargetBills(sourEntity, sourEntryEntity, paramList, ruleId, transferBills);
            this.dispose(transferInfo, transferBills);
            List<Object> list2 = list;
            return list2;
        }
        catch (Exception ex) {
            try {
                txHandle.markRollback();
                throw new KDBizException(ex.getMessage());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    protected void checkParam(String sourEntity, String sourEntryEntity, List<AssignBillPushParam> paramList, boolean assignEntry) {
        OperationResult result;
        if (ObjectUtils.isEmpty(paramList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8f6c\u5165\u660e\u7ec6\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinApTransferServiceImpl_12", (String)"fi-ap-mservice", (Object[])new Object[0]));
        }
        super.checkParam(sourEntity, sourEntryEntity, paramList, assignEntry);
        Set<Long> srcBillIds = paramList.stream().map(AssignBillPushParam::getSourBillId).collect(Collectors.toSet());
        if (!assignEntry && srcBillIds.size() != paramList.size()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6574\u5355\u8f6c\u4ed8\u65f6\uff0c\u8f93\u5165\u7684\u6e90\u5355id\u4e0d\u53ef\u91cd\u590d\u3002", (String)"FinApTransferServiceImpl_8", (String)"fi-ap-mservice", (Object[])new Object[0]));
        }
        HashSet<String> transferTypes = new HashSet<String>(2);
        for (AssignBillPushParam assignBillPushParam : paramList) {
            String transferType = assignBillPushParam.getTransferType();
            if (StringUtils.isEmpty((String)transferType)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8f6c\u4ed8\u65b9\u5f0f\u3002", (String)"FinApTransferServiceImpl_9", (String)"fi-ap-mservice", (Object[])new Object[0]));
            }
            if (assignEntry && !"summary".equals(transferType) && !"dispersed".equals(transferType)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u8f6c\u4ed8\u65b9\u5f0f\u4e0d\u652f\u6301\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"FinApTransferServiceImpl_10", (String)"fi-ap-mservice", (Object[])new Object[0]));
            }
            transferTypes.add(transferType);
        }
        if (assignEntry && transferTypes.size() != 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6309\u884c\u8f6c\u4ed8\u8c03\u7528\u65f6\u53ea\u652f\u6301\u6c47\u603b\u8f6c\u5165\u6216\u5206\u6563\u8f6c\u5165\uff0c\u4e0d\u652f\u6301\u6df7\u5408\u8c03\u7528\u3002", (String)"FinApTransferServiceImpl_11", (String)"fi-ap-mservice", (Object[])new Object[0]));
        }
        if (assignEntry) {
            result = OperationServiceHelper.executeOperate((String)"transpay", (String)sourEntity, (Object[])srcBillIds.toArray(new Long[0]), (OperateOption)OperateOption.create());
            OperationHelper.assertResult((OperationResult)result);
        } else {
            result = OperationServiceHelper.executeOperate((String)"transferall", (String)sourEntity, (Object[])srcBillIds.toArray(new Long[0]), (OperateOption)OperateOption.create());
            OperationHelper.assertResult((OperationResult)result);
        }
        ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0018", null, (Object[])new Object[]{srcBillIds});
    }

    private DynamicObject paramCovertDynamicObject(List<AssignBillPushParam> paramList) {
        AssignBillPushParam assignBillPushParam;
        Map tarFieldValueMap;
        Set srcApBills = paramList.stream().map(AssignBillPushParam::getSourBillId).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("id", "in", srcApBills);
        qFilter.and(new QFilter("detailentry.unlockamt", "!=", (Object)Constants.ZERO));
        DynamicObject[] finBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)String.join((CharSequence)",", this.getSourceBillSelectors()), (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtils.isEmpty((Object)finBills)) {
            throw new KDBizException("Query source bill data is empty.");
        }
        HashMap<Long, DynamicObject> finEntryMap = new HashMap<Long, DynamicObject>(64);
        HashMap<Long, DynamicObject> finBillMap = new HashMap<Long, DynamicObject>(64);
        for (DynamicObject finApBill : finBills) {
            DynamicObject[] entry = finApBill.getDynamicObjectCollection(this.finApBillModel.ENTRY);
            for (DynamicObject detailRow : entry) {
                finEntryMap.put(detailRow.getLong("id"), detailRow);
            }
            finBillMap.put(finApBill.getLong("id"), finApBill);
        }
        DynamicObject transferInfo = BusinessDataServiceHelper.newDynamicObject((String)"transferpaybill");
        DynamicObject billObj = finBills[0];
        InitHelper init = new InitHelper(billObj.getLong(this.finApBillModel.HEAD_ORG + ".id"), "ap_init");
        transferInfo.set("org", (Object)billObj.getDynamicObject(this.finApBillModel.HEAD_ORG));
        transferInfo.set("transdate", (Object)DateUtils.getDataFormat((Date)new Date(), (boolean)true));
        transferInfo.set("exratedate", (Object)DateUtils.getDataFormat((Date)new Date(), (boolean)true));
        HashSet<Date> dates = new HashSet<Date>(2);
        for (DynamicObject fin : finBills) {
            dates.add(fin.getDate("exratedate"));
            if (dates.size() > 1) break;
        }
        if (dates.size() == 1) {
            transferInfo.set("exratedate", (Object)billObj.getDate("exratedate"));
        }
        HashSet<Long> exratetableIds = new HashSet<Long>(2);
        for (DynamicObject fin : finBills) {
            Long exratetableId = fin.getLong("exratetable.id");
            exratetableIds.add(exratetableId);
            if (exratetableIds.size() > 1) break;
        }
        if (exratetableIds.size() == 1) {
            transferInfo.set("exratetable", (Object)billObj.getDynamicObject("exratetable"));
        } else {
            transferInfo.set("exratetable", (Object)init.getExrateTable());
        }
        Date currentDate = ObjectUtils.isEmpty((Object)init.getCurrentDate()) ? init.getStartDate() : init.getCurrentDate();
        Date bizDate = new Date();
        if (currentDate.after(bizDate)) {
            transferInfo.set("transdate", (Object)currentDate);
        }
        transferInfo.set("transdate", (Object)((tarFieldValueMap = (assignBillPushParam = paramList.get(0)).getTarFieldValueMap()).get(this.finApBillModel.HEAD_BIZDATE) == null ? transferInfo.getDate("transdate") : tarFieldValueMap.get(this.finApBillModel.HEAD_BIZDATE)));
        transferInfo.set("duedate", tarFieldValueMap.get(this.finApBillModel.HEAD_DUEDATE));
        transferInfo.set("fincurrency", (Object)billObj.getDynamicObject("currency"));
        transferInfo.set("basecurrency", (Object)billObj.getDynamicObject("basecurrency"));
        Object exchangeRate = tarFieldValueMap.get(this.finApBillModel.HEAD_EXCHANGERATE);
        if (billObj.getLong("currency.id") == billObj.getLong("basecurrency.id")) {
            transferInfo.set("head_exchangerate", (Object)BigDecimal.ONE);
            transferInfo.set("quotation", (Object)"0");
        } else {
            long srcCurrencyId = transferInfo.getLong("fincurrency.id");
            long destCurrencyId = transferInfo.getLong("basecurrency.id");
            long exrateTableId = transferInfo.getLong("exratetable.id");
            Date exrateDate = transferInfo.getDate("exratedate");
            Map exrateMap = BaseDataHelper.getExchangeRateMap((Long)exrateTableId, (Long)srcCurrencyId, (Long)destCurrencyId, (Date)exrateDate);
            if (exrateMap != null) {
                boolean quoteType = (Boolean)exrateMap.get("quoteType");
                String quotation = quoteType ? "1" : "0";
                transferInfo.set("quotation", (Object)quotation);
                if (EmptyUtils.isNotEmpty(exchangeRate)) {
                    transferInfo.set("head_exchangerate", exchangeRate);
                } else {
                    exchangeRate = exrateMap.get("exchangeRate");
                    if (EmptyUtils.isNotEmpty(exchangeRate)) {
                        transferInfo.set("head_exchangerate", exchangeRate);
                    }
                }
            }
        }
        HashSet<Long> currencySet = new HashSet<Long>(2);
        HashSet<Long> billTypeSet = new HashSet<Long>(2);
        Map extendFieldMap = ArApTransferHelper.getTransferExtendFields((String)"transferpaybill");
        Set headExtendFields = (Set)extendFieldMap.get("head");
        Set materialExtendFields = (Set)extendFieldMap.get("detailentry");
        Set planExtendFields = (Set)extendFieldMap.get("planentity");
        DynamicObjectCollection transferEntry = transferInfo.getDynamicObjectCollection("entry");
        for (AssignBillPushParam pushParam : paramList) {
            Map fieldValueMap = pushParam.getTarFieldValueMap();
            DynamicObject finApBill = (DynamicObject)finBillMap.get(pushParam.getSourBillId());
            DynamicObject detailRow = (DynamicObject)finEntryMap.get(pushParam.getSourBillEntryId());
            if (finApBill == null || detailRow == null) continue;
            DynamicObject addNew = transferEntry.addNew();
            addNew.set("finbillid", (Object)finApBill.getLong("id"));
            addNew.set("finentryid", (Object)detailRow.getLong("id"));
            addNew.set("transqty", (Object)(fieldValueMap.get(this.finApBillModel.E_QUANTITY) == null ? detailRow.getBigDecimal(this.finApBillModel.E_QUANTITY) : fieldValueMap.get(this.finApBillModel.E_QUANTITY)));
            addNew.set("taxrateid", fieldValueMap.get(this.finApBillModel.E_TAXRATEID) == null ? detailRow.getDynamicObject(this.finApBillModel.E_TAXRATEID) : fieldValueMap.get(this.finApBillModel.E_TAXRATEID));
            addNew.set("transamount", (Object)(fieldValueMap.get(this.finApBillModel.E_AMOUNT) == null ? detailRow.getBigDecimal(this.finApBillModel.E_AMOUNT) : fieldValueMap.get(this.finApBillModel.E_AMOUNT)));
            addNew.set("transtax", (Object)(fieldValueMap.get(this.finApBillModel.E_TAX) == null ? detailRow.getBigDecimal(this.finApBillModel.E_TAX) : fieldValueMap.get(this.finApBillModel.E_TAX)));
            addNew.set("transpricetaxtotal", (Object)addNew.getBigDecimal("transamount").add(addNew.getBigDecimal("transtax")));
            addNew.set("e_splitdimensionid", fieldValueMap.get("e_splitdimensionid") == null ? Integer.valueOf(detailRow.getInt("e_splitdimensionid")) : fieldValueMap.get("e_splitdimensionid"));
            currencySet.add(finApBill.getLong(this.finApBillModel.HEAD_CURRENCY + ".id"));
            billTypeSet.add(finApBill.getLong(this.finApBillModel.HEAD_BILLTYPE + ".id"));
            for (String materialExtendField : materialExtendFields) {
                addNew.set(materialExtendField, fieldValueMap.get(materialExtendField));
            }
        }
        if (billTypeSet.size() > 1 || currencySet.size() > 1) {
            transferInfo.set("isdfcurrency", (Object)Boolean.TRUE);
        }
        Map fieldValueMap = paramList.get(0).getTarFieldValueMap();
        transferInfo.set("methodtype", (Object)paramList.get(0).getTransferType());
        transferInfo.set("payeebanknum", fieldValueMap.get(this.finApBillModel.HEAD_PAYEEBANKNUM));
        transferInfo.set("bebank", fieldValueMap.get(this.finApBillModel.HEAD_BEBANK));
        transferInfo.set("asstacttype", fieldValueMap.get(this.finApBillModel.HEAD_ASSTACTTYPE));
        transferInfo.set("asstact", fieldValueMap.get(this.finApBillModel.HEAD_ASSTACT));
        transferInfo.set("payproperty", fieldValueMap.get(this.finApBillModel.HEAD_PAYPROPERTY));
        transferInfo.set("paycond", fieldValueMap.get(this.finApBillModel.HEAD_PAYCOND));
        transferInfo.set("settlementtype", fieldValueMap.get(this.finApBillModel.HEAD_SETTLEMENTTYPE));
        List containsPlanParams = paramList.stream().filter(param -> !ObjectUtils.isEmpty((Object)param.getTarInvEntrys())).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(containsPlanParams)) {
            DynamicObjectCollection transferPlanEntry = transferInfo.getDynamicObjectCollection("planentry");
            for (AssignBillPushParam containsPlanParam : containsPlanParams) {
                List transPlanRows = containsPlanParam.getTarInvEntrys();
                for (Map transPlanRowMap : transPlanRows) {
                    DynamicObject newPlanRow = transferPlanEntry.addNew();
                    newPlanRow.set("p_billno", transPlanRowMap.get("p_billno"));
                    newPlanRow.set("p_billid", transPlanRowMap.get("p_billid"));
                    newPlanRow.set("p_transpricetaxtotal", transPlanRowMap.get("p_transpricetaxtotal"));
                    newPlanRow.set("p_entryid", transPlanRowMap.get("p_entryid"));
                    newPlanRow.set("p_splitdimensionid", transPlanRowMap.get("p_splitdimensionid"));
                    newPlanRow.set("p_payrate", transPlanRowMap.get("p_payrate"));
                    for (String fieldName : planExtendFields) {
                        newPlanRow.set(fieldName, transPlanRowMap.get(fieldName));
                    }
                }
            }
        }
        for (String headExtendField : headExtendFields) {
            transferInfo.set(headExtendField, fieldValueMap.get(headExtendField));
        }
        return this.checkTranInfo(transferInfo, finEntryMap);
    }

    private void setHeadDueDate(DynamicObject finApBill) {
        Date planMaxDuedate = finApBill.getDate("duedate");
        DynamicObjectCollection planEntries = finApBill.getDynamicObjectCollection("planentity");
        for (DynamicObject planEntry : planEntries) {
            Date planEntryDueDate = planEntry.getDate("planduedate");
            if (planMaxDuedate == null) {
                planMaxDuedate = planEntryDueDate;
                continue;
            }
            if (planEntryDueDate == null) continue;
            planMaxDuedate = planEntryDueDate.after(planMaxDuedate) ? planEntryDueDate : planMaxDuedate;
        }
        finApBill.set("duedate", (Object)planMaxDuedate);
    }

    private DynamicObject checkTranInfo(DynamicObject transferInfo, Map<Long, DynamicObject> finEntryMap) {
        if (EmptyUtils.isEmpty((Object)transferInfo.getBigDecimal("head_exchangerate"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u8be5\u7ed3\u7b97\u5e01\u7684\u201c\u6c47\u7387\u201d\u3002", (String)"FinApTransferServiceImpl_0", (String)"fi-ap-mservice", (Object[])new Object[0]));
        }
        if ("summary".equals(transferInfo.getString("methodtype")) && transferInfo.getBoolean("isdfcurrency")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6c47\u603b\u8f6c\u4ed8\u5fc5\u987b\u5e01\u79cd\u4e00\u81f4,\u5355\u636e\u7c7b\u578b\u4e00\u81f4\u3002", (String)"FinApTransferServiceImpl_7", (String)"fi-ap-mservice", (Object[])new Object[0]));
        }
        DecimalScopeValidator decimalScopeValidator = new DecimalScopeValidator();
        decimalScopeValidator.validate(transferInfo);
        return transferInfo;
    }

    private void dispose(DynamicObject transferInfo, List<DynamicObject> transferBills) {
        DynamicObjectCollection transferDetailEntry = transferInfo.getDynamicObjectCollection("entry");
        Set sourceBillIds = transferDetailEntry.stream().map(row -> row.getLong("finbillid")).collect(Collectors.toSet());
        CommonSettleServiceHelper.settleAddMutexCtrlInTX(sourceBillIds, (String)"ap_finapbill", (boolean)false);
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", sourceBillIds)};
        String selectors = String.join((CharSequence)",", FinApBillHandleHelper.getLockWBSelector());
        DynamicObject[] sourceBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)selectors, (QFilter[])filters);
        this.validateSrcLockedAmtOver(sourceBills, transferBills);
        ApTransferWBFinBillServiceHelper.directWriteBack((DynamicObject[])sourceBills, transferBills);
    }

    /*
     * WARNING - void declaration
     */
    private void validateSrcLockedAmtOver(DynamicObject[] sourceBills, List<DynamicObject> transferBills) {
        void var6_8;
        HashMap<Long, BigDecimal> srcEntryIdToUnLockAmt = new HashMap<Long, BigDecimal>(sourceBills.length);
        DynamicObject[] dynamicObjectArray = sourceBills;
        int n = dynamicObjectArray.length;
        boolean bl = false;
        while (var6_8 < n) {
            DynamicObject sourceBill = dynamicObjectArray[var6_8];
            DynamicObjectCollection detailEntries = sourceBill.getDynamicObjectCollection("detailentry");
            Iterator iterator = detailEntries.iterator();
            while (iterator.hasNext()) {
                DynamicObject detailEntry = (DynamicObject)iterator.next();
                srcEntryIdToUnLockAmt.put(detailEntry.getLong("id"), detailEntry.getBigDecimal("unlockamt"));
            }
            ++var6_8;
        }
        HashMap<Long, BigDecimal> transferSrcEntryIdToNeedWBAmt = new HashMap<Long, BigDecimal>(transferBills.size());
        for (DynamicObject dynamicObject : transferBills) {
            DynamicObjectCollection detailEntries = dynamicObject.getDynamicObjectCollection("detailentry");
            for (DynamicObject detailEntry : detailEntries) {
                long srcEntryId = detailEntry.getLong("e_sourcebillentryid");
                BigDecimal detailEntryPriceTaxTotal = detailEntry.getBigDecimal("e_pricetaxtotal");
                transferSrcEntryIdToNeedWBAmt.merge(srcEntryId, detailEntryPriceTaxTotal, BigDecimal::add);
            }
        }
        for (Map.Entry entry : transferSrcEntryIdToNeedWBAmt.entrySet()) {
            Long srcEntryId = (Long)entry.getKey();
            BigDecimal needWBAmt = (BigDecimal)entry.getValue();
            BigDecimal unLockAmt = (BigDecimal)srcEntryIdToUnLockAmt.get(srcEntryId);
            if (unLockAmt == null || needWBAmt.abs().compareTo(unLockAmt.abs()) <= 0) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u8f6c\u4ed8\u5355\u7684\u5e94\u4ed8\u91d1\u989d\u8d85\u8fc7\u4e86\u6e90\u5355\u7684\u672a\u9501\u5b9a\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinApTransferServiceImpl_13", (String)"fi-ap-mservice", (Object[])new Object[0]));
        }
    }

    protected List<Object> saveTargetBills(String sourEntity, String sourEntryEntity, List<AssignBillPushParam> paramList, String ruleId, List<DynamicObject> targetBills) {
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)this.getTargetEntity(), (DynamicObject[])targetBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)saveResult);
        List successPkIds = saveResult.getSuccessPkIds();
        if (!"true".equals(StdConfig.get((String)"isTransferasSaved")) && !ObjectUtils.isEmpty((Object)successPkIds)) {
            OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)this.getTargetEntity(), (Object[])successPkIds.toArray(new Object[0]), (OperateOption)OperateOption.create());
            OperationHelper.assertResult((OperationResult)submitResult);
            return submitResult.getSuccessPkIds();
        }
        return saveResult.getSuccessPkIds();
    }

    protected List<String> canModifyFields() {
        List fields = super.canModifyFields();
        fields.add(this.finApBillModel.HEAD_ASSTACT);
        fields.add(this.finApBillModel.HEAD_PAYEEBANKNUM);
        fields.add(this.finApBillModel.HEAD_BEBANK);
        fields.add(this.finApBillModel.HEAD_PAYPROPERTY);
        fields.add(this.finApBillModel.E_AMOUNT);
        fields.add(this.finApBillModel.E_TAX);
        fields.add(this.finApBillModel.HEAD_REMARK);
        fields.add(this.finApBillModel.E_TAXRATEID);
        fields.add(this.billModel.HEAD_PURDEPT);
        fields.add(this.billModel.HEAD_PURCHASER);
        fields.add(this.billModel.HEAD_PURORG);
        fields.add(this.billModel.HEAD_PAYCOND);
        fields.add(this.billModel.HEAD_SETTLEMENTTYPE);
        fields.add(this.billModel.P_PLANSETTLETYPE);
        Map extendFieldMap = ArApTransferHelper.getTransferExtendFields((String)"transferpaybill");
        fields.addAll((Collection)extendFieldMap.get("head"));
        fields.addAll((Collection)extendFieldMap.get("detailentry"));
        return fields;
    }

    @Override
    protected String getTargetEntity() {
        return "ap_finapbill";
    }

    private List<String> getSourceBillSelectors() {
        ArrayList<String> selectors = new ArrayList<String>(32);
        selectors.add(this.finApBillModel.HEAD_BILLNO);
        selectors.add(this.finApBillModel.HEAD_ORG);
        selectors.add(this.finApBillModel.HEAD_ASSTACT);
        selectors.add(this.finApBillModel.HEAD_ASSTACTTYPE);
        selectors.add(this.finApBillModel.HEAD_CURRENCY);
        selectors.add(this.finApBillModel.HEAD_BASECURRENCY);
        selectors.add(this.finApBillModel.HEAD_EXRATETABLE);
        selectors.add(this.finApBillModel.HEAD_EXRATEDATE);
        selectors.add(this.finApBillModel.HEAD_BILLTYPE);
        selectors.add(this.finApBillModel.HEAD_EXCHANGERATE);
        selectors.add(this.finApBillModel.E_SPECTYPE);
        selectors.add(this.finApBillModel.E_MATERIAL);
        selectors.add(this.finApBillModel.E_ASSISTANTATTR);
        selectors.add(this.finApBillModel.E_EXPENSEITEM);
        selectors.add(this.finApBillModel.E_QUANTITY);
        selectors.add(this.finApBillModel.E_UNLOCKAMT);
        selectors.add(this.finApBillModel.E_LOCKEDAMT);
        selectors.add(this.finApBillModel.P_PLANLOCKEDAMT);
        selectors.add(this.finApBillModel.P_UNPLANLOCKAMT);
        selectors.add(this.finApBillModel.HEAD_PRICETAXTOTAL);
        selectors.add(this.finApBillModel.HEAD_PREMIUMAMT);
        selectors.add(this.finApBillModel.HEAD_BIZDATE);
        selectors.add(this.finApBillModel.HEAD_DUEDATE);
        selectors.add(this.finApBillModel.E_MEASUREUNIT);
        selectors.add(this.finApBillModel.E_TAXRATE);
        selectors.add(this.finApBillModel.E_TAXRATEID);
        selectors.add(this.finApBillModel.HEAD_QUOTATION);
        selectors.add(this.finApBillModel.E_AMOUNT);
        selectors.add(this.finApBillModel.E_SPLITDIMENSION_ID);
        selectors.add(this.finApBillModel.P_SPLITDIMENSION_ID);
        return selectors;
    }

    @Override
    public String getServiceName() {
        return ServiceNameEnum.FINAPTRANSFER.getValue();
    }
}

