/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.api.push;

import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.ext.fi.plugin.ArApConvert.InitConvertHelper;
import kd.bos.script.annotations.KSObject;
import kd.fi.arapcommon.api.param.AssignBillPushParam;
import kd.fi.arapcommon.api.param.BillHeadAmtParam;
import kd.fi.arapcommon.api.param.ServiceNameEnum;
import kd.fi.arapcommon.api.push.AbstractPushBillService;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.model.BusApBillModel;

@KSObject
public class PushBusApBillServiceImpl
extends AbstractPushBillService {
    protected BusApBillModel busApBillModel = new BusApBillModel();

    protected void resetEntryAmtField(PriceLocalCalculator localCalculator, DynamicObject targetBillEntry, List<AssignBillPushParam> paramList) {
        super.resetEntryAmtField(localCalculator, targetBillEntry, paramList);
        targetBillEntry.set(this.busApBillModel.E_UNINVOICEDAMT, (Object)localCalculator.getPricetaxtotal());
        targetBillEntry.set(this.busApBillModel.E_UNINVOICEDLOCAMT, (Object)localCalculator.getPricetaxtotallocal());
        targetBillEntry.set(this.busApBillModel.E_UNWOFFAMT, (Object)localCalculator.getPricetaxtotal());
        targetBillEntry.set(this.busApBillModel.E_UNWOFFLOCAMT, (Object)localCalculator.getPricetaxtotallocal());
        targetBillEntry.set(this.busApBillModel.E_UNWOFFNOTAXAMT, (Object)localCalculator.getAmount());
        targetBillEntry.set(this.busApBillModel.E_UNWOFFNOTAXLOCAMT, (Object)localCalculator.getAmountlocal());
        targetBillEntry.set(this.busApBillModel.E_UNWOFFTAX, (Object)localCalculator.getTax());
        targetBillEntry.set(this.busApBillModel.E_UNWOFFTAXLOCAL, (Object)localCalculator.getTaxlocal());
        targetBillEntry.set(this.busApBillModel.E_UNINVNOTAXAMT, (Object)localCalculator.getAmount());
        targetBillEntry.set(this.busApBillModel.E_UNINVNOTAXLOCALAMT, (Object)localCalculator.getAmountlocal());
    }

    protected void resetHeadAmtField(DynamicObject targetBill, BillHeadAmtParam billHeadAmtParam) {
        super.resetHeadAmtField(targetBill, billHeadAmtParam);
        targetBill.set(this.busApBillModel.HEAD_UNINVOICEDAMT, (Object)billHeadAmtParam.getPriceTaxTotal());
        targetBill.set(this.busApBillModel.HEAD_UNINVOICEDLOCAMT, (Object)billHeadAmtParam.getPriceTaxTotalLocal());
        targetBill.set(this.busApBillModel.HEAD_UNWOFFAMT, (Object)billHeadAmtParam.getPriceTaxTotal());
        targetBill.set(this.busApBillModel.HEAD_UNWOFFLOCAMT, (Object)billHeadAmtParam.getPriceTaxTotalLocal());
        targetBill.set(this.busApBillModel.HEAD_UNWOFFNOTAXAMT, (Object)billHeadAmtParam.getAmount());
        targetBill.set(this.busApBillModel.HEAD_UNWOFFNOTAXLOCAMT, (Object)billHeadAmtParam.getAmountLocal());
        targetBill.set(this.busApBillModel.HEAD_UNWOFFTAX, (Object)billHeadAmtParam.getTaxAmt());
        targetBill.set(this.busApBillModel.HEAD_UNWOFFTAXLOCAL, (Object)billHeadAmtParam.getTaxAmtLocal());
    }

    protected void afterPush(String sourEntity, String sourEntryEntity, List<AssignBillPushParam> paramList, String ruleId, List<DynamicObject> targetBills) {
        super.afterPush(sourEntity, sourEntryEntity, paramList, ruleId, targetBills);
        Optional<AssignBillPushParam> entryPushParamOptional = paramList.stream().filter(entryPushParam -> entryPushParam.getTarFieldValueMap().get(this.billModel.E_QUANTITY) != null).findAny();
        if (entryPushParamOptional.isPresent()) {
            this.reSetEntryQty(targetBills);
        }
    }

    protected String getTargetEntity() {
        return "ap_busbill";
    }

    private void reSetEntryQty(List<DynamicObject> targetBills) {
        for (DynamicObject targetBill : targetBills) {
            DynamicObjectCollection entries = targetBill.getDynamicObjectCollection(this.getTargetEntryEntity());
            for (DynamicObject entry : entries) {
                DynamicObject baseunit = entry.getDynamicObject(this.busApBillModel.E_BASEUNIT);
                BigDecimal quantity = entry.getBigDecimal(this.busApBillModel.E_QUANTITY);
                BigDecimal covertRate = entry.getBigDecimal(this.busApBillModel.E_UNITCOEFFICIENT);
                BigDecimal baseQty = InitConvertHelper.getBaseunitqty((BigDecimal)quantity, (BigDecimal)covertRate, (DynamicObject)baseunit);
                entry.set(this.busApBillModel.E_BASEUNITQTY, (Object)baseQty);
                entry.set(this.busApBillModel.E_UNWOFFQTY, (Object)quantity);
                entry.set(this.busApBillModel.E_UNINVOICEDQTY, (Object)quantity);
            }
        }
    }

    public String getServiceName() {
        return ServiceNameEnum.PUSHBUSAP.getValue();
    }
}

