/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.api.push;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.EntryProp;
import kd.bos.ext.fi.plugin.ArApConvert.InitConvertHelper;
import kd.bos.script.annotations.KSObject;
import kd.fi.ap.enums.InvoiceSrcTypeEnum;
import kd.fi.ap.piaozone.InvoiceHelper;
import kd.fi.arapcommon.api.param.AssignBillPushParam;
import kd.fi.arapcommon.api.param.BillHeadAmtParam;
import kd.fi.arapcommon.api.param.CalculatorParam;
import kd.fi.arapcommon.api.param.ServiceNameEnum;
import kd.fi.arapcommon.api.push.AbstractPushBillService;
import kd.fi.arapcommon.business.piaozone.info.InvoiceItemVO;
import kd.fi.arapcommon.business.piaozone.info.InvoiceVO;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.enums.InvoiceType;
import kd.fi.arapcommon.helper.InvoiceTypeHelper;
import kd.fi.arapcommon.invcloud.CallCloudHelper;
import kd.fi.arapcommon.model.FinApBillModel;
import kd.fi.arapcommon.service.plan.split.PlanSplitAndBuilder;
import kd.fi.arapcommon.util.StringUtils;

@KSObject
public class PushFinApBillServiceImpl
extends AbstractPushBillService {
    protected FinApBillModel finApBillModel = new FinApBillModel();

    protected CalculatorParam genCalculatorParam(DynamicObject targetBill, DynamicObject targetBillEntry) {
        CalculatorParam calculatorParam = super.genCalculatorParam(targetBill, targetBillEntry);
        calculatorParam.setAdjustAmt(targetBillEntry.getBigDecimal(this.finApBillModel.E_ADJUSTAMOUNT));
        return calculatorParam;
    }

    protected void resetEntryAmtField(PriceLocalCalculator localCalculator, DynamicObject targetBillEntry, List<AssignBillPushParam> paramList) {
        super.resetEntryAmtField(localCalculator, targetBillEntry, paramList);
        targetBillEntry.set(this.finApBillModel.E_ADJUSTAMOUNT, (Object)localCalculator.getAdjustamt());
        targetBillEntry.set(this.finApBillModel.E_ADJUSTLOCALAMT, (Object)localCalculator.getAdjustamtlocal());
        targetBillEntry.set(this.finApBillModel.E_UNVERIFYAMT, (Object)localCalculator.getAmount());
        targetBillEntry.set(this.finApBillModel.E_UNINVOICEDAMT, (Object)localCalculator.getPricetaxtotal());
        targetBillEntry.set(this.finApBillModel.E_UNLOCKAMT, (Object)localCalculator.getPricetaxtotal());
        targetBillEntry.set(this.finApBillModel.E_UNSETTLEAMT, (Object)localCalculator.getPricetaxtotal());
        targetBillEntry.set(this.finApBillModel.E_UNSETTLELOCALAMT, (Object)localCalculator.getPricetaxtotallocal());
    }

    protected void resetHeadAmtField(DynamicObject targetBill, BillHeadAmtParam billHeadAmtParam) {
        super.resetHeadAmtField(targetBill, billHeadAmtParam);
        targetBill.set(this.finApBillModel.HEAD_ADJUSTAMOUNT, (Object)billHeadAmtParam.getAdjustAmt());
        targetBill.set(this.finApBillModel.HEAD_ADJUSTLOCALAMT, (Object)billHeadAmtParam.getAdjustAmtLocal());
        targetBill.set(this.finApBillModel.HEAD_UNVERIFYAMOUNT, (Object)billHeadAmtParam.getAmount());
        targetBill.set(this.finApBillModel.HEAD_UNINVOICEDAMT, (Object)billHeadAmtParam.getAmount());
        targetBill.set(this.finApBillModel.HEAD_UNSETTLEAMOUNT, (Object)billHeadAmtParam.getPriceTaxTotal());
        targetBill.set(this.finApBillModel.HEAD_UNSETTLELOCALAMT, (Object)billHeadAmtParam.getPriceTaxTotalLocal());
    }

    protected void afterPush(String sourEntity, String sourEntryEntity, List<AssignBillPushParam> paramList, String ruleId, List<DynamicObject> targetBills) {
        Optional<AssignBillPushParam> entryPushParamOptional;
        super.afterPush(sourEntity, sourEntryEntity, paramList, ruleId, targetBills);
        if ("ap_invoice".equals(sourEntity)) {
            this.reSetEntryInvoicedAmt(targetBills);
        }
        if ((entryPushParamOptional = paramList.stream().filter(entryPushParam -> entryPushParam.getTarFieldValueMap().get("quantity") != null).findAny()).isPresent()) {
            this.reSetEntryQty(targetBills);
        }
        this.reSetPlanEntry(targetBills);
        this.setInvoiceEntry(paramList, targetBills);
    }

    protected String getTargetEntity() {
        return "ap_finapbill";
    }

    private void reSetEntryInvoicedAmt(List<DynamicObject> targetBills) {
        for (DynamicObject targetBill : targetBills) {
            DynamicObjectCollection entries = targetBill.getDynamicObjectCollection(this.getTargetEntryEntity());
            for (DynamicObject entry : entries) {
                entry.set(this.finApBillModel.E_UNINVOICEDAMT, (Object)BigDecimal.ZERO);
                entry.set(this.finApBillModel.E_INVOICEDAMT, (Object)entry.getBigDecimal(this.finApBillModel.E_PRICETAXTOTAL));
            }
        }
    }

    private void reSetEntryQty(List<DynamicObject> targetBills) {
        for (DynamicObject targetBill : targetBills) {
            DynamicObjectCollection entries = targetBill.getDynamicObjectCollection(this.getTargetEntryEntity());
            for (DynamicObject entry : entries) {
                DynamicObject baseunit = entry.getDynamicObject(this.finApBillModel.E_BASEUNIT);
                BigDecimal quantity = entry.getBigDecimal(this.finApBillModel.E_QUANTITY);
                BigDecimal covertRate = entry.getBigDecimal(this.finApBillModel.E_UNITCOEFFICIENT);
                BigDecimal baseQty = InitConvertHelper.getBaseunitqty((BigDecimal)quantity, (BigDecimal)covertRate, (DynamicObject)baseunit);
                entry.set(this.finApBillModel.E_BASEUNITQTY, (Object)baseQty);
                entry.set(this.finApBillModel.E_UNVERIFYQTY, (Object)quantity);
            }
        }
    }

    private void reSetPlanEntry(List<DynamicObject> targetBills) {
        PlanSplitAndBuilder.splitAndBuild((DynamicObject[])targetBills.toArray(new DynamicObject[0]));
    }

    private void setInvoiceEntry(List<AssignBillPushParam> paramList, List<DynamicObject> targetBills) {
        List invoiceParamList = paramList.stream().filter(pushParam -> !pushParam.getTarInvEntrys().isEmpty()).collect(Collectors.toList());
        if (ObjectUtils.isEmpty(invoiceParamList)) {
            return;
        }
        Map invoiceTypePKMap = InvoiceTypeHelper.getInvoiceTypePKMap();
        for (DynamicObject targetBill : targetBills) {
            Object targetBillEntry2;
            DynamicObjectCollection targetBillEntries = targetBill.getDynamicObjectCollection(this.getTargetEntryEntity());
            HashSet<Long> srcBillIds = new HashSet<Long>(4);
            for (Object targetBillEntry2 : targetBillEntries) {
                Object sourIdObj = targetBillEntry2.get(this.getTargetSourIdKey());
                srcBillIds.add(Long.parseLong(sourIdObj.toString()));
            }
            HashSet<String> invSerial = new HashSet<String>(8);
            targetBillEntry2 = invoiceParamList.iterator();
            while (targetBillEntry2.hasNext()) {
                AssignBillPushParam pushParam2 = (AssignBillPushParam)targetBillEntry2.next();
                if (!srcBillIds.contains(pushParam2.getSourBillId())) continue;
                List invEntryValues = pushParam2.getTarInvEntrys();
                for (Map invRowValue : invEntryValues) {
                    if (!"invcloud".equals(invRowValue.get("i_srctype"))) continue;
                    invSerial.add((String)invRowValue.get("i_serialno"));
                }
            }
            if (invSerial.isEmpty()) continue;
            DynamicObject org = targetBill.getDynamicObject("org");
            HashMap<Long, String> orgForSerialMap = new HashMap<Long, String>(8);
            orgForSerialMap.put(org.getLong("id"), String.join((CharSequence)",", invSerial));
            List invoiceVOs = CallCloudHelper.queryCloudInvoice(orgForSerialMap);
            if (ObjectUtils.isEmpty((Object)invoiceVOs)) continue;
            EntryProp prop = (EntryProp)EntityMetadataCache.getDataEntityType((String)this.getTargetEntity()).findProperty("inventry");
            DynamicObjectType dt = prop.getDynamicCollectionItemPropertyType();
            for (InvoiceVO invoiceVO : invoiceVOs) {
                Set taxRateSet;
                DynamicObject invoiceEntry = new DynamicObject(dt);
                String invoiceType = invoiceVO.getInvoiceType();
                invoiceEntry.set("i_invoicetype", (Object)InvoiceType.getValue((String)invoiceType));
                invoiceEntry.set("i_invoicetypef7", (Object)invoiceTypePKMap.computeIfAbsent(invoiceType, v -> 0L));
                invoiceEntry.set("i_invoicecode", (Object)invoiceVO.getInvoiceCode());
                invoiceEntry.set("i_invoiceno", (Object)invoiceVO.getInvoiceNo());
                invoiceEntry.set("i_invoicedate", (Object)invoiceVO.getInvoiceDate());
                invoiceEntry.set("i_pricetaxtotal", (Object)invoiceVO.getTotalAmount());
                invoiceEntry.set("i_canuseamt", (Object)invoiceVO.getTotalAmount());
                invoiceEntry.set("i_currency", (Object)1L);
                invoiceEntry.set("i_tax", (Object)invoiceVO.getTaxAmount());
                invoiceEntry.set("i_amount", (Object)invoiceVO.getInvoiceAmount());
                invoiceEntry.set("i_serialno", (Object)invoiceVO.getSerialNo());
                invoiceEntry.set("i_asstactname", (Object)invoiceVO.getSalerName());
                invoiceEntry.set("i_buyername", (Object)invoiceVO.getBuyerName());
                invoiceEntry.set("i_istaxdeduction", (Object)("1".equals(invoiceVO.getCanBeDeduction()) ? Boolean.TRUE : Boolean.FALSE));
                invoiceEntry.set("i_remark", (Object)StringUtils.trim((String)invoiceVO.getRemark()));
                invoiceEntry.set("i_srctype", (Object)InvoiceSrcTypeEnum.SUPPLIERCOORDINATE.getValue());
                invoiceEntry.set("i_issupplement", (Object)"0");
                List items = invoiceVO.getItems();
                if (!ObjectUtils.isEmpty((Object)items) && (taxRateSet = items.stream().map(InvoiceItemVO::getTaxRate).collect(Collectors.toSet())).size() == 1) {
                    BigDecimal taxRate = ((InvoiceItemVO)items.get(0)).getTaxRate();
                    invoiceEntry.set("i_taxrate", (Object)(taxRate == null ? BigDecimal.ZERO : taxRate.multiply(BigDecimal.valueOf(100L))));
                }
                targetBill.getDynamicObjectCollection("inventry").add((Object)invoiceEntry);
            }
        }
        InvoiceHelper.updateFinTaxDeductionLogic((DynamicObject[])targetBills.toArray(new DynamicObject[0]), (boolean)false);
    }

    public String getServiceName() {
        return ServiceNameEnum.PUSHFINAP.getValue();
    }
}

