/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.api.service;

import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.fi.ap.mservice.ApPayAutoSettleService;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.vo.Result;
import kd.fi.arapcommon.vo.SettleParam;
import kd.fi.arapcommon.vo.SettleSchemeVO;

@KSObject
public class ApSettleRecordService {
    @KSMethod
    public Result apPaySettle(SettleParam param) {
        Result checkResult;
        param.setMainEntity("ap_finapbill");
        if (StringUtils.isEmpty((String)param.getAsstEntity())) {
            param.setAsstEntity("cas_paybill");
        }
        if (!StringUtils.isEmpty((String)(checkResult = this.checkBillId(param)).getErrorInfo())) {
            return checkResult;
        }
        Set mainBillIds = param.getMainBillIds();
        Set asstBillIds = param.getAsstBillIds();
        SettleSchemeVO scheme = param.genSchemeVO();
        ApPayAutoSettleService service = new ApPayAutoSettleService();
        try (TXHandle tx = TX.required((String)"apPaySettle");){
            try {
                CommonSettleServiceHelper.settleAddMutexCtrlInTX((Set)asstBillIds, (String)param.getAsstEntity(), (boolean)true);
                service.batchAutoSettle(mainBillIds, param.getAsstEntity(), asstBillIds, scheme);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        return Result.success();
    }

    private Result checkBillId(SettleParam param) {
        Result result = new Result();
        if (param == null) {
            return Result.fail((String)"999", (String)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"ApSettleRecordService_0", (String)"fi-ap-mservice", (Object[])new Object[0]));
        }
        Set mainBillIds = param.getMainBillIds();
        if (mainBillIds.isEmpty()) {
            return Result.fail((String)"999", (String)ResManager.loadKDString((String)"\u4e3b\u65b9\u5355\u636eID\u4e3a\u7a7a\u3002", (String)"ApSettleRecordService_1", (String)"fi-ap-mservice", (Object[])new Object[0]));
        }
        Set asstBillIds = param.getAsstBillIds();
        if (asstBillIds.isEmpty()) {
            return Result.fail((String)"999", (String)ResManager.loadKDString((String)"\u8f85\u65b9\u5355\u636eID\u4e3a\u7a7a\u3002", (String)"ApSettleRecordService_2", (String)"fi-ap-mservice", (Object[])new Object[0]));
        }
        return result;
    }

    private void addCommitListener() {
        TX.addCommitListener((CommitListener)new CommitListener(){

            public void onEnded(boolean rollbacked) {
                CommonSettleServiceHelper.settleReleaseMutexCtrl();
            }
        });
    }
}

