/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.api.settle;

import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.orm.query.QFilter;
import kd.fi.ap.mservice.ApPayAutoSettleService;
import kd.fi.ap.mservice.ApPaySettleService;
import kd.fi.arapcommon.api.param.AssignSettleParam;
import kd.fi.arapcommon.api.param.BaseSettleParam;
import kd.fi.arapcommon.api.param.NoAssignSettleParam;
import kd.fi.arapcommon.api.param.SettleDetailParam;
import kd.fi.arapcommon.api.param.SettleResult;
import kd.fi.arapcommon.api.settle.AbstractSettleService;
import kd.fi.arapcommon.service.AbstractSettleTemplate;
import kd.fi.arapcommon.service.helper.FinApBillHandleHelper;
import kd.fi.arapcommon.service.helper.PayBillHandleHelper;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class ApPaySettleServiceImpl
extends AbstractSettleService {
    protected SettleResult doSettle(NoAssignSettleParam param) {
        if (param.isOnlyByBotp() || param.isOnlyByCoreBill() || param.isOnlyByConBill()) {
            ApPayAutoSettleService settleService = new ApPayAutoSettleService();
            SettleSchemeVO scheme = param.genSchemeVO();
            settleService.batchAutoSettle(param.getMainBillIds(), param.getAsstEntity(), param.getAsstBillIds(), scheme);
            SettleResult result = new SettleResult();
            result.setSettleRecordPKs(scheme.getRecordPks());
            return result;
        }
        return super.doSettle(param);
    }

    protected String getMainEntity() {
        return "ap_finapbill";
    }

    protected String getAsstEntity() {
        return "cas_paybill";
    }

    protected DynamicObject[] getMainBills(BaseSettleParam param, Set<Long> billIds) {
        return FinApBillHandleHelper.load((QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
    }

    protected DynamicObject[] getAsstBills(BaseSettleParam param, Set<Long> billIds) {
        Object[] payBills = PayBillHandleHelper.load((String)param.getAsstEntity(), (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        Object[] paidBills = new DynamicObject[]{};
        if (param.isContainPre()) {
            paidBills = PayBillHandleHelper.load((String)"ap_paidbill", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        }
        return (DynamicObject[])ArrayUtils.addAll((Object[])payBills, (Object[])paidBills);
    }

    protected void processMainBillByDetailParam(AssignSettleParam assignSettleParam, DynamicObject[] bills, List<SettleDetailParam> detailParamList, int settleModel) {
        FinApBillHandleHelper.processBillByDetailParam((AssignSettleParam)assignSettleParam, (DynamicObject[])bills, detailParamList, (int)settleModel);
    }

    protected void processAsstBillByDetailParam(AssignSettleParam assignSettleParam, DynamicObject[] bills, List<SettleDetailParam> detailParamList, int settleModel) {
        PayBillHandleHelper.processBillByDetailParam((AssignSettleParam)assignSettleParam, (DynamicObject[])bills, detailParamList);
    }

    protected List<BillSettleVO> getMainSettleVOList(DynamicObject[] bills, SettleSchemeVO scheme) {
        return FinApBillHandleHelper.getMainListVO((DynamicObject[])bills, (SettleSchemeVO)scheme);
    }

    protected List<BillSettleVO> getAsstSettleVOList(DynamicObject[] bills, SettleSchemeVO scheme) {
        return PayBillHandleHelper.getAsstListVO((DynamicObject[])bills);
    }

    protected AbstractSettleTemplate getService() {
        return new ApPaySettleService();
    }
}

