/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.SettleRecordVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class SettleServiceHelper {
    public static List<Object> saveSettleRecord(DynamicObject[] results) {
        return CommonSettleServiceHelper.saveSettleRecord((DynamicObject[])results, (boolean)false);
    }

    public static List<SettleRecordVO> settle(List<BillSettleVO> mainList, List<BillSettleVO> asstList, SettleSchemeVO scheme, String settleType) {
        return CommonSettleServiceHelper.settle(mainList, asstList, (SettleSchemeVO)scheme, (String)settleType);
    }

    public static List<SettleRecordVO> settleSelf(List<BillSettleVO> mainList, List<BillSettleVO> asstList, SettleSchemeVO scheme, String settleType) {
        return CommonSettleServiceHelper.settleSelf(mainList, asstList, (SettleSchemeVO)scheme, (String)settleType);
    }

    public static List<SettleRecordVO> diffCurrencySettle(List<BillSettleVO> mainList, List<BillSettleVO> asstList, SettleSchemeVO scheme, String settleType) {
        return CommonSettleServiceHelper.diffCurrencySettle(mainList, asstList, (SettleSchemeVO)scheme, (String)settleType);
    }

    public static DynamicObject[] converVO2Dyn(List<SettleRecordVO> resultList) {
        return CommonSettleServiceHelper.converVO2Dyn(resultList, (boolean)false);
    }

    public static SettleRecordVO converDyn2VO(DynamicObject result) {
        return CommonSettleServiceHelper.converDyn2VO((DynamicObject)result);
    }

    public static List<String> getEntityByRelation(String settleRelation) {
        ArrayList<String> list = new ArrayList<String>();
        if (SettleRelationEnum.APPAYSETTLE.getValue().equals(settleRelation)) {
            list.add("ap_finapbill");
            list.add("cas_paybill");
        } else if (SettleRelationEnum.APSELF.getValue().equals(settleRelation)) {
            list.add("ap_finapbill");
            list.add("ap_finapbill");
        } else if (SettleRelationEnum.PAYSELF.getValue().equals(settleRelation)) {
            list.add("cas_paybill");
            list.add("cas_paybill");
        } else if (SettleRelationEnum.APARSETTLE.getValue().equals(settleRelation)) {
            list.add("ap_finapbill");
            list.add("ar_finarbill");
        }
        return list;
    }

    @Deprecated
    public static Set<Long> getPaidBillIdsByCoreBill(DynamicObject[] apBills) {
        HashSet<Long> paidBillIds = new HashSet<Long>(8);
        if (apBills == null || apBills.length == 0) {
            return paidBillIds;
        }
        Map<String, Set<Long>> asstBillIdByModelMap = SettleServiceHelper.getPaidBillIdsByCoreBill(Arrays.asList(apBills), new HashMap<Long, Map<String, Object>>(2));
        for (Map.Entry<String, Set<Long>> entrySet : asstBillIdByModelMap.entrySet()) {
            paidBillIds.addAll((Collection<Long>)entrySet.getValue());
        }
        return paidBillIds;
    }

    public static Map<String, Set<Long>> getPaidBillIdsByCoreBill(List<DynamicObject> apBills, Map<Long, Map<String, Object>> appParametersMap) {
        HashMap<String, Set<Long>> result = new HashMap<String, Set<Long>>(8);
        if (ObjectUtils.isEmpty(apBills)) {
            return result;
        }
        HashSet<String> coreBillNos = new HashSet<String>(8);
        HashSet<String> coreBillSeqs = new HashSet<String>(8);
        HashSet<Long> orgIds = new HashSet<Long>(8);
        for (DynamicObject bill : apBills) {
            orgIds.add(bill.getLong("org.id"));
            DynamicObjectCollection mainEntrys = bill.getDynamicObjectCollection("detailentry");
            for (DynamicObject mainEntry : mainEntrys) {
                String coreBillNo = mainEntry.getString("corebillno");
                String coreBillseq = mainEntry.getString("corebillentryseq");
                if (StringUtils.isEmpty((String)coreBillNo) || StringUtils.isEmpty((String)coreBillseq)) continue;
                coreBillNos.add(coreBillNo);
                coreBillSeqs.add(coreBillseq);
            }
        }
        if (coreBillNos.size() > 0 && coreBillSeqs.size() > 0) {
            QFilter[] paidFilter = new QFilter[]{new QFilter("billstatus", "=", (Object)"C"), new QFilter("paymenttype.ispartpayment", "=", (Object)Character.valueOf('1')), new QFilter("entry.e_corebillno", "in", coreBillNos), new QFilter("org", "in", orgIds), new QFilter("entry.e_unsettledamt", "<>", (Object)0)};
            DataSet apPaidDataSet = QueryServiceHelper.queryDataSet((String)"query_paid_bill", (String)"ap_paidbill", (String)"id,org", (QFilter[])paidFilter, (String)"bizdate");
            SettleServiceHelper.splitResultBySettleModel(result, appParametersMap, apPaidDataSet, "org");
        }
        return result;
    }

    @Deprecated
    public static Set<Long> getPayBillIdsByCoreBill(DynamicObject[] apBills) {
        HashSet<Long> payBillIds = new HashSet<Long>(8);
        if (apBills == null || apBills.length == 0) {
            return payBillIds;
        }
        Map<String, Set<Long>> asstBillIdByModelMap = SettleServiceHelper.getPayBillIdsByCoreBill(Arrays.asList(apBills), new HashMap<Long, Map<String, Object>>(2));
        for (Map.Entry<String, Set<Long>> entrySet : asstBillIdByModelMap.entrySet()) {
            payBillIds.addAll((Collection<Long>)entrySet.getValue());
        }
        return payBillIds;
    }

    public static Map<String, Set<Long>> getPayBillIdsByCoreBill(List<DynamicObject> apBills, Map<Long, Map<String, Object>> appParametersMap) {
        HashMap<String, Set<Long>> result = new HashMap<String, Set<Long>>(8);
        if (ObjectUtils.isEmpty(apBills)) {
            return result;
        }
        HashSet<String> coreBillNos = new HashSet<String>(8);
        HashSet<String> coreBillSeqs = new HashSet<String>(8);
        HashSet<Long> orgIds = new HashSet<Long>(8);
        for (DynamicObject bill : apBills) {
            orgIds.add(bill.getLong("org.id"));
            DynamicObjectCollection mainEntrys = bill.getDynamicObjectCollection("detailentry");
            for (DynamicObject mainEntry : mainEntrys) {
                String coreBillNo = mainEntry.getString("corebillno");
                String coreBillseq = mainEntry.getString("corebillentryseq");
                if (StringUtils.isEmpty((String)coreBillNo) || StringUtils.isEmpty((String)coreBillseq)) continue;
                coreBillNos.add(coreBillNo);
                coreBillSeqs.add(coreBillseq);
            }
        }
        if (coreBillNos.size() > 0 && coreBillSeqs.size() > 0) {
            QFilter[] payFilter = new QFilter[]{new QFilter("billstatus", "in", (Object)new String[]{"D", "F", "I"}), new QFilter("paymenttype.ispartpayment", "=", (Object)Character.valueOf('1')), new QFilter("entry.e_corebillno", "in", coreBillNos), new QFilter("entry.settleorg", "in", orgIds), new QFilter("entry.e_unsettledamt", "<>", (Object)0)};
            DataSet apPayDataSet = QueryServiceHelper.queryDataSet((String)"query_pay_bill", (String)"cas_paybill", (String)"id,entry.settleorg", (QFilter[])payFilter, (String)"bizdate");
            SettleServiceHelper.splitResultBySettleModel(result, appParametersMap, apPayDataSet, "entry.settleorg");
        }
        return result;
    }

    public static Map<String, Set<Long>> getPayBillIdsByConBill(List<DynamicObject> apBills, Map<Long, Map<String, Object>> appParametersMap) {
        HashMap<String, Set<Long>> result = new HashMap<String, Set<Long>>(8);
        if (ObjectUtils.isEmpty(apBills)) {
            return result;
        }
        HashSet<String> conBillNos = new HashSet<String>(8);
        HashSet<Long> orgIds = new HashSet<Long>(8);
        for (DynamicObject bill : apBills) {
            orgIds.add(bill.getLong("org.id"));
            DynamicObjectCollection mainEntrys = bill.getDynamicObjectCollection("detailentry");
            for (DynamicObject mainEntry : mainEntrys) {
                String conBillNo = mainEntry.getString("e_conbillnumber");
                if (StringUtils.isEmpty((String)conBillNo)) continue;
                conBillNos.add(conBillNo);
            }
        }
        if (conBillNos.size() > 0) {
            QFilter[] payFilter = new QFilter[]{new QFilter("billstatus", "in", (Object)new String[]{"D", "F", "I"}), new QFilter("paymenttype.ispartpayment", "=", (Object)Character.valueOf('1')), new QFilter("entry.conbillnumber", "in", conBillNos), new QFilter("entry.settleorg", "in", orgIds), new QFilter("entry.e_unsettledamt", "<>", (Object)0)};
            DataSet apPayDataSet = QueryServiceHelper.queryDataSet((String)"query_pay_bill", (String)"cas_paybill", (String)"id,entry.settleorg,entry.e_corebilltype,entry.e_corebillno", (QFilter[])payFilter, (String)"bizdate");
            for (Row apPay : apPayDataSet) {
                Long billId = apPay.getLong("id");
                String coreBillType = apPay.getString("entry.e_corebilltype");
                String coreBillNo = apPay.getString("entry.e_corebillno");
                if ("pm_purorderbill".equals(coreBillType) && !StringUtils.isEmpty((String)coreBillNo)) continue;
                Map<String, Object> orgParametersMap = appParametersMap.get(apPay.getLong("entry.settleorg"));
                String settleModel = "1";
                if (!ObjectUtils.isEmpty(orgParametersMap)) {
                    settleModel = (String)orgParametersMap.get("ap_003");
                }
                Set asstBillIds = result.getOrDefault(settleModel, new HashSet(64));
                asstBillIds.add(billId);
                result.put(settleModel, asstBillIds);
            }
        }
        return result;
    }

    private static void splitResultBySettleModel(Map<String, Set<Long>> result, Map<Long, Map<String, Object>> appParametersMap, DataSet dataSet, String orgKey) {
        for (Row apPay : dataSet) {
            Long billId = apPay.getLong("id");
            Map<String, Object> orgParametersMap = appParametersMap.get(apPay.getLong(orgKey));
            String settleModel = "1";
            if (!ObjectUtils.isEmpty(orgParametersMap)) {
                settleModel = (String)orgParametersMap.get("ap_003");
            }
            Set asstBillIds = result.getOrDefault(settleModel, new HashSet(64));
            asstBillIds.add(billId);
            result.put(settleModel, asstBillIds);
        }
    }

    @Deprecated
    public static Set<Long> getFinApBillIdsByCoreBill(Set<Long> payBillIds) {
        if (ObjectUtils.isEmpty(payBillIds)) {
            return new HashSet<Long>(2);
        }
        HashSet<Long> apBillIds = new HashSet<Long>(payBillIds.size());
        HashSet<Long> settleOrgIds = new HashSet<Long>(2);
        HashSet<String> coreBillNos = new HashSet<String>(2);
        DataSet payDataSet = QueryServiceHelper.queryDataSet((String)"getFinApBillIdsByCoreBill-query-paybill", (String)"cas_paybill", (String)"id,entry.settleorg,entry.e_corebillno", (QFilter[])new QFilter[]{new QFilter("id", "in", payBillIds)}, (String)"");
        for (Row row : payDataSet) {
            settleOrgIds.add(row.getLong("entry.settleorg"));
            String eCoreBillNo = row.getString("entry.e_corebillno");
            if (ObjectUtils.isEmpty((Object)eCoreBillNo)) continue;
            coreBillNos.add(eCoreBillNo);
        }
        if (!coreBillNos.isEmpty()) {
            QFilter filter = new QFilter("billstatus", "=", (Object)"C");
            filter.and(new QFilter("detailentry.corebillno", "in", coreBillNos));
            filter.and(new QFilter("detailentry.unsettleamt", "<>", (Object)0));
            if (settleOrgIds.size() > 0) {
                filter.and(new QFilter("org", "in", settleOrgIds));
            }
            DataSet apDataSet = QueryServiceHelper.queryDataSet((String)"getFinApBillIdsByCoreBill-query-apbill", (String)"ap_finapbill", (String)"id", (QFilter[])new QFilter[]{filter}, (String)"");
            for (Row row : apDataSet) {
                apBillIds.add(row.getLong("id"));
            }
        }
        return apBillIds;
    }

    public static Map<Long, Set<Long>> getFinApBillIdsByCoreBill(Set<Long> settleOrgIds, Set<String> coreBillNos) {
        HashMap<Long, Set<Long>> idMap = new HashMap<Long, Set<Long>>(2);
        if (!coreBillNos.isEmpty()) {
            QFilter filter = new QFilter("billstatus", "=", (Object)"C");
            filter.and(new QFilter("detailentry.corebillno", "in", coreBillNos));
            filter.and(new QFilter("detailentry.unsettleamt", "<>", (Object)0));
            if (settleOrgIds.size() > 0) {
                filter.and(new QFilter("org", "in", settleOrgIds));
            }
            DataSet apDataSet = QueryServiceHelper.queryDataSet((String)"getFinApBillIdsByCoreBill-query-apbill", (String)"ap_finapbill", (String)"id,org", (QFilter[])new QFilter[]{filter}, (String)"");
            for (Row row : apDataSet) {
                Long orgId = row.getLong("org");
                Long id = row.getLong("id");
                HashSet<Long> ids = (HashSet<Long>)idMap.get(orgId);
                if (ids == null) {
                    ids = new HashSet<Long>(2);
                }
                ids.add(id);
                idMap.put(orgId, ids);
            }
        }
        return idMap;
    }

    public static Map<Long, Set<Long>> getFinApBillIdsByConBill(Set<Long> settleOrgIds, Set<String> conBillNos) {
        HashMap<Long, Set<Long>> idMap = new HashMap<Long, Set<Long>>(2);
        if (!conBillNos.isEmpty()) {
            QFilter filter = new QFilter("billstatus", "=", (Object)"C");
            filter.and(new QFilter("detailentry.e_conbillnumber", "in", conBillNos));
            filter.and(new QFilter("detailentry.unsettleamt", "<>", (Object)0));
            if (settleOrgIds.size() > 0) {
                filter.and(new QFilter("org", "in", settleOrgIds));
            }
            DataSet apDataSet = QueryServiceHelper.queryDataSet((String)"getFinApBillIdsByConBill-query-apbill", (String)"ap_finapbill", (String)"id,org", (QFilter[])new QFilter[]{filter}, (String)"");
            for (Row row : apDataSet) {
                Long orgId = row.getLong("org");
                Long id = row.getLong("id");
                HashSet<Long> ids = (HashSet<Long>)idMap.get(orgId);
                if (ids == null) {
                    ids = new HashSet<Long>(2);
                }
                ids.add(id);
                idMap.put(orgId, ids);
            }
        }
        return idMap;
    }
}

