/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.kdtx.ec;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.ext.provider.BaseECService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ap.piaozone.InvoiceHelper;
import kd.fi.arapcommon.business.piaozone.info.InvoiceCloudCfg;
import kd.fi.arapcommon.business.piaozone.info.InvoiceVO;
import kd.fi.arapcommon.business.piaozone.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.arapcommon.business.piaozone.kingdee.action.ActionResponse;
import kd.fi.arapcommon.business.piaozone.kingdee.action.IAction;
import kd.fi.arapcommon.business.piaozone.kingdee.action.PullImageAction;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.invcloud.CallCloudHelper;
import kd.fi.arapcommon.util.ErStdConfig;
import kd.fi.arapcommon.util.StdConfig;

public class ApInvoicePullImageECService
extends BaseECService {
    private static final Log logger = LogFactory.getLog(ApInvoicePullImageECService.class);

    protected DtxResponse doExecute(Object param, Object o1) throws Exception {
        logger.info("ApInvoicePullImageService doExecute begin ");
        CommonParam ecParam = (CommonParam)param;
        List invoiceIds = (List)ecParam.get((Object)"invoiceIds");
        String finBillNo = ecParam.getString((Object)"finBillNo");
        logger.info("ApInvoicePullImageService doExecute invoiceIds is :" + invoiceIds);
        String selectors = "serialno,invoicecode,invoiceno,org,billno,org,imageno,creator,isreffin";
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"ap_invoice", (String)selectors, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)invoiceIds)});
        logger.info("ApInvoicePullImageService doExecute invoices size is :" + invoices.length);
        this.pullImage(invoices, finBillNo);
        return null;
    }

    private void pullImage(DynamicObject[] invoices, String finBillNo) {
        if (!ObjectUtils.isEmpty((Object[])invoices) && "false".equals(ErStdConfig.get((String)"invoicecloud.invoicecloudxh")) || "true".equals(StdConfig.get((String)"pullimagexh"))) {
            this.updateInvCloudBefore(invoices);
            HashMap<Long, Boolean> ap018Map = new HashMap<Long, Boolean>(32);
            HashMap<Long, InvoiceCloudCfg> invoiceCloudCfgMap = new HashMap<Long, InvoiceCloudCfg>(32);
            for (DynamicObject invoice : invoices) {
                long orgId;
                boolean isPull;
                String serialNo = invoice.getString("serialno");
                if (ObjectUtils.isEmpty((Object)serialNo) || !(isPull = ap018Map.computeIfAbsent(orgId = invoice.getLong("org.id"), e -> SystemParameterHelper.getAPBooleanParam((long)orgId, (String)"ap_018")).booleanValue())) continue;
                InvoiceCloudCfg config = invoiceCloudCfgMap.computeIfAbsent(orgId, e -> KingdeeInvoiceCloudConfig.getConfig((Long)orgId));
                PullImageAction pullImage = new PullImageAction(invoice, config, finBillNo);
                this.callBackInvCloud((IAction)pullImage);
            }
        }
    }

    private void updateInvCloudBefore(DynamicObject[] invoices) {
        Map<String, Long> serialNoMap = Arrays.stream(invoices).collect(Collectors.toMap(inv -> inv.getString("serialno"), inv -> inv.getLong("id")));
        Map orgForSerialMap = InvoiceHelper.getOrgForSerialMap((DynamicObject[])invoices);
        logger.info("ApInvoicePullImageECService updateInvCloudBefore orgForSerialMap : " + orgForSerialMap);
        List invoiceVOS = CallCloudHelper.queryCloudInvoice((Map)orgForSerialMap);
        if (!ObjectUtils.isEmpty((Object[])invoices)) {
            for (InvoiceVO invoiceVO : invoiceVOS) {
                if ("1".equals(invoiceVO.getExpenseStatus())) continue;
                serialNoMap.remove(invoiceVO.getSerialNo());
            }
        }
        if (!serialNoMap.isEmpty()) {
            logger.info("ApInvoicePullImageECService updateInvCloudBefore execute updateInvoiceCloud.");
            CallCloudHelper.updateInvoiceCloud(new ArrayList<Long>(serialNoMap.values()));
        }
    }

    private void callBackInvCloud(IAction action) {
        String execute = action.execute();
        ActionResponse actionResponse = (ActionResponse)JSON.parseObject((String)execute, ActionResponse.class);
        if (actionResponse == null || !actionResponse.success()) {
            String tipString = ResManager.loadKDString((String)"\u901a\u77e5\u53d1\u7968\u62c9\u53d6\u5f71\u50cf\uff1a\u6267\u884c\u5931\u8d25\u3002", (String)"ApInvoicePullImageService_0", (String)"fi-ap-mservice", (Object[])new Object[0]);
            tipString = actionResponse == null ? tipString : actionResponse.getDescription();
            throw new KDBizException(tipString);
        }
    }
}

