/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.kdtx.ec;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.idemponent.properties.IdempotentProperties;
import kd.bos.kdtx.common.idemponent.service.IdempotentService;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.ext.provider.BaseECService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.mservice.CancelRefundAndRenoteNewExecutor;
import kd.fi.ap.mservice.PayRecSettleService;
import kd.fi.ap.mservice.helper.RefundAndRenoteServiceHelper;
import kd.fi.ap.vo.CancelRefundAndRenoteParam;
import kd.fi.ap.vo.PayRefundEntryInfo;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.kdtx.ec.service.DefaultECServiceIdempotentProperties;
import kd.fi.arapcommon.service.freeze.CancelRefundAndRenoteUnFreezeService;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.vo.UnSettleParam;

public class CancelRefundAndRenoteECService
extends BaseECService
implements IdempotentService {
    private static final Log logger = LogFactory.getLog(CancelRefundAndRenoteECService.class);

    protected DtxResponse doExecute(Object param, Object o1) {
        logger.info("CancelRefundAndRenoteECService execute start");
        try (TXHandle tx = TX.required();){
            try {
                CommonParam ecParam = (CommonParam)param;
                String paramJson = (String)ecParam.get((Object)"paramJson");
                CancelRefundAndRenoteParam cancelRefundAndRenoteParam = RefundAndRenoteServiceHelper.cancelConvertParam(paramJson);
                logger.info("CancelRefundAndRenoteECService.execute param convert result:" + JSON.toJSONString((Object)cancelRefundAndRenoteParam));
                boolean isExecuteNewLogic = RefundAndRenoteServiceHelper.isExecuteNewLogic();
                if (isExecuteNewLogic) {
                    this.executeNewLogic(cancelRefundAndRenoteParam);
                } else {
                    this.executeOldLogic(cancelRefundAndRenoteParam);
                }
            }
            catch (Throwable e) {
                logger.error("CancelRefundAndRenoteECService error:" + e);
                tx.markRollback();
                throw e;
            }
        }
        logger.info("CancelRefundAndRenoteECService execute end");
        return null;
    }

    private void executeNewLogic(CancelRefundAndRenoteParam cancelRefundAndRenoteParam) {
        new CancelRefundAndRenoteNewExecutor().cancel(cancelRefundAndRenoteParam);
    }

    private void executeOldLogic(CancelRefundAndRenoteParam cancelRefundAndRenoteParam) {
        Set payIds = cancelRefundAndRenoteParam.getPayInfos().stream().map(PayRefundEntryInfo::getPayId).collect(Collectors.toSet());
        PayRecSettleService settleService = new PayRecSettleService();
        QFilter filter = new QFilter("settlerelation", "=", (Object)SettleRelationEnum.PAYRECSETTLE.getValue());
        filter.and("mainbillid", "in", payIds);
        filter.and("iswrittenoff", "=", (Object)Boolean.FALSE).and("hadwrittenoff", "=", (Object)Boolean.FALSE);
        DynamicObject[] settleRecords = BusinessDataServiceHelper.load((String)"ap_settlerecord", (String)CommonSettleServiceHelper.getSettleRecordSelector(), (QFilter[])filter.toArray());
        ArrayList<DynamicObject> deleteRecords = new ArrayList<DynamicObject>(settleRecords.length);
        ArrayList<DynamicObject> redRecords = new ArrayList<DynamicObject>(settleRecords.length);
        HashMap<Long, Date> currentDateMap = new HashMap<Long, Date>(1);
        boolean redAllSettleRecord = CommonSettleServiceHelper.isRedAllSettleRecord();
        if (redAllSettleRecord) {
            Collections.addAll(redRecords, settleRecords);
        } else {
            for (DynamicObject result2 : settleRecords) {
                Date currentDate;
                long orgId = result2.getLong("org.id");
                Date date = (Date)currentDateMap.get(orgId);
                if (date != null) {
                    currentDate = date;
                } else {
                    InitHelper init = new InitHelper(orgId, "ap_init");
                    currentDate = init.getCurrentDate() != null ? init.getCurrentDate() : init.getStartDate();
                    currentDateMap.put(orgId, currentDate);
                }
                if (result2.getBoolean("isvoucher") || DateUtils.getDiffDays((Date)result2.getDate("settledate"), (Date)currentDate) > 0) {
                    redRecords.add(result2);
                    continue;
                }
                deleteRecords.add(result2);
            }
        }
        if (deleteRecords.size() > 0) {
            UnSettleParam unSettleParam = new UnSettleParam();
            unSettleParam.setUnSettleByReturn(true);
            settleService.unSettle(deleteRecords.toArray(new DynamicObject[0]), unSettleParam);
        }
        if (redRecords.size() > 0) {
            List resultIds = redRecords.stream().map(result -> result.getLong("id")).collect(Collectors.toList());
            String apSettleRecordRedRuleId = "733772355079280640";
            List redSettleRecords = BOTPHelper.push((String)"ap_settlerecord", (String)"ap_settlerecord", (String)apSettleRecordRedRuleId, resultIds, (String)ResManager.loadKDString((String)"\u7ed3\u7b97\u8bb0\u5f55\u7ea2\u51b2\u5931\u8d25\u3002", (String)"PayBillListener_0", (String)"fi-ap-mservice", (Object[])new Object[0]));
            OperateOption option = OperateOption.create();
            option.setVariableValue("mutex_writeback", "false");
            OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"ap_settlerecord", (DynamicObject[])redSettleRecords.toArray(new DynamicObject[0]), (OperateOption)option);
            OperationHelper.assertResult((OperationResult)saveResult);
            OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"ap_settlerecord", (Object[])saveResult.getSuccessPkIds().toArray(), (OperateOption)option);
            OperationHelper.assertResult((OperationResult)submitResult);
            OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ap_settlerecord", (Object[])submitResult.getSuccessPkIds().toArray(), (OperateOption)option);
            OperationHelper.assertResult((OperationResult)auditResult);
            for (DynamicObject record : redRecords) {
                record.set("hadwrittenoff", (Object)1);
                DynamicObjectCollection entries = record.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entries) {
                    entry.set("e_hadwrittenoff", (Object)1);
                }
            }
            DynamicObject[] results = redRecords.toArray(new DynamicObject[0]);
            SaveServiceHelper.update((DynamicObject[])results);
            UnSettleParam unSettleParam = new UnSettleParam();
            unSettleParam.setRedSettleRecord(true);
            unSettleParam.setUnSettleByReturn(true);
            settleService.unSettle(redRecords.toArray(new DynamicObject[0]), unSettleParam);
        }
        CancelRefundAndRenoteUnFreezeService service = new CancelRefundAndRenoteUnFreezeService();
        service.freeze(payIds, false);
        DynamicObject[] payBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"entry.id,entry.e_sourcebillid,entry.e_sourcebillentryid,sourcebilltype,billstatus,e_payableamt,e_refundamt", (QFilter[])new QFilter[]{new QFilter("id", "in", payIds)});
        List payInfos = cancelRefundAndRenoteParam.getPayInfos();
        HashMap<Long, BigDecimal> needSettleEntryMap = new HashMap<Long, BigDecimal>(payInfos.size());
        for (PayRefundEntryInfo payInfo : payInfos) {
            needSettleEntryMap.put(payInfo.getEntryId(), payInfo.getEntryRefundAmt());
        }
        ArrayList params = new ArrayList(8);
        for (DynamicObject payBill : payBills) {
            String sourcebilltype = payBill.getString("sourcebilltype");
            if (!"ap_payapply".equals(sourcebilltype)) continue;
            DynamicObjectCollection entries = payBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                HashMap<String, Object> param = new HashMap<String, Object>(6);
                param.put("sourcepk", entry.getLong("e_sourcebillid"));
                param.put("sourceentrypk", entry.getLong("e_sourcebillentryid"));
                param.put("operate", cancelRefundAndRenoteParam.getOperateKey());
                param.put("issuccess", true);
                param.put("payableamt", entry.getBigDecimal("e_payableamt"));
                param.put("refundamt", needSettleEntryMap.get(entry.getLong("id")) == null ? BigDecimal.ZERO : ((BigDecimal)needSettleEntryMap.get(entry.getLong("id"))).negate());
                params.add(param);
            }
        }
        DispatchServiceHelper.invokeBizService((String)"fi", (String)"ap", (String)"payO2OService", (String)"syncBill", (Object[])new Object[]{params});
    }

    public IdempotentProperties getIdempotentProperties(Object param, Object o1) {
        return DefaultECServiceIdempotentProperties.generate((String)((Object)((Object)this)).getClass().getName(), (Object)param);
    }
}

