/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.unittest.scene.settle;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.AbstractJUnitTestWithOutFormPlugIn;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.ap.mservice.ApArManualSettleService;
import kd.fi.ap.mservice.ApPayManualSettleService;
import kd.fi.ap.mservice.ApRecManualSettleService;
import kd.fi.ap.mservice.ApSelfManualSettleService;
import kd.fi.ap.mservice.PayRecManualSettleService;
import kd.fi.ap.mservice.PaySelfManualSettleService;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.unittest.framework.check.CasPayBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.CasRecBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.FinArBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.CasPayBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.CasRecBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinApBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinArBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.CasPayBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.CasPayBillDataVO;
import kd.fi.arapcommon.unittest.framework.entity.CasRecBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.CasRecBillDataVO;
import kd.fi.arapcommon.unittest.framework.entity.FinApBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.FinApBillDataVO;
import kd.fi.arapcommon.unittest.framework.entity.FinArBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.FinArBillDataVO;
import kd.fi.arapcommon.unittest.scene.process.settle.BillRowVO;
import kd.fi.arapcommon.unittest.scene.process.settle.ManualSettleUnitTestHelper;
import kd.fi.arapcommon.vo.ManualSettleParam;
import org.junit.Test;

public class AP012_001ApManualSettleIndirectUnitText
extends AbstractJUnitTestWithOutFormPlugIn {
    @TestMethod(value=1)
    @DisplayName(value="\u5e94\u4ed8\u4ed8\u6b3e")
    @Test
    public void testApPay_001_1() throws InterruptedException {
        DynamicObject[] apBills;
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        FinApBillDataVO finBillInfo = new FinApBillDataVO();
        finBillInfo.setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setQuotation("1").setExchangerate(BigDecimal.ONE).setPricetaxTotal(new BigDecimal(100)).setBillNo("ApPayManualSettle_FinAp_ind_1").setOrg(org);
        DynamicObject apBill = FinApBillTestDataProvider.buildByHeadPriceTaxTotal((FinApBillDataVO)finBillInfo);
        ArrayList<CasPayBillDataDetailVO> entryInfoPayList = new ArrayList<CasPayBillDataDetailVO>(2);
        CasPayBillDataVO CasPayBillInfo = CasPayBillDataVO.New().setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setQuotation("1").setExchangerate(BigDecimal.ONE).setBillNo("ApPayManualSettle_CasPay_ind_1").setOrg(org);
        entryInfoPayList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(1));
        DynamicObject payBill = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((CasPayBillDataVO)CasPayBillInfo, entryInfoPayList);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal((DynamicObject)apBill, (BigDecimal)BigDecimal.valueOf(80L), (boolean)false);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal((DynamicObject)payBill, (BigDecimal)BigDecimal.valueOf(80L), (boolean)false);
        ApPayManualSettleService service = new ApPayManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getApSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Object[] mainIds = new Long[]{apBill.getLong("id")};
        Object[] asstIds = new Long[]{payBill.getLong("id")};
        this.checkForSettleForTestAp_001_1((Long[])mainIds, (Long[])asstIds);
        this.checkForSettleForTestPay_001_1((Long[])asstIds);
        Set settleRecordIds = ManualSettleUnitTestHelper.getSettleRecordIds((Long[])mainIds, (Long[])asstIds, (boolean)false);
        OperationResult unSettleResult = OperationServiceHelper.executeOperate((String)"unsettle", (String)"ap_settlerecord", (Object[])settleRecordIds.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unSettleResult);
        this.checkForUnSettleForTestAp_001_1((Long[])mainIds, (Long[])asstIds);
        this.checkForUnSettleForTestPay_001_1((Long[])asstIds);
        service.manualSettle(mainRows, asstRows, param);
        this.checkForSettleForTestAp_001_1((Long[])mainIds, (Long[])asstIds);
        this.checkForSettleForTestPay_001_1((Long[])asstIds);
        OperationResult unAuditRusult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])mainIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unAuditRusult);
        this.checkForUnSettleForTestAp_001_1((Long[])mainIds, (Long[])asstIds);
        this.checkForUnSettleForTestPay_001_1((Long[])asstIds);
        for (DynamicObject bill : apBills = FinApBillTestDataProvider.loadData((Long[])mainIds)) {
            bill.set("billstatus", (Object)"C");
        }
        SaveServiceHelper.save((DynamicObject[])apBills);
        service.manualSettle(mainRows, asstRows, param);
        this.checkForSettleForTestAp_001_1((Long[])mainIds, (Long[])asstIds);
        this.checkForSettleForTestPay_001_1((Long[])asstIds);
        OperationResult cancelPayRusult = OperationServiceHelper.executeOperate((String)"cancelpay", (String)"cas_paybill", (Object[])asstIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)cancelPayRusult);
        Thread.sleep(20000L);
        this.checkForUnSettleForTestAp_001_1((Long[])mainIds, (Long[])asstIds);
        this.checkForUnSettleForTestPay_001_1((Long[])asstIds);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u5e94\u4ed8\u51b2\u5e94\u6536")
    @Test
    public void testApAr_001_1() {
        DynamicObject[] apBills;
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        FinApBillDataVO finBillInfo = new FinApBillDataVO();
        finBillInfo.setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setQuotation("1").setExchangerate(BigDecimal.ONE).setPricetaxTotal(new BigDecimal(100)).setBillNo("ApArManualSettle_FinAp_ind_1").setOrg(org);
        DynamicObject apBill = FinApBillTestDataProvider.buildByHeadPriceTaxTotal((FinApBillDataVO)finBillInfo);
        ArrayList<FinArBillDataDetailVO> entryInfoApList = new ArrayList<FinArBillDataDetailVO>(2);
        FinArBillDataVO billInfo = new FinArBillDataVO();
        billInfo.setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setQuotation("1").setExchangerate(BigDecimal.ONE).setPricetaxTotal(BigDecimal.valueOf(100L)).setBillNo("ApArManualSettle_FinAr_ind_1").setOrg(org);
        entryInfoApList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        DynamicObject arBill = FinArBillTestDataProvider.buildByPriceAndQuantity((FinArBillDataVO)billInfo, entryInfoApList);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal((DynamicObject)apBill, (BigDecimal)BigDecimal.valueOf(80L), (boolean)false);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal((DynamicObject)arBill, (BigDecimal)BigDecimal.valueOf(80L), (boolean)false);
        ApArManualSettleService service = new ApArManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getApSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Object[] mainIds = new Long[]{apBill.getLong("id")};
        Object[] asstIds = new Long[]{arBill.getLong("id")};
        this.checkForSettleForTestAp_001_1((Long[])mainIds, (Long[])asstIds);
        this.checkForSettleForTestAr_001_1((Long[])asstIds);
        Set settleRecordIds = ManualSettleUnitTestHelper.getSettleRecordIds((Long[])mainIds, (Long[])asstIds, (boolean)false);
        OperationResult unSettleResult = OperationServiceHelper.executeOperate((String)"unsettle", (String)"ap_settlerecord", (Object[])settleRecordIds.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unSettleResult);
        this.checkForUnSettleForTestAp_001_1((Long[])mainIds, (Long[])asstIds);
        this.checkForUnSettleForTestAr_001_1((Long[])asstIds);
        service.manualSettle(mainRows, asstRows, param);
        this.checkForSettleForTestAp_001_1((Long[])mainIds, (Long[])asstIds);
        this.checkForSettleForTestAr_001_1((Long[])asstIds);
        OperationResult unAuditRusult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])mainIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unAuditRusult);
        this.checkForUnSettleForTestAp_001_1((Long[])mainIds, (Long[])asstIds);
        this.checkForUnSettleForTestAr_001_1((Long[])asstIds);
        for (DynamicObject bill : apBills = FinApBillTestDataProvider.loadData((Long[])mainIds)) {
            bill.set("billstatus", (Object)"C");
        }
        SaveServiceHelper.save((DynamicObject[])apBills);
        service.manualSettle(mainRows, asstRows, param);
        this.checkForSettleForTestAp_001_1((Long[])mainIds, (Long[])asstIds);
        this.checkForSettleForTestAr_001_1((Long[])asstIds);
        unAuditRusult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ar_finarbill", (Object[])asstIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unAuditRusult);
        this.checkForUnSettleForTestAp_001_1((Long[])mainIds, (Long[])asstIds);
        this.checkForUnSettleForTestAr_001_1((Long[])asstIds);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u5e94\u4ed8\u9000\u6b3e")
    @Test
    public void testApRec_001_1() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        FinApBillDataVO finBillInfo = new FinApBillDataVO();
        finBillInfo.setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setQuotation("1").setExchangerate(BigDecimal.ONE).setPricetaxTotal(new BigDecimal(100)).setBillNo("ApRecManualSettle_FinAp_ind_1").setOrg(org);
        ArrayList<FinApBillDataDetailVO> entryInfoApList = new ArrayList<FinApBillDataDetailVO>(1);
        entryInfoApList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(-1L)));
        DynamicObject apBill = FinApBillTestDataProvider.buildByPriceAndQuantity((FinApBillDataVO)finBillInfo, entryInfoApList);
        ArrayList<CasRecBillDataDetailVO> entryInfoRecList = new ArrayList<CasRecBillDataDetailVO>(1);
        entryInfoRecList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(1));
        CasRecBillDataVO recBillInfo = CasRecBillDataVO.New().setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setQuotation("1").setExchangerate(BigDecimal.ONE).setBillNo("ApRecManualSettle_CasRec_ind_1").setOrg(org);
        DynamicObject recBill = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((CasRecBillDataVO)recBillInfo, entryInfoRecList);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal((DynamicObject)apBill, (BigDecimal)BigDecimal.valueOf(-100L), (boolean)false);
        ArrayList<BillRowVO> asstBills = new ArrayList<BillRowVO>(2);
        BillRowVO rowModel = new BillRowVO(recBill, BigDecimal.valueOf(100L));
        asstBills.add(rowModel);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal(asstBills, (boolean)false);
        ApRecManualSettleService service = new ApRecManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getApSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{apBill.getLong("id")};
        Long[] asstIds = new Long[]{recBill.getLong("id")};
        this.checkForSettleForTestApRec_001_1(mainIds, asstIds);
        Set settleRecordIds = ManualSettleUnitTestHelper.getSettleRecordIds((Long[])mainIds, (Long[])asstIds, (boolean)false);
        OperationResult unSettleResult = OperationServiceHelper.executeOperate((String)"unsettle", (String)"ap_settlerecord", (Object[])settleRecordIds.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unSettleResult);
        this.checkForUnSettleForTestApRec_001_1(mainIds, asstIds);
    }

    @TestMethod(value=4)
    @DisplayName(value="\u5e94\u4ed8\u7ea2\u84dd\u5bf9\u51b2")
    @Test
    public void testApSelf_001_1() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        FinApBillDataVO finBillInfo = new FinApBillDataVO();
        finBillInfo.setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setQuotation("1").setExchangerate(BigDecimal.ONE).setPricetaxTotal(new BigDecimal(200)).setBillNo("ApSelfManualSettle_FinAp_ind_1").setOrg(org);
        ArrayList<FinApBillDataDetailVO> entryInfoApList = new ArrayList<FinApBillDataDetailVO>(1);
        entryInfoApList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)));
        entryInfoApList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)));
        DynamicObject apBill = FinApBillTestDataProvider.buildByPriceAndQuantity((FinApBillDataVO)finBillInfo, entryInfoApList);
        FinApBillDataVO finBillInfo2 = new FinApBillDataVO();
        finBillInfo2.setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setQuotation("1").setExchangerate(BigDecimal.ONE).setPricetaxTotal(new BigDecimal(-150)).setBillNo("ApSelfManualSettle_FinAp_ind_2").setOrg(org);
        ArrayList<FinApBillDataDetailVO> entryInfoApList2 = new ArrayList<FinApBillDataDetailVO>(1);
        entryInfoApList2.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(-1L)));
        entryInfoApList2.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(50L)).setQuantity(BigDecimal.valueOf(-1L)));
        DynamicObject apBill2 = FinApBillTestDataProvider.buildByPriceAndQuantity((FinApBillDataVO)finBillInfo2, entryInfoApList2);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal((DynamicObject)apBill, (BigDecimal)BigDecimal.valueOf(150L), (boolean)false);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal((DynamicObject)apBill2, (BigDecimal)BigDecimal.valueOf(-150L), (boolean)false);
        ApSelfManualSettleService service = new ApSelfManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getApSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{apBill.getLong("id")};
        Object[] asstIds = new Long[]{apBill2.getLong("id")};
        this.checkForSettleForTestApSelf_001_1(mainIds, (Long[])asstIds);
        OperationResult unAuditRusult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])asstIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unAuditRusult);
        this.checkForUnSettleForTestApSelf_001_1(mainIds, (Long[])asstIds);
    }

    @TestMethod(value=5)
    @DisplayName(value="\u4ed8\u6b3e\u51b2\u6536\u6b3e")
    @Test
    public void testPayRec_001_1() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        CasPayBillDataVO CasPayBillInfo = CasPayBillDataVO.New().setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setQuotation("1").setExchangerate(BigDecimal.ONE).setBillNo("PayRecManualSettle_CasPay_ind_1").setOrg(org);
        ArrayList<CasPayBillDataDetailVO> entryInfoPayList = new ArrayList<CasPayBillDataDetailVO>(2);
        entryInfoPayList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(1));
        entryInfoPayList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(2));
        DynamicObject payBill = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((CasPayBillDataVO)CasPayBillInfo, entryInfoPayList);
        ArrayList<CasRecBillDataDetailVO> entryInfoRecList = new ArrayList<CasRecBillDataDetailVO>(2);
        entryInfoRecList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(1));
        entryInfoRecList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)).setSeq(2));
        CasRecBillDataVO recBillInfo = CasRecBillDataVO.New().setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setQuotation("1").setExchangerate(BigDecimal.ONE).setBillNo("PayRecManualSettle_CasRec_ind_1").setOrg(org);
        DynamicObject recBill = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((CasRecBillDataVO)recBillInfo, entryInfoRecList);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal((DynamicObject)payBill, (BigDecimal)BigDecimal.valueOf(150L), (boolean)false);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal((DynamicObject)recBill, (BigDecimal)BigDecimal.valueOf(150L), (boolean)false);
        PayRecManualSettleService service = new PayRecManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getApSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{payBill.getLong("id")};
        Object[] asstIds = new Long[]{recBill.getLong("id")};
        this.checkForSettleForTestPayRec_001_1(mainIds, (Long[])asstIds);
        OperationResult cancelRecRusult = OperationServiceHelper.executeOperate((String)"cancelrec", (String)"cas_recbill", (Object[])asstIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)cancelRecRusult);
        this.checkForUnSettleForTestPayRec_001_1(mainIds, (Long[])asstIds);
    }

    @TestMethod(value=5)
    @DisplayName(value="\u4ed8\u6b3e\u7ea2\u84dd\u5bf9\u51b2")
    @Test
    public void testPaySelf_001_1() throws InterruptedException {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        CasPayBillDataVO CasPayBillInfo = CasPayBillDataVO.New().setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setQuotation("1").setExchangerate(BigDecimal.ONE).setBillNo("PaySelfMSettle_CasPay_ind_1").setOrg(org);
        ArrayList<CasPayBillDataDetailVO> entryInfoPayList = new ArrayList<CasPayBillDataDetailVO>(2);
        entryInfoPayList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(1));
        entryInfoPayList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(2));
        DynamicObject payBill = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((CasPayBillDataVO)CasPayBillInfo, entryInfoPayList);
        CasPayBillDataVO CasPayBillInfo2 = CasPayBillDataVO.New().setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setQuotation("1").setExchangerate(BigDecimal.ONE).setBillNo("PaySelfMSettle_CasPay_ind_2").setOrg(org);
        ArrayList<CasPayBillDataDetailVO> entryInfoPayList1 = new ArrayList<CasPayBillDataDetailVO>(2);
        entryInfoPayList1.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(-100L)).setSeq(1));
        entryInfoPayList1.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(-50L)).setSeq(2));
        DynamicObject payBill2 = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((CasPayBillDataVO)CasPayBillInfo2, entryInfoPayList1);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal((DynamicObject)payBill, (BigDecimal)BigDecimal.valueOf(150L), (boolean)false);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal((DynamicObject)payBill2, (BigDecimal)BigDecimal.valueOf(-150L), (boolean)false);
        PaySelfManualSettleService service = new PaySelfManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getApSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{payBill.getLong("id")};
        Object[] asstIds = new Long[]{payBill2.getLong("id")};
        this.checkForSettleForTestPaySelf_001_1(mainIds, (Long[])asstIds);
        OperationResult cancelpayRusult = OperationServiceHelper.executeOperate((String)"cancelpay", (String)"cas_paybill", (Object[])asstIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)cancelpayRusult);
        Thread.sleep(20000L);
        this.checkForUnSettleForTestPaySelf_001_1(mainIds, (Long[])asstIds);
    }

    private void checkForSettleForTestAp_001_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateApFinHeadSettleStatus((DynamicObject)needCheckMainBill, (String)"partsettle");
        FinApBillTestChecker.validateApFinHeadSettleAmt((DynamicObject)needCheckMainBill, (BigDecimal)BigDecimal.valueOf(20L), (BigDecimal)BigDecimal.valueOf(20L), (BigDecimal)BigDecimal.valueOf(80L), (BigDecimal)BigDecimal.valueOf(80L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry0, (BigDecimal)BigDecimal.valueOf(80L), (BigDecimal)BigDecimal.valueOf(20L), (BigDecimal)BigDecimal.valueOf(80L), (BigDecimal)BigDecimal.valueOf(80L), (BigDecimal)BigDecimal.valueOf(20L), (BigDecimal)BigDecimal.valueOf(20L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)planEntry0, (BigDecimal)BigDecimal.valueOf(80L), (BigDecimal)BigDecimal.valueOf(20L), (BigDecimal)BigDecimal.valueOf(80L), (BigDecimal)BigDecimal.valueOf(80L), (BigDecimal)BigDecimal.valueOf(20L), (BigDecimal)BigDecimal.valueOf(20L));
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForSettleForTestPay_001_1(Long[] payIds) {
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])payIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        DynamicObjectCollection entries = needCheckAsstBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt((DynamicObject)entry0, (BigDecimal)BigDecimal.valueOf(80L), (BigDecimal)BigDecimal.valueOf(20L), (BigDecimal)BigDecimal.valueOf(80L), (BigDecimal)BigDecimal.valueOf(80L), (BigDecimal)BigDecimal.valueOf(20L), (BigDecimal)BigDecimal.valueOf(20L));
    }

    private void checkForUnSettleForTestAp_001_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateApFinHeadSettleStatus((DynamicObject)needCheckMainBill, (String)"unsettle");
        FinApBillTestChecker.validateApFinHeadSettleAmt((DynamicObject)needCheckMainBill, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry0, (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)planEntry0, (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L));
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForUnSettleForTestPay_001_1(Long[] payBills) {
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])payBills);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        DynamicObjectCollection entries = needCheckAsstBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt((DynamicObject)entry0, (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L));
    }

    private void checkForSettleForTestAr_001_1(Long[] ArIds) {
        DynamicObject[] needCheckAsstBills = FinArBillTestDataProvider.loadData((Long[])ArIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        BigDecimal settleamount = needCheckAsstBill.getBigDecimal("settleamount");
        BigDecimal settlelocalamt = needCheckAsstBill.getBigDecimal("settlelocalamt");
        KDAssert.assertEquals((String)"\u5e94\u6536\u5355\u8868\u5934\u7ed3\u7b97\u72b6\u6001\u5e94\u4e3a\u90e8\u5206\u7ed3\u7b97", (String)"partsettle", (String)needCheckAsstBill.getString("settlestatus"));
        FinArBillTestChecker.validateHeadSettleAmt((DynamicObject)needCheckAsstBill, (BigDecimal)settleamount, (BigDecimal)settlelocalamt, (BigDecimal)BigDecimal.valueOf(20L), (BigDecimal)BigDecimal.valueOf(20L));
        DynamicObjectCollection detailEntry = needCheckAsstBill.getDynamicObjectCollection("entry");
        for (DynamicObject detail : detailEntry) {
            BigDecimal elockedamt = detail.getBigDecimal("e_lockedamt");
            BigDecimal esettledamt = detail.getBigDecimal("e_settledamt");
            FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detail, (BigDecimal)elockedamt, (BigDecimal)BigDecimal.valueOf(20L));
            FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detail, (BigDecimal)esettledamt, (BigDecimal)esettledamt, (BigDecimal)BigDecimal.valueOf(20L), (BigDecimal)BigDecimal.valueOf(20L));
        }
        DynamicObjectCollection planEntity = needCheckAsstBill.getDynamicObjectCollection("planentity");
        for (DynamicObject plan : planEntity) {
            BigDecimal planlockedamt = plan.getBigDecimal("planlockedamt");
            BigDecimal plansettledamt = plan.getBigDecimal("plansettledamt");
            FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)plan, (BigDecimal)planlockedamt, (BigDecimal)BigDecimal.valueOf(20L));
            FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)plan, (BigDecimal)plansettledamt, (BigDecimal)plansettledamt, (BigDecimal)BigDecimal.valueOf(20L), (BigDecimal)BigDecimal.valueOf(20L));
        }
    }

    private void checkForUnSettleForTestAr_001_1(Long[] ArIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])ArIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateInitialBill((DynamicObject)needCheckMainBill);
    }

    private void checkForSettleForTestApRec_001_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateFinishApFin((DynamicObject)needCheckMainBill, (boolean)true, (boolean)false);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateFinishBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForUnSettleForTestApRec_001_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateInitialApFin((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateInitialBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForSettleForTestApSelf_001_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateApFinHeadSettleStatus((DynamicObject)needCheckMainBill, (String)"partsettle");
        FinApBillTestChecker.validateApFinHeadSettleAmt((DynamicObject)needCheckMainBill, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(150L), (BigDecimal)BigDecimal.valueOf(150L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry0, (BigDecimal)BigDecimal.valueOf(75L), (BigDecimal)BigDecimal.valueOf(25L), (BigDecimal)BigDecimal.valueOf(75L), (BigDecimal)BigDecimal.valueOf(75L), (BigDecimal)BigDecimal.valueOf(25L), (BigDecimal)BigDecimal.valueOf(25L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry1, (BigDecimal)BigDecimal.valueOf(75L), (BigDecimal)BigDecimal.valueOf(25L), (BigDecimal)BigDecimal.valueOf(75L), (BigDecimal)BigDecimal.valueOf(75L), (BigDecimal)BigDecimal.valueOf(25L), (BigDecimal)BigDecimal.valueOf(25L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)planEntry0, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObject planEntry1 = (DynamicObject)planEntries.get(1);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)planEntry1, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L));
        DynamicObject[] needCheckAsstBills = FinApBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        FinApBillTestChecker.validateFinishApFin((DynamicObject)needCheckAsstBill, (boolean)true, (boolean)false);
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForUnSettleForTestApSelf_001_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateInitialApFin((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = FinApBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        FinApBillTestChecker.validateInitialApFin((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForSettleForTestPayRec_001_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = CasPayBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        DynamicObjectCollection entries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt((DynamicObject)entry0, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObject entry1 = (DynamicObject)entries.get(1);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt((DynamicObject)entry1, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L));
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateFinishBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForUnSettleForTestPayRec_001_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = CasPayBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        CasPayBillTestChecker.validateInitialCasPayBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateInitialBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForSettleForTestPaySelf_001_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = CasPayBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        DynamicObjectCollection entries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt((DynamicObject)entry0, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObject entry1 = (DynamicObject)entries.get(1);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt((DynamicObject)entry1, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L));
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateFinishCasPayBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForUnSettleForTestPaySelf_001_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = CasPayBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        CasPayBillTestChecker.validateInitialCasPayBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateInitialCasPayBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }
}

