/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.unittest.scene.settle;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.AbstractJUnitTestWithOutFormPlugIn;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.ap.mservice.ApPayManualSettleService;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.unittest.framework.check.CasPayBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.PaidSettleTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.CasPayBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinApBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.PaidBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.CasPayBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.CasPayBillDataVO;
import kd.fi.arapcommon.unittest.framework.entity.FinApBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.FinApBillDataVO;
import kd.fi.arapcommon.unittest.framework.entity.PaidBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.helper.SettleRecordTestHelper;
import kd.fi.arapcommon.unittest.scene.process.settle.BillRowVO;
import kd.fi.arapcommon.unittest.scene.process.settle.EntryRowVO;
import kd.fi.arapcommon.unittest.scene.process.settle.ManualSettleUnitTestHelper;
import kd.fi.arapcommon.vo.ManualSettleParam;
import org.junit.Test;

public class AP012_001_ApPayManualSettleSameUnitTest
extends AbstractJUnitTestWithOutFormPlugIn {
    @TestMethod(value=1)
    @DisplayName(value="\u5e94\u4ed8\u4ed8\u6b3e-\u8ba1\u5212\u884c-\u6574\u5355-\u4e00\u5bf9\u4e00-\u4e0d\u540c\u91d1\u989d")
    @Test
    public void testApPay_001_1() throws InterruptedException {
        DynamicObject[] apBills;
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinApBillDataDetailVO> entryInfoApList = new ArrayList<FinApBillDataDetailVO>(2);
        entryInfoApList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        entryInfoApList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(2));
        DynamicObject apBill = FinApBillTestDataProvider.buildByPriceAndQuantity((String)"ApPayManualSettle_FinAp_001_1", (DynamicObject)org, entryInfoApList);
        ArrayList<CasPayBillDataDetailVO> entryInfoPayList = new ArrayList<CasPayBillDataDetailVO>(2);
        entryInfoPayList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(1));
        entryInfoPayList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)).setSeq(2));
        DynamicObject payBill = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((String)"ApPayManualSettle_CasPay_001_1", (DynamicObject)org, entryInfoPayList);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal((DynamicObject)apBill, (BigDecimal)BigDecimal.valueOf(150L), (boolean)false);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal((DynamicObject)payBill, (BigDecimal)BigDecimal.valueOf(150L), (boolean)false);
        ApPayManualSettleService service = new ApPayManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getApSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Object[] mainIds = new Long[]{apBill.getLong("id")};
        Object[] asstIds = new Long[]{payBill.getLong("id")};
        this.checkForSettleForTestApPay_001_1((Long[])mainIds, (Long[])asstIds);
        Set settleRecordIds = ManualSettleUnitTestHelper.getSettleRecordIds((Long[])mainIds, (Long[])asstIds, (boolean)false);
        OperationResult unSettleResult = OperationServiceHelper.executeOperate((String)"unsettle", (String)"ap_settlerecord", (Object[])settleRecordIds.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unSettleResult);
        this.checkForUnSettleForTestApPay_001_1((Long[])mainIds, (Long[])asstIds);
        service.manualSettle(mainRows, asstRows, param);
        this.checkForSettleForTestApPay_001_1((Long[])mainIds, (Long[])asstIds);
        OperationResult unAuditRusult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])mainIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unAuditRusult);
        this.checkForUnSettleForTestApPay_001_1((Long[])mainIds, (Long[])asstIds);
        for (DynamicObject bill : apBills = FinApBillTestDataProvider.loadData((Long[])mainIds)) {
            bill.set("billstatus", (Object)"C");
        }
        SaveServiceHelper.save((DynamicObject[])apBills);
        service.manualSettle(mainRows, asstRows, param);
        this.checkForSettleForTestApPay_001_1((Long[])mainIds, (Long[])asstIds);
        OperationResult cancelPayRusult = OperationServiceHelper.executeOperate((String)"cancelpay", (String)"cas_paybill", (Object[])asstIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)cancelPayRusult);
        Thread.sleep(20000L);
        this.checkForUnSettleForTestApPay_001_1((Long[])mainIds, (Long[])asstIds);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u5e94\u4ed8\u4ed8\u6b3e-\u8ba1\u5212\u884c-\u6574\u5355-\u4e00\u5bf9\u591a-\u76f8\u540c\u91d1\u989d")
    @Test
    public void testApPay_001_2() throws InterruptedException {
        DynamicObject[] apBills;
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinApBillDataDetailVO> entryInfoApList = new ArrayList<FinApBillDataDetailVO>(1);
        entryInfoApList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)));
        DynamicObject apBill = FinApBillTestDataProvider.buildByPriceAndQuantity((String)"ApPayManualSettle_FinAp_001_2", (DynamicObject)org, entryInfoApList);
        ArrayList<CasPayBillDataDetailVO> entryInfoPayList = new ArrayList<CasPayBillDataDetailVO>(1);
        entryInfoPayList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)));
        DynamicObject payBill0 = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((String)"ApPayManualSettle_CasPay_001_2_0", (DynamicObject)org, entryInfoPayList);
        ArrayList<CasPayBillDataDetailVO> entryInfoPayList1 = new ArrayList<CasPayBillDataDetailVO>(1);
        entryInfoPayList1.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)));
        DynamicObject payBill1 = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((String)"ApPayManualSettle_CasPay_001_2_1", (DynamicObject)org, entryInfoPayList1);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal((DynamicObject)apBill, (BigDecimal)BigDecimal.valueOf(100L), (boolean)false);
        ArrayList<BillRowVO> asstBills = new ArrayList<BillRowVO>(2);
        BillRowVO rowModel = new BillRowVO(payBill0, BigDecimal.valueOf(50L));
        BillRowVO rowModel0 = new BillRowVO(payBill1, BigDecimal.valueOf(50L));
        asstBills.add(rowModel);
        asstBills.add(rowModel0);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal(asstBills, (boolean)false);
        ApPayManualSettleService service = new ApPayManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getApSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Object[] mainIds = new Long[]{apBill.getLong("id")};
        Long[] asstIds = new Long[]{payBill0.getLong("id"), payBill1.getLong("id")};
        this.checkForSettleForTestApPay_001_2((Long[])mainIds, asstIds);
        Set settleRecordIds = ManualSettleUnitTestHelper.getSettleRecordIds((Long[])mainIds, (Long[])asstIds, (boolean)false);
        OperationResult unSettleResult = OperationServiceHelper.executeOperate((String)"unsettle", (String)"ap_settlerecord", (Object[])settleRecordIds.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unSettleResult);
        this.checkForUnSettleForTestApPay_001_2((Long[])mainIds, asstIds);
        service.manualSettle(mainRows, asstRows, param);
        this.checkForSettleForTestApPay_001_2((Long[])mainIds, asstIds);
        OperationResult unAuditRusult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])mainIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unAuditRusult);
        this.checkForUnSettleForTestApPay_001_2((Long[])mainIds, asstIds);
        for (DynamicObject bill : apBills = FinApBillTestDataProvider.loadData((Long[])mainIds)) {
            bill.set("billstatus", (Object)"C");
        }
        SaveServiceHelper.save((DynamicObject[])apBills);
        service.manualSettle(mainRows, asstRows, param);
        this.checkForSettleForTestApPay_001_2((Long[])mainIds, asstIds);
        OperationResult cancelPayRusult = OperationServiceHelper.executeOperate((String)"cancelpay", (String)"cas_paybill", (Object[])new Long[]{asstIds[0]}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)cancelPayRusult);
        Thread.sleep(20000L);
        this.checkForUnSettleForTestApPay_001_2_0((Long[])mainIds, asstIds, asstIds[0]);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u5e94\u4ed8\u4ed8\u6b3e-\u8ba1\u5212\u884c-\u5206\u5f55-\u4e00\u5bf9\u591a-\u76f8\u540c\u91d1\u989d")
    @Test
    public void testApPay_001_3() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinApBillDataDetailVO> entryInfoApList = new ArrayList<FinApBillDataDetailVO>(1);
        entryInfoApList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)));
        DynamicObject apBill = FinApBillTestDataProvider.buildByPriceAndQuantity((String)"ApPayManualSettle_FinAp_001_3", (DynamicObject)org, entryInfoApList);
        ArrayList<CasPayBillDataDetailVO> entryInfoPayList = new ArrayList<CasPayBillDataDetailVO>(1);
        entryInfoPayList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)));
        DynamicObject payBill0 = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((String)"ApPayManualSettle_CasPay_001_3_0", (DynamicObject)org, entryInfoPayList);
        ArrayList<CasPayBillDataDetailVO> entryInfoPayList1 = new ArrayList<CasPayBillDataDetailVO>(1);
        entryInfoPayList1.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)));
        DynamicObject payBill1 = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((String)"ApPayManualSettle_CasPay_001_3_1", (DynamicObject)org, entryInfoPayList1);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByEntry((DynamicObject)apBill, (DynamicObject)((DynamicObject)apBill.getDynamicObjectCollection("planentity").get(0)), (BigDecimal)BigDecimal.valueOf(100L), (boolean)false);
        ArrayList<EntryRowVO> asstBills = new ArrayList<EntryRowVO>(2);
        EntryRowVO row1 = new EntryRowVO(payBill0, (DynamicObject)payBill0.getDynamicObjectCollection("entry").get(0), BigDecimal.valueOf(50L));
        EntryRowVO row2 = new EntryRowVO(payBill1, (DynamicObject)payBill1.getDynamicObjectCollection("entry").get(0), BigDecimal.valueOf(50L));
        asstBills.add(row1);
        asstBills.add(row2);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByEntry(asstBills, (boolean)false);
        ApPayManualSettleService service = new ApPayManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(false);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getApSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{apBill.getLong("id")};
        Long[] asstIds = new Long[]{payBill0.getLong("id"), payBill1.getLong("id")};
        this.checkForSettleForTestApPay_001_3(mainIds, asstIds);
    }

    @TestMethod(value=4)
    @DisplayName(value="\u5e94\u4ed8\u4ed8\u6b3e-\u8ba1\u5212\u884c-\u5206\u5f55-\u4e00\u5bf9\u591a-\u76f8\u540c\u91d1\u989d-\u4e0d\u540c\u6c47\u7387")
    @Test
    public void testApPay_001_4() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        FinApBillDataVO apInfo = FinApBillDataVO.New().setBillNo("ApPayManualSettle_FinAp_001_4").setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyUSD().getLong("id"))).setExchangerate(BigDecimal.ONE).setOrg(org);
        ArrayList<FinApBillDataDetailVO> entryInfoApList = new ArrayList<FinApBillDataDetailVO>(1);
        entryInfoApList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)));
        DynamicObject apBill = FinApBillTestDataProvider.buildByPriceAndQuantity((FinApBillDataVO)apInfo, entryInfoApList);
        CasPayBillDataVO payInfo0 = CasPayBillDataVO.New().setBillNo("ApPayManualSettle_CasPay_001_4_0").setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyUSD().getLong("id"))).setExchangerate(BigDecimal.valueOf(2L)).setOrg(org);
        ArrayList<CasPayBillDataDetailVO> entryInfoPayList0 = new ArrayList<CasPayBillDataDetailVO>(1);
        entryInfoPayList0.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)));
        DynamicObject payBill0 = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((CasPayBillDataVO)payInfo0, entryInfoPayList0);
        CasPayBillDataVO payInfo1 = CasPayBillDataVO.New().setBillNo("ApPayManualSettle_CasPay_001_4_1").setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyUSD().getLong("id"))).setExchangerate(BigDecimal.valueOf(2L)).setOrg(org);
        ArrayList<CasPayBillDataDetailVO> entryInfoPayList1 = new ArrayList<CasPayBillDataDetailVO>(1);
        entryInfoPayList1.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)));
        DynamicObject payBill1 = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((CasPayBillDataVO)payInfo1, entryInfoPayList1);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByEntry((DynamicObject)apBill, (DynamicObject)((DynamicObject)apBill.getDynamicObjectCollection("planentity").get(0)), (BigDecimal)BigDecimal.valueOf(100L), (boolean)false);
        ArrayList<EntryRowVO> asstBills = new ArrayList<EntryRowVO>(2);
        EntryRowVO row1 = new EntryRowVO(payBill0, (DynamicObject)payBill0.getDynamicObjectCollection("entry").get(0), BigDecimal.valueOf(50L));
        EntryRowVO row2 = new EntryRowVO(payBill1, (DynamicObject)payBill1.getDynamicObjectCollection("entry").get(0), BigDecimal.valueOf(50L));
        asstBills.add(row1);
        asstBills.add(row2);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByEntry(asstBills, (boolean)false);
        ApPayManualSettleService service = new ApPayManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(false);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getApSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{apBill.getLong("id")};
        Long[] asstIds = new Long[]{payBill0.getLong("id"), payBill1.getLong("id")};
        this.checkForSettleForTestApPay_001_4(mainIds, asstIds);
    }

    @TestMethod(value=5)
    @DisplayName(value="\u5e94\u4ed8\u4ed8\u6b3e(\u9884\u4ed8)-\u8ba1\u5212\u884c-\u6574\u5355-\u4e00\u5bf9\u591a-\u76f8\u540c\u91d1\u989d")
    @Test
    public void testApPay_001_5() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinApBillDataDetailVO> entryInfoApList = new ArrayList<FinApBillDataDetailVO>(1);
        entryInfoApList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)));
        DynamicObject apBill = FinApBillTestDataProvider.buildByPriceAndQuantity((String)"ApPayManualSettle_FinAp_001_5", (DynamicObject)org, entryInfoApList);
        ArrayList<PaidBillDataDetailVO> entryInfoPayList = new ArrayList<PaidBillDataDetailVO>(1);
        entryInfoPayList.add(PaidBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)));
        DynamicObject payBill0 = PaidBillTestDataProvider.buildByEntryPriceTaxTotal((String)"ApPayManualSettle_Paid_001_5_0", (DynamicObject)org, entryInfoPayList);
        ArrayList<PaidBillDataDetailVO> entryInfoPayList1 = new ArrayList<PaidBillDataDetailVO>(1);
        entryInfoPayList1.add(PaidBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)));
        DynamicObject payBill1 = PaidBillTestDataProvider.buildByEntryPriceTaxTotal((String)"ApPayManualSettle_Paid_001_5_1", (DynamicObject)org, entryInfoPayList1);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByEntry((DynamicObject)apBill, (DynamicObject)((DynamicObject)apBill.getDynamicObjectCollection("planentity").get(0)), (BigDecimal)BigDecimal.valueOf(100L), (boolean)false);
        ArrayList<EntryRowVO> asstBills = new ArrayList<EntryRowVO>(2);
        EntryRowVO row1 = new EntryRowVO(payBill0, (DynamicObject)payBill0.getDynamicObjectCollection("entry").get(0), BigDecimal.valueOf(50L));
        EntryRowVO row2 = new EntryRowVO(payBill1, (DynamicObject)payBill1.getDynamicObjectCollection("entry").get(0), BigDecimal.valueOf(50L));
        asstBills.add(row1);
        asstBills.add(row2);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByEntry(asstBills, (boolean)false);
        ApPayManualSettleService service = new ApPayManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getApSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{apBill.getLong("id")};
        Long[] asstIds = new Long[]{payBill0.getLong("id"), payBill1.getLong("id")};
        this.checkForSettleForTestApPay_001_5(mainIds, asstIds);
        Set settleRecordIds = ManualSettleUnitTestHelper.getSettleRecordIds((Long[])mainIds, (Long[])asstIds, (boolean)false);
        OperationResult unSettleResult = OperationServiceHelper.executeOperate((String)"unsettle", (String)"ap_settlerecord", (Object[])settleRecordIds.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unSettleResult);
        this.checkForUnSettleForTestApPay_001_5(mainIds, asstIds);
    }

    @TestMethod(value=6)
    @DisplayName(value="\u5e94\u4ed8\u4ed8\u6b3e-\u7269\u6599\u884c-\u6574\u5355-\u4e00\u5bf9\u4e00-\u540c\u91d1\u989d")
    @Test
    public void testApPay_001_6() throws InterruptedException {
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        ArrayList<FinApBillDataDetailVO> entryInfoApList = new ArrayList<FinApBillDataDetailVO>(2);
        entryInfoApList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        entryInfoApList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(2));
        DynamicObject apBill = FinApBillTestDataProvider.buildByPriceAndQuantity((String)"ApPayManualSettle_FinAp_001_6", (DynamicObject)org, entryInfoApList);
        ArrayList<CasPayBillDataDetailVO> entryInfoPayList = new ArrayList<CasPayBillDataDetailVO>(2);
        entryInfoPayList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(1));
        entryInfoPayList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(2));
        DynamicObject payBill = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((String)"ApPayManualSettle_CasPay_001_6", (DynamicObject)org, entryInfoPayList);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal((DynamicObject)apBill, (BigDecimal)BigDecimal.valueOf(200L), (boolean)false);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal((DynamicObject)payBill, (BigDecimal)BigDecimal.valueOf(200L), (boolean)false);
        ApPayManualSettleService service = new ApPayManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getApSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{apBill.getLong("id")};
        Object[] asstIds = new Long[]{payBill.getLong("id")};
        this.checkForSettleForTestApPay_001_6(mainIds, (Long[])asstIds);
        OperationResult cancelPayRusult = OperationServiceHelper.executeOperate((String)"cancelpay", (String)"cas_paybill", (Object[])asstIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)cancelPayRusult);
        Thread.sleep(20000L);
        this.checkForUnSettleForTestApPay_001_6(mainIds, (Long[])asstIds);
    }

    @TestMethod(value=7)
    @DisplayName(value="\u5e94\u4ed8\u4ed8\u6b3e-\u7269\u6599\u884c-\u6574\u5355-\u4e00\u5bf9\u4e00-\u540c\u91d1\u989d-\u6b63\u8d1f\u5206\u5f55")
    @Test
    public void testApPay_001_7() throws InterruptedException {
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        ArrayList<FinApBillDataDetailVO> entryInfoApList = new ArrayList<FinApBillDataDetailVO>(2);
        entryInfoApList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(2L)).setSeq(1));
        entryInfoApList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(-1L)).setSeq(2));
        DynamicObject apBill = FinApBillTestDataProvider.buildByPriceAndQuantity((String)"ApPayManualSettle_FinAp_001_7", (DynamicObject)org, entryInfoApList);
        ArrayList<CasPayBillDataDetailVO> entryInfoPayList = new ArrayList<CasPayBillDataDetailVO>(2);
        entryInfoPayList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(200L)).setSeq(1));
        entryInfoPayList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(-100L)).setSeq(2));
        DynamicObject payBill = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((String)"ApPayManualSettle_CasPay_001_7", (DynamicObject)org, entryInfoPayList);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal((DynamicObject)apBill, (BigDecimal)BigDecimal.valueOf(100L), (boolean)false);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal((DynamicObject)payBill, (BigDecimal)BigDecimal.valueOf(100L), (boolean)false);
        ApPayManualSettleService service = new ApPayManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getApSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{apBill.getLong("id")};
        Object[] asstIds = new Long[]{payBill.getLong("id")};
        this.checkForSettleForTestApPay_001_7(mainIds, (Long[])asstIds);
        OperationResult cancelPayRusult = OperationServiceHelper.executeOperate((String)"cancelpay", (String)"cas_paybill", (Object[])asstIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)cancelPayRusult);
        Thread.sleep(20000L);
        this.checkForUnSettleForTestApPay_001_7(mainIds, (Long[])asstIds);
    }

    @TestMethod(value=8)
    @DisplayName(value="\u5e94\u4ed8\u4ed8\u6b3e-\u7269\u6599\u884c-\u5206\u5f55-\u4e00\u5bf9\u591a-\u540c\u91d1\u989d")
    @Test
    public void testApPay_001_8() {
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        ArrayList<FinApBillDataDetailVO> entryInfoApList = new ArrayList<FinApBillDataDetailVO>(1);
        entryInfoApList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)));
        DynamicObject apBill = FinApBillTestDataProvider.buildByPriceAndQuantity((String)"ApPayMS_FinAp_001_8", (DynamicObject)org, entryInfoApList);
        ArrayList<CasPayBillDataDetailVO> entryInfoPayList = new ArrayList<CasPayBillDataDetailVO>(1);
        entryInfoPayList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)));
        DynamicObject payBill0 = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((String)"ApPayMS_CasPay_001_8_1", (DynamicObject)org, entryInfoPayList);
        ArrayList<CasPayBillDataDetailVO> entryInfoPayList1 = new ArrayList<CasPayBillDataDetailVO>(1);
        entryInfoPayList1.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)));
        DynamicObject payBill1 = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((String)"ApPayMS_CasPay_001_8_2", (DynamicObject)org, entryInfoPayList1);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByEntry((DynamicObject)apBill, (DynamicObject)((DynamicObject)apBill.getDynamicObjectCollection("detailentry").get(0)), (BigDecimal)BigDecimal.valueOf(50L), (boolean)false);
        ArrayList<EntryRowVO> asstBills = new ArrayList<EntryRowVO>(2);
        EntryRowVO row1 = new EntryRowVO(payBill0, (DynamicObject)payBill0.getDynamicObjectCollection("entry").get(0), BigDecimal.valueOf(25L));
        EntryRowVO row2 = new EntryRowVO(payBill1, (DynamicObject)payBill1.getDynamicObjectCollection("entry").get(0), BigDecimal.valueOf(25L));
        asstBills.add(row1);
        asstBills.add(row2);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByEntry(asstBills, (boolean)false);
        ApPayManualSettleService service = new ApPayManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(false);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getApSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{apBill.getLong("id")};
        Long[] asstIds = new Long[]{payBill0.getLong("id"), payBill1.getLong("id")};
        this.checkForSettleForTestApPay_001_8_1(mainIds, asstIds);
        service.manualSettle(mainRows, asstRows, param);
        this.checkForSettleForTestApPay_001_8_2(mainIds, asstIds);
    }

    private void checkForSettleForTestApPay_001_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateApFinHeadSettleStatus((DynamicObject)needCheckMainBill, (String)"partsettle");
        FinApBillTestChecker.validateApFinHeadSettleAmt((DynamicObject)needCheckMainBill, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(150L), (BigDecimal)BigDecimal.valueOf(150L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry0, (BigDecimal)BigDecimal.valueOf(75L), (BigDecimal)BigDecimal.valueOf(25L), (BigDecimal)BigDecimal.valueOf(75L), (BigDecimal)BigDecimal.valueOf(75L), (BigDecimal)BigDecimal.valueOf(25L), (BigDecimal)BigDecimal.valueOf(25L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry1, (BigDecimal)BigDecimal.valueOf(75L), (BigDecimal)BigDecimal.valueOf(25L), (BigDecimal)BigDecimal.valueOf(75L), (BigDecimal)BigDecimal.valueOf(75L), (BigDecimal)BigDecimal.valueOf(25L), (BigDecimal)BigDecimal.valueOf(25L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)planEntry0, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObject planEntry1 = (DynamicObject)planEntries.get(1);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)planEntry1, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L));
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        DynamicObjectCollection entries = needCheckAsstBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt((DynamicObject)entry0, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObject entry1 = (DynamicObject)entries.get(1);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt((DynamicObject)entry1, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForUnSettleForTestApPay_001_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateApFinHeadSettleStatus((DynamicObject)needCheckMainBill, (String)"unsettle");
        FinApBillTestChecker.validateApFinHeadSettleAmt((DynamicObject)needCheckMainBill, (BigDecimal)BigDecimal.valueOf(200L), (BigDecimal)BigDecimal.valueOf(200L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry0, (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry1, (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)planEntry0, (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L));
        DynamicObject planEntry1 = (DynamicObject)planEntries.get(1);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)planEntry1, (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L));
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        DynamicObjectCollection entries = needCheckAsstBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt((DynamicObject)entry0, (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L));
        DynamicObject entry1 = (DynamicObject)entries.get(1);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt((DynamicObject)entry1, (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L));
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForSettleForTestApPay_001_2(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateApFinHeadSettleStatus((DynamicObject)needCheckMainBill, (String)"settled");
        FinApBillTestChecker.validateApFinHeadSettleAmt((DynamicObject)needCheckMainBill, (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry0, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)planEntry0, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        DynamicObjectCollection entries = needCheckAsstBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt((DynamicObject)entry0, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObject needCheckAsstBill0 = needCheckAsstBills[1];
        DynamicObjectCollection entries0 = needCheckAsstBill0.getDynamicObjectCollection("entry");
        DynamicObject entry0_0 = (DynamicObject)entries0.get(0);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt((DynamicObject)entry0_0, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForSettleForTestApPay_001_3(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateApFinHeadSettleStatus((DynamicObject)needCheckMainBill, (String)"settled");
        FinApBillTestChecker.validateApFinHeadSettleAmt((DynamicObject)needCheckMainBill, (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry0, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)planEntry0, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        DynamicObjectCollection entries = needCheckAsstBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt((DynamicObject)entry0, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObject needCheckAsstBill0 = needCheckAsstBills[1];
        DynamicObjectCollection entries0 = needCheckAsstBill0.getDynamicObjectCollection("entry");
        DynamicObject entry0_0 = (DynamicObject)entries0.get(0);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt((DynamicObject)entry0_0, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForSettleForTestApPay_001_4(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateApFinHeadSettleStatus((DynamicObject)needCheckMainBill, (String)"settled");
        FinApBillTestChecker.validateApFinHeadSettleAmt((DynamicObject)needCheckMainBill, (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry0, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)planEntry0, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        DynamicObjectCollection entries = needCheckAsstBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt((DynamicObject)entry0, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObject needCheckAsstBill0 = needCheckAsstBills[1];
        DynamicObjectCollection entries0 = needCheckAsstBill0.getDynamicObjectCollection("entry");
        DynamicObject entry0_0 = (DynamicObject)entries0.get(0);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt((DynamicObject)entry0_0, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData((Long[])mainIds, (Long[])asstIds, (boolean)false);
        KDAssert.assertEquals((boolean)true, (settleRecords.length == 1 ? 1 : 0) != 0);
        DynamicObject settleRecord = settleRecords[0];
        SettleRecordTestChecker.checkSwapL((DynamicObject)settleRecord, (BigDecimal)BigDecimal.valueOf(100L));
    }

    private void checkForSettleForTestApPay_001_5(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateApFinHeadSettleStatus((DynamicObject)needCheckMainBill, (String)"settled");
        FinApBillTestChecker.validateApFinHeadSettleAmt((DynamicObject)needCheckMainBill, (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry0, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)planEntry0, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObject[] needCheckAsstBills = PaidBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        DynamicObjectCollection entries = needCheckAsstBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        PaidSettleTestChecker.checkEntry((DynamicObject)entry0, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObject needCheckAsstBill0 = needCheckAsstBills[1];
        DynamicObjectCollection entries0 = needCheckAsstBill0.getDynamicObjectCollection("entry");
        DynamicObject entry0_0 = (DynamicObject)entries0.get(0);
        PaidSettleTestChecker.checkEntry((DynamicObject)entry0_0, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(0L));
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForSettleForTestApPay_001_6(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateApFinHeadSettleStatus((DynamicObject)needCheckMainBill, (String)"settled");
        FinApBillTestChecker.validateApFinHeadSettleAmt((DynamicObject)needCheckMainBill, (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(200L), (BigDecimal)BigDecimal.valueOf(200L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry0, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry1, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)planEntry0, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObject planEntry1 = (DynamicObject)planEntries.get(1);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)planEntry1, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        DynamicObjectCollection entries = needCheckAsstBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt((DynamicObject)entry0, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObject entry1 = (DynamicObject)entries.get(1);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt((DynamicObject)entry1, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForSettleForTestApPay_001_7(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateApFinHeadSettleStatus((DynamicObject)needCheckMainBill, (String)"settled");
        FinApBillTestChecker.validateApFinHeadSettleAmt((DynamicObject)needCheckMainBill, (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry0, (BigDecimal)BigDecimal.valueOf(200L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(200L), (BigDecimal)BigDecimal.valueOf(200L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry1, (BigDecimal)BigDecimal.valueOf(-100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(-100L), (BigDecimal)BigDecimal.valueOf(-100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)planEntry0, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        DynamicObjectCollection entries = needCheckAsstBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt((DynamicObject)entry0, (BigDecimal)BigDecimal.valueOf(200L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(200L), (BigDecimal)BigDecimal.valueOf(200L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObject entry1 = (DynamicObject)entries.get(1);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt((DynamicObject)entry1, (BigDecimal)BigDecimal.valueOf(-100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(-100L), (BigDecimal)BigDecimal.valueOf(-100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForSettleForTestApPay_001_8_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateApFinHeadSettleStatus((DynamicObject)needCheckMainBill, (String)"partsettle");
        FinApBillTestChecker.validateApFinHeadSettleAmt((DynamicObject)needCheckMainBill, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry0, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)planEntry0, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L));
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        DynamicObjectCollection entries = needCheckAsstBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt((DynamicObject)entry0, (BigDecimal)BigDecimal.valueOf(25L), (BigDecimal)BigDecimal.valueOf(25L), (BigDecimal)BigDecimal.valueOf(25L), (BigDecimal)BigDecimal.valueOf(25L), (BigDecimal)BigDecimal.valueOf(25L), (BigDecimal)BigDecimal.valueOf(25L));
        DynamicObject needCheckAsstBill0 = needCheckAsstBills[1];
        DynamicObjectCollection entries0 = needCheckAsstBill0.getDynamicObjectCollection("entry");
        DynamicObject entry0_0 = (DynamicObject)entries0.get(0);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt((DynamicObject)entry0_0, (BigDecimal)BigDecimal.valueOf(25L), (BigDecimal)BigDecimal.valueOf(25L), (BigDecimal)BigDecimal.valueOf(25L), (BigDecimal)BigDecimal.valueOf(25L), (BigDecimal)BigDecimal.valueOf(25L), (BigDecimal)BigDecimal.valueOf(25L));
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForSettleForTestApPay_001_8_2(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateApFinHeadSettleStatus((DynamicObject)needCheckMainBill, (String)"settled");
        FinApBillTestChecker.validateApFinHeadSettleAmt((DynamicObject)needCheckMainBill, (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry0, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)planEntry0, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        DynamicObjectCollection entries = needCheckAsstBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt((DynamicObject)entry0, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObject needCheckAsstBill0 = needCheckAsstBills[1];
        DynamicObjectCollection entries0 = needCheckAsstBill0.getDynamicObjectCollection("entry");
        DynamicObject entry0_0 = (DynamicObject)entries0.get(0);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt((DynamicObject)entry0_0, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForUnSettleForTestApPay_001_2(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateApFinHeadSettleStatus((DynamicObject)needCheckMainBill, (String)"unsettle");
        FinApBillTestChecker.validateApFinHeadSettleAmt((DynamicObject)needCheckMainBill, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry0, (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)planEntry0, (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L));
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        DynamicObjectCollection entries = needCheckAsstBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt((DynamicObject)entry0, (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L));
        DynamicObject needCheckAsstBill0 = needCheckAsstBills[1];
        DynamicObjectCollection entries0 = needCheckAsstBill0.getDynamicObjectCollection("entry");
        DynamicObject entry0_0 = (DynamicObject)entries0.get(0);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt((DynamicObject)entry0_0, (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L));
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForUnSettleForTestApPay_001_2_0(Long[] mainIds, Long[] asstIds, Long cancelPayAsstId) {
        DynamicObject[] needCheckAsstBills;
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateApFinHeadSettleStatus((DynamicObject)needCheckMainBill, (String)"partsettle");
        FinApBillTestChecker.validateApFinHeadSettleAmt((DynamicObject)needCheckMainBill, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry0, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)planEntry0, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L));
        for (DynamicObject needCheckAsstBill : needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])asstIds)) {
            Long asstBillId = needCheckAsstBill.getLong("id");
            DynamicObjectCollection entries = needCheckAsstBill.getDynamicObjectCollection("entry");
            DynamicObject entry = (DynamicObject)entries.get(0);
            if (asstBillId.equals(cancelPayAsstId)) {
                CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt((DynamicObject)entry, (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L));
                continue;
            }
            CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt((DynamicObject)entry, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        }
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData((Long[])mainIds, (Long[])asstIds, (boolean)false);
        KDAssert.assertEquals((boolean)true, (settleRecords.length == 1 ? 1 : 0) != 0);
        DynamicObject settleRecord = settleRecords[0];
        SettleRecordTestChecker.checkSettleAmt((DynamicObject)settleRecord, (BigDecimal)BigDecimal.valueOf(50L));
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForUnSettleForTestApPay_001_5(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateApFinHeadSettleStatus((DynamicObject)needCheckMainBill, (String)"unsettle");
        FinApBillTestChecker.validateApFinHeadSettleAmt((DynamicObject)needCheckMainBill, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry0, (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)planEntry0, (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L));
        DynamicObject[] needCheckAsstBills = PaidBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        DynamicObjectCollection entries = needCheckAsstBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        PaidSettleTestChecker.checkEntry((DynamicObject)entry0, (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(50L));
        DynamicObject needCheckAsstBill0 = needCheckAsstBills[1];
        DynamicObjectCollection entries0 = needCheckAsstBill0.getDynamicObjectCollection("entry");
        DynamicObject entry0_0 = (DynamicObject)entries0.get(0);
        PaidSettleTestChecker.checkEntry((DynamicObject)entry0_0, (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(50L));
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForUnSettleForTestApPay_001_6(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateApFinHeadSettleStatus((DynamicObject)needCheckMainBill, (String)"unsettle");
        FinApBillTestChecker.validateApFinHeadSettleAmt((DynamicObject)needCheckMainBill, (BigDecimal)BigDecimal.valueOf(200L), (BigDecimal)BigDecimal.valueOf(200L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry0, (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry1, (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)planEntry0, (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L));
        DynamicObject planEntry1 = (DynamicObject)planEntries.get(1);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)planEntry1, (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L));
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        DynamicObjectCollection entries = needCheckAsstBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt((DynamicObject)entry0, (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L));
        DynamicObject entry1 = (DynamicObject)entries.get(1);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt((DynamicObject)entry1, (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L));
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForUnSettleForTestApPay_001_7(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateApFinHeadSettleStatus((DynamicObject)needCheckMainBill, (String)"partsettle");
        FinApBillTestChecker.validateApFinHeadSettleAmt((DynamicObject)needCheckMainBill, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry0, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry1, (BigDecimal)BigDecimal.valueOf(-100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(-100L), (BigDecimal)BigDecimal.valueOf(-100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)planEntry0, (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L));
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        DynamicObjectCollection entries = needCheckAsstBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt((DynamicObject)entry0, (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(200L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(200L), (BigDecimal)BigDecimal.valueOf(200L));
        DynamicObject entry1 = (DynamicObject)entries.get(1);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt((DynamicObject)entry1, (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(-100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(-100L), (BigDecimal)BigDecimal.valueOf(-100L));
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }
}

