/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.unittest.scene.settle;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.unittest.AbstractJUnitTestWithOutFormPlugIn;
import kd.fi.ap.mservice.ApArManualSettleService;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.FinArBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinApBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinArBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.FinApBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.FinArBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.helper.FinApBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.SettleRecordTestHelper;
import kd.fi.arapcommon.unittest.scene.process.settle.EntryRowVO;
import kd.fi.arapcommon.unittest.scene.process.settle.ManualSettleUnitTestHelper;
import kd.fi.arapcommon.vo.ManualSettleParam;
import org.junit.Test;

public class AP016_017_ApArManualSettle2WriteOffTest
extends AbstractJUnitTestWithOutFormPlugIn {
    @TestMethod(value=1)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8\u4e0e\u5e94\u6536\u624b\u5de5\u7ed3\u7b97 AND \u8d22\u52a1\u5e94\u4ed8-\u51b2\u9500(\u8ba1\u5212\u884c)")
    @Test
    public void ApFinUnitTest_001() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinApBillDataDetailVO> entryInfoApList = new ArrayList<FinApBillDataDetailVO>(1);
        entryInfoApList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.ONE));
        DynamicObject apBill = FinApBillTestDataProvider.buildByPriceAndQuantity((String)"AP016_017_apfin_1", (DynamicObject)org, entryInfoApList);
        long apBillId = apBill.getLong("id");
        ArrayList<FinArBillDataDetailVO> entryInfoArList = new ArrayList<FinArBillDataDetailVO>(2);
        entryInfoArList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.ONE));
        DynamicObject arBill = FinArBillTestDataProvider.buildByPriceAndQuantity((String)"AP016_017_arfin_1", (DynamicObject)org, entryInfoArList);
        long arBillId = arBill.getLong("id");
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByEntry((DynamicObject)apBill, (DynamicObject)((DynamicObject)apBill.getDynamicObjectCollection("planentity").get(0)), (BigDecimal)BigDecimal.valueOf(100L), (boolean)false);
        ArrayList<EntryRowVO> asstBills = new ArrayList<EntryRowVO>(2);
        asstBills.add(new EntryRowVO(arBill, (DynamicObject)arBill.getDynamicObjectCollection("planentity").get(0), BigDecimal.valueOf(100L)));
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByEntry(asstBills, (boolean)false);
        ApArManualSettleService service = new ApArManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(false);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getApSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        DynamicObject writeOffBill = FinApBillTestHelper.executeAndGetWriteOffBill((long)apBillId);
        this.validateData(apBillId, writeOffBill, arBillId);
        OperationResult unAudit = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Long[]{writeOffBill.getLong("id")}, (OperateOption)OperateOption.create());
        AP016_017_ApArManualSettle2WriteOffTest.assertEquals((String)"\u51b2\u9500\u5355\u53cd\u5ba1\u6838\u5931\u8d25", (boolean)true, (boolean)unAudit.isSuccess());
        FinApBillTestChecker.validateInitialApFin((long)apBillId);
    }

    private void validateData(long apBillId, DynamicObject writeOffBill, long arBillId) {
        FinApBillTestChecker.validateFinishApFin((long)apBillId, (boolean)true, (boolean)true);
        long writerOffId = writeOffBill.getLong("id");
        FinApBillTestChecker.validateApFinVerifyRecordData((long)apBillId, (long)writerOffId);
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])new Long[]{apBillId}, (Long[])new Long[]{writerOffId}, (boolean)false);
        FinApBillTestChecker.validateFinishApFin((DynamicObject)writeOffBill, (boolean)true, (boolean)true);
        DynamicObject arBill = BusinessDataServiceHelper.loadSingle((Object)arBillId, (String)"ar_finarbill");
        FinArBillTestChecker.validateInitialBill((DynamicObject)arBill);
        DynamicObject[] arApSettleRecords = SettleRecordTestHelper.loadData((Long[])new Long[]{apBillId}, (Long[])new Long[]{arBillId}, (boolean)false);
        AP016_017_ApArManualSettle2WriteOffTest.assertEquals((String)"\u6e90\u8d22\u52a1\u5e94\u4ed8\u5355\u548c\u4ed8\u6b3e\u5355\u7684\u7ed3\u7b97\u8bb0\u5f55\u5e94\u8be5\u4e3a2\u6761", (boolean)true, (arApSettleRecords.length == 2 ? 1 : 0) != 0);
        SettleRecordTestChecker.checkSettleAmtAndJournal((DynamicObject[])arApSettleRecords);
    }
}

