/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class ApBusMostSrcFieldUpgradePlugin
implements IUpgradeService {
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        if (ArApHelper.queryApIsNotInit()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
            resultMap.put("info", "is not need Upgrade");
            resultMap.put("success", Boolean.TRUE);
            return new UpgradeResult(resultMap);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        boolean success = true;
        String log = "ArApBusMostSrcFieldUpgradePlugin Upgrade SUCCESS!";
        String info = "ArApBusMostSrcFieldUpgradePlugin Upgrade SUCCESS!";
        resultMap.put("success", success);
        resultMap.put("log", log);
        resultMap.put("el", "");
        resultMap.put("info", info);
        try {
            this.upgrade();
        }
        catch (Exception e) {
            info = log = ArApHelper.getStackTraceMessage((Throwable)e);
            resultMap.put("success", success);
            resultMap.put("log", log);
            resultMap.put("el", "");
            resultMap.put("info", info);
        }
        return new UpgradeResult(resultMap);
    }

    private void upgrade() {
        this.upgradeBusBills(false);
    }

    private void upgradeBusBills(boolean isAr) {
        String billEntity = isAr ? "ar_busbill" : "ap_busbill";
        QFilter filter = new QFilter("writeoffbusiness", "=", (Object)Boolean.TRUE);
        filter.and(new QFilter("isadjust", "=", (Object)Boolean.TRUE));
        String selector = "id,sourcebillid,entry.id,entry.e_srcentryid,entry.e_srcbillid,mostsrcbusbillid,entry.e_mostsrcbusentryid,entry.e_mostsrcbusbillid";
        DynamicObject[] allWriteOffBill = BusinessDataServiceHelper.load((String)billEntity, (String)selector, (QFilter[])new QFilter[]{filter});
        if (allWriteOffBill.length == 0) {
            return;
        }
        HashMap<Long, DynamicObject> allWriteOffBillMap = new HashMap<Long, DynamicObject>(64);
        HashMap<Long, DynamicObject> busBillRowMap = new HashMap<Long, DynamicObject>(64);
        for (DynamicObject busBill : allWriteOffBill) {
            allWriteOffBillMap.put(busBill.getLong("id"), busBill);
            DynamicObjectCollection entry = busBill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                busBillRowMap.put(row.getLong("id"), row);
            }
        }
        ArrayList<DynamicObject> toSaveWriteOffBills = new ArrayList<DynamicObject>(allWriteOffBill.length);
        Iterator iterator = allWriteOffBillMap.entrySet().iterator();
        while (iterator.hasNext()) {
            DynamicObject writeOffBill = (DynamicObject)iterator.next().getValue();
            Long sourceBillId = writeOffBill.getLong("sourcebillid");
            DynamicObject srcAdjustBill = (DynamicObject)allWriteOffBillMap.get(sourceBillId);
            if (srcAdjustBill == null) continue;
            writeOffBill.set("mostsrcbusbillid", (Object)srcAdjustBill.getLong("sourcebillid"));
            DynamicObjectCollection entry = writeOffBill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                DynamicObject srcAdjustRow = (DynamicObject)busBillRowMap.get(row.getLong("e_srcentryid"));
                if (srcAdjustRow == null) continue;
                row.set("e_mostsrcbusentryid", srcAdjustRow.get("e_srcentryid"));
                row.set("e_mostsrcbusbillid", srcAdjustRow.get("e_srcbillid"));
            }
            toSaveWriteOffBills.add(writeOffBill);
        }
        if (EmptyUtils.isNotEmpty(toSaveWriteOffBills)) {
            SaveServiceHelper.save((DynamicObject[])toSaveWriteOffBills.toArray(new DynamicObject[0]));
        }
    }
}

