/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.enums.InvoiceType;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.InvoiceTypeHelper;

public class ApFinInvTypeUpgradePlugin
implements IUpgradeService {
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String info = "ApFinInvTypeUpgradePlugin Upgrade SUCCESS!";
        boolean success = true;
        try (TXHandle tx = TX.required((String)"beginUpgradeTask");){
            try {
                String qrySql = "select finvoicetype,fentryid from t_ap_finapbillinventry;";
                DataSet upgradeDatas = DB.queryDataSet((String)"ApFinInvTypeUpgradePlugin", (DBRoute)DBRouteConst.AP, (String)qrySql);
                ArrayList<Object[]> updateParams = new ArrayList<Object[]>(32);
                Map invoiceTypePKMap = InvoiceTypeHelper.getInvoiceTypePKMap();
                for (Row upgradeData : upgradeDatas) {
                    String typeStr = upgradeData.getString("finvoicetype");
                    Long invTypeId = invoiceTypePKMap.computeIfAbsent(InvoiceType.getTypeNo((String)typeStr), v -> 0L);
                    if (invTypeId == 0L) continue;
                    Object[] params = new Object[]{invTypeId, upgradeData.getLong("fentryid")};
                    updateParams.add(params);
                }
                String updateSql = "update t_ap_finapbillinventry set finvoicetypeid = ? where fentryid = ? ;";
                DB.executeBatch((DBRoute)DBRouteConst.AP, (String)updateSql, updateParams);
            }
            catch (Exception exc) {
                tx.markRollback();
                info = ArApHelper.getStackTraceMessage((Throwable)exc);
            }
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        resultMap.put("success", success);
        resultMap.put("log", info);
        resultMap.put("el", "");
        resultMap.put("info", info);
        return new UpgradeResult(resultMap);
    }
}

