/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.upgrade;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.service.upgrade.AbstractUpgradeHandle;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.vo.UpgradeConfigEntryVO;

public class ApJournalBusAmountNoTaxUpgradeHandle
extends AbstractUpgradeHandle {
    protected void upgrade(List<Long> billIds) {
        String sql = "select fid,famount,flocalamt from t_ap_busbill where fid in (" + StringUtils.join((Object[])billIds.toArray(), (String)",") + ");";
        DataSet busBills = DB.queryDataSet((String)"ApJournalBusAmountNoTaxUpgradeHandle.QueryBusBill", (DBRoute)DBRouteConst.AP, (String)sql);
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(billIds.size());
        for (Row busbill : busBills) {
            Object[] params = new Object[]{busbill.getBigDecimal("famount"), busbill.getBigDecimal("flocalamt"), busbill.getLong("fid")};
            updateParams.add(params);
        }
        if (!ObjectUtils.isEmpty(updateParams)) {
            String updateSql = "update t_ap_journal set festimatednotaxamt = ?, flocalestimatednotaxamt = ? where fsourcebillid = ? ";
            DB.executeBatch((DBRoute)DBRouteConst.AP, (String)updateSql, updateParams);
        }
    }

    protected String queryBillIdSql(UpgradeConfigEntryVO entryVO) {
        String beginDate = DateUtils.formatString((Date)entryVO.getDataStartDate(), (String)"yyyy-MM-dd HH:mm:ss");
        String filterSql = "select fsourcebillid fid from " + entryVO.getTableName() + " where fsourcebilltype = 'ap_busbill' and " + this.getDateFieldName() + " >= '" + beginDate + "'";
        if (entryVO.getDataEndTime() != null) {
            String endDate = DateUtils.formatString((Date)entryVO.getDataEndTime(), (String)"yyyy-MM-dd HH:mm:ss");
            filterSql = filterSql + " and " + this.getDateFieldName() + " <= '" + endDate + "'";
        }
        return filterSql;
    }
}

