/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.helper.ArApHelper;

public class ApSettleRecordBillTypeUpgradePlugin
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        if (ArApHelper.queryApIsNotInit()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
            resultMap.put("info", "is not need Upgrade");
            resultMap.put("success", Boolean.TRUE);
            return new UpgradeResult(resultMap);
        }
        return new UpgradeResult(this.beforeExecuteSql(ver, iteration, dbKey, sqlFileName));
    }

    public Map<String, Object> beforeExecuteSql(String ver, String iteration, String dbKey, String sqlFileName) {
        boolean success = true;
        String log = "Ap SettleRecord BillType Upgrade SUCCESS!";
        String info = "Ap SettleRecord BillType Upgrade SUCCESS!";
        try {
            this.upgrade();
        }
        catch (Exception e) {
            info = log = this.getStackTraceMessage(e);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        resultMap.put("success", success);
        resultMap.put("log", log);
        resultMap.put("el", "");
        resultMap.put("info", info);
        return resultMap;
    }

    private void upgrade() {
        String settleRecordQuerySql = "SELECT FMAINBILLID FROM T_AP_SETTLERECORD WHERE FBILLTYPE = ' ' AND FMAINBILLENTITY = 'ap_finapbill'";
        DataSet settleRecordDataSet = DB.queryDataSet((String)"AP.QUERYSETTLERECORD", (DBRoute)DBRouteConst.AP, (String)settleRecordQuerySql);
        ArrayList<Long> apbillPks = new ArrayList<Long>(100);
        for (Row row : settleRecordDataSet) {
            apbillPks.add(row.getLong("FMAINBILLID"));
        }
        String settleRecordUpadateSql = "UPDATE T_AP_SETTLERECORD SET FBILLTYPE = ?  WHERE FMAINBILLID = ?";
        QFilter filter = new QFilter("id", "in", apbillPks);
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"id,billtypeid", (QFilter[])filter.toArray());
        ArrayList<Object[]> params = new ArrayList<Object[]>(100);
        for (DynamicObject bill : bills) {
            String billtype = bill.getString("billtypeid.number");
            Long id = bill.getLong("id");
            if (!StringUtils.isNotEmpty((String)billtype) || id == null) continue;
            Object[] param = new Object[]{billtype, id};
            params.add(param);
        }
        if (params.size() > 0) {
            DB.executeBatch((DBRoute)DBRouteConst.AP, (String)settleRecordUpadateSql, params);
        }
        String settleRecordEntryQuerySql = "SELECT FBILLID FROM T_AP_SETTLERECORDENTRY WHERE FBILLTYPE = ' ' AND FBILLENTITY = 'ap_finapbill'";
        DataSet settleRecordEntryDataSet = DB.queryDataSet((String)"AP.QUERYSETTLERECORDENTRY", (DBRoute)DBRouteConst.AP, (String)settleRecordEntryQuerySql);
        ArrayList<Long> apbillPks0 = new ArrayList<Long>(100);
        for (Row row : settleRecordEntryDataSet) {
            apbillPks0.add(row.getLong("FBILLID"));
        }
        String settleRecordEntryUpadateSql = "UPDATE T_AP_SETTLERECORDENTRY SET FBILLTYPE = ?  WHERE FBILLID = ?";
        QFilter filter0 = new QFilter("id", "in", apbillPks0);
        DynamicObject[] bills0 = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"id,billtypeid", (QFilter[])filter0.toArray());
        ArrayList<Object[]> params0 = new ArrayList<Object[]>(100);
        for (DynamicObject bill : bills0) {
            String billtype = bill.getString("billtypeid.number");
            Long id = bill.getLong("id");
            if (!StringUtils.isNotEmpty((String)billtype) || id == null) continue;
            Object[] param = new Object[]{billtype, id};
            params0.add(param);
        }
        if (params0.size() > 0) {
            DB.executeBatch((DBRoute)DBRouteConst.AP, (String)settleRecordEntryUpadateSql, params0);
        }
    }

    private String getStackTraceMessage(Exception e) {
        return ArApHelper.getStackTraceMessage((Throwable)e);
    }
}

