/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.helper.ArApHelper;

public class ApSettleRecordPayPropertyUpgradePlugin
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        if (ArApHelper.queryApIsNotInit() && ArApHelper.queryArIsNotInit()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
            resultMap.put("info", "is not need Upgrade");
            resultMap.put("success", Boolean.TRUE);
            return new UpgradeResult(resultMap);
        }
        return new UpgradeResult(this.beforeExecuteSql(ver, iteration, dbKey, sqlFileName));
    }

    public Map<String, Object> beforeExecuteSql(String ver, String iteration, String dbKey, String sqlFileName) {
        boolean success = true;
        String log = "Ap SettleRecord PayProperty Upgrade SUCCESS!";
        String info = "Ap SettleRecord PayProperty Upgrade SUCCESS!";
        try {
            this.upgrade();
        }
        catch (Exception e) {
            info = log = this.getStackTraceMessage(e);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        resultMap.put("success", success);
        resultMap.put("log", log);
        resultMap.put("el", "");
        resultMap.put("info", info);
        return resultMap;
    }

    private void upgrade() {
        String settleRecordQuerySql = "SELECT FMAINBILLID,FMAINBILLENTITY FROM T_AP_SETTLERECORD";
        DataSet settleRecordDataSet = DB.queryDataSet((String)"AP.QUERYSETTLERECORD", (DBRoute)DBRouteConst.AP, (String)settleRecordQuerySql);
        HashMap<String, List> map = new HashMap<String, List>();
        for (Row row : settleRecordDataSet) {
            String billIdentity = row.getString("FMAINBILLENTITY");
            if (!map.containsKey(billIdentity)) {
                ArrayList<Long> billIds = new ArrayList<Long>();
                billIds.add(row.getLong("FMAINBILLID"));
                map.put(billIdentity, billIds);
                continue;
            }
            ((List)map.get(billIdentity)).add(row.getLong("FMAINBILLID"));
        }
        ArrayList params = new ArrayList();
        String settleRecordUpadateSql = "UPDATE T_AP_SETTLERECORD SET FPAYPROPERTYTYPE = ? ,FPAYPROPERTYFIELD = ? WHERE FMAINBILLID = ?";
        map.forEach((key, value) -> {
            QFilter filter = new QFilter("id", "in", value);
            String payPropertyType = this.getSelectorByBillIdentity((String)key);
            if (!"".equals(payPropertyType)) {
                DynamicObject[] bills;
                for (DynamicObject bill : bills = BusinessDataServiceHelper.load((String)key, (String)("id," + payPropertyType), (QFilter[])filter.toArray())) {
                    DynamicObject payPropertyDO = bill.getDynamicObject(payPropertyType);
                    if (payPropertyDO == null) continue;
                    long payPropertyId = payPropertyDO.getLong("id");
                    Object[] param = new Object[]{payPropertyDO.getDataEntityType().getName(), payPropertyId, bill.getLong("id")};
                    params.add(param);
                }
            }
        });
        if (params.size() > 0) {
            DB.executeBatch((DBRoute)DBRouteConst.AP, (String)settleRecordUpadateSql, params);
        }
        String settleRecordEntryQuerySql = "SELECT FBILLID,FBILLENTITY FROM T_AP_SETTLERECORDENTRY";
        DataSet settleRecordEntryDataSet = DB.queryDataSet((String)"AP.QUERYSETTLERECORDENTRY", (DBRoute)DBRouteConst.AP, (String)settleRecordEntryQuerySql);
        HashMap<String, List> entryMap = new HashMap<String, List>();
        for (Row row : settleRecordEntryDataSet) {
            String billIdentity = row.getString("FBILLENTITY");
            if (!entryMap.containsKey(billIdentity)) {
                ArrayList<Long> billIds = new ArrayList<Long>();
                billIds.add(row.getLong("FBILLID"));
                entryMap.put(billIdentity, billIds);
                continue;
            }
            ((List)entryMap.get(billIdentity)).add(row.getLong("FBILLID"));
        }
        ArrayList params0 = new ArrayList();
        String settleRecordEntryUpadateSql = "UPDATE T_AP_SETTLERECORDENTRY SET FPAYPROPERTYTYPE = ?,FPAYPROPERTYFIELD = ? WHERE FBILLID = ?";
        entryMap.forEach((key, value) -> {
            QFilter filter = new QFilter("id", "in", value);
            String payPropertyType = this.getSelectorByBillIdentity((String)key);
            if (!"".equals(payPropertyType)) {
                DynamicObject[] bills;
                for (DynamicObject bill : bills = BusinessDataServiceHelper.load((String)key, (String)("id," + payPropertyType), (QFilter[])filter.toArray())) {
                    DynamicObject payPropertyDO = bill.getDynamicObject(payPropertyType);
                    if (payPropertyDO == null) continue;
                    long payPropertyId = payPropertyDO.getLong("id");
                    Object[] param = new Object[]{payPropertyDO.getDataEntityType().getName(), payPropertyId, bill.getLong("id")};
                    params0.add(param);
                }
            }
        });
        if (params0.size() > 0) {
            DB.executeBatch((DBRoute)DBRouteConst.AP, (String)settleRecordEntryUpadateSql, params0);
        }
    }

    private String getSelectorByBillIdentity(String billIdentity) {
        if ("ar_finarbill".equals(billIdentity) || "ap_finapbill".equals(billIdentity)) {
            return "payproperty";
        }
        if ("cas_recbill".equals(billIdentity)) {
            return "receivingtype";
        }
        if ("cas_paybill".equals(billIdentity)) {
            return "paymenttype";
        }
        return "";
    }

    private String getStackTraceMessage(Exception e) {
        return ArApHelper.getStackTraceMessage((Throwable)e);
    }
}

