/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.helper.ArApHelper;

public class ApVerifyBillTypeUpgradePlugin
implements IUpgradeService {
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        if (ArApHelper.queryApIsNotInit()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
            resultMap.put("info", "is not need Upgrade");
            resultMap.put("success", Boolean.TRUE);
            return new UpgradeResult(resultMap);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        boolean success = true;
        String log = "ApVerifyBillType Upgrade SUCCESS!";
        String info = "ApVerifyBillType Upgrade SUCCESS!";
        resultMap.put("log", log);
        resultMap.put("info", info);
        try {
            this.upgrade(resultMap);
        }
        catch (Exception e) {
            info = log = this.getStackTraceMessage(e);
            resultMap.put("success", success);
            resultMap.put("log", log);
            resultMap.put("el", "");
            resultMap.put("info", info);
        }
        return new UpgradeResult(resultMap);
    }

    private void upgrade(Map<String, Object> resultMap) {
        try (TXHandle tx = TX.requiresNew((String)"upgrade_apverifybilltype");){
            DynamicObject apBillTypeParam = BusinessDataServiceHelper.loadSingle((String)"ap_stdconfig", (String)"key,value", (QFilter[])new QFilter[]{new QFilter("key", "=", (Object)"verify.apbilltype")});
            if (apBillTypeParam == null) {
                DynamicObject[] apBillTypes;
                List<String> apVerifyBillTypes = this.apVerifyBillTypes();
                List<String> apAllBillTypes = this.apAllBillTypes();
                for (DynamicObject apBillType : apBillTypes = BusinessDataServiceHelper.load((String)"bos_billtype", (String)"number", (QFilter[])new QFilter[]{new QFilter("billformid", "=", (Object)"ap_finapbill")})) {
                    String number = apBillType.getString("number");
                    if (apAllBillTypes.contains(number)) continue;
                    apVerifyBillTypes.add(number);
                }
                DynamicObject stdconfig = BusinessDataServiceHelper.newDynamicObject((String)"ap_stdconfig");
                stdconfig.set("key", (Object)"verify.apbilltype");
                stdconfig.set("value", (Object)String.join((CharSequence)",", apVerifyBillTypes));
                stdconfig.set("desc", (Object)ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5355\u53c2\u4e0e\u6838\u9500\u7684\u5355\u636e\u7c7b\u578b\u3002", (String)"ApVerifyBillTypeUpgradePlugin_0", (String)"fi-ap-mservice", (Object[])new Object[0]));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{stdconfig});
            }
        }
        catch (Exception e) {
            resultMap.put("log", this.getStackTraceMessage(e));
            resultMap.put("el", "");
            resultMap.put("info", this.getStackTraceMessage(e));
        }
    }

    private String getStackTraceMessage(Exception e) {
        return ArApHelper.getStackTraceMessage((Throwable)e);
    }

    private List<String> apAllBillTypes() {
        ArrayList<String> apAllBillTypes = new ArrayList<String>(8);
        apAllBillTypes.add("ApFin_borr_BT_S");
        apAllBillTypes.add("ApFin_fee_BT_S");
        apAllBillTypes.add("ApFin_other_BT_S");
        apAllBillTypes.add("ApFin_product_BT_S");
        apAllBillTypes.add("ApFin_pur_BT_S");
        apAllBillTypes.add("ApFin_purfee_BT_S");
        apAllBillTypes.add("ApFin_service_BT_S");
        apAllBillTypes.add("ap_finapbill_asset_BT_S");
        return apAllBillTypes;
    }

    private List<String> apVerifyBillTypes() {
        ArrayList<String> apVerifyBillTypes = new ArrayList<String>(5);
        apVerifyBillTypes.add("ApFin_pur_BT_S");
        apVerifyBillTypes.add("ap_finapbill_asset_BT_S");
        apVerifyBillTypes.add("ApFin_service_BT_S");
        apVerifyBillTypes.add("ApFin_product_BT_S");
        apVerifyBillTypes.add("ApFin_fee_BT_S");
        return apVerifyBillTypes;
    }
}

