/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.upgrade;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.balance.BalanceRebuildService;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;

public class ArApJournalOrgUpgradePlugin
extends AbstractOperationServicePlugIn {
    private String srcBillType = null;
    private String entityKey = null;
    private String app = null;

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        if (ArApHelper.queryApIsNotInit()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
            resultMap.put("info", "is not need Upgrade");
            resultMap.put("success", Boolean.TRUE);
            return;
        }
        String entityName = e.getDataEntities()[0].getDataEntityType().getName();
        this.srcBillType = "ap_journal".equals(entityName) ? "cas_paybill" : "cas_recbill";
        this.entityKey = "ap_journal".equals(entityName) ? "ap_journal" : "ar_journal";
        this.app = "ap_journal".equals(entityName) ? "ap" : "ar";
        this.upgrade();
    }

    private void upgrade() {
        QFilter filter = new QFilter("sourcebilltype", "=", (Object)this.srcBillType);
        ArrayList<Long> batchIds = new ArrayList<Long>(10000);
        try (DataSet journalIds = QueryServiceHelper.queryDataSet((String)"upgrade.upApJournalOrg", (String)this.entityKey, (String)"id", (QFilter[])new QFilter[]{filter}, null);){
            for (Row journalId : journalIds) {
                batchIds.add(journalId.getLong("id"));
                if (batchIds.size() != 10000) continue;
                this.doUpgrade(batchIds);
                batchIds.clear();
            }
        }
        if (!batchIds.isEmpty()) {
            this.doUpgrade(batchIds);
        }
    }

    private void doUpgrade(List<Long> batchIds) {
        DynamicObject[] casBills;
        String selector = "id, sourcebillid, org, bizdate";
        DynamicObject[] journals = BusinessDataServiceHelper.load((String)this.entityKey, (String)selector, (QFilter[])new QFilter[]{new QFilter("id", "in", batchIds)});
        Set srcIds = Arrays.stream(journals).map(j -> j.getLong("sourcebillid")).collect(Collectors.toSet());
        HashMap<Long, Long> mapOrg = new HashMap<Long, Long>(8);
        String casselector = "cas_paybill".equals(this.srcBillType) ? "id,entry.settleorg" : "id,entry.e_settleorg";
        for (DynamicObject dynamicObject : casBills = BusinessDataServiceHelper.load((String)this.srcBillType, (String)casselector, (QFilter[])new QFilter[]{new QFilter("id", "in", srcIds)})) {
            Long casBillId = dynamicObject.getLong("id");
            DynamicObjectCollection entryCol = dynamicObject.getDynamicObjectCollection("entry");
            Long settleOrgId = 0L;
            if (entryCol.size() > 0) {
                settleOrgId = "cas_paybill".equals(this.srcBillType) ? ((DynamicObject)entryCol.get(0)).getLong("settleorg.id") : ((DynamicObject)entryCol.get(0)).getLong("e_settleorg.id");
            }
            mapOrg.put(casBillId, settleOrgId);
        }
        ArrayList<DynamicObject> updateJournals = new ArrayList<DynamicObject>(64);
        HashMap<Long, Date> orgDateMap = new HashMap<Long, Date>(8);
        for (DynamicObject bill : journals) {
            Date date;
            Long settleOrgId;
            Long orgId = bill.getLong("org.id");
            Long srcBillId = bill.getLong("sourcebillid");
            if (EmptyUtils.isEmpty(mapOrg.get(srcBillId)) || (settleOrgId = (Long)mapOrg.get(srcBillId)).equals(0L) || settleOrgId.equals(orgId)) continue;
            Date bizDate = bill.getDate("bizdate");
            if (EmptyUtils.isEmpty(orgDateMap.get(orgId))) {
                orgDateMap.put(orgId, bizDate);
            } else {
                date = (Date)orgDateMap.get(orgId);
                orgDateMap.put(orgId, DateUtils.compareTo((Date)date, (Date)bizDate) == 1 ? bizDate : date);
            }
            if (EmptyUtils.isEmpty(orgDateMap.get(settleOrgId))) {
                orgDateMap.put(settleOrgId, bizDate);
            } else {
                date = (Date)orgDateMap.get(settleOrgId);
                orgDateMap.put(settleOrgId, DateUtils.compareTo((Date)date, (Date)bizDate) == 1 ? bizDate : date);
            }
            bill.set("org", (Object)settleOrgId);
            updateJournals.add(bill);
        }
        if (!updateJournals.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])updateJournals.toArray(new DynamicObject[0]));
        }
        for (Map.Entry entry : orgDateMap.entrySet()) {
            Long orgId = (Long)entry.getKey();
            Date bizDate = (Date)entry.getValue();
            BalanceRebuildService service = new BalanceRebuildService(orgId, bizDate, this.app);
            service.rebuild();
        }
    }
}

