/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.upgrade;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.param.ParameterWriter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.arapcommon.helper.ArApHelper;

public class BillTypeParamUpgradePlugin
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        if (ArApHelper.queryApIsNotInit()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
            resultMap.put("info", "is not need Upgrade");
            resultMap.put("success", Boolean.TRUE);
            return new UpgradeResult(resultMap);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        boolean success = true;
        try {
            this.doUpgrade("ap_finapbill", 535198337297582080L);
            this.doUpgrade("ap_busbill", 683777200847102976L);
        }
        catch (Exception e) {
            String log;
            String info = log = ArApHelper.getStackTraceMessage((Throwable)e);
            resultMap.put("success", success);
            resultMap.put("log", log);
            resultMap.put("el", "");
            resultMap.put("info", info);
        }
        return new UpgradeResult(resultMap);
    }

    private void doUpgrade(String formId, Long billTypeId) {
        DynamicObject param = (DynamicObject)SystemParamServiceHelper.getBillTypeParameter((String)formId, (String)"bd_billtypeparameter", (long)billTypeId);
        if (param == null) {
            return;
        }
        List<Long> presetBizTypes = Arrays.asList(422857170485263360L, 688847172015446016L, 688850502762584064L, 688852433954466816L);
        DynamicObjectCollection entry = param.getDynamicObjectCollection("entryentity");
        for (DynamicObject row : entry) {
            if (!presetBizTypes.contains(row.getLong("biztypenumber.id"))) continue;
            row.set("ispreset", (Object)Boolean.TRUE);
        }
        DynamicObject newRow = entry.addNew();
        newRow.set("biztypenumber", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)691915699186345984L, (String)"bd_biztype"));
        newRow.set("isdefault", (Object)Boolean.FALSE);
        newRow.set("ispreset", (Object)Boolean.TRUE);
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(param.getDynamicObjectType());
        binder.setOnlyDbProperty(false);
        binder.setSerializeDefaultValue(true);
        DcJsonSerializer serializer = new DcJsonSerializer((DcBinder)binder);
        String jsonString = serializer.serializeToString((Object)param, null);
        ParameterWriter.saveBillTypeParameter((String)formId, (long)billTypeId, (String)jsonString);
    }
}

