/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.upgrade;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.OpBizRuleSetServiceHelper;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class ExecControlRegisterServiceUpdatePlugin
implements IUpgradeService {
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        boolean success = true;
        try {
            this.doUpgrade();
        }
        catch (Exception e) {
            String log = ArApHelper.getStackTraceMessage((Throwable)e);
            resultMap.put("success", success);
            resultMap.put("log", log);
            resultMap.put("el", "");
            resultMap.put("info", log);
        }
        return new UpgradeResult(resultMap);
    }

    private void doUpgrade() {
        String querySql = "select fbizobjid,fctrlpoint from t_arap_execcontrol where fbizobjid in ('cas_paybill','cas_recbill') and fenable = '1'";
        DataSet dataSet = DB.queryDataSet((String)"ExecControlRegisterServiceUpdatePlugin", (DBRoute)new DBRoute("ap"), (String)querySql);
        if (!dataSet.hasNext()) {
            return;
        }
        HashMap<String, List> registerService = new HashMap<String, List>(2);
        for (Row control : dataSet) {
            String bizObjId = control.getString("fbizobjid");
            List registerOpNames = registerService.getOrDefault(bizObjId, new ArrayList(4));
            String ctrlPoint = control.getString("fctrlpoint");
            if (EmptyUtils.isNotEmpty((Object)ctrlPoint)) {
                Set opNames = Arrays.stream(ctrlPoint.split(",")).filter(str -> str.length() != 0).collect(Collectors.toSet());
                for (String opName : opNames) {
                    if (registerOpNames.contains(opName)) continue;
                    registerOpNames.add(opName);
                }
            }
            registerService.put(bizObjId, registerOpNames);
        }
        for (Map.Entry entry : registerService.entrySet()) {
            OpBizRuleSetServiceHelper.deleteOpBizRuleSet((String)((String)entry.getKey()), (String)"ArApExecControl");
            OpBizRuleSetServiceHelper.saveOpBizRuleSet((String)((String)entry.getKey()), (String)"ArApExecControl", (List)((List)entry.getValue()));
        }
    }
}

