/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.upgrade;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.util.DateUtils;

public class FinBusFarmAmtUpgradePlugin
implements IUpgradeService {
    private static final int MAX_PROCESSNUMBER = 10000;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        if (ArApHelper.queryApIsNotInit()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
            resultMap.put("info", "is not need Upgrade");
            resultMap.put("success", Boolean.TRUE);
            return new UpgradeResult(resultMap);
        }
        String log = "";
        try (TXHandle txHandle = TX.required();){
            try {
                this.upgradeBusBills();
                this.upgradeFinBills();
            }
            catch (Exception e) {
                txHandle.markRollback();
                log = this.getStackTraceMessage(e);
            }
        }
        UpgradeResult upgradeResult = new UpgradeResult();
        upgradeResult.setSuccess(true);
        upgradeResult.setLog(log);
        return upgradeResult;
    }

    public void upgradeFinBills() {
        ArrayList<Date> queryArgs = new ArrayList<Date>(1);
        Date beginDate = DateUtils.getNextDay((Date)new Date(), (int)-180);
        queryArgs.add(beginDate);
        String queryIsTaxSql = "select fid,fistaxdeduction from t_ap_finapbill where fbizdate > ? ";
        DataSet allFinDataSet = DB.queryDataSet((String)"FinBusFarmAmtUpgradePlugin", (DBRoute)DBRoute.of((String)"ap"), (String)queryIsTaxSql, (Object[])queryArgs.toArray());
        ArrayList<Long> needUpdateFinTaxIds = new ArrayList<Long>(64);
        ArrayList<Long> needUpdateFinNoTaxIds = new ArrayList<Long>(64);
        for (Row finRow : allFinDataSet) {
            boolean isTaxDeduction = finRow.getBoolean("fistaxdeduction");
            if (isTaxDeduction) {
                needUpdateFinTaxIds.add(finRow.getLong("fid"));
            } else {
                needUpdateFinNoTaxIds.add(finRow.getLong("fid"));
            }
            if (needUpdateFinTaxIds.size() == 10000) {
                this.updateTaxFinEntry(needUpdateFinTaxIds, true);
                needUpdateFinTaxIds.clear();
            }
            if (needUpdateFinNoTaxIds.size() != 10000) continue;
            this.updateTaxFinEntry(needUpdateFinNoTaxIds, false);
            needUpdateFinNoTaxIds.clear();
        }
        if (!needUpdateFinTaxIds.isEmpty()) {
            this.updateTaxFinEntry(needUpdateFinTaxIds, true);
        }
        if (!needUpdateFinNoTaxIds.isEmpty()) {
            this.updateTaxFinEntry(needUpdateFinNoTaxIds, false);
        }
    }

    private void updateTaxFinEntry(List<Long> needUpdateBillIds, boolean isTax) {
        if (needUpdateBillIds == null || needUpdateBillIds.isEmpty()) {
            return;
        }
        ArrayList<Object[]> updateFinBillParams = new ArrayList<Object[]>(needUpdateBillIds.size());
        for (Long billId : needUpdateBillIds) {
            Object[] param = new Object[]{billId};
            updateFinBillParams.add(param);
        }
        String updateSql = "";
        updateSql = isTax ? "update t_ap_finapbilldetailentry set fintercostamt=famountbase,fcurdeductibleamt=fpricetaxtotalbase-famountbase where fid = ?" : "update t_ap_finapbilldetailentry set fintercostamt=fpricetaxtotalbase where fid = ?";
        DB.executeBatch((DBRoute)new DBRoute("ap"), (String)updateSql, updateFinBillParams);
    }

    public void upgradeBusBills() {
        String sql = "select b.fcalorgid from t_cal_calpolicy a left join t_cal_costaccount b on a.fsupporttaxamt=? and b.fismainaccount = ? and a.fid = b.fcalpolicyid";
        DataSet accountDataSet = DB.queryDataSet((String)"FinApTaxDeductionUpgradePlugin", (DBRoute)new DBRoute("cal"), (String)sql, (Object[])new Object[]{Character.valueOf('1'), Character.valueOf('1')});
        HashSet<Long> taxOrgIds = new HashSet<Long>(10);
        for (Row account : accountDataSet) {
            Long orgId = account.getLong("fcalorgid");
            taxOrgIds.add(orgId);
        }
        this.queryAndUpdateTaxEntry(taxOrgIds);
    }

    private void queryAndUpdateTaxEntry(Set taxOrgIds) {
        ArrayList<Date> queryArgs = new ArrayList<Date>(1 + taxOrgIds.size());
        Date beginDate = DateUtils.getNextDay((Date)new Date(), (int)-180);
        queryArgs.add(beginDate);
        String queryIsTaxSql = "select fid,forgid from t_ap_busbill where fbizdate > ? ";
        DataSet allFinDataSet = DB.queryDataSet((String)"FinBusFarmAmtUpgradePlugin", (DBRoute)DBRoute.of((String)"ap"), (String)queryIsTaxSql, (Object[])queryArgs.toArray());
        ArrayList<Long> needUpdateBusTaxIds = new ArrayList<Long>(64);
        ArrayList<Long> needUpdateBusNoTaxIds = new ArrayList<Long>(64);
        for (Row finRow : allFinDataSet) {
            Long orgId = finRow.getLong("forgid");
            if (taxOrgIds.size() > 0 && taxOrgIds.contains(orgId)) {
                needUpdateBusTaxIds.add(finRow.getLong("fid"));
            } else {
                needUpdateBusNoTaxIds.add(finRow.getLong("fid"));
            }
            if (needUpdateBusTaxIds.size() == 10000) {
                this.updateTaxEntry(needUpdateBusTaxIds, true);
                needUpdateBusTaxIds.clear();
            }
            if (needUpdateBusNoTaxIds.size() != 10000) continue;
            this.updateTaxEntry(needUpdateBusNoTaxIds, false);
            needUpdateBusNoTaxIds.clear();
        }
        if (!needUpdateBusTaxIds.isEmpty()) {
            this.updateTaxEntry(needUpdateBusTaxIds, true);
        }
        if (!needUpdateBusNoTaxIds.isEmpty()) {
            this.updateTaxEntry(needUpdateBusNoTaxIds, false);
        }
    }

    private void updateTaxEntry(List<Long> needUpdateBillIds, boolean isTax) {
        if (needUpdateBillIds == null || needUpdateBillIds.isEmpty()) {
            return;
        }
        ArrayList<Object[]> updateFinBillParams = new ArrayList<Object[]>(needUpdateBillIds.size());
        for (Long billId : needUpdateBillIds) {
            Object[] param = new Object[]{billId};
            updateFinBillParams.add(param);
        }
        String updateSql = "";
        updateSql = isTax ? "update t_ap_busbillentry set fintercostamt=flocalamt,fcurdeductibleamt=ftaxlocalamt where fid = ?" : "update t_ap_busbillentry set fintercostamt=fpricetaxtotalbase where fid = ?";
        DB.executeBatch((DBRoute)new DBRoute("ap"), (String)updateSql, updateFinBillParams);
    }

    public String getStackTraceMessage(Exception e) {
        return ArApHelper.getStackTraceMessage((Throwable)e);
    }
}

