/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.helper.ArApHelper;

public class InitSettleModelUpgradePlugin
implements IUpgradeService {
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        if (ArApHelper.queryApIsNotInit() && ArApHelper.queryArIsNotInit()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
            resultMap.put("info", "is not need Upgrade");
            resultMap.put("success", Boolean.TRUE);
            return new UpgradeResult(resultMap);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        boolean success = true;
        String log = "SettleModel Upgrade SUCCESS!";
        String info = "SettleModel Upgrade SUCCESS!";
        resultMap.put("success", success);
        resultMap.put("log", log);
        resultMap.put("el", "");
        resultMap.put("info", info);
        try {
            this.upgrade();
        }
        catch (Exception e) {
            info = log = this.getStackTraceMessage(e);
            resultMap.put("success", success);
            resultMap.put("log", log);
            resultMap.put("el", "");
            resultMap.put("info", info);
        }
        return new UpgradeResult(resultMap);
    }

    private void upgrade() {
        this.upgradeInit(true);
        this.upgradeInit(false);
    }

    private void upgradeInit(boolean isAr) {
        String tableName = isAr ? "T_AR_INIT" : "T_AP_INIT";
        String querySql = String.format("SELECT FID,FORGID FROM %s WHERE FSETTLEMODEL = ' '", tableName);
        DataSet queryDataSet = DB.queryDataSet((String)"QUERYSETTLEMODEL", (DBRoute)(isAr ? DBRouteConst.AR : DBRouteConst.AP), (String)querySql);
        ArrayList<Object[]> params = new ArrayList<Object[]>(10);
        for (Row row : queryDataSet) {
            int settleParam = isAr ? ArApHelper.getArSettleParam((Object)row.getLong("FORGID")) : ArApHelper.getApSettleParam((Object)row.getLong("FORGID"));
            Object[] param = new Object[]{settleParam, row.getLong("FID")};
            params.add(param);
        }
        String updateSql = String.format("UPDATE %s SET FSETTLEMODEL = ? WHERE FID = ?", tableName);
        if (params.size() > 0) {
            DB.executeBatch((DBRoute)(isAr ? DBRouteConst.AR : DBRouteConst.AP), (String)updateSql, params);
        }
    }

    private String getStackTraceMessage(Exception e) {
        return ArApHelper.getStackTraceMessage((Throwable)e);
    }
}

