/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.upgrade;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.fi.arapcommon.consts.DBRouteConst;

public class InvoiceArticulateUpgradeOp
extends AbstractOperationServicePlugIn {
    private final Map<Long, Map<String, Object>> invoiceDataMap = new HashMap<Long, Map<String, Object>>(64);
    private final Map<Long, List<Map<String, Object>>> invoiceEntryDataMap = new HashMap<Long, List<Map<String, Object>>>(64);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("inventry.invid");
        fieldKeys.add("billstatus");
        fieldKeys.add("sourcebilltype");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Long> allBillIds = new HashSet<Long>(16);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection invEntry = dataEntity.getDynamicObjectCollection("inventry");
            if (invEntry.isEmpty()) continue;
            allBillIds.add(dataEntity.getLong("id"));
        }
        if (allBillIds.isEmpty()) {
            return;
        }
        HashSet<Long> hasArticulateFinApIds = new HashSet<Long>(32);
        HashSet<Long> hasArticulateInvIds = new HashSet<Long>(32);
        String finApMainSql = "select fbillid,fbilltype from t_ap_invoicematchentry where fbillid in (" + StringUtils.join((Object[])allBillIds.toArray(), (String)",") + ");";
        DataSet apFinMainDataSet = DB.queryDataSet((String)"query_match_record_entry", (DBRoute)DBRouteConst.AP, (String)finApMainSql);
        for (Row row : apFinMainDataSet) {
            if ("ap_finapbill".equals(row.getString("fbilltype"))) {
                hasArticulateFinApIds.add(row.getLong("fbillid"));
                continue;
            }
            hasArticulateInvIds.add(row.getLong("fbillid"));
        }
        String finApAssSql = "select fassbillid,fassbilltype from t_ap_invoicematchentry where fassbillid in (" + StringUtils.join((Object[])allBillIds.toArray(), (String)",") + ");";
        DataSet apFinAssDataSet = DB.queryDataSet((String)"query_match_record_entry", (DBRoute)DBRouteConst.AP, (String)finApAssSql);
        for (Row row : apFinAssDataSet) {
            if ("ap_finapbill".equals(row.getString("fassbilltype"))) {
                hasArticulateFinApIds.add(row.getLong("fassbillid"));
                continue;
            }
            hasArticulateInvIds.add(row.getLong("fassbillid"));
        }
        HashSet<Long> needUpgradeFinApIds = new HashSet<Long>(16);
        for (DynamicObject dataEntity : dataEntities) {
            long finApBillId = dataEntity.getLong("id");
            if ("ap_invoice".equals(dataEntity.getString("sourcebilltype")) || "A".equals(dataEntity.getString("billstatus")) || hasArticulateFinApIds.contains(finApBillId)) continue;
            DynamicObjectCollection invEntry = dataEntity.getDynamicObjectCollection("inventry");
            boolean isNeedUpgrade = true;
            for (DynamicObject invRow : invEntry) {
                if (!hasArticulateInvIds.contains(invRow.getLong("invid"))) continue;
                isNeedUpgrade = false;
                break;
            }
            if (!isNeedUpgrade) continue;
            needUpgradeFinApIds.add(finApBillId);
        }
        this.upgrade(needUpgradeFinApIds);
    }

    public void upgrade(Set<Long> finApBillIds) {
        List detailParams;
        if (ObjectUtils.isEmpty(finApBillIds)) {
            return;
        }
        String queryFinApSql = "select fid,fcurrencyid,fbasecurrencyid,fbillno,forgid from t_ap_finapbill where fid in (" + StringUtils.join((Object[])finApBillIds.toArray(), (String)",") + ") and fsourcebilltype != 'ap_invoice';";
        DataSet apFinDataSet = DB.queryDataSet((String)"query_ap_fin", (DBRoute)DBRouteConst.AP, (String)queryFinApSql);
        HashMap finApDataMap = new HashMap(finApBillIds.size());
        for (Row finAp : apFinDataSet) {
            HashMap<String, Object> finApParamMap = new HashMap<String, Object>(8);
            finApParamMap.put("fid", finAp.get("fid"));
            finApParamMap.put("forgid", finAp.get("forgid"));
            finApParamMap.put("fcurrencyid", finAp.get("fcurrencyid"));
            finApParamMap.put("fbasecurrencyid", finAp.get("fbasecurrencyid"));
            finApParamMap.put("fbillno", finAp.get("fbillno"));
            finApDataMap.put(finAp.getLong("fid"), finApParamMap);
        }
        if (finApDataMap.isEmpty()) {
            return;
        }
        String queryEntrySql = "select fid,fentryid,finvoicedamt,funinvoicedamt from t_ap_finapbilldetailentry_e where fid in (" + StringUtils.join((Object[])finApDataMap.keySet().toArray(), (String)",") + ") and finvoicedamt != 0;";
        DataSet apFinDetailDataSet = DB.queryDataSet((String)"query_ap_fin_detail", (DBRoute)DBRouteConst.AP, (String)queryEntrySql);
        HashMap<Long, List> detailEntryDataMap = new HashMap<Long, List>(64);
        for (Row detailRow : apFinDetailDataSet) {
            Long fid = detailRow.getLong("fid");
            detailParams = detailEntryDataMap.getOrDefault(fid, new ArrayList(16));
            HashMap<String, Object> detailParam = new HashMap<String, Object>(8);
            detailParam.put("fid", detailRow.get("fid"));
            detailParam.put("fentryid", detailRow.get("fentryid"));
            detailParam.put("finvoicedamt", detailRow.get("finvoicedamt"));
            detailParam.put("funinvoicedamt", detailRow.get("funinvoicedamt"));
            detailParams.add(detailParam);
            detailEntryDataMap.put(fid, detailParams);
        }
        Iterator iterator = detailEntryDataMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            Long finApBillId = (Long)next.getKey();
            detailParams = (List)next.getValue();
            boolean isErrorData = false;
            for (Map detailParam : detailParams) {
                BigDecimal funinvoicedamt;
                BigDecimal finvoicedamt = (BigDecimal)detailParam.get("finvoicedamt");
                if (finvoicedamt.multiply(funinvoicedamt = (BigDecimal)detailParam.get("funinvoicedamt")).compareTo(BigDecimal.ZERO) >= 0) continue;
                isErrorData = true;
                break;
            }
            if (!isErrorData) continue;
            finApDataMap.remove(finApBillId);
            iterator.remove();
        }
        if (finApDataMap.isEmpty()) {
            return;
        }
        String queryInvEntrySql = "select fid,fentryid,finvid,fusedamt from t_ap_finapbillinventry where fid in (" + StringUtils.join((Object[])finApDataMap.keySet().toArray(), (String)",") + ") and fusedamt != 0;";
        DataSet apInvEntryDataSet = DB.queryDataSet((String)"query_ap_fin_invEntry", (DBRoute)DBRouteConst.AP, (String)queryInvEntrySql);
        HashMap<Object, List> invEntryDataMap = new HashMap<Object, List>(64);
        HashSet<Long> invoiceIds = new HashSet<Long>(16);
        for (Row invRow : apInvEntryDataSet) {
            Long fid = invRow.getLong("fid");
            List invParams = invEntryDataMap.getOrDefault(fid, new ArrayList(16));
            HashMap<String, Object> invParam = new HashMap<String, Object>(8);
            invParam.put("fentryid", invRow.get("fentryid"));
            invParam.put("finvid", invRow.get("finvid"));
            invParam.put("fusedamt", invRow.get("fusedamt"));
            invParams.add(invParam);
            invEntryDataMap.put(fid, invParams);
            if (this.invoiceDataMap.get(invRow.getLong("finvid")) != null) continue;
            invoiceIds.add(invRow.getLong("finvid"));
        }
        if (!invoiceIds.isEmpty()) {
            String queryInvoiceSql = "select fid,fcurrencyid,fbasecurrencyid,fbillno,forgid from t_ap_invoice where fid in (" + StringUtils.join((Object[])invoiceIds.toArray(), (String)",") + ");";
            DataSet invoiceDataSet = DB.queryDataSet((String)"query_invoice", (DBRoute)DBRouteConst.AP, (String)queryInvoiceSql);
            for (Row invoice : invoiceDataSet) {
                HashMap<String, Object> invoiceParamMap = new HashMap<String, Object>(8);
                invoiceParamMap.put("fid", invoice.get("fid"));
                invoiceParamMap.put("forgid", invoice.get("forgid"));
                invoiceParamMap.put("fcurrencyid", invoice.get("fcurrencyid"));
                invoiceParamMap.put("fbasecurrencyid", invoice.get("fbasecurrencyid"));
                invoiceParamMap.put("fbillno", invoice.get("fbillno"));
                this.invoiceDataMap.put(invoice.getLong("fid"), (Map<String, Object>)invoiceParamMap);
            }
            String queryInvoiceEntrySql = "select fid,fentryid,frelatedamt,funrelatedamt from t_ap_invoiceentry where fid in (" + StringUtils.join((Object[])invoiceIds.toArray(), (String)",") + ") and frelatedamt != 0;";
            DataSet invoiceEntryDataSet = DB.queryDataSet((String)"query_invoice_entry", (DBRoute)DBRouteConst.AP, (String)queryInvoiceEntrySql);
            for (Row invoiceRow : invoiceEntryDataSet) {
                Long fid = invoiceRow.getLong("fid");
                List invoiceEntryParams = this.invoiceEntryDataMap.getOrDefault(fid, new ArrayList(16));
                HashMap<String, Object> invoiceEntryParam = new HashMap<String, Object>(8);
                invoiceEntryParam.put("fid", invoiceRow.get("fid"));
                invoiceEntryParam.put("fentryid", invoiceRow.get("fentryid"));
                invoiceEntryParam.put("frelatedamt", invoiceRow.get("frelatedamt"));
                invoiceEntryParam.put("funrelatedamt", invoiceRow.get("funrelatedamt"));
                invoiceEntryParams.add(invoiceEntryParam);
                this.invoiceEntryDataMap.put(fid, invoiceEntryParams);
            }
        }
        ArrayList recordInsertParams = new ArrayList(64);
        ArrayList recordEntryInsertParams = new ArrayList(64);
        for (Map.Entry entrySet : finApDataMap.entrySet()) {
            List detailParams2;
            Long finApId = (Long)entrySet.getKey();
            Map finApParamMap = (Map)entrySet.getValue();
            if (invEntryDataMap.get(finApId) == null || ObjectUtils.isEmpty((Object)(detailParams2 = (List)detailEntryDataMap.get(finApId)))) continue;
            Tuple<List<Object[]>, List<Object[]>> tuple1 = this.finApSelfArticulate(finApParamMap, detailParams2);
            recordInsertParams.addAll((Collection)tuple1.item1);
            recordEntryInsertParams.addAll((Collection)tuple1.item2);
            List finApInvEntryParams = (List)invEntryDataMap.get(finApId);
            Tuple<List<Object[]>, List<Object[]>> tuple = this.invoiceArticulateFinAp(finApParamMap, finApInvEntryParams, detailParams2, this.invoiceDataMap, this.invoiceEntryDataMap);
            recordInsertParams.addAll((Collection)tuple.item1);
            recordEntryInsertParams.addAll((Collection)tuple.item2);
        }
        if (!recordInsertParams.isEmpty()) {
            String recordInsertSql = "insert into t_ap_invoicematchrecord(fid,fbillstatus,fwfnumber,fwfseq,fcreatetime,fwriteofftypeid,fcreatorid,forgid) values(?,?,?,?,?,?,?,?);";
            DB.executeBatch((DBRoute)DBRouteConst.AP, (String)recordInsertSql, recordInsertParams);
        }
        if (!recordEntryInsertParams.isEmpty()) {
            String recordEntryInsertSql = "insert into t_ap_invoicematchentry(fid,fentryid,fbilltype,fbillno,fbillid,fbillentryid,fbasecurrencyid,fcurrencyid,fmatchamt,fassbilltype,fassbasecurrencyid,fasscurrencyid,fassbillno,fassbillid,fassmatchamt,fassbillentryid) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";
            DB.executeBatch((DBRoute)DBRouteConst.AP, (String)recordEntryInsertSql, recordEntryInsertParams);
        }
    }

    private Tuple<List<Object[]>, List<Object[]>> invoiceArticulateFinAp(Map<String, Object> finApParamMap, List<Map<String, Object>> finApInvEntryParams, List<Map<String, Object>> detailParams, Map<Long, Map<String, Object>> invoiceDataMap, Map<Long, List<Map<String, Object>>> invoiceEntryDataMap) {
        ArrayList<Object[]> recordInsertParams = new ArrayList<Object[]>(32);
        ArrayList<Object[]> recordEntryInsertParams = new ArrayList<Object[]>(32);
        Iterator<Map<String, Object>> finApDetailIterator = detailParams.iterator();
        Map<String, Object> nowFinApDetailMap = finApDetailIterator.next();
        block0: for (Map<String, Object> finApInvEntryParam : finApInvEntryParams) {
            Long invoiceId = (Long)finApInvEntryParam.get("finvid");
            BigDecimal fUsedAmt = (BigDecimal)finApInvEntryParam.get("fusedamt");
            Map<String, Object> invoiceMap = invoiceDataMap.get(invoiceId);
            List<Map<String, Object>> invoiceEntryMaps = invoiceEntryDataMap.get(invoiceId);
            if (invoiceEntryMaps == null) continue;
            Iterator<Map<String, Object>> invoiceEntryIterator = invoiceEntryMaps.iterator();
            Map<String, Object> nowInvoiceEntryMap = invoiceEntryIterator.next();
            while (nowInvoiceEntryMap != null) {
                BigDecimal frelatedamt = (BigDecimal)nowInvoiceEntryMap.get("frelatedamt");
                while (nowFinApDetailMap != null) {
                    BigDecimal finvoicedamt = (BigDecimal)nowFinApDetailMap.get("finvoicedamt");
                    if (finvoicedamt.compareTo(BigDecimal.ZERO) == 0) {
                        nowFinApDetailMap = finApDetailIterator.hasNext() ? finApDetailIterator.next() : null;
                        continue;
                    }
                    BigDecimal invoiceMatchAmount = BigDecimal.ZERO;
                    invoiceMatchAmount = frelatedamt.abs().compareTo(fUsedAmt.abs()) > 0 ? fUsedAmt : frelatedamt;
                    BigDecimal finApMatchAmount = BigDecimal.ZERO;
                    finApMatchAmount = finvoicedamt.abs().compareTo(fUsedAmt.abs()) > 0 ? fUsedAmt : finvoicedamt;
                    BigDecimal mainInvoiceAmt = invoiceMatchAmount.abs().compareTo(finApMatchAmount.abs()) > 0 ? finApMatchAmount : invoiceMatchAmount;
                    Object[] recordInsertParam = this.constructRecordSqlParam(invoiceMap, 1893667005572058112L);
                    recordInsertParams.add(recordInsertParam);
                    long recordId = (Long)recordInsertParam[0];
                    Object[] recordEntrySqlParam = this.constructRecordEntrySqlParam(invoiceMap, nowInvoiceEntryMap, finApParamMap, nowFinApDetailMap, mainInvoiceAmt, 1893667005572058112L, recordId);
                    recordEntryInsertParams.add(recordEntrySqlParam);
                    finvoicedamt = finvoicedamt.subtract(mainInvoiceAmt);
                    frelatedamt = frelatedamt.subtract(mainInvoiceAmt);
                    fUsedAmt = fUsedAmt.subtract(mainInvoiceAmt);
                    nowFinApDetailMap.put("finvoicedamt", finvoicedamt);
                    if (finvoicedamt.compareTo(BigDecimal.ZERO) == 0) {
                        Map<String, Object> map = nowFinApDetailMap = finApDetailIterator.hasNext() ? finApDetailIterator.next() : null;
                    }
                    if (frelatedamt.compareTo(BigDecimal.ZERO) != 0 && fUsedAmt.compareTo(BigDecimal.ZERO) != 0) continue;
                    break;
                }
                nowInvoiceEntryMap.put("frelatedamt", frelatedamt);
                if (frelatedamt.compareTo(BigDecimal.ZERO) == 0) {
                    Map<String, Object> map = nowInvoiceEntryMap = invoiceEntryIterator.hasNext() ? invoiceEntryIterator.next() : null;
                }
                if (fUsedAmt.compareTo(BigDecimal.ZERO) != 0 && nowFinApDetailMap != null) continue;
                continue block0;
            }
        }
        return Tuple.create(recordInsertParams, recordEntryInsertParams);
    }

    private Tuple<List<Object[]>, List<Object[]>> finApSelfArticulate(Map<String, Object> finApParamMap, List<Map<String, Object>> detailParams) {
        ArrayList<Object[]> recordInsertParams = new ArrayList<Object[]>(32);
        ArrayList<Object[]> recordEntryInsertParams = new ArrayList<Object[]>(32);
        ArrayList<Map<String, Object>> mainDetailParams = new ArrayList<Map<String, Object>>(16);
        ArrayList<Map<String, Object>> asstDetailParams = new ArrayList<Map<String, Object>>(16);
        for (Map<String, Object> detailParam : detailParams) {
            BigDecimal finvoicedamt = (BigDecimal)detailParam.get("finvoicedamt");
            if (finvoicedamt.compareTo(BigDecimal.ZERO) > 0) {
                mainDetailParams.add(detailParam);
                continue;
            }
            if (finvoicedamt.compareTo(BigDecimal.ZERO) >= 0) continue;
            asstDetailParams.add(detailParam);
        }
        if (mainDetailParams.isEmpty() || asstDetailParams.isEmpty()) {
            return Tuple.create(recordInsertParams, recordEntryInsertParams);
        }
        Object[] recordInsertParam = this.constructRecordSqlParam(finApParamMap, 1893666267970144256L);
        recordInsertParams.add(recordInsertParam);
        long recordId = (Long)recordInsertParam[0];
        Iterator iterator = asstDetailParams.iterator();
        Map nowAsstDetailParam = (Map)iterator.next();
        for (Map map : mainDetailParams) {
            BigDecimal mainfinvoicedamt = (BigDecimal)map.get("finvoicedamt");
            while (nowAsstDetailParam != null) {
                BigDecimal asstfinvoicedamt = (BigDecimal)nowAsstDetailParam.get("finvoicedamt");
                BigDecimal mainMatchAmt = mainfinvoicedamt.abs().compareTo(asstfinvoicedamt.abs()) > 0 ? asstfinvoicedamt.negate() : mainfinvoicedamt;
                mainfinvoicedamt = mainfinvoicedamt.subtract(mainMatchAmt);
                asstfinvoicedamt = asstfinvoicedamt.add(mainMatchAmt);
                Object[] recordEntrySqlParam = this.constructRecordEntrySqlParam(finApParamMap, map, finApParamMap, nowAsstDetailParam, mainMatchAmt, 1893666267970144256L, recordId);
                recordEntryInsertParams.add(recordEntrySqlParam);
                nowAsstDetailParam.put("finvoicedamt", asstfinvoicedamt);
                if (asstfinvoicedamt.compareTo(BigDecimal.ZERO) == 0) {
                    Map map2 = nowAsstDetailParam = iterator.hasNext() ? (Map)iterator.next() : null;
                }
                if (mainfinvoicedamt.compareTo(BigDecimal.ZERO) != 0) continue;
                break;
            }
            map.put("finvoicedamt", mainfinvoicedamt);
        }
        return Tuple.create(recordInsertParams, recordEntryInsertParams);
    }

    private Object[] constructRecordSqlParam(Map<String, Object> mainParam, long writeOffTypeId) {
        Object[] recordInsertParam = new Object[]{DB.genGlobalLongId(), "C", mainParam.get("fbillno"), DB.genGlobalLongId(), new Date(System.currentTimeMillis()), writeOffTypeId, RequestContext.get().getCurrUserId(), mainParam.get("forgid")};
        return recordInsertParam;
    }

    private Object[] constructRecordEntrySqlParam(Map<String, Object> mainParam, Map<String, Object> mainEntryParam, Map<String, Object> asstParam, Map<String, Object> asstEntryParam, BigDecimal matchAmt, long writeOffTypeId, long recordId) {
        Object[] param = new Object[16];
        param[0] = recordId;
        param[1] = DB.genGlobalLongId();
        if (1893666267970144256L == writeOffTypeId) {
            param[2] = "ap_finapbill";
            param[14] = matchAmt.negate();
        } else {
            param[2] = "ap_invoice";
            param[14] = matchAmt;
        }
        param[3] = mainParam.get("fbillno");
        param[4] = mainParam.get("fid");
        param[5] = mainEntryParam.get("fentryid");
        param[6] = mainParam.get("fbasecurrencyid");
        param[7] = mainParam.get("fcurrencyid");
        param[8] = matchAmt;
        param[9] = "ap_finapbill";
        param[10] = asstParam.get("fbasecurrencyid");
        param[11] = asstParam.get("fcurrencyid");
        param[12] = asstParam.get("fbillno");
        param[13] = asstParam.get("fid");
        param[15] = asstEntryParam.get("fentryid");
        return param;
    }
}

