/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.upgrade;

import java.util.HashMap;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.ap.mservice.upgrade.InvoiceArticulateUpgradeOp;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.helper.ArApHelper;

public class InvoiceArticulateUpgradePlugin
implements IUpgradeService {
    private static final int UPGRADE_BILL_NUMBER = 5000;

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        if (ArApHelper.queryApIsNotInit()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
            resultMap.put("info", "is not need Upgrade");
            resultMap.put("success", Boolean.TRUE);
            return new UpgradeResult(resultMap);
        }
        String existRecordSql = "select count(fid) as count from t_ap_invoicematchrecord;";
        DataSet recordDateSet = DB.queryDataSet((String)"query_ap_match_record", (DBRoute)DBRouteConst.AP, (String)existRecordSql);
        if (recordDateSet.next().getInteger("count") != 0) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
            resultMap.put("info", "There is already a matching record and data upgrade is not supported. Please specify a tracking number to upgrade!");
            resultMap.put("success", Boolean.TRUE);
            return new UpgradeResult(resultMap);
        }
        String log = "";
        try (TXHandle txHandle = TX.required();){
            try {
                this.upgrade();
            }
            catch (Exception e) {
                txHandle.markRollback();
                log = ArApHelper.getStackTraceMessage((Throwable)e);
            }
        }
        UpgradeResult upgradeResult = new UpgradeResult();
        upgradeResult.setSuccess(true);
        upgradeResult.setLog(log);
        return upgradeResult;
    }

    private void upgrade() {
        String queryInvEntrySql = "select fid from t_ap_finapbillinventry where finvid != 0 and fusedamt != 0;";
        DataSet invEntryDataSet = DB.queryDataSet((String)"query_ap_match_record", (DBRoute)DBRouteConst.AP, (String)queryInvEntrySql);
        if (!invEntryDataSet.hasNext()) {
            return;
        }
        InvoiceArticulateUpgradeOp upgradeOp = new InvoiceArticulateUpgradeOp();
        HashSet<Long> allFinApBillIds = new HashSet<Long>(64);
        for (Row invRow : invEntryDataSet) {
            allFinApBillIds.add(invRow.getLong("fid"));
            if (allFinApBillIds.size() <= 5000) continue;
            upgradeOp.upgrade(allFinApBillIds);
            allFinApBillIds.clear();
        }
        if (!allFinApBillIds.isEmpty()) {
            upgradeOp.upgrade(allFinApBillIds);
            allFinApBillIds.clear();
        }
    }
}

