/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.verify;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ap.mservice.helper.VerifyServiceHelper;
import kd.fi.ap.mservice.verify.ApOminVerifyService;
import kd.fi.ap.mservice.verify.ApOminreturnVerifyService;
import kd.fi.ap.mservice.verify.ApPurAutoVerifyService;
import kd.fi.arapcommon.service.AbstractVerifyTemplate;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class ApOminAutoVerifyService
extends ApPurAutoVerifyService {
    public ApOminAutoVerifyService() {
    }

    public ApOminAutoVerifyService(String purEntity, Set<Long> botpIds) {
        this.purEntity = purEntity;
        this.botpIds = botpIds;
    }

    @Override
    protected AbstractVerifyTemplate getService(int direction) {
        if (0 == direction) {
            return new ApOminVerifyService();
        }
        return new ApOminreturnVerifyService();
    }

    @Override
    protected DynamicObject[] getMainObjs(DynamicObject[] objArr, SettleSchemeVO scheme) {
        HashSet<String> coreBillNoSet = new HashSet<String>();
        HashSet<Long> coreBillEntrySeqSet = new HashSet<Long>();
        for (DynamicObject obj : objArr) {
            DynamicObjectCollection entries = obj.getDynamicObjectCollection("detailentry");
            for (DynamicObject entry : entries) {
                String coreBillno = entry.getString("corebillno");
                String coreBilltype = entry.getString("corebilltype");
                if (ObjectUtils.isEmpty((Object)coreBillno) || !"pm_om_purorderbill".equals(coreBilltype)) continue;
                coreBillNoSet.add(coreBillno);
                coreBillEntrySeqSet.add(entry.getLong("corebillentryseq"));
            }
        }
        QFilter filter = null;
        if (!ObjectUtils.isEmpty((Object)this.botpIds)) {
            filter = new QFilter("id", "in", (Object)this.botpIds);
            scheme.setOnlyByBotp(true);
        } else {
            String omInbillkey = VerifyServiceHelper.getOmInBillKey();
            if (omInbillkey.equals(this.purEntity) && coreBillNoSet.size() > 0 && coreBillEntrySeqSet.size() > 0) {
                QFilter coreBillFilter = new QFilter("billentry.mainbillnumber", "in", coreBillNoSet);
                coreBillFilter.and("billentry.mainbillentryseq", "in", coreBillEntrySeqSet);
                coreBillFilter.and("billstatus", "=", (Object)"C");
                filter = coreBillFilter;
                scheme.setOnlyByCoreBill(true);
            }
        }
        if (filter != null) {
            String selector = "id,org,invscheme.transceivertype,billno,settlecurrency,currency,exchangerate,billtype,biztime,supplier,billentry.actualprice,billentry.actualtaxprice,billentry.id,billentry.material,billentry.qty,billentry.amount,billentry.ispresent,billentry.mainbillnumber,billentry.unverifyqty,billentry.unit,billentry.baseunit,billentry.entrysettleorg,billentry.mainbillentryseq,billentry.mversion,billentry.material.masterid.modelnum,billentry.auxpty,billentry.configuredcode,billentry.tracknumber";
            DynamicObject[] mainBills = BusinessDataServiceHelper.load((String)this.purEntity, (String)selector, (QFilter[])new QFilter[]{filter});
            return mainBills;
        }
        return null;
    }
}

