/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.verify;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.fi.ap.helper.SystemParameterHelper;
import kd.fi.ap.helper.ViewverHelper;
import kd.fi.ap.mservice.IAutoVerifyService;
import kd.fi.ap.mservice.helper.VerifyServiceHelper;
import kd.fi.ap.mservice.verify.ApPurinVerifyService;
import kd.fi.ap.mservice.verify.ApPurreturnVerifyService;
import kd.fi.ap.mservice.verify.VerifyServiceFactory;
import kd.fi.arapcommon.enums.VerifyModeEnum;
import kd.fi.arapcommon.service.AbstractVerifyTemplate;
import kd.fi.arapcommon.service.helper.CommonVerifyServiceHelper;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class ApPurAutoVerifyService
implements IAutoVerifyService {
    private static final Log logger = LogFactory.getLog(ApPurAutoVerifyService.class);
    protected static final int BIZDIRECTION_IN = 0;
    protected static final int BIZDIRECTION_OUT = 1;
    protected static final String MAIN_PURINBILL = "im_purinbill";
    protected String purEntity;
    protected Set<Long> botpIds;

    public ApPurAutoVerifyService() {
    }

    public ApPurAutoVerifyService(String purEntity, Set<Long> botpIds) {
        this.purEntity = purEntity;
        this.botpIds = botpIds;
    }

    public void autoVerify(DynamicObject[] objArr, boolean isMain) throws KDBizException {
        DynamicObject[] assts;
        DynamicObject[] mains;
        SettleSchemeVO scheme = new SettleSchemeVO();
        if (isMain) {
            mains = objArr;
            assts = this.getAsstObjs(objArr, scheme);
        } else {
            assts = objArr;
            mains = this.getMainObjs(objArr, scheme);
        }
        this.autoVerify(mains, assts, scheme);
    }

    public void autoVerify(Set<Long> mainIds, Set<Long> asstIds, SettleSchemeVO scheme) {
        if (ObjectUtils.isEmpty(mainIds) || ObjectUtils.isEmpty(asstIds) || ObjectUtils.isEmpty((Object)scheme)) {
            logger.info("ApPurAutoVerifyService autoVerify param is null;return;");
            return;
        }
        DynamicObject[] mains = BusinessDataServiceHelper.load((String)this.purEntity, (String)this.getMainSelector(), (QFilter[])new QFilter[]{new QFilter("id", "in", mainIds), new QFilter("billentry.logisticsbill", "=", (Object)Boolean.FALSE)});
        DynamicObject[] assts = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)this.getAsstSelector(), (QFilter[])new QFilter[]{new QFilter("id", "in", asstIds)});
        this.autoVerify(mains, assts, scheme);
    }

    private void autoVerify(DynamicObject[] mains, DynamicObject[] assts, SettleSchemeVO scheme) {
        if (mains != null && assts != null && mains.length > 0 && assts.length > 0) {
            if (scheme.isOnlyByCoreBill() && !SystemParameterHelper.getParameterBoolean((long)assts[0].getLong("org.id"), (String)"ap_020")) {
                logger.info("ApPurAutoVerifyService not support verify by core bill.");
                return;
            }
            ArrayList<DynamicObject> inBills = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> outBills = new ArrayList<DynamicObject>();
            for (DynamicObject main : mains) {
                DynamicObject transType = main.getDynamicObject("invscheme.transceivertype");
                int direction = (transType = BusinessDataServiceHelper.loadSingleFromCache((Object)transType.getPkValue(), (String)"bd_transceivertype")).getInt("bizdirection");
                if (0 == direction) {
                    inBills.add(main);
                    continue;
                }
                outBills.add(main);
            }
            if (inBills.size() > 0) {
                this.getService(0).verify(inBills.toArray(new DynamicObject[0]), assts, scheme, VerifyModeEnum.AUTO.getValue());
            }
            if (outBills.size() > 0) {
                this.getService(1).verify(outBills.toArray(new DynamicObject[0]), assts, scheme, VerifyModeEnum.AUTO.getValue());
            }
        }
    }

    protected AbstractVerifyTemplate getService(int direction) {
        if (0 == direction) {
            return new ApPurinVerifyService();
        }
        return new ApPurreturnVerifyService();
    }

    protected DynamicObject[] getMainObjs(DynamicObject[] objArr, SettleSchemeVO scheme) {
        HashSet<String> coreBillNoSet = new HashSet<String>();
        HashSet<Long> coreBillEntrySeqSet = new HashSet<Long>();
        for (DynamicObject obj : objArr) {
            DynamicObjectCollection entries = obj.getDynamicObjectCollection("detailentry");
            for (DynamicObject entry : entries) {
                String coreBillno = entry.getString("corebillno");
                if (ObjectUtils.isEmpty((Object)coreBillno)) continue;
                coreBillNoSet.add(coreBillno);
                coreBillEntrySeqSet.add(entry.getLong("corebillentryseq"));
            }
        }
        QFilter filter = null;
        if (!ObjectUtils.isEmpty(this.botpIds)) {
            filter = new QFilter("id", "in", this.botpIds);
            filter.and("billentry.logisticsbill", "=", (Object)Boolean.FALSE);
            scheme.setOnlyByBotp(true);
        } else if (!"im_purreceivebill".equals(this.purEntity) && coreBillNoSet.size() > 0 && coreBillEntrySeqSet.size() > 0) {
            QFilter coreBillFilter = new QFilter("billentry.mainbillnumber", "in", coreBillNoSet);
            coreBillFilter.and("billentry.mainbillentryseq", "in", coreBillEntrySeqSet);
            coreBillFilter.and("billstatus", "=", (Object)"C");
            filter = coreBillFilter;
            filter.and("billentry.logisticsbill", "=", (Object)Boolean.FALSE);
            scheme.setOnlyByCoreBill(true);
        }
        if (filter != null) {
            String selector = "id,org,invscheme.transceivertype,billno,settlecurrency,currency,quotation,exchangerate,billtype,biztime,supplier,billentry.actualprice,billentry.actualtaxprice,billentry.id,billentry.material,billentry.qty,billentry.amount,billentry.ispresent,billentry.mainbillnumber,billentry.baseqty,billentry.unverifyqty,billentry.unit,billentry.baseunit,billentry.entrysettleorg,billentry.mainbillentryseq,billentry.mversion,billentry.material.masterid.modelnum,billentry.auxpty,billentry.configuredcode,billentry.tracknumber,billentry.invoicesupplier";
            DynamicObject[] mainBills = BusinessDataServiceHelper.load((String)this.purEntity, (String)selector, (QFilter[])new QFilter[]{filter});
            return mainBills;
        }
        return null;
    }

    protected DynamicObject[] getAsstObjs(DynamicObject[] objArr, SettleSchemeVO scheme) {
        return null;
    }

    public void unAutoVerify(Object[] pks, boolean isMain) throws KDBizException {
        String entityName = !isMain ? "ap_finapbill" : MAIN_PURINBILL;
        this.unAutoVerifyByEntity(pks, entityName);
    }

    public void unAutoVerifyByEntity(Object[] pks, String entityName) throws KDBizException {
        Throwable throwable = null;
        try (TXHandle tx = TX.required((String)"unAutoVerify");){
            AppLogInfo appLogInfo = new AppLogInfo();
            appLogInfo.setBizAppID("+HKZHSKFXOX");
            appLogInfo.setBizObjID("ap_verifyrecord");
            appLogInfo.setOpName("unAutoVerify");
            Set verifyRecordPKs = ViewverHelper.getBillVerifyRecordPKs((Object[])pks, (String)entityName);
            if (verifyRecordPKs.isEmpty()) {
                appLogInfo.setOpDescription("no records need to unverify ");
                return;
            }
            if (!CommonVerifyServiceHelper.isFiVerifyRecord((Set)verifyRecordPKs, (boolean)false)) {
                appLogInfo.setOpDescription("not fi verify");
                return;
            }
            try {
                DynamicObject[] results = this.getVerifyRecords(new QFilter("id", "in", (Object)verifyRecordPKs), "ap_verifyrecord");
                appLogInfo.setOpDescription(results.length + " records need to unverify " + pks[0]);
                LogServiceHelper.addLog((AppLogInfo)appLogInfo);
                Map<String, List<DynamicObject>> map = VerifyServiceHelper.classfyByRelation(results);
                for (Map.Entry<String, List<DynamicObject>> entry : map.entrySet()) {
                    AbstractVerifyTemplate service = VerifyServiceFactory.getService(entry.getKey());
                    DynamicObject[] verifyRecords = entry.getValue().toArray(new DynamicObject[0]);
                    service.unVerify(verifyRecords);
                }
            }
            catch (Throwable e) {
                tx.markRollback();
                AppLogInfo appLogInfo2 = new AppLogInfo();
                appLogInfo2.setBizAppID("+HKZHSKFXOX");
                appLogInfo2.setBizObjID("ap_verifyrecord");
                appLogInfo2.setOpName("unAutoVerify");
                appLogInfo2.setOpDescription(e.getMessage());
                LogServiceHelper.addLog((AppLogInfo)appLogInfo2);
                throw e;
            }
        }
    }

    private DynamicObject[] getVerifyRecords(QFilter filter, String entity) {
        DynamicObject[] results = BusinessDataServiceHelper.load((String)entity, (String)"org,billid,billno,billtype,billentryid,qty,measureunit,verifyqty,verifybaseqty,payableamount,verifyamount,verifytype,verifyrelation,e_billtype,e_qty,e_measureunit,e_verifyqty,e_verifybaseqty,e_payableamount,e_verifyamount,e_billid,e_billno,e_billentryid,currency,e_currency,e_verifytaxamount,verifytaxamount", (QFilter[])filter.toArray());
        return results;
    }

    protected String getMainSelector() {
        return "id,org,invscheme.transceivertype,billno,settlecurrency,currency,quotation,exchangerate,billtype,biztime,supplier,billentry.actualprice,billentry.actualtaxprice,billentry.id,billentry.material,billentry.qty,billentry.amount,billentry.ispresent,billentry.mainbillnumber,billentry.unverifyqty,billentry.unit,billentry.baseunit,billentry.entrysettleorg,billentry.mainbillentryseq,billentry.baseqty,billentry.mversion,billentry.material.masterid.modelnum,billentry.auxpty,billentry.configuredcode,billentry.tracknumber,billentry.invoicesupplier";
    }

    protected String getAsstSelector() {
        return "id,billno,bizdate,currency,basecurrency,asstacttype,asstact,quotation,exchangerate,e_pricetaxtotal,material,actprice,corebillno,corebillentryseq,measureunit,e_baseunit,e_materialversion,spectype,e_baseunitqty,e_assistantattr,configuredcode,tracknumber,e_unitconvertrate,quantity,verifyquantity,actpricetax,unverifyquantity,verifyamount,e_unverifyamount,e_sourcebillentryid,ispresent,e_isallverify,org";
    }
}

